/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.mobs.impl.utils.evalex;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import net.advancedplugins.mobs.impl.commons.effects.effects.AdvancedEffect;
import net.advancedplugins.mobs.impl.utils.evalex.AbstractFunction;
import net.advancedplugins.mobs.impl.utils.evalex.AbstractLazyFunction;
import net.advancedplugins.mobs.impl.utils.evalex.AbstractOperator;
import net.advancedplugins.mobs.impl.utils.evalex.AbstractUnaryOperator;
import net.advancedplugins.mobs.impl.utils.evalex.ExpressionSettings;
import net.advancedplugins.mobs.impl.utils.evalex.LazyIfNumber;
import net.advancedplugins.mobs.impl.utils.evalex.LazyOperator;

public class Expression {
    public static final int OPERATOR_PRECEDENCE_UNARY = 60;
    public static final int OPERATOR_PRECEDENCE_EQUALITY = 7;
    public static final int OPERATOR_PRECEDENCE_COMPARISON = 10;
    public static final int OPERATOR_PRECEDENCE_OR = 2;
    public static final int OPERATOR_PRECEDENCE_AND = 4;
    public static final int OPERATOR_PRECEDENCE_POWER = 40;
    public static final int OPERATOR_PRECEDENCE_POWER_HIGHER = 80;
    public static final int OPERATOR_PRECEDENCE_MULTIPLICATIVE = 30;
    public static final int OPERATOR_PRECEDENCE_ADDITIVE = 20;
    public static final BigDecimal PI;
    public static final BigDecimal e;
    public static final String MISSING_PARAMETERS_FOR_OPERATOR;
    private MathContext mc = null;
    private int powerOperatorPrecedence = 40;
    private String firstVarChars = "_";
    private String varChars = "_";
    private final String originalExpression;
    private String expressionString = null;
    private List<Token> rpn = null;
    protected Map<String, LazyOperator> operators = new TreeMap<String, LazyOperator>(String.CASE_INSENSITIVE_ORDER);
    protected Map<String, net.advancedplugins.mobs.impl.utils.evalex.LazyFunction> functions = new TreeMap<String, net.advancedplugins.mobs.impl.utils.evalex.LazyFunction>(String.CASE_INSENSITIVE_ORDER);
    protected Map<String, LazyNumber> variables = new TreeMap<String, LazyNumber>(String.CASE_INSENSITIVE_ORDER);
    private static final char DECIMAL_SEPARATOR = '.';
    private static final char MINUS_SIGN = '-';
    private static final LazyNumber PARAMS_START;
    private static int a;
    private static final String[] b;

    protected LazyNumber createLazyNumber(final BigDecimal bigDecimal) {
        return new LazyNumber(){

            @Override
            public String getString() {
                return bigDecimal.toPlainString();
            }

            @Override
            public BigDecimal eval() {
                return bigDecimal;
            }
        };
    }

    public Expression(String string) {
        this(string, MathContext.DECIMAL32);
    }

    public Expression(String string, MathContext mathContext) {
        this(string, ExpressionSettings.builder().mathContext(mathContext).build());
    }

    public Expression(String string, ExpressionSettings expressionSettings) {
        this.mc = expressionSettings.getMathContext();
        this.powerOperatorPrecedence = expressionSettings.getPowerOperatorPrecedence();
        this.expressionString = string;
        this.originalExpression = string;
        this.addOperator(new Operator("+", 20, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                return bigDecimal.add(bigDecimal2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("-", 20, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                return bigDecimal.subtract(bigDecimal2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("*", 30, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                return bigDecimal.multiply(bigDecimal2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("/", 30, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                return bigDecimal.divide(bigDecimal2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("%", 30, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                return bigDecimal.remainder(bigDecimal2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("^", this.powerOperatorPrecedence, false){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                int n = bigDecimal2.signum();
                double d = bigDecimal.doubleValue();
                bigDecimal2 = bigDecimal2.multiply(new BigDecimal(n));
                BigDecimal bigDecimal3 = bigDecimal2.remainder(BigDecimal.ONE);
                BigDecimal bigDecimal4 = bigDecimal2.subtract(bigDecimal3);
                BigDecimal bigDecimal5 = bigDecimal.pow(bigDecimal4.intValueExact(), Expression.this.mc);
                BigDecimal bigDecimal6 = BigDecimal.valueOf(Math.pow(d, bigDecimal3.doubleValue()));
                int n2 = AbstractLazyFunction.c();
                BigDecimal bigDecimal7 = bigDecimal5.multiply(bigDecimal6, Expression.this.mc);
                if (n == -1) {
                    bigDecimal7 = BigDecimal.ONE.divide(bigDecimal7, Expression.this.mc.getPrecision(), RoundingMode.HALF_UP);
                }
                if (AdvancedEffect.b() == null) {
                    AbstractLazyFunction.b(++n2);
                }
                return bigDecimal7;
            }
        });
        String[] stringArray = b;
        this.addOperator(new Operator(stringArray[71], 4, false, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                boolean bl;
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                boolean bl2 = bl = bigDecimal.compareTo(BigDecimal.ZERO) != 0;
                if (!bl) {
                    return BigDecimal.ZERO;
                }
                boolean bl3 = bigDecimal2.compareTo(BigDecimal.ZERO) != 0;
                return bl3 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(stringArray[5], 2, false, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                boolean bl;
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                boolean bl2 = bl = bigDecimal.compareTo(BigDecimal.ZERO) != 0;
                if (bl) {
                    return BigDecimal.ONE;
                }
                boolean bl3 = bigDecimal2.compareTo(BigDecimal.ZERO) != 0;
                return bl3 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(">", 10, false, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                return bigDecimal.compareTo(bigDecimal2) > 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(stringArray[24], 10, false, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                return bigDecimal.compareTo(bigDecimal2) >= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("<", 10, false, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                return bigDecimal.compareTo(bigDecimal2) < 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(stringArray[73], 10, false, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                return bigDecimal.compareTo(bigDecimal2) <= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("=", 7, false, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                if (bigDecimal == bigDecimal2) {
                    return BigDecimal.ONE;
                }
                if (bigDecimal == null || bigDecimal2 == null) {
                    return BigDecimal.ZERO;
                }
                return bigDecimal.compareTo(bigDecimal2) == 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(stringArray[61], 7, false, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                return ((Operator)Expression.this.operators.get("=")).eval(bigDecimal, bigDecimal2);
            }
        });
        int n = AbstractLazyFunction.c();
        this.addOperator(new Operator(stringArray[4], 7, false, true){

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                if (bigDecimal == bigDecimal2) {
                    return BigDecimal.ZERO;
                }
                if (bigDecimal == null || bigDecimal2 == null) {
                    return BigDecimal.ONE;
                }
                return bigDecimal.compareTo(bigDecimal2) != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(stringArray[47], 7, false, true){
            private static final String a = 18.a(58, 18.a("(\b"));

            @Override
            public BigDecimal eval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                Expression.this.assertNotNull(bigDecimal, bigDecimal2);
                return ((Operator)Expression.this.operators.get(a)).eval(bigDecimal, bigDecimal2);
            }

            private static char[] a(String string) {
                char[] cArray = string.toCharArray();
                if (cArray.length < 2) {
                    cArray = cArray;
                    cArray[0] = (char)(cArray[0] ^ 0x33);
                }
                return cArray;
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            private static String a(int n, char[] cArray) {
                char[] cArray2;
                block11: {
                    int n2;
                    int n3;
                    int n4;
                    block10: {
                        n4 = n;
                        cArray2 = cArray;
                        n3 = cArray.length;
                        n2 = 0;
                        if (!true) break block10;
                        n3 = n3;
                        if (n3 <= n2) break block11;
                    }
                    do {
                        int n5;
                        n4 = n4;
                        cArray2 = cArray2;
                        int n6 = n2;
                        switch (n2 % 7) {
                            case 0: {
                                n5 = 51;
                                break;
                            }
                            case 1: {
                                n5 = 15;
                                break;
                            }
                            case 2: {
                                n5 = 121;
                                break;
                            }
                            case 3: {
                                n5 = 40;
                                break;
                            }
                            case 4: {
                                n5 = 17;
                                break;
                            }
                            case 5: {
                                n5 = 42;
                                break;
                            }
                            default: {
                                n5 = 51;
                            }
                        }
                        cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                        ++n2;
                        n3 = n3;
                    } while (n3 > n2);
                }
                return new String(cArray2).intern();
            }
        });
        this.addOperator(new UnaryOperator("-", 60, false){

            @Override
            public BigDecimal evalUnary(BigDecimal bigDecimal) {
                return bigDecimal.multiply(new BigDecimal(-1));
            }
        });
        this.addOperator(new UnaryOperator("+", 60, false){

            @Override
            public BigDecimal evalUnary(BigDecimal bigDecimal) {
                return bigDecimal.multiply(BigDecimal.ONE);
            }
        });
        this.addFunction(new Function(stringArray[50], 1, false){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                BigDecimal bigDecimal;
                block2: {
                    int n = AbstractLazyFunction.b();
                    Expression.this.assertNotNull(list.get(0));
                    int n2 = n;
                    int n3 = list.get(0).intValue();
                    BigDecimal bigDecimal2 = BigDecimal.ONE;
                    for (int i = 1; i <= n3; ++i) {
                        bigDecimal = bigDecimal2.multiply(new BigDecimal(i));
                        if (n2 != 0) {
                            bigDecimal2 = bigDecimal;
                            if (n2 != 0) continue;
                        }
                        break block2;
                    }
                    bigDecimal = bigDecimal2;
                }
                return bigDecimal;
            }
        });
        this.addFunction(new Function(stringArray[63], 1, true){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                boolean bl = list.get(0).compareTo(BigDecimal.ZERO) == 0;
                return bl ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addLazyFunction(new LazyFunction(stringArray[30], 3){

            @Override
            public LazyNumber lazyEval(List<LazyNumber> list) {
                return new LazyIfNumber(list);
            }
        });
        this.addFunction(new Function(stringArray[13], 0){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                double d = Math.random();
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[14], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.sin(list.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[42], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.cos(list.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[40], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.tan(list.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[16], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = 1.0;
                double d2 = Math.tan(list.get(0).doubleValue());
                return new BigDecimal(d / d2, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[1], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = 1.0;
                double d2 = Math.cos(list.get(0).doubleValue());
                return new BigDecimal(d / d2, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[41], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = 1.0;
                double d2 = Math.sin(list.get(0).doubleValue());
                return new BigDecimal(d / d2, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[18], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.sin(Math.toRadians(list.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[45], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.cos(Math.toRadians(list.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[62], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.tan(Math.toRadians(list.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[10], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = 1.0;
                double d2 = Math.tan(Math.toRadians(list.get(0).doubleValue()));
                return new BigDecimal(d / d2, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[26], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = 1.0;
                double d2 = Math.cos(Math.toRadians(list.get(0).doubleValue()));
                return new BigDecimal(d / d2, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[66], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = 1.0;
                double d2 = Math.sin(Math.toRadians(list.get(0).doubleValue()));
                return new BigDecimal(d / d2, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[80], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.asin(list.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[59], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.acos(list.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[12], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.atan(list.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[43], 1){
            private static final String c = 40.a(61, 40.a("\n>\u0007,g0P)>\u0019:\",\u001f0k\b+\"r"));

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                try {
                    Expression.this.assertNotNull(list.get(0));
                    if (list.get(0).doubleValue() == 0.0) {
                        throw new ExpressionException(c);
                    }
                }
                catch (ExpressionException expressionException) {
                    throw 40.b(expressionException);
                }
                double d = Math.atan(1.0 / list.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }

            private static ExpressionException b(ExpressionException expressionException) {
                return expressionException;
            }

            private static char[] a(String string) {
                char[] cArray = string.toCharArray();
                if (cArray.length < 2) {
                    cArray = cArray;
                    cArray[0] = (char)(cArray[0] ^ 0x4D);
                }
                return cArray;
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            private static String a(int n, char[] cArray) {
                char[] cArray2;
                block11: {
                    int n2;
                    int n3;
                    int n4;
                    block10: {
                        n4 = n;
                        cArray2 = cArray;
                        n3 = cArray.length;
                        n2 = 0;
                        if (!true) break block10;
                        n3 = n3;
                        if (n3 <= n2) break block11;
                    }
                    do {
                        int n5;
                        n4 = n4;
                        cArray2 = cArray2;
                        int n6 = n2;
                        switch (n2 % 7) {
                            case 0: {
                                n5 = 121;
                                break;
                            }
                            case 1: {
                                n5 = 118;
                                break;
                            }
                            case 2: {
                                n5 = 87;
                                break;
                            }
                            case 3: {
                                n5 = 115;
                                break;
                            }
                            case 4: {
                                n5 = 63;
                                break;
                            }
                            case 5: {
                                n5 = 127;
                                break;
                            }
                            default: {
                                n5 = 77;
                            }
                        }
                        cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                        ++n2;
                        n3 = n3;
                    } while (n3 > n2);
                }
                return new String(cArray2).intern();
            }
        });
        this.addFunction(new Function(stringArray[8], 2){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0), list.get(1));
                double d = Math.atan2(list.get(0).doubleValue(), list.get(1).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[31], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.toDegrees(Math.asin(list.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[33], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.toDegrees(Math.acos(list.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[79], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.toDegrees(Math.atan(list.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[11], 1){
            private static final String c = 45.a(44, 45.a("4\u000e Z7s\u001b\u0017\u000e>LroT\u000e[/]r1"));

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                try {
                    Expression.this.assertNotNull(list.get(0));
                    if (list.get(0).doubleValue() == 0.0) {
                        throw new ExpressionException(c);
                    }
                }
                catch (ExpressionException expressionException) {
                    throw 45.b(expressionException);
                }
                double d = Math.toDegrees(Math.atan(1.0 / list.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }

            private static ExpressionException b(ExpressionException expressionException) {
                return expressionException;
            }

            private static char[] a(String string) {
                char[] cArray = string.toCharArray();
                if (cArray.length < 2) {
                    cArray = cArray;
                    cArray[0] = (char)(cArray[0] ^ 0x17);
                }
                return cArray;
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            private static String a(int n, char[] cArray) {
                char[] cArray2;
                block11: {
                    int n2;
                    int n3;
                    int n4;
                    block10: {
                        n4 = n;
                        cArray2 = cArray;
                        n3 = cArray.length;
                        n2 = 0;
                        if (!true) break block10;
                        n3 = n3;
                        if (n3 <= n2) break block11;
                    }
                    do {
                        int n5;
                        n4 = n4;
                        cArray2 = cArray2;
                        int n6 = n2;
                        switch (n2 % 7) {
                            case 0: {
                                n5 = 86;
                                break;
                            }
                            case 1: {
                                n5 = 87;
                                break;
                            }
                            case 2: {
                                n5 = 97;
                                break;
                            }
                            case 3: {
                                n5 = 20;
                                break;
                            }
                            case 4: {
                                n5 = 126;
                                break;
                            }
                            case 5: {
                                n5 = 45;
                                break;
                            }
                            default: {
                                n5 = 23;
                            }
                        }
                        cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                        ++n2;
                        n3 = n3;
                    } while (n3 > n2);
                }
                return new String(cArray2).intern();
            }
        });
        this.addFunction(new Function(stringArray[78], 2){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0), list.get(1));
                double d = Math.toDegrees(Math.atan2(list.get(0).doubleValue(), list.get(1).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[37], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.sinh(list.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[69], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.cosh(list.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[77], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.tanh(list.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[20], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = 1.0;
                double d2 = Math.cosh(list.get(0).doubleValue());
                return new BigDecimal(d / d2, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[52], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = 1.0;
                double d2 = Math.sinh(list.get(0).doubleValue());
                return new BigDecimal(d / d2, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[22], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = 1.0;
                double d2 = Math.tanh(list.get(0).doubleValue());
                return new BigDecimal(d / d2, Expression.this.mc);
            }
        });
        this.addFunction(new Function(stringArray[68], 1){

            @Override
            public BigDecimal eval(List<BigDecimal> list) {
                Expression.this.assertNotNull(list.get(0));
                double d = Math.log(list.get(0).doubleValue() + Math.sqrt(Math.pow(list.get(0).doubleValue(), 2.0) + 1.0));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        int n2 = n;
        try {
            this.addFunction(new Function(stringArray[46], 1){
                private static final String c = 54.a(8, 54.a("N\u001dr ^\u001c\"m\u001dl6\u001b\fg \u0010?|\u0006N3"));

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    try {
                        Expression.this.assertNotNull(list.get(0));
                        if (Double.compare(list.get(0).doubleValue(), 1.0) < 0) {
                            throw new ExpressionException(c);
                        }
                    }
                    catch (ExpressionException expressionException) {
                        throw 54.b(expressionException);
                    }
                    double d = Math.log(list.get(0).doubleValue() + Math.sqrt(Math.pow(list.get(0).doubleValue(), 2.0) - 1.0));
                    return new BigDecimal(d, Expression.this.mc);
                }

                private static ExpressionException b(ExpressionException expressionException) {
                    return expressionException;
                }

                private static char[] a(String string) {
                    char[] cArray = string.toCharArray();
                    if (cArray.length < 2) {
                        cArray = cArray;
                        cArray[0] = (char)(cArray[0] ^ 0xA);
                    }
                    return cArray;
                }

                /*
                 * Handled impossible loop by duplicating code
                 * Enabled aggressive block sorting
                 */
                private static String a(int n, char[] cArray) {
                    char[] cArray2;
                    block11: {
                        int n2;
                        int n3;
                        int n4;
                        block10: {
                            n4 = n;
                            cArray2 = cArray;
                            n3 = cArray.length;
                            n2 = 0;
                            if (!true) break block10;
                            n3 = n3;
                            if (n3 <= n2) break block11;
                        }
                        do {
                            int n5;
                            n4 = n4;
                            cArray2 = cArray2;
                            int n6 = n2;
                            switch (n2 % 7) {
                                case 0: {
                                    n5 = 8;
                                    break;
                                }
                                case 1: {
                                    n5 = 96;
                                    break;
                                }
                                case 2: {
                                    n5 = 23;
                                    break;
                                }
                                case 3: {
                                    n5 = 74;
                                    break;
                                }
                                case 4: {
                                    n5 = 51;
                                    break;
                                }
                                case 5: {
                                    n5 = 102;
                                    break;
                                }
                                default: {
                                    n5 = 10;
                                }
                            }
                            cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                            ++n2;
                            n3 = n3;
                        } while (n3 > n2);
                    }
                    return new String(cArray2).intern();
                }
            });
            this.addFunction(new Function(stringArray[53], 1){
                private static final String c = 55.a(94, 55.a("(\u001bENPP\u0006\u000b\u001b[X\u0015@CF\u0012PP\u0015\u001e\u0006W"));

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    block4: {
                        try {
                            try {
                                Expression.this.assertNotNull(list.get(0));
                                if (!(Math.abs(list.get(0).doubleValue()) > 1.0) && Math.abs(list.get(0).doubleValue()) != 1.0) break block4;
                            }
                            catch (ExpressionException expressionException) {
                                throw 55.b(expressionException);
                            }
                            throw new ExpressionException(c);
                        }
                        catch (ExpressionException expressionException) {
                            throw 55.b(expressionException);
                        }
                    }
                    double d = 0.5 * Math.log((1.0 + list.get(0).doubleValue()) / (1.0 - list.get(0).doubleValue()));
                    return new BigDecimal(d, Expression.this.mc);
                }

                private static ExpressionException b(ExpressionException expressionException) {
                    return expressionException;
                }

                private static char[] a(String string) {
                    char[] cArray = string.toCharArray();
                    if (cArray.length < 2) {
                        cArray = cArray;
                        cArray[0] = (char)(cArray[0] ^ 0x78);
                    }
                    return cArray;
                }

                /*
                 * Handled impossible loop by duplicating code
                 * Enabled aggressive block sorting
                 */
                private static String a(int n, char[] cArray) {
                    char[] cArray2;
                    block11: {
                        int n2;
                        int n3;
                        int n4;
                        block10: {
                            n4 = n;
                            cArray2 = cArray;
                            n3 = cArray.length;
                            n2 = 0;
                            if (!true) break block10;
                            n3 = n3;
                            if (n3 <= n2) break block11;
                        }
                        do {
                            int n5;
                            n4 = n4;
                            cArray2 = cArray2;
                            int n6 = n2;
                            switch (n2 % 7) {
                                case 0: {
                                    n5 = 56;
                                    break;
                                }
                                case 1: {
                                    n5 = 48;
                                    break;
                                }
                                case 2: {
                                    n5 = 118;
                                    break;
                                }
                                case 3: {
                                    n5 = 114;
                                    break;
                                }
                                case 4: {
                                    n5 = 107;
                                    break;
                                }
                                case 5: {
                                    n5 = 124;
                                    break;
                                }
                                default: {
                                    n5 = 120;
                                }
                            }
                            cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                            ++n2;
                            n3 = n3;
                        } while (n3 > n2);
                    }
                    return new String(cArray2).intern();
                }
            });
            this.addFunction(new Function(stringArray[57], 1){

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    Expression.this.assertNotNull(list.get(0));
                    double d = Math.toRadians(list.get(0).doubleValue());
                    return new BigDecimal(d, Expression.this.mc);
                }
            });
            this.addFunction(new Function(stringArray[2], 1){

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    Expression.this.assertNotNull(list.get(0));
                    double d = Math.toDegrees(list.get(0).doubleValue());
                    return new BigDecimal(d, Expression.this.mc);
                }
            });
            this.addFunction(new Function(stringArray[29], -1){
                private static final String c = 58.a(40, 58.a("Wbwtt$OoJ]1ua_n\u0003C1g2J:LA1&1_hBB1r$L"));

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    BigDecimal bigDecimal;
                    block8: {
                        int n = AbstractLazyFunction.c();
                        try {
                            if (list.isEmpty()) {
                                throw new ExpressionException(c);
                            }
                        }
                        catch (ExpressionException expressionException) {
                            throw 58.b(expressionException);
                        }
                        BigDecimal bigDecimal2 = null;
                        for (BigDecimal bigDecimal3 : list) {
                            block10: {
                                block9: {
                                    try {
                                        try {
                                            Expression.this.assertNotNull(bigDecimal3);
                                            bigDecimal = bigDecimal2;
                                            if (n != 0) break block8;
                                            if (bigDecimal == null) break block9;
                                        }
                                        catch (ExpressionException expressionException) {
                                            throw 58.b(expressionException);
                                        }
                                        if (bigDecimal3.compareTo(bigDecimal2) <= 0) break block10;
                                    }
                                    catch (ExpressionException expressionException) {
                                        throw 58.b(expressionException);
                                    }
                                }
                                bigDecimal2 = bigDecimal3;
                            }
                            if (n == 0) continue;
                        }
                        bigDecimal = bigDecimal2;
                    }
                    return bigDecimal;
                }

                private static ExpressionException b(ExpressionException expressionException) {
                    return expressionException;
                }

                private static char[] a(String string) {
                    char[] cArray = string.toCharArray();
                    if (cArray.length < 2) {
                        cArray = cArray;
                        cArray[0] = (char)(cArray[0] ^ 0x16);
                    }
                    return cArray;
                }

                /*
                 * Handled impossible loop by duplicating code
                 * Enabled aggressive block sorting
                 */
                private static String a(int n, char[] cArray) {
                    char[] cArray2;
                    block11: {
                        int n2;
                        int n3;
                        int n4;
                        block10: {
                            n4 = n;
                            cArray2 = cArray;
                            n3 = cArray.length;
                            n2 = 0;
                            if (!true) break block10;
                            n3 = n3;
                            if (n3 <= n2) break block11;
                        }
                        do {
                            int n5;
                            n4 = n4;
                            cArray2 = cArray2;
                            int n6 = n2;
                            switch (n2 % 7) {
                                case 0: {
                                    n5 = 50;
                                    break;
                                }
                                case 1: {
                                    n5 = 11;
                                    break;
                                }
                                case 2: {
                                    n5 = 7;
                                    break;
                                }
                                case 3: {
                                    n5 = 124;
                                    break;
                                }
                                case 4: {
                                    n5 = 46;
                                    break;
                                }
                                case 5: {
                                    n5 = 105;
                                    break;
                                }
                                default: {
                                    n5 = 22;
                                }
                            }
                            cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                            ++n2;
                            n3 = n3;
                        } while (n3 > n2);
                    }
                    return new String(cArray2).intern();
                }
            });
            this.addFunction(new Function(stringArray[70], -1){
                private static final String c = 59.a(34, 59.a("&;\u001fvuO^\u001e\u001b#3t\nN\u001fR=3fY[K\u001d?3'ZN\u0019\u0013<3sO]"));

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    BigDecimal bigDecimal;
                    block8: {
                        int n = AbstractLazyFunction.b();
                        try {
                            if (list.isEmpty()) {
                                throw new ExpressionException(c);
                            }
                        }
                        catch (ExpressionException expressionException) {
                            throw 59.b(expressionException);
                        }
                        BigDecimal bigDecimal2 = null;
                        for (BigDecimal bigDecimal3 : list) {
                            block10: {
                                block9: {
                                    try {
                                        try {
                                            Expression.this.assertNotNull(bigDecimal3);
                                            bigDecimal = bigDecimal2;
                                            if (n == 0) break block8;
                                            if (bigDecimal == null) break block9;
                                        }
                                        catch (ExpressionException expressionException) {
                                            throw 59.b(expressionException);
                                        }
                                        if (bigDecimal3.compareTo(bigDecimal2) >= 0) break block10;
                                    }
                                    catch (ExpressionException expressionException) {
                                        throw 59.b(expressionException);
                                    }
                                }
                                bigDecimal2 = bigDecimal3;
                            }
                            if (n != 0) continue;
                        }
                        bigDecimal = bigDecimal2;
                    }
                    return bigDecimal;
                }

                private static ExpressionException b(ExpressionException expressionException) {
                    return expressionException;
                }

                private static char[] a(String string) {
                    char[] cArray = string.toCharArray();
                    if (cArray.length < 2) {
                        cArray = cArray;
                        cArray[0] = (char)(cArray[0] ^ 0xD);
                    }
                    return cArray;
                }

                /*
                 * Handled impossible loop by duplicating code
                 * Enabled aggressive block sorting
                 */
                private static String a(int n, char[] cArray) {
                    char[] cArray2;
                    block11: {
                        int n2;
                        int n3;
                        int n4;
                        block10: {
                            n4 = n;
                            cArray2 = cArray;
                            n3 = cArray.length;
                            n2 = 0;
                            if (!true) break block10;
                            n3 = n3;
                            if (n3 <= n2) break block11;
                        }
                        do {
                            int n5;
                            n4 = n4;
                            cArray2 = cArray2;
                            int n6 = n2;
                            switch (n2 % 7) {
                                case 0: {
                                    n5 = 73;
                                    break;
                                }
                                case 1: {
                                    n5 = 80;
                                    break;
                                }
                                case 2: {
                                    n5 = 115;
                                    break;
                                }
                                case 3: {
                                    n5 = 116;
                                    break;
                                }
                                case 4: {
                                    n5 = 37;
                                    break;
                                }
                                case 5: {
                                    n5 = 8;
                                    break;
                                }
                                default: {
                                    n5 = 13;
                                }
                            }
                            cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                            ++n2;
                            n3 = n3;
                        } while (n3 > n2);
                    }
                    return new String(cArray2).intern();
                }
            });
            this.addFunction(new Function(stringArray[6], 1){

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    Expression.this.assertNotNull(list.get(0));
                    return list.get(0).abs(Expression.this.mc);
                }
            });
            this.addFunction(new Function(stringArray[39], 1){

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    Expression.this.assertNotNull(list.get(0));
                    double d = Math.log(list.get(0).doubleValue());
                    return new BigDecimal(d, Expression.this.mc);
                }
            });
            this.addFunction(new Function(stringArray[75], 1){

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    Expression.this.assertNotNull(list.get(0));
                    double d = Math.log10(list.get(0).doubleValue());
                    return new BigDecimal(d, Expression.this.mc);
                }
            });
            this.addFunction(new Function(stringArray[67], 2){

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    Expression.this.assertNotNull(list.get(0), list.get(1));
                    BigDecimal bigDecimal = list.get(0);
                    int n = list.get(1).intValue();
                    return bigDecimal.setScale(n, Expression.this.mc.getRoundingMode());
                }
            });
            this.addFunction(new Function(stringArray[51], 1){

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    Expression.this.assertNotNull(list.get(0));
                    BigDecimal bigDecimal = list.get(0);
                    return bigDecimal.setScale(0, RoundingMode.FLOOR);
                }
            });
            this.addFunction(new Function(stringArray[38], 1){

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    Expression.this.assertNotNull(list.get(0));
                    BigDecimal bigDecimal = list.get(0);
                    return bigDecimal.setScale(0, RoundingMode.CEILING);
                }
            });
            this.addFunction(new Function(stringArray[23], 1){
                private static final String c = 66.a(78, 66.a("s\u007f\u001d\u0006x'9F-\u000e\u001c5\u0011\u0006`YRZ5$\"\\n\u000e\u001az,w_x\t\u00075,8F-\u0018\u00165,2Ul\u000e\u001ac'"));

                @Override
                public BigDecimal eval(List<BigDecimal> list) {
                    BigInteger bigInteger;
                    BigInteger bigInteger2;
                    Expression.this.assertNotNull(list.get(0));
                    BigDecimal bigDecimal = list.get(0);
                    try {
                        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                            return new BigDecimal(0);
                        }
                    }
                    catch (ExpressionException expressionException) {
                        throw 66.b(expressionException);
                    }
                    try {
                        if (bigDecimal.signum() < 0) {
                            throw new ExpressionException(c);
                        }
                    }
                    catch (ExpressionException expressionException) {
                        throw 66.b(expressionException);
                    }
                    BigInteger bigInteger3 = bigDecimal.movePointRight(Expression.this.mc.getPrecision() << 1).toBigInteger();
                    int n = bigInteger3.bitLength() + 1 >> 1;
                    BigInteger bigInteger4 = bigInteger3.shiftRight(n);
                    do {
                        bigInteger = bigInteger4;
                        bigInteger4 = bigInteger4.add(bigInteger3.divide(bigInteger4)).shiftRight(1);
                        Thread.yield();
                    } while ((bigInteger2 = bigInteger4.subtract(bigInteger).abs()).compareTo(BigInteger.ZERO) != 0 && bigInteger2.compareTo(BigInteger.ONE) != 0);
                    return new BigDecimal(bigInteger4, Expression.this.mc.getPrecision());
                }

                private static ExpressionException b(ExpressionException expressionException) {
                    return expressionException;
                }

                private static char[] a(String string) {
                    char[] cArray = string.toCharArray();
                    if (cArray.length < 2) {
                        cArray = cArray;
                        cArray[0] = (char)(cArray[0] ^ 0x19);
                    }
                    return cArray;
                }

                /*
                 * Handled impossible loop by duplicating code
                 * Enabled aggressive block sorting
                 */
                private static String a(int n, char[] cArray) {
                    char[] cArray2;
                    block11: {
                        int n2;
                        int n3;
                        int n4;
                        block10: {
                            n4 = n;
                            cArray2 = cArray;
                            n3 = cArray.length;
                            n2 = 0;
                            if (!true) break block10;
                            n3 = n3;
                            if (n3 <= n2) break block11;
                        }
                        do {
                            int n5;
                            n4 = n4;
                            cArray2 = cArray2;
                            int n6 = n2;
                            switch (n2 % 7) {
                                case 0: {
                                    n5 = 124;
                                    break;
                                }
                                case 1: {
                                    n5 = 67;
                                    break;
                                }
                                case 2: {
                                    n5 = 52;
                                    break;
                                }
                                case 3: {
                                    n5 = 61;
                                    break;
                                }
                                case 4: {
                                    n5 = 91;
                                    break;
                                }
                                case 5: {
                                    n5 = 12;
                                    break;
                                }
                                default: {
                                    n5 = 25;
                                }
                            }
                            cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                            ++n2;
                            n3 = n3;
                        } while (n3 > n2);
                    }
                    return new String(cArray2).intern();
                }
            });
            this.variables.put("e", this.createLazyNumber(e));
            this.variables.put(stringArray[60], this.createLazyNumber(PI));
            this.variables.put(stringArray[9], null);
            this.variables.put(stringArray[15], this.createLazyNumber(BigDecimal.ONE));
            this.variables.put(stringArray[76], this.createLazyNumber(BigDecimal.ZERO));
            if (n2 != 0) {
                AdvancedEffect.b(new String[3]);
            }
        }
        catch (ExpressionException expressionException) {
            throw Expression.b(expressionException);
        }
    }

    protected void assertNotNull(BigDecimal bigDecimal) {
        try {
            if (bigDecimal == null) {
                throw new ArithmeticException(b[27]);
            }
        }
        catch (ExpressionException expressionException) {
            throw Expression.b(expressionException);
        }
    }

    protected void assertNotNull(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        try {
            if (bigDecimal == null) {
                String[] stringArray = b;
                throw new ArithmeticException(stringArray[58]);
            }
        }
        catch (ExpressionException expressionException) {
            throw Expression.b(expressionException);
        }
        try {
            if (bigDecimal2 == null) {
                throw new ArithmeticException(b[64]);
            }
        }
        catch (ExpressionException expressionException) {
            throw Expression.b(expressionException);
        }
    }

    protected boolean isNumber(String string) {
        boolean bl;
        block38: {
            int n;
            block37: {
                block35: {
                    block34: {
                        block33: {
                            n = AbstractLazyFunction.c();
                            try {
                                try {
                                    if (string.charAt(0) != '-' || string.length() != 1) break block33;
                                }
                                catch (ExpressionException expressionException) {
                                    throw Expression.b(expressionException);
                                }
                                return false;
                            }
                            catch (ExpressionException expressionException) {
                                throw Expression.b(expressionException);
                            }
                        }
                        try {
                            try {
                                if (string.charAt(0) != '+' || string.length() != 1) break block34;
                            }
                            catch (ExpressionException expressionException) {
                                throw Expression.b(expressionException);
                            }
                            return false;
                        }
                        catch (ExpressionException expressionException) {
                            throw Expression.b(expressionException);
                        }
                    }
                    try {
                        block36: {
                            try {
                                try {
                                    if (string.charAt(0) != '.') break block35;
                                    if (string.length() == 1) break block36;
                                }
                                catch (ExpressionException expressionException) {
                                    throw Expression.b(expressionException);
                                }
                                if (Character.isDigit(string.charAt(1))) break block35;
                            }
                            catch (ExpressionException expressionException) {
                                throw Expression.b(expressionException);
                            }
                        }
                        return false;
                    }
                    catch (ExpressionException expressionException) {
                        throw Expression.b(expressionException);
                    }
                }
                try {
                    try {
                        if (string.charAt(0) != 'e' && string.charAt(0) != 'E') break block37;
                    }
                    catch (ExpressionException expressionException) {
                        throw Expression.b(expressionException);
                    }
                    return false;
                }
                catch (ExpressionException expressionException) {
                    throw Expression.b(expressionException);
                }
            }
            for (char c : string.toCharArray()) {
                try {
                    try {
                        try {
                            try {
                                try {
                                    try {
                                        try {
                                            bl = Character.isDigit(c);
                                            if (n != 0) break block38;
                                            if (bl) continue;
                                        }
                                        catch (ExpressionException expressionException) {
                                            throw Expression.b(expressionException);
                                        }
                                        if (c == '-') continue;
                                    }
                                    catch (ExpressionException expressionException) {
                                        throw Expression.b(expressionException);
                                    }
                                    if (c == '.') continue;
                                }
                                catch (ExpressionException expressionException) {
                                    throw Expression.b(expressionException);
                                }
                                if (c == 'e') continue;
                            }
                            catch (ExpressionException expressionException) {
                                throw Expression.b(expressionException);
                            }
                            if (c == 'E') continue;
                        }
                        catch (ExpressionException expressionException) {
                            throw Expression.b(expressionException);
                        }
                        if (c == '+') continue;
                    }
                    catch (ExpressionException expressionException) {
                        throw Expression.b(expressionException);
                    }
                    return false;
                }
                catch (ExpressionException expressionException) {
                    throw Expression.b(expressionException);
                }
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    private List<Token> shuntingYard(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void shuntOperators(List<Token> list, Stack<Token> stack, LazyOperator lazyOperator) {
        Token token;
        int n = AbstractLazyFunction.c();
        try {
            Token token2 = token = stack.isEmpty() ? null : stack.peek();
        }
        catch (ExpressionException expressionException) {
            throw Expression.b(expressionException);
        }
        while (token != null) {
            block18: {
                Token token3;
                block17: {
                    try {
                        try {
                            block16: {
                                try {
                                    block15: {
                                        try {
                                            try {
                                                try {
                                                    if (token.type != TokenType.OPERATOR && token.type != TokenType.UNARY_OPERATOR) break;
                                                }
                                                catch (ExpressionException expressionException) {
                                                    throw Expression.b(expressionException);
                                                }
                                                if (!lazyOperator.isLeftAssoc()) break block15;
                                            }
                                            catch (ExpressionException expressionException) {
                                                throw Expression.b(expressionException);
                                            }
                                            if (lazyOperator.getPrecedence() <= this.operators.get(token.surface).getPrecedence()) break block16;
                                        }
                                        catch (ExpressionException expressionException) {
                                            throw Expression.b(expressionException);
                                        }
                                    }
                                    if (lazyOperator.getPrecedence() >= this.operators.get(token.surface).getPrecedence()) break;
                                }
                                catch (ExpressionException expressionException) {
                                    throw Expression.b(expressionException);
                                }
                            }
                            list.add(stack.pop());
                            if (!stack.isEmpty()) break block17;
                        }
                        catch (ExpressionException expressionException) {
                            throw Expression.b(expressionException);
                        }
                        token3 = null;
                        break block18;
                    }
                    catch (ExpressionException expressionException) {
                        throw Expression.b(expressionException);
                    }
                }
                token3 = token = stack.peek();
            }
            if (n == 0) continue;
        }
    }

    public BigDecimal eval() {
        return this.eval(true);
    }

    /*
     * Exception decompiling
     */
    public BigDecimal eval(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Expression setPrecision(int n) {
        this.mc = new MathContext(n);
        return this;
    }

    public Expression setRoundingMode(RoundingMode roundingMode) {
        this.mc = new MathContext(this.mc.getPrecision(), roundingMode);
        return this;
    }

    public Expression setFirstVariableCharacters(String string) {
        this.firstVarChars = string;
        return this;
    }

    public Expression setVariableCharacters(String string) {
        this.varChars = string;
        return this;
    }

    public <OPERATOR extends LazyOperator> OPERATOR addOperator(OPERATOR OPERATOR) {
        String string = OPERATOR.getOper();
        if (OPERATOR instanceof AbstractUnaryOperator) {
            string = string + "u";
        }
        return (OPERATOR)this.operators.put(string, OPERATOR);
    }

    public net.advancedplugins.mobs.impl.utils.evalex.Function addFunction(net.advancedplugins.mobs.impl.utils.evalex.Function function) {
        return (net.advancedplugins.mobs.impl.utils.evalex.Function)this.functions.put(function.getName(), function);
    }

    public net.advancedplugins.mobs.impl.utils.evalex.LazyFunction addLazyFunction(net.advancedplugins.mobs.impl.utils.evalex.LazyFunction lazyFunction) {
        return this.functions.put(lazyFunction.getName(), lazyFunction);
    }

    public Expression setVariable(String string, BigDecimal bigDecimal) {
        return this.setVariable(string, this.createLazyNumber(bigDecimal));
    }

    public Expression setVariable(String string, LazyNumber lazyNumber) {
        this.variables.put(string, lazyNumber);
        return this;
    }

    public Expression setVariable(String string, String string2) {
        block7: {
            block8: {
                int n = AbstractLazyFunction.c();
                try {
                    try {
                        block6: {
                            try {
                                if (!this.isNumber(string2)) break block6;
                                this.variables.put(string, this.createLazyNumber(new BigDecimal(string2, this.mc)));
                                if (n == 0) break block7;
                            }
                            catch (ExpressionException expressionException) {
                                throw Expression.b(expressionException);
                            }
                        }
                        if (!string2.equalsIgnoreCase(b[44])) break block8;
                    }
                    catch (ExpressionException expressionException) {
                        throw Expression.b(expressionException);
                    }
                    this.variables.put(string, null);
                    if (n == 0) break block7;
                }
                catch (ExpressionException expressionException) {
                    throw Expression.b(expressionException);
                }
            }
            final String string3 = string2;
            this.variables.put(string, new LazyNumber(){
                private final Map<String, LazyNumber> outerVariables;
                private final Map<String, net.advancedplugins.mobs.impl.utils.evalex.LazyFunction> outerFunctions;
                private final Map<String, LazyOperator> outerOperators;
                private final String innerExpressionString;
                private final MathContext inneMc;
                {
                    this.outerVariables = Expression.this.variables;
                    this.outerFunctions = Expression.this.functions;
                    this.outerOperators = Expression.this.operators;
                    this.innerExpressionString = string3;
                    this.inneMc = Expression.this.mc;
                }

                @Override
                public String getString() {
                    return this.innerExpressionString;
                }

                @Override
                public BigDecimal eval() {
                    Expression expression = new Expression(this.innerExpressionString, this.inneMc);
                    expression.variables = this.outerVariables;
                    expression.functions = this.outerFunctions;
                    expression.operators = this.outerOperators;
                    return expression.eval();
                }
            });
            this.rpn = null;
        }
        return this;
    }

    private Expression createEmbeddedExpression(String string) {
        Map<String, LazyNumber> map = this.variables;
        Map<String, net.advancedplugins.mobs.impl.utils.evalex.LazyFunction> map2 = this.functions;
        Map<String, LazyOperator> map3 = this.operators;
        MathContext mathContext = this.mc;
        Expression expression = new Expression(string, mathContext);
        expression.variables = map;
        expression.functions = map2;
        expression.operators = map3;
        return expression;
    }

    public Expression with(String string, BigDecimal bigDecimal) {
        return this.setVariable(string, bigDecimal);
    }

    public Expression with(String string, LazyNumber lazyNumber) {
        return this.setVariable(string, lazyNumber);
    }

    public Expression and(String string, String string2) {
        return this.setVariable(string, string2);
    }

    public Expression and(String string, BigDecimal bigDecimal) {
        return this.setVariable(string, bigDecimal);
    }

    public Expression and(String string, LazyNumber lazyNumber) {
        return this.setVariable(string, lazyNumber);
    }

    public Expression with(String string, String string2) {
        return this.setVariable(string, string2);
    }

    public Iterator<Token> getExpressionTokenizer() {
        String string = this.expressionString;
        return new Tokenizer(string);
    }

    private List<Token> getRPN() {
        try {
            if (this.rpn == null) {
                this.rpn = this.shuntingYard(this.expressionString);
                this.validate(this.rpn);
            }
        }
        catch (ExpressionException expressionException) {
            throw Expression.b(expressionException);
        }
        return this.rpn;
    }

    /*
     * Exception decompiling
     */
    private void validate(List<Token> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public String toRPN() {
        block13: {
            var2_1 = new StringBuilder();
            var1_2 = AbstractLazyFunction.c();
            for (Token var4_4 : this.getRPN()) {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                try {
                                    try {
                                        v0 = var2_1;
                                        if (var1_2 != 0) break block13;
                                        if (v0.length() == 0) break block14;
                                    }
                                    catch (ExpressionException v1) {
                                        throw Expression.b(v1);
                                    }
                                    var2_1.append(" ");
                                }
                                catch (ExpressionException v2) {
                                    throw Expression.b(v2);
                                }
                            }
                            try {
                                if (var4_4.type == TokenType.VARIABLE && this.variables.containsKey(var4_4.surface)) {
                                }
                                ** GOTO lbl42
                            }
                            catch (ExpressionException v3) {
                                throw Expression.b(v3);
                            }
                            var5_5 = this.variables.get(var4_4.surface);
                            var6_6 = var5_5.getString();
                            try {
                                if (!this.isNumber(var6_6)) break block15;
                                var2_1.append(var4_4);
                                if (var1_2 == 0) break block16;
                            }
                            catch (ExpressionException v4) {
                                throw Expression.b(v4);
                            }
                        }
                        var7_7 = this.createEmbeddedExpression(var6_6);
                        var8_8 = var7_7.toRPN();
                        var2_1.append(var8_8);
                    }
                    try {
                        if (var1_2 == 0) break block17;
lbl42:
                        // 2 sources

                        var2_1.append(var4_4);
                    }
                    catch (ExpressionException v5) {
                        throw Expression.b(v5);
                    }
                }
                if (var1_2 == 0) continue;
            }
            v0 = var2_1;
        }
        return v0.toString();
    }

    public Set<String> getDeclaredVariables() {
        return Collections.unmodifiableSet(this.variables.keySet());
    }

    public Set<String> getDeclaredOperators() {
        return Collections.unmodifiableSet(this.operators.keySet());
    }

    public Set<String> getDeclaredFunctions() {
        return Collections.unmodifiableSet(this.functions.keySet());
    }

    public String getExpression() {
        return this.expressionString;
    }

    public List<String> getUsedVariables() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = AbstractLazyFunction.c();
        Tokenizer tokenizer = new Tokenizer(this.expressionString);
        while (tokenizer.hasNext()) {
            String[] stringArray;
            Token token = tokenizer.next();
            String string = token.toString();
            if (token.type != TokenType.VARIABLE || string.equals((stringArray = b)[60]) || string.equals("e") || string.equals(stringArray[15])) continue;
            try {
                if (string.equals(stringArray[76]) && n == 0) continue;
            }
            catch (ExpressionException expressionException) {
                throw Expression.b(expressionException);
            }
            arrayList.add(string);
            if (n == 0) continue;
        }
        return arrayList;
    }

    public String getOriginalExpression() {
        return this.originalExpression;
    }

    public boolean equals(Object object) {
        Expression expression;
        block12: {
            boolean bl;
            block14: {
                block13: {
                    block11: {
                        try {
                            if (this == object) {
                                return true;
                            }
                        }
                        catch (ExpressionException expressionException) {
                            throw Expression.b(expressionException);
                        }
                        try {
                            try {
                                if (object != null && this.getClass() == object.getClass()) break block11;
                            }
                            catch (ExpressionException expressionException) {
                                throw Expression.b(expressionException);
                            }
                            return false;
                        }
                        catch (ExpressionException expressionException) {
                            throw Expression.b(expressionException);
                        }
                    }
                    expression = (Expression)object;
                    try {
                        try {
                            if (this.expressionString != null) break block12;
                            if (expression.expressionString != null) break block13;
                        }
                        catch (ExpressionException expressionException) {
                            throw Expression.b(expressionException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (ExpressionException expressionException) {
                        throw Expression.b(expressionException);
                    }
                }
                bl = false;
            }
            return bl;
        }
        return this.expressionString.equals(expression.expressionString);
    }

    public int hashCode() {
        int n;
        try {
            n = this.expressionString == null ? 0 : this.expressionString.hashCode();
        }
        catch (ExpressionException expressionException) {
            throw Expression.b(expressionException);
        }
        return n;
    }

    public String toString() {
        return this.expressionString;
    }

    public boolean isBoolean() {
        boolean bl;
        block12: {
            List<Token> list = this.getRPN();
            int n = AbstractLazyFunction.c();
            if (!list.isEmpty()) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    Token token;
                    block14: {
                        token = list.get(i);
                        try {
                            try {
                                block13: {
                                    try {
                                        try {
                                            bl = token.surface.equals(b[30]);
                                            if (n != 0) break block12;
                                            if (!bl) break block13;
                                        }
                                        catch (ExpressionException expressionException) {
                                            throw Expression.b(expressionException);
                                        }
                                        if (n == 0) continue;
                                    }
                                    catch (ExpressionException expressionException) {
                                        throw Expression.b(expressionException);
                                    }
                                }
                                if (token.type != TokenType.FUNCTION) break block14;
                            }
                            catch (ExpressionException expressionException) {
                                throw Expression.b(expressionException);
                            }
                            return this.functions.get(token.surface).isBooleanFunction();
                        }
                        catch (ExpressionException expressionException) {
                            throw Expression.b(expressionException);
                        }
                    }
                    try {
                        if (token.type != TokenType.OPERATOR) continue;
                        return this.operators.get(token.surface).isBooleanOperator();
                    }
                    catch (ExpressionException expressionException) {
                        throw Expression.b(expressionException);
                    }
                }
            }
            bl = false;
        }
        return bl;
    }

    public List<String> infixNotation() {
        ArrayList<String> arrayList;
        block4: {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Tokenizer tokenizer = new Tokenizer(this.expressionString);
            int n = AbstractLazyFunction.c();
            while (tokenizer.hasNext()) {
                Token token = tokenizer.next();
                String string = "{" + (Object)((Object)token.type) + ":" + token.surface + "}";
                try {
                    arrayList = arrayList2;
                    if (n == 0) {
                        arrayList.add(string);
                        if (n == 0) continue;
                        break;
                    }
                    break block4;
                }
                catch (ExpressionException expressionException) {
                    throw Expression.b(expressionException);
                }
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    static /* synthetic */ String access$000(Expression expression) {
        return expression.firstVarChars;
    }

    static /* synthetic */ String access$100(Expression expression) {
        return expression.varChars;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block10: {
            block9: {
                var5 = new String[81];
                var3_1 = 0;
                var2_2 = "JRCusLPKJGrwAPNEAsqA]ONDuqJQJNExwI[ADFp{NXOEAx{J^LMBtzKY@KFxvM\\@NAquAXOHBwpA_KLJx{A_KDBrvA[LOFssH^IJEx\u0004*91\u0013\u0003=95\u0011,\u0012\u0019/-\u000e\u0007Y\u001a\u0007/!\r\u0000\u0016\u0012R\u0002XA\u0002\u0005\u0000\u00038>!\u0010<\u0011\u00025;Y\f\u0001\f\u0000$1\n\u0000\u0016\u0012\u00068(3\u000fp+\u00047)>\r\u0003:3&\u00048?=\u0015\u00058(3\u000f\u0010\u0006+=<\u0005\r4\u0004*5<\u0013\u0004-.'\u0004\u0004:3&\u0013\"4\u0015\u00012+\u0017\u000eY\f\u00133#\u0014\f\r\u0019\u0000i1PI\u001f\u0013\u0000a-\t\f\u000b\u001d\u0006.0Y\u0003*5<+-\u0013\u001da/\u0018\u0007\u0000\\\u0007/*\u0018\u0007\u001d\u0010\u0017%b\u001f\u001c\u0017\u001f\u0006(-\u0017I\t\u001d\u0000 /\u001c\u001d\u001c\u000eR-+\n\u001d\n\u0004*91\t\u0010,\u0012\u001792\u001c\n\r\u0019\u0016a!\u0016\u0004\u0014\u001d\u0004:3&\t\u0004*- \u0015\u0002GA\t?\t\u001c\"6\u0010\u0006\u0017\\\u0003*91\u00176\f\u00173#\u0017\rY\u0011\u00138b\u0017\u0006\r\\\u0010$b\u0017\u001c\u0015\u0010\u0011Y\f\u00133#\u0014\f\r\u0019\u00002nY\u000e\u0016\bR\u00034=*\u00020:\u00048/;\u000f/-\u0013\u001da/\u0018\u0007\u0000\\\u00144,\u001a\u001d\u0010\u0013\u001ca!\u0018\u0005\u0015\u000f^a/\u0018\u0011\u0010\u0011\u0007,b\n\n\u0016\f\u0017a'\u0001\n\u001c\u0019\u0016$&\u00048?=\u0012IKREpzKQHD@yvLPIHGsqLZOL@yuM^HOGstO[MEEvwN[MKBxqOP@EGxwN]@JDxtN_KKEsvI^OJA\u0019)\u001d\u00002'Y\f\u000b\u000e\u001d3b\u001f\u0006\u000b\\\u00144,\u001a\u001d\u0010\u0013\u001ca$0\u0012\u0004 .\u0010\rY\f\u001d2+\r\u0000\u0016\u0012R'-\u000bI\f\u0012\u00133;Y\u0006\t\u0019\u0000 6\u0016\u001bY\u0004*5<\t\u0007:9;\r\u000b7.\u0003535\u0004-=<\u0013\u0004:/1\u0013\u0004:3!\u0013\u00058?=\u0015\u0010\u0004\u0017\t\u001e-\u0003:3!\u00058?=\u0012\n\u0002EB\u00164\u0015\u0001,#\r\n\u0011\u0019\u0016a2\u0018\u001b\u001c\u0012\u0006)'\n\f\n\u001e,\u0012\u0019/-\u000e\u0007Y\u0013\u0002$0\u0018\u001d\u0016\u000eR.0Y\u000f\f\u0012\u00115+\u0016\u0007C\\\u0004?=1\u0015\u0005?0=\u000e\u0010\u0004:/1\t\u00058(3\u000f\n\nY\u0019\n1'\u001a\u001d\u001c\u0018R\u0011,\u0012\u001792\u001c\n\r\u0019\u0016a6\u0016\u0002\u001c\u0012R\u0011,\u0012\u0019/-\u000e\u0007Y\u0013\u0002$0\u0018\u001d\u0016\u000eR\u0003+=6\u001d?\u0015\u000026Y\u0006\t\u0019\u0000 ,\u001dI\u0014\u001d\u000ba,\u0016\u001dY\u001e\u0017a,\f\u0005\u0015\u00058?=\u0012\u0010\u0002)5\u0002DA\u0003-=<\u000373&\u001e*\u0019\u0011.,\u001dI\u0016\f\u00173#\u0017\rY\u0011\u00138b\u0017\u0006\r\\\u0010$b\u0017\u001c\u0015\u0010\u00104\u0015\u00012+\u0017\u000eY\u0013\u0002$0\u0018\u001d\u0016\u000e\u0003:/1\u0005+3'\u000f\u0006\u00058/;\u000f\n\u0004:3!\t\u000345<\u0002_Z\u001d-\u0013\u001da/\u0018\u0007\u0000\\\u001c4/\u001b\f\u000b\u000fR.0Y\u001f\u0018\u000e\u001b  \u0015\f\n\u0002EA\u0017,\u0012\u0019/-\u000e\u0007Y\t\u001c 0\u0000I\u0016\f\u00173#\r\u0006\u000b\\\u0005535pr\u0005?=>\u0012\u0007\u0004-=<\t\u00058(3\u000fp";
                var4_3 = "JRCusLPKJGrwAPNEAsqA]ONDuqJQJNExwI[ADFp{NXOEAx{J^LMBtzKY@KFxvM\\@NAquAXOHBwpA_KLJx{A_KDBrvA[LOFssH^IJEx\u0004*91\u0013\u0003=95\u0011,\u0012\u0019/-\u000e\u0007Y\u001a\u0007/!\r\u0000\u0016\u0012R\u0002XA\u0002\u0005\u0000\u00038>!\u0010<\u0011\u00025;Y\f\u0001\f\u0000$1\n\u0000\u0016\u0012\u00068(3\u000fp+\u00047)>\r\u0003:3&\u00048?=\u0015\u00058(3\u000f\u0010\u0006+=<\u0005\r4\u0004*5<\u0013\u0004-.'\u0004\u0004:3&\u0013\"4\u0015\u00012+\u0017\u000eY\f\u00133#\u0014\f\r\u0019\u0000i1PI\u001f\u0013\u0000a-\t\f\u000b\u001d\u0006.0Y\u0003*5<+-\u0013\u001da/\u0018\u0007\u0000\\\u0007/*\u0018\u0007\u001d\u0010\u0017%b\u001f\u001c\u0017\u001f\u0006(-\u0017I\t\u001d\u0000 /\u001c\u001d\u001c\u000eR-+\n\u001d\n\u0004*91\t\u0010,\u0012\u001792\u001c\n\r\u0019\u0016a!\u0016\u0004\u0014\u001d\u0004:3&\t\u0004*- \u0015\u0002GA\t?\t\u001c\"6\u0010\u0006\u0017\\\u0003*91\u00176\f\u00173#\u0017\rY\u0011\u00138b\u0017\u0006\r\\\u0010$b\u0017\u001c\u0015\u0010\u0011Y\f\u00133#\u0014\f\r\u0019\u00002nY\u000e\u0016\bR\u00034=*\u00020:\u00048/;\u000f/-\u0013\u001da/\u0018\u0007\u0000\\\u00144,\u001a\u001d\u0010\u0013\u001ca!\u0018\u0005\u0015\u000f^a/\u0018\u0011\u0010\u0011\u0007,b\n\n\u0016\f\u0017a'\u0001\n\u001c\u0019\u0016$&\u00048?=\u0012IKREpzKQHD@yvLPIHGsqLZOL@yuM^HOGstO[MEEvwN[MKBxqOP@EGxwN]@JDxtN_KKEsvI^OJA\u0019)\u001d\u00002'Y\f\u000b\u000e\u001d3b\u001f\u0006\u000b\\\u00144,\u001a\u001d\u0010\u0013\u001ca$0\u0012\u0004 .\u0010\rY\f\u001d2+\r\u0000\u0016\u0012R'-\u000bI\f\u0012\u00133;Y\u0006\t\u0019\u0000 6\u0016\u001bY\u0004*5<\t\u0007:9;\r\u000b7.\u0003535\u0004-=<\u0013\u0004:/1\u0013\u0004:3!\u0013\u00058?=\u0015\u0010\u0004\u0017\t\u001e-\u0003:3!\u00058?=\u0012\n\u0002EB\u00164\u0015\u0001,#\r\n\u0011\u0019\u0016a2\u0018\u001b\u001c\u0012\u0006)'\n\f\n\u001e,\u0012\u0019/-\u000e\u0007Y\u0013\u0002$0\u0018\u001d\u0016\u000eR.0Y\u000f\f\u0012\u00115+\u0016\u0007C\\\u0004?=1\u0015\u0005?0=\u000e\u0010\u0004:/1\t\u00058(3\u000f\n\nY\u0019\n1'\u001a\u001d\u001c\u0018R\u0011,\u0012\u001792\u001c\n\r\u0019\u0016a6\u0016\u0002\u001c\u0012R\u0011,\u0012\u0019/-\u000e\u0007Y\u0013\u0002$0\u0018\u001d\u0016\u000eR\u0003+=6\u001d?\u0015\u000026Y\u0006\t\u0019\u0000 ,\u001dI\u0014\u001d\u000ba,\u0016\u001dY\u001e\u0017a,\f\u0005\u0015\u00058?=\u0012\u0010\u0002)5\u0002DA\u0003-=<\u000373&\u001e*\u0019\u0011.,\u001dI\u0016\f\u00173#\u0017\rY\u0011\u00138b\u0017\u0006\r\\\u0010$b\u0017\u001c\u0015\u0010\u00104\u0015\u00012+\u0017\u000eY\u0013\u0002$0\u0018\u001d\u0016\u000e\u0003:/1\u0005+3'\u000f\u0006\u00058/;\u000f\n\u0004:3!\t\u000345<\u0002_Z\u001d-\u0013\u001da/\u0018\u0007\u0000\\\u001c4/\u001b\f\u000b\u000fR.0Y\u001f\u0018\u000e\u001b  \u0015\f\n\u0002EA\u0017,\u0012\u0019/-\u000e\u0007Y\t\u001c 0\u0000I\u0016\f\u00173#\r\u0006\u000b\\\u0005535pr\u0005?=>\u0012\u0007\u0004-=<\t\u00058(3\u000fp".length();
                var1_4 = 102;
                Expression.b(0);
                var0_5 = -1;
lbl8:
                // 2 sources

                while (true) {
                    v0 = 89;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block9;
                    break;
                }
lbl14:
                // 1 sources

                while (true) {
                    var5[var3_1++] = Expression.a(v0, Expression.a(v2));
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = ">.5\t\u0005>)=\t\u0016";
                    var4_3 = ">.5\t\u0005>)=\t\u0016".length();
                    var1_4 = 4;
                    var0_5 = -1;
lbl23:
                    // 2 sources

                    while (true) {
                        v0 = 95;
                        v4 = ++var0_5;
                        v2 = var2_2.substring(v4, v4 + var1_4);
                        v3 = 0;
                        break block9;
                        break;
                    }
                    break;
                }
lbl29:
                // 1 sources

                while (true) {
                    var5[var3_1++] = Expression.a(v0, Expression.a(v2));
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block10;
                    break;
                }
            }
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl40:
                // 1 sources

                ** continue;
            }
        }
        Expression.b = var5;
        Expression.MISSING_PARAMETERS_FOR_OPERATOR = Expression.b[17];
        var0_6 = Expression.b;
        Expression.PI = new BigDecimal(var0_6[0]);
        Expression.e = new BigDecimal(var0_6[34]);
        Expression.PARAMS_START = new LazyNumber(){

            @Override
            public BigDecimal eval() {
                return null;
            }

            @Override
            public String getString() {
                return null;
            }
        };
    }

    public static void b(int n) {
        a = n;
    }

    public static int b() {
        return a;
    }

    public static int c() {
        int n = Expression.b();
        try {
            if (n == 0) {
                return 99;
            }
        }
        catch (ExpressionException expressionException) {
            throw Expression.b(expressionException);
        }
        return 0;
    }

    private static ExpressionException b(ExpressionException expressionException) {
        return expressionException;
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x30);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 32;
                        break;
                    }
                    case 1: {
                        n5 = 37;
                        break;
                    }
                    case 2: {
                        n5 = 43;
                        break;
                    }
                    case 3: {
                        n5 = 24;
                        break;
                    }
                    case 4: {
                        n5 = 27;
                        break;
                    }
                    case 5: {
                        n5 = 32;
                        break;
                    }
                    default: {
                        n5 = 48;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }

    public static interface LazyNumber {
        public BigDecimal eval();

        public String getString();
    }

    private class Tokenizer
    implements Iterator<Token> {
        private int pos = 0;
        private final String input;
        private Token previousToken;
        private static final String a = Tokenizer.a(90, Tokenizer.a("\\\u000eO^\u001e\u000b2\u0007KL^\u001cNi[\u001bR^\u001a\u001a\u007fJ"));

        public Tokenizer(String string) {
            this.input = string.trim();
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            try {
                bl = this.pos < this.input.length();
            }
            catch (ExpressionException expressionException) {
                throw Tokenizer.b(expressionException);
            }
            return bl;
        }

        private char peekNextChar() {
            try {
                if (this.pos < this.input.length() - 1) {
                    return this.input.charAt(this.pos + 1);
                }
            }
            catch (ExpressionException expressionException) {
                throw Tokenizer.b(expressionException);
            }
            return '\u0000';
        }

        private boolean isHexDigit(char c) {
            boolean bl;
            block20: {
                block19: {
                    try {
                        block16: {
                            try {
                                try {
                                    block18: {
                                        try {
                                            try {
                                                block17: {
                                                    try {
                                                        try {
                                                            try {
                                                                if (c == 'x' || c == 'X') break block16;
                                                            }
                                                            catch (ExpressionException expressionException) {
                                                                throw Tokenizer.b(expressionException);
                                                            }
                                                            if (c < '0') break block17;
                                                        }
                                                        catch (ExpressionException expressionException) {
                                                            throw Tokenizer.b(expressionException);
                                                        }
                                                        if (c <= '9') break block16;
                                                    }
                                                    catch (ExpressionException expressionException) {
                                                        throw Tokenizer.b(expressionException);
                                                    }
                                                }
                                                if (c < 'a') break block18;
                                            }
                                            catch (ExpressionException expressionException) {
                                                throw Tokenizer.b(expressionException);
                                            }
                                            if (c <= 'f') break block16;
                                        }
                                        catch (ExpressionException expressionException) {
                                            throw Tokenizer.b(expressionException);
                                        }
                                    }
                                    if (c < 'A') break block19;
                                }
                                catch (ExpressionException expressionException) {
                                    throw Tokenizer.b(expressionException);
                                }
                                if (c > 'F') break block19;
                            }
                            catch (ExpressionException expressionException) {
                                throw Tokenizer.b(expressionException);
                            }
                        }
                        bl = true;
                        break block20;
                    }
                    catch (ExpressionException expressionException) {
                        throw Tokenizer.b(expressionException);
                    }
                }
                bl = false;
            }
            return bl;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Token next() {
            block166: {
                block164: {
                    block188: {
                        block185: {
                            block181: {
                                block183: {
                                    block177: {
                                        block174: {
                                            block176: {
                                                block175: {
                                                    block171: {
                                                        block173: {
                                                            block172: {
                                                                block169: {
                                                                    block165: {
                                                                        block158: {
                                                                            block159: {
                                                                                block156: {
                                                                                    var2_1 = new Token();
                                                                                    var1_2 = AbstractLazyFunction.b();
                                                                                    try {
                                                                                        if (this.pos >= this.input.length()) {
                                                                                            this.previousToken = null;
                                                                                            return null;
                                                                                        }
                                                                                    }
                                                                                    catch (ExpressionException v0) {
                                                                                        throw Tokenizer.b(v0);
                                                                                    }
                                                                                    var3_3 = this.input.charAt(this.pos);
                                                                                    while (Character.isWhitespace(var3_3)) {
                                                                                        try {
                                                                                            v1 = this.pos++;
                                                                                            if (var1_2 == 0) break block156;
                                                                                            if (v1 >= this.input.length()) break;
                                                                                        }
                                                                                        catch (ExpressionException v2) {
                                                                                            throw Tokenizer.b(v2);
                                                                                        }
                                                                                        var3_3 = this.input.charAt(this.pos);
                                                                                        if (var1_2 != 0) continue;
                                                                                    }
                                                                                    var2_1.pos = this.pos;
                                                                                    v1 = 0;
                                                                                }
                                                                                var4_4 = v1;
                                                                                try {
                                                                                    try {
                                                                                        try {
                                                                                            block157: {
                                                                                                try {
                                                                                                    try {
                                                                                                        if (Character.isDigit(var3_3)) break block157;
                                                                                                        if (var3_3 == '.') {
                                                                                                        }
                                                                                                        ** GOTO lbl158
                                                                                                    }
                                                                                                    catch (ExpressionException v3) {
                                                                                                        throw Tokenizer.b(v3);
                                                                                                    }
                                                                                                    if (Character.isDigit(this.peekNextChar())) {
                                                                                                    }
                                                                                                    ** GOTO lbl158
                                                                                                }
                                                                                                catch (ExpressionException v4) {
                                                                                                    throw Tokenizer.b(v4);
                                                                                                }
                                                                                            }
                                                                                            if (var3_3 != '0') break block158;
                                                                                        }
                                                                                        catch (ExpressionException v5) {
                                                                                            throw Tokenizer.b(v5);
                                                                                        }
                                                                                        if (this.peekNextChar() == 'x') break block159;
                                                                                    }
                                                                                    catch (ExpressionException v6) {
                                                                                        throw Tokenizer.b(v6);
                                                                                    }
                                                                                    if (this.peekNextChar() != 'X') break block158;
                                                                                }
                                                                                catch (ExpressionException v7) {
                                                                                    throw Tokenizer.b(v7);
                                                                                }
                                                                            }
                                                                            var4_4 = 1;
                                                                        }
                                                                        do {
                                                                            block163: {
                                                                                block160: {
                                                                                    if (var4_4 == 0) ** GOTO lbl68
                                                                                    try {
                                                                                        try {
                                                                                            v8 = this.isHexDigit(var3_3);
                                                                                            if (var1_2 == 0) break block160;
                                                                                            if (!v8) {
                                                                                            }
                                                                                            ** GOTO lbl137
                                                                                        }
                                                                                        catch (ExpressionException v9) {
                                                                                            throw Tokenizer.b(v9);
                                                                                        }
lbl68:
                                                                                        // 2 sources

                                                                                        v8 = Character.isDigit(var3_3);
                                                                                    }
                                                                                    catch (ExpressionException v10) {
                                                                                        throw Tokenizer.b(v10);
                                                                                    }
                                                                                }
                                                                                try {
                                                                                    try {
                                                                                        try {
                                                                                            block161: {
                                                                                                try {
                                                                                                    try {
                                                                                                        try {
                                                                                                            try {
                                                                                                                block162: {
                                                                                                                    try {
                                                                                                                        try {
                                                                                                                            try {
                                                                                                                                try {
                                                                                                                                    try {
                                                                                                                                        try {
                                                                                                                                            try {
                                                                                                                                                if (v8 || var3_3 == '.') break block161;
                                                                                                                                            }
                                                                                                                                            catch (ExpressionException v11) {
                                                                                                                                                throw Tokenizer.b(v11);
                                                                                                                                            }
                                                                                                                                            if (var3_3 == 'e') break block161;
                                                                                                                                        }
                                                                                                                                        catch (ExpressionException v12) {
                                                                                                                                            throw Tokenizer.b(v12);
                                                                                                                                        }
                                                                                                                                        if (var3_3 == 'E') break block161;
                                                                                                                                    }
                                                                                                                                    catch (ExpressionException v13) {
                                                                                                                                        throw Tokenizer.b(v13);
                                                                                                                                    }
                                                                                                                                    if (var3_3 != '-') break block162;
                                                                                                                                }
                                                                                                                                catch (ExpressionException v14) {
                                                                                                                                    throw Tokenizer.b(v14);
                                                                                                                                }
                                                                                                                                if (var2_1.length() <= 0) break block162;
                                                                                                                            }
                                                                                                                            catch (ExpressionException v15) {
                                                                                                                                throw Tokenizer.b(v15);
                                                                                                                            }
                                                                                                                            if ('e' == var2_1.charAt(var2_1.length() - 1)) break block161;
                                                                                                                        }
                                                                                                                        catch (ExpressionException v16) {
                                                                                                                            throw Tokenizer.b(v16);
                                                                                                                        }
                                                                                                                        if ('E' == var2_1.charAt(var2_1.length() - 1)) break block161;
                                                                                                                    }
                                                                                                                    catch (ExpressionException v17) {
                                                                                                                        throw Tokenizer.b(v17);
                                                                                                                    }
                                                                                                                }
                                                                                                                if (var3_3 != '+') break;
                                                                                                            }
                                                                                                            catch (ExpressionException v18) {
                                                                                                                throw Tokenizer.b(v18);
                                                                                                            }
                                                                                                            if (var2_1.length() <= 0) break;
                                                                                                        }
                                                                                                        catch (ExpressionException v19) {
                                                                                                            throw Tokenizer.b(v19);
                                                                                                        }
                                                                                                        if ('e' == var2_1.charAt(var2_1.length() - 1)) break block161;
                                                                                                    }
                                                                                                    catch (ExpressionException v20) {
                                                                                                        throw Tokenizer.b(v20);
                                                                                                    }
                                                                                                    if ('E' != var2_1.charAt(var2_1.length() - 1)) break;
                                                                                                }
                                                                                                catch (ExpressionException v21) {
                                                                                                    throw Tokenizer.b(v21);
                                                                                                }
                                                                                            }
                                                                                            if (this.pos >= this.input.length()) break;
                                                                                        }
                                                                                        catch (ExpressionException v22) {
                                                                                            throw Tokenizer.b(v22);
                                                                                        }
lbl137:
                                                                                        // 2 sources

                                                                                        var2_1.append(this.input.charAt(this.pos++));
                                                                                        if (this.pos != this.input.length()) break block163;
                                                                                    }
                                                                                    catch (ExpressionException v23) {
                                                                                        throw Tokenizer.b(v23);
                                                                                    }
                                                                                    v24 = '\u0000';
                                                                                    continue;
                                                                                }
                                                                                catch (ExpressionException v25) {
                                                                                    throw Tokenizer.b(v25);
                                                                                }
                                                                            }
                                                                            v24 = var3_3 = this.input.charAt(this.pos);
                                                                        } while (var1_2 != 0);
                                                                        try {
                                                                            v26 = var2_1;
                                                                            v27 = var4_4 != 0 ? TokenType.HEX_LITERAL : TokenType.LITERAL;
                                                                        }
                                                                        catch (ExpressionException v28) {
                                                                            throw Tokenizer.b(v28);
                                                                        }
                                                                        try {
                                                                            try {
                                                                                v26.type = v27;
                                                                                if (var1_2 != 0) break block164;
lbl158:
                                                                                // 3 sources

                                                                                if (var3_3 != '\"') break block165;
                                                                            }
                                                                            catch (ExpressionException v29) {
                                                                                throw Tokenizer.b(v29);
                                                                            }
                                                                            ++this.pos;
                                                                            if (this.previousToken.type != TokenType.STRINGPARAM) {
                                                                            }
                                                                            ** GOTO lbl190
                                                                        }
                                                                        catch (ExpressionException v30) {
                                                                            throw Tokenizer.b(v30);
                                                                        }
                                                                        var3_3 = this.input.charAt(this.pos);
                                                                        while (var3_3 != '\"') {
                                                                            block168: {
                                                                                block167: {
                                                                                    try {
                                                                                        try {
                                                                                            var2_1.append(this.input.charAt(this.pos++));
                                                                                            v31 = this;
                                                                                            if (var1_2 == 0) break block166;
                                                                                            if (v31.pos != this.input.length()) break block167;
                                                                                        }
                                                                                        catch (ExpressionException v32) {
                                                                                            throw Tokenizer.b(v32);
                                                                                        }
                                                                                        v33 = '\u0000';
                                                                                        break block168;
                                                                                    }
                                                                                    catch (ExpressionException v34) {
                                                                                        throw Tokenizer.b(v34);
                                                                                    }
                                                                                }
                                                                                v33 = var3_3 = this.input.charAt(this.pos);
                                                                            }
                                                                            if (var1_2 != 0) continue;
                                                                        }
                                                                        try {
                                                                            var2_1.type = TokenType.STRINGPARAM;
                                                                            if (var1_2 != 0) break block164;
lbl190:
                                                                            // 2 sources

                                                                            return this.next();
                                                                        }
                                                                        catch (ExpressionException v35) {
                                                                            throw Tokenizer.b(v35);
                                                                        }
                                                                    }
                                                                    try {
                                                                        try {
                                                                            if (Character.isLetter(var3_3) || Expression.access$000(Expression.this).indexOf(var3_3) >= 0) {
                                                                            }
                                                                            ** GOTO lbl311
                                                                        }
                                                                        catch (ExpressionException v36) {
                                                                            throw Tokenizer.b(v36);
                                                                        }
lbl201:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            if (!Character.isLetter(var3_3)) {
                                                                            }
                                                                            ** GOTO lbl230
                                                                            break;
                                                                        }
                                                                    }
                                                                    catch (ExpressionException v37) {
                                                                        throw Tokenizer.b(v37);
                                                                    }
                                                                    try {
                                                                        block170: {
                                                                            try {
                                                                                try {
                                                                                    try {
                                                                                        try {
                                                                                            v38 = (int)Character.isDigit(var3_3);
                                                                                            if (var1_2 == 0) break block169;
                                                                                            if (v38 != 0) break block170;
                                                                                        }
                                                                                        catch (ExpressionException v39) {
                                                                                            throw Tokenizer.b(v39);
                                                                                        }
                                                                                        if (Expression.access$100(Expression.this).indexOf(var3_3) >= 0) break block170;
                                                                                    }
                                                                                    catch (ExpressionException v40) {
                                                                                        throw Tokenizer.b(v40);
                                                                                    }
                                                                                    if (var2_1.length() != 0) break block171;
                                                                                }
                                                                                catch (ExpressionException v41) {
                                                                                    throw Tokenizer.b(v41);
                                                                                }
                                                                                if (Expression.access$000(Expression.this).indexOf(var3_3) < 0) break block171;
                                                                            }
                                                                            catch (ExpressionException v42) {
                                                                                throw Tokenizer.b(v42);
                                                                            }
                                                                        }
                                                                        v38 = this.pos;
                                                                    }
                                                                    catch (ExpressionException v43) {
                                                                        throw Tokenizer.b(v43);
                                                                    }
                                                                }
                                                                try {
                                                                    try {
                                                                        if (v38 >= this.input.length()) break block171;
                                                                        var2_1.append(this.input.charAt(this.pos++));
                                                                        if (this.pos != this.input.length()) break block172;
                                                                    }
                                                                    catch (ExpressionException v44) {
                                                                        throw Tokenizer.b(v44);
                                                                    }
                                                                    v45 = '\u0000';
                                                                    break block173;
                                                                }
                                                                catch (ExpressionException v46) {
                                                                    throw Tokenizer.b(v46);
                                                                }
                                                            }
                                                            v45 = var3_3 = this.input.charAt(this.pos);
                                                        }
                                                        ** while (var1_2 != 0)
                                                    }
                                                    try {
                                                        if (!Character.isWhitespace(var3_3)) break block174;
lbl255:
                                                        // 2 sources

                                                        while (Character.isWhitespace(var3_3)) {
                                                            break block175;
                                                        }
                                                        break block176;
                                                    }
                                                    catch (ExpressionException v47) {
                                                        throw Tokenizer.b(v47);
                                                    }
                                                }
                                                try {
                                                    v48 = this.pos;
                                                    v49 = this.input.length();
                                                    if (var1_2 == 0) break block177;
                                                    if (v48 >= v49) break block176;
                                                }
                                                catch (ExpressionException v50) {
                                                    throw Tokenizer.b(v50);
                                                }
                                                var3_3 = this.input.charAt(this.pos++);
                                                if (var1_2 != 0) ** GOTO lbl255
                                            }
                                            --this.pos;
                                        }
                                        try {
                                            block178: {
                                                try {
                                                    if (!Expression.this.operators.containsKey(var2_1.surface)) break block178;
                                                    var2_1.type = TokenType.OPERATOR;
                                                    if (var1_2 != 0) break block164;
                                                }
                                                catch (ExpressionException v51) {
                                                    throw Tokenizer.b(v51);
                                                }
                                            }
                                            v48 = var3_3;
                                            v49 = 40;
                                        }
                                        catch (ExpressionException v52) {
                                            throw Tokenizer.b(v52);
                                        }
                                    }
                                    try {
                                        block184: {
                                            try {
                                                try {
                                                    block182: {
                                                        try {
                                                            try {
                                                                block180: {
                                                                    try {
                                                                        try {
                                                                            try {
                                                                                try {
                                                                                    block179: {
                                                                                        try {
                                                                                            if (v48 != v49) break block179;
                                                                                            var2_1.type = TokenType.FUNCTION;
                                                                                            if (var1_2 != 0) break block164;
                                                                                        }
                                                                                        catch (ExpressionException v53) {
                                                                                            throw Tokenizer.b(v53);
                                                                                        }
                                                                                    }
                                                                                    var2_1.type = TokenType.VARIABLE;
                                                                                    if (var1_2 != 0) break block164;
                                                                                }
                                                                                catch (ExpressionException v54) {
                                                                                    throw Tokenizer.b(v54);
                                                                                }
lbl311:
                                                                                // 2 sources

                                                                                if (var3_3 == '(') break block180;
                                                                            }
                                                                            catch (ExpressionException v55) {
                                                                                throw Tokenizer.b(v55);
                                                                            }
                                                                            if (var3_3 == ')') break block180;
                                                                        }
                                                                        catch (ExpressionException v56) {
                                                                            throw Tokenizer.b(v56);
                                                                        }
                                                                        if (var3_3 != ',') break block181;
                                                                    }
                                                                    catch (ExpressionException v57) {
                                                                        throw Tokenizer.b(v57);
                                                                    }
                                                                }
                                                                if (var3_3 != '(') break block182;
                                                            }
                                                            catch (ExpressionException v58) {
                                                                throw Tokenizer.b(v58);
                                                            }
                                                            var2_1.type = TokenType.OPEN_PAREN;
                                                            if (var1_2 != 0) break block183;
                                                        }
                                                        catch (ExpressionException v59) {
                                                            throw Tokenizer.b(v59);
                                                        }
                                                    }
                                                    if (var3_3 != ')') break block184;
                                                }
                                                catch (ExpressionException v60) {
                                                    throw Tokenizer.b(v60);
                                                }
                                                var2_1.type = TokenType.CLOSE_PAREN;
                                                if (var1_2 != 0) break block183;
                                            }
                                            catch (ExpressionException v61) {
                                                throw Tokenizer.b(v61);
                                            }
                                        }
                                        var2_1.type = TokenType.COMMA;
                                    }
                                    catch (ExpressionException v62) {
                                        throw Tokenizer.b(v62);
                                    }
                                }
                                var2_1.append(var3_3);
                                ++this.pos;
                                if (var1_2 != 0) break block164;
                            }
                            var5_5 = new StringBuilder();
                            var6_6 = this.pos;
                            var3_3 = this.input.charAt(this.pos);
                            var7_7 = -1;
                            while (!Character.isLetter(var3_3)) {
                                block186: {
                                    try {
                                        try {
                                            try {
                                                try {
                                                    try {
                                                        try {
                                                            try {
                                                                try {
                                                                    v63 = (int)Character.isDigit(var3_3);
                                                                    if (var1_2 == 0) break block185;
                                                                    if (v63 != 0) break;
                                                                }
                                                                catch (ExpressionException v64) {
                                                                    throw Tokenizer.b(v64);
                                                                }
                                                                if (Expression.access$000(Expression.this).indexOf(var3_3) >= 0) break;
                                                            }
                                                            catch (ExpressionException v65) {
                                                                throw Tokenizer.b(v65);
                                                            }
                                                            if (Character.isWhitespace(var3_3)) break;
                                                        }
                                                        catch (ExpressionException v66) {
                                                            throw Tokenizer.b(v66);
                                                        }
                                                        if (var3_3 == '(') break;
                                                    }
                                                    catch (ExpressionException v67) {
                                                        throw Tokenizer.b(v67);
                                                    }
                                                    if (var3_3 == ')') break;
                                                }
                                                catch (ExpressionException v68) {
                                                    throw Tokenizer.b(v68);
                                                }
                                                if (var3_3 == ',') break;
                                            }
                                            catch (ExpressionException v69) {
                                                throw Tokenizer.b(v69);
                                            }
                                            if (this.pos >= this.input.length()) break;
                                        }
                                        catch (ExpressionException v70) {
                                            throw Tokenizer.b(v70);
                                        }
                                        var5_5.append(var3_3);
                                        ++this.pos;
                                        if (!Expression.this.operators.containsKey(var5_5.toString())) break block186;
                                    }
                                    catch (ExpressionException v71) {
                                        throw Tokenizer.b(v71);
                                    }
                                    var7_7 = this.pos;
                                }
                                try {
                                    v72 = var3_3 = this.pos == this.input.length() ? '\u0000' : this.input.charAt(this.pos);
                                }
                                catch (ExpressionException v73) {
                                    throw Tokenizer.b(v73);
                                }
                                if (var1_2 != 0) continue;
                            }
                            v63 = var7_7;
                        }
                        try {
                            block187: {
                                try {
                                    if (v63 == -1) break block187;
                                    var2_1.append(this.input.substring(var6_6, var7_7));
                                    this.pos = var7_7;
                                    if (var1_2 != 0) break block188;
                                }
                                catch (ExpressionException v74) {
                                    throw Tokenizer.b(v74);
                                }
                            }
                            var2_1.append(var5_5.toString());
                        }
                        catch (ExpressionException v75) {
                            throw Tokenizer.b(v75);
                        }
                    }
                    try {
                        block190: {
                            try {
                                block189: {
                                    try {
                                        try {
                                            try {
                                                try {
                                                    if (this.previousToken == null || this.previousToken.type == TokenType.OPERATOR) break block189;
                                                }
                                                catch (ExpressionException v76) {
                                                    throw Tokenizer.b(v76);
                                                }
                                                if (this.previousToken.type == TokenType.OPEN_PAREN) break block189;
                                            }
                                            catch (ExpressionException v77) {
                                                throw Tokenizer.b(v77);
                                            }
                                            if (this.previousToken.type == TokenType.COMMA) break block189;
                                        }
                                        catch (ExpressionException v78) {
                                            throw Tokenizer.b(v78);
                                        }
                                        if (this.previousToken.type != TokenType.UNARY_OPERATOR) break block190;
                                    }
                                    catch (ExpressionException v79) {
                                        throw Tokenizer.b(v79);
                                    }
                                }
                                var2_1.surface = var2_1.surface + "u";
                                var2_1.type = TokenType.UNARY_OPERATOR;
                                if (var1_2 != 0) break block164;
                            }
                            catch (ExpressionException v80) {
                                throw Tokenizer.b(v80);
                            }
                        }
                        var2_1.type = TokenType.OPERATOR;
                    }
                    catch (ExpressionException v81) {
                        throw Tokenizer.b(v81);
                    }
                }
                v31 = this;
            }
            v31.previousToken = var2_1;
            return var2_1;
        }

        @Override
        public void remove() {
            throw new ExpressionException(a);
        }

        private static ExpressionException b(ExpressionException expressionException) {
            return expressionException;
        }

        private static char[] a(String string) {
            char[] cArray = string.toCharArray();
            if (cArray.length < 2) {
                cArray = cArray;
                cArray[0] = (char)(cArray[0] ^ 0x40);
            }
            return cArray;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        private static String a(int n, char[] cArray) {
            char[] cArray2;
            block11: {
                int n2;
                int n3;
                int n4;
                block10: {
                    n4 = n;
                    cArray2 = cArray;
                    n3 = cArray.length;
                    n2 = 0;
                    if (!true) break block10;
                    n3 = n3;
                    if (n3 <= n2) break block11;
                }
                do {
                    int n5;
                    n4 = n4;
                    cArray2 = cArray2;
                    int n6 = n2;
                    switch (n2 % 7) {
                        case 0: {
                            n5 = 116;
                            break;
                        }
                        case 1: {
                            n5 = 49;
                            break;
                        }
                        case 2: {
                            n5 = 120;
                            break;
                        }
                        case 3: {
                            n5 = 107;
                            break;
                        }
                        case 4: {
                            n5 = 50;
                            break;
                        }
                        case 5: {
                            n5 = 52;
                            break;
                        }
                        default: {
                            n5 = 64;
                        }
                    }
                    cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                    ++n2;
                    n3 = n3;
                } while (n3 > n2);
            }
            return new String(cArray2).intern();
        }
    }

    public class Token {
        public String surface = "";
        public TokenType type;
        public int pos;

        public void append(char c) {
            this.surface = this.surface + c;
        }

        public void append(String string) {
            this.surface = this.surface + string;
        }

        public char charAt(int n) {
            return this.surface.charAt(n);
        }

        public int length() {
            return this.surface.length();
        }

        public String toString() {
            return this.surface;
        }
    }

    static final class TokenType
    extends Enum<TokenType> {
        public static final /* enum */ TokenType VARIABLE;
        public static final /* enum */ TokenType FUNCTION;
        public static final /* enum */ TokenType LITERAL;
        public static final /* enum */ TokenType OPERATOR;
        public static final /* enum */ TokenType UNARY_OPERATOR;
        public static final /* enum */ TokenType OPEN_PAREN;
        public static final /* enum */ TokenType COMMA;
        public static final /* enum */ TokenType CLOSE_PAREN;
        public static final /* enum */ TokenType HEX_LITERAL;
        public static final /* enum */ TokenType STRINGPARAM;
        private static final /* synthetic */ TokenType[] $VALUES;

        public static TokenType[] values() {
            return (TokenType[])$VALUES.clone();
        }

        public static TokenType valueOf(String string) {
            return Enum.valueOf(TokenType.class, string);
        }

        private static /* synthetic */ TokenType[] $values() {
            return new TokenType[]{VARIABLE, FUNCTION, LITERAL, OPERATOR, UNARY_OPERATOR, OPEN_PAREN, COMMA, CLOSE_PAREN, HEX_LITERAL, STRINGPARAM};
        }

        /*
         * Unable to fully structure code
         */
        static {
            block10: {
                block9: {
                    var6 = new String[10];
                    var4_1 = 0;
                    var3_2 = "\u0012\u0005gq\u0015ue\b\u0011\u001cvf\u0006`f\f\u000b\u0016\tkk\u000b}}\u001b\u001erx\u000b\u001d\u0000|g\u0002ky\u001f\u001evz\u000e\u000b\u0002rf\u001ekf\u000e\tau\u0013{{\u0005\u001d\u0003~y\u0006\b\b\ra}\u0006ve\u001b\n\u0011\u001cvz\u0018dh\f\t}";
                    var5_3 = "\u0012\u0005gq\u0015ue\b\u0011\u001cvf\u0006`f\f\u000b\u0016\tkk\u000b}}\u001b\u001erx\u000b\u001d\u0000|g\u0002ky\u001f\u001evz\u000e\u000b\u0002rf\u001ekf\u000e\tau\u0013{{\u0005\u001d\u0003~y\u0006\b\b\ra}\u0006ve\u001b\n\u0011\u001cvz\u0018dh\f\t}".length();
                    var2_4 = 7;
                    var1_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 117;
                        v1 = ++var1_5;
                        v2 = var3_2.substring(v1, v1 + var2_4);
                        v3 = -1;
                        break block9;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var6[var4_1++] = TokenType.a(v0, TokenType.a(v2));
                        if ((var1_5 += var2_4) < var5_3) {
                            var2_4 = var3_2.charAt(var1_5);
                            ** continue;
                        }
                        var3_2 = "WV28\\2)_\u000bBW.2F<6PQ=6";
                        var5_3 = "WV28\\2)_\u000bBW.2F<6PQ=6".length();
                        var2_4 = 8;
                        var1_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 58;
                            v4 = ++var1_5;
                            v2 = var3_2.substring(v4, v4 + var2_4);
                            v3 = 0;
                            break block9;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var6[var4_1++] = TokenType.a(v0, TokenType.a(v2));
                        if ((var1_5 += var2_4) < var5_3) {
                            var2_4 = var3_2.charAt(var1_5);
                            ** continue;
                        }
                        break block10;
                        break;
                    }
                }
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl39:
                    // 1 sources

                    ** continue;
                }
            }
            var0_6 = var6;
            TokenType.VARIABLE = new TokenType();
            TokenType.FUNCTION = new TokenType();
            TokenType.LITERAL = new TokenType();
            TokenType.OPERATOR = new TokenType();
            TokenType.UNARY_OPERATOR = new TokenType();
            TokenType.OPEN_PAREN = new TokenType();
            TokenType.COMMA = new TokenType();
            TokenType.CLOSE_PAREN = new TokenType();
            TokenType.HEX_LITERAL = new TokenType();
            TokenType.STRINGPARAM = new TokenType();
            TokenType.$VALUES = TokenType.$values();
        }

        private static char[] a(String string) {
            char[] cArray = string.toCharArray();
            if (cArray.length < 2) {
                cArray = cArray;
                cArray[0] = (char)(cArray[0] ^ 0x5C);
            }
            return cArray;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        private static String a(int n, char[] cArray) {
            char[] cArray2;
            block11: {
                int n2;
                int n3;
                int n4;
                block10: {
                    n4 = n;
                    cArray2 = cArray;
                    n3 = cArray.length;
                    n2 = 0;
                    if (!true) break block10;
                    n3 = n3;
                    if (n3 <= n2) break block11;
                }
                do {
                    int n5;
                    n4 = n4;
                    cArray2 = cArray2;
                    int n6 = n2;
                    switch (n2 % 7) {
                        case 0: {
                            n5 = 43;
                            break;
                        }
                        case 1: {
                            n5 = 57;
                            break;
                        }
                        case 2: {
                            n5 = 70;
                            break;
                        }
                        case 3: {
                            n5 = 65;
                            break;
                        }
                        case 4: {
                            n5 = 50;
                            break;
                        }
                        case 5: {
                            n5 = 65;
                            break;
                        }
                        default: {
                            n5 = 92;
                        }
                    }
                    cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                    ++n2;
                    n3 = n3;
                } while (n3 > n2);
            }
            return new String(cArray2).intern();
        }
    }

    public static class ExpressionException
    extends RuntimeException {
        private static final long serialVersionUID = 1118142866870779047L;
        private static final String a = ExpressionException.a(8, ExpressionException.a("F?bY\u0016$o\u0014?u\r\u0010>.\u00161e\u0010\u0001%a\b~"));

        public ExpressionException(String string) {
            super(string);
        }

        public ExpressionException(String string, int n) {
            super(string + a + n);
        }

        private static char[] a(String string) {
            char[] cArray = string.toCharArray();
            if (cArray.length < 2) {
                cArray = cArray;
                cArray[0] = (char)(cArray[0] ^ 6);
            }
            return cArray;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        private static String a(int n, char[] cArray) {
            char[] cArray2;
            block11: {
                int n2;
                int n3;
                int n4;
                block10: {
                    n4 = n;
                    cArray2 = cArray;
                    n3 = cArray.length;
                    n2 = 0;
                    if (!true) break block10;
                    n3 = n3;
                    if (n3 <= n2) break block11;
                }
                do {
                    int n5;
                    n4 = n4;
                    cArray2 = cArray2;
                    int n6 = n2;
                    switch (n2 % 7) {
                        case 0: {
                            n5 = 110;
                            break;
                        }
                        case 1: {
                            n5 = 86;
                            break;
                        }
                        case 2: {
                            n5 = 30;
                            break;
                        }
                        case 3: {
                            n5 = 113;
                            break;
                        }
                        case 4: {
                            n5 = 125;
                            break;
                        }
                        case 5: {
                            n5 = 68;
                            break;
                        }
                        default: {
                            n5 = 6;
                        }
                    }
                    cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                    ++n2;
                    n3 = n3;
                } while (n3 > n2);
            }
            return new String(cArray2).intern();
        }
    }

    public abstract class UnaryOperator
    extends AbstractUnaryOperator {
        public UnaryOperator(String string, int n, boolean bl) {
            super(string, n, bl);
        }
    }

    public abstract class Operator
    extends AbstractOperator {
        public Operator(String string, int n, boolean bl, boolean bl2) {
            super(string, n, bl, bl2);
        }

        public Operator(String string, int n, boolean bl) {
            super(string, n, bl);
        }
    }

    public abstract class Function
    extends AbstractFunction {
        public Function(String string, int n) {
            super(string, n);
        }

        public Function(String string, int n, boolean bl) {
            super(string, n, bl);
        }
    }

    public abstract class LazyFunction
    extends AbstractLazyFunction {
        public LazyFunction(String string, int n, boolean bl) {
            super(string, n, bl);
        }

        public LazyFunction(String string, int n) {
            super(string, n);
        }
    }
}

