/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.mobs.libs.apache.commons.math3.util;

import java.io.PrintStream;
import net.advancedplugins.mobs.impl.commons.effects.effects.AdvancedEffect;
import net.advancedplugins.mobs.libs.apache.commons.math3.exception.MathArithmeticException;
import net.advancedplugins.mobs.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.mobs.libs.apache.commons.math3.util.FastMathCalc;
import net.advancedplugins.mobs.libs.apache.commons.math3.util.FastMathLiteralArrays;
import net.advancedplugins.mobs.libs.apache.commons.math3.util.Precision;

public class FastMath {
    public static final double PI = Math.PI;
    public static final double E = Math.E;
    static final int EXP_INT_TABLE_MAX_INDEX = 750;
    static final int EXP_INT_TABLE_LEN = 1500;
    static final int LN_MANT_LEN = 1024;
    static final int EXP_FRAC_TABLE_LEN = 1025;
    private static final double LOG_MAX_VALUE;
    private static final boolean RECOMPUTE_TABLES_AT_RUNTIME = false;
    private static final double LN_2_A = 0.6931470632553101;
    private static final double LN_2_B = 1.1730463525082348E-7;
    private static final double[][] LN_QUICK_COEF;
    private static final double[][] LN_HI_PREC_COEF;
    private static final int SINE_TABLE_LEN = 14;
    private static final double[] SINE_TABLE_A;
    private static final double[] SINE_TABLE_B;
    private static final double[] COSINE_TABLE_A;
    private static final double[] COSINE_TABLE_B;
    private static final double[] TANGENT_TABLE_A;
    private static final double[] TANGENT_TABLE_B;
    private static final long[] RECIP_2PI;
    private static final long[] PI_O_4_BITS;
    private static final double[] EIGHTHS;
    private static final double[] CBRTTWO;
    private static final long HEX_40000000 = 0x40000000L;
    private static final long MASK_30BITS = -1073741824L;
    private static final int MASK_NON_SIGN_INT = Integer.MAX_VALUE;
    private static final long MASK_NON_SIGN_LONG = Long.MAX_VALUE;
    private static final long MASK_DOUBLE_EXPONENT = 0x7FF0000000000000L;
    private static final long MASK_DOUBLE_MANTISSA = 0xFFFFFFFFFFFFFL;
    private static final long IMPLICIT_HIGH_BIT = 0x10000000000000L;
    private static final double TWO_POWER_52 = 4.503599627370496E15;
    private static final double F_1_3 = 0.3333333333333333;
    private static final double F_1_5 = 0.2;
    private static final double F_1_7 = 0.14285714285714285;
    private static final double F_1_9 = 0.1111111111111111;
    private static final double F_1_11 = 0.09090909090909091;
    private static final double F_1_13 = 0.07692307692307693;
    private static final double F_1_15 = 0.06666666666666667;
    private static final double F_1_17 = 0.058823529411764705;
    private static final double F_3_4 = 0.75;
    private static final double F_15_16 = 0.9375;
    private static final double F_13_14 = 0.9285714285714286;
    private static final double F_11_12 = 0.9166666666666666;
    private static final double F_9_10 = 0.9;
    private static final double F_7_8 = 0.875;
    private static final double F_5_6 = 0.8333333333333334;
    private static final double F_1_2 = 0.5;
    private static final double F_1_4 = 0.25;
    private static AdvancedEffect[] a;
    private static final String[] b;

    private FastMath() {
    }

    private static double doubleHighPart(double d) {
        block4: {
            try {
                try {
                    if (!(d > -Precision.SAFE_MIN) || !(d < Precision.SAFE_MIN)) break block4;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                return d;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        long l = Double.doubleToRawLongBits(d);
        return Double.longBitsToDouble(l &= 0xFFFFFFFFC0000000L);
    }

    public static double sqrt(double d) {
        return Math.sqrt(d);
    }

    public static double cosh(double d) {
        block10: {
            block11: {
                block8: {
                    block9: {
                        try {
                            if (d != d) {
                                return d;
                            }
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        try {
                            if (!(d > 20.0)) break block8;
                            if (!(d >= LOG_MAX_VALUE)) break block9;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        double d2 = FastMath.exp(0.5 * d);
                        return 0.5 * d2 * d2;
                    }
                    return 0.5 * FastMath.exp(d);
                }
                try {
                    if (!(d < -20.0)) break block10;
                    if (!(d <= -LOG_MAX_VALUE)) break block11;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                double d3 = FastMath.exp(-0.5 * d);
                return 0.5 * d3 * d3;
            }
            return 0.5 * FastMath.exp(-d);
        }
        double[] dArray = new double[2];
        if (d < 0.0) {
            d = -d;
        }
        FastMath.exp(d, 0.0, dArray);
        double d4 = dArray[0] + dArray[1];
        double d5 = -(d4 - dArray[0] - dArray[1]);
        double d6 = d4 * 1.073741824E9;
        double d7 = d4 + d6 - d6;
        double d8 = d4 - d7;
        double d9 = 1.0 / d4;
        d6 = d9 * 1.073741824E9;
        double d10 = d9 + d6 - d6;
        double d11 = d9 - d10;
        d11 += (1.0 - d7 * d10 - d7 * d11 - d8 * d10 - d8 * d11) * d9;
        d11 += -d5 * d9 * d9;
        d6 = d4 + d10;
        d5 += -(d6 - d4 - d10);
        d4 = d6;
        d6 = d4 + d11;
        d5 += -(d6 - d4 - d11);
        d4 = d6;
        double d12 = d4 + d5;
        return d12 *= 0.5;
    }

    public static double sinh(double d) {
        double d2;
        boolean bl;
        block21: {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double[] dArray;
            block20: {
                AdvancedEffect[] advancedEffectArray;
                block18: {
                    block19: {
                        block16: {
                            block17: {
                                bl = false;
                                advancedEffectArray = FastMath.b();
                                try {
                                    if (d != d) {
                                        return d;
                                    }
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                                try {
                                    if (!(d > 20.0)) break block16;
                                    if (!(d >= LOG_MAX_VALUE)) break block17;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                                double d11 = FastMath.exp(0.5 * d);
                                return 0.5 * d11 * d11;
                            }
                            return 0.5 * FastMath.exp(d);
                        }
                        try {
                            if (!(d < -20.0)) break block18;
                            if (!(d <= -LOG_MAX_VALUE)) break block19;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        double d12 = FastMath.exp(-0.5 * d);
                        return -0.5 * d12 * d12;
                    }
                    return -0.5 * FastMath.exp(-d);
                }
                try {
                    if (d == 0.0) {
                        return d;
                    }
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                if (d < 0.0) {
                    d = -d;
                    bl = true;
                }
                if (!(d > 0.25)) break block20;
                dArray = new double[2];
                FastMath.exp(d, 0.0, dArray);
                d10 = dArray[0] + dArray[1];
                d9 = -(d10 - dArray[0] - dArray[1]);
                d8 = d10 * 1.073741824E9;
                d7 = d10 + d8 - d8;
                d6 = d10 - d7;
                d5 = 1.0 / d10;
                d8 = d5 * 1.073741824E9;
                d4 = d5 + d8 - d8;
                d3 = d5 - d4;
                d3 += (1.0 - d7 * d4 - d7 * d3 - d6 * d4 - d6 * d3) * d5;
                d3 += -d9 * d5 * d5;
                d4 = -d4;
                d3 = -d3;
                d8 = d10 + d4;
                d9 += -(d8 - d10 - d4);
                d10 = d8;
                d8 = d10 + d3;
                d9 += -(d8 - d10 - d3);
                d10 = d8;
                d2 = d10 + d9;
                d2 *= 0.5;
                if (advancedEffectArray == null) break block21;
            }
            dArray = new double[2];
            FastMath.expm1(d, dArray);
            d10 = dArray[0] + dArray[1];
            d9 = -(d10 - dArray[0] - dArray[1]);
            d8 = 1.0 + d10;
            d7 = 1.0 / d8;
            d6 = -(d8 - 1.0 - d10) + d9;
            d5 = d10 * d7;
            d4 = d5 * 1.073741824E9;
            d3 = d5 + d4 - d4;
            double d13 = d5 - d3;
            d4 = d8 * 1.073741824E9;
            double d14 = d8 + d4 - d4;
            double d15 = d8 - d14;
            d13 += (d10 - d14 * d3 - d14 * d13 - d15 * d3 - d15 * d13) * d7;
            d13 += d9 * d7;
            d13 += -d10 * d6 * d7 * d7;
            d4 = d10 + d3;
            d9 += -(d4 - d10 - d3);
            d10 = d4;
            d4 = d10 + d13;
            d9 += -(d4 - d10 - d13);
            d10 = d4;
            d2 = d10 + d9;
            d2 *= 0.5;
        }
        if (bl) {
            d2 = -d2;
        }
        return d2;
    }

    public static double tanh(double d) {
        double d2;
        boolean bl;
        block19: {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            double d13;
            double d14;
            double[] dArray;
            block18: {
                bl = false;
                AdvancedEffect[] advancedEffectArray = FastMath.b();
                try {
                    if (d != d) {
                        return d;
                    }
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                try {
                    if (d > 20.0) {
                        return 1.0;
                    }
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                try {
                    if (d < -20.0) {
                        return -1.0;
                    }
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                try {
                    if (d == 0.0) {
                        return d;
                    }
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                if (d < 0.0) {
                    d = -d;
                    bl = true;
                }
                if (!(d >= 0.5)) break block18;
                dArray = new double[2];
                FastMath.exp(d * 2.0, 0.0, dArray);
                d14 = dArray[0] + dArray[1];
                d13 = -(d14 - dArray[0] - dArray[1]);
                d12 = -1.0 + d14;
                d11 = -(d12 + 1.0 - d14);
                d10 = d12 + d13;
                d11 += -(d10 - d12 - d13);
                d12 = d10;
                d9 = 1.0 + d14;
                d8 = -(d9 - 1.0 - d14);
                d10 = d9 + d13;
                d8 += -(d10 - d9 - d13);
                d9 = d10;
                d10 = d9 * 1.073741824E9;
                d7 = d9 + d10 - d10;
                d6 = d9 - d7;
                d5 = d12 / d9;
                d10 = d5 * 1.073741824E9;
                d4 = d5 + d10 - d10;
                d3 = d5 - d4;
                d3 += (d12 - d7 * d4 - d7 * d3 - d6 * d4 - d6 * d3) / d9;
                d3 += d11 / d9;
                d2 = d4 + (d3 += -d8 * d12 / d9 / d9);
                if (advancedEffectArray == null) break block19;
            }
            dArray = new double[2];
            FastMath.expm1(d * 2.0, dArray);
            d14 = dArray[0] + dArray[1];
            d13 = -(d14 - dArray[0] - dArray[1]);
            d12 = d14;
            d11 = d13;
            d10 = 2.0 + d14;
            d9 = -(d10 - 2.0 - d14);
            d8 = d10 + d13;
            d9 += -(d8 - d10 - d13);
            d10 = d8;
            d8 = d10 * 1.073741824E9;
            d7 = d10 + d8 - d8;
            d6 = d10 - d7;
            d5 = d12 / d10;
            d8 = d5 * 1.073741824E9;
            d4 = d5 + d8 - d8;
            d3 = d5 - d4;
            d3 += (d12 - d7 * d4 - d7 * d3 - d6 * d4 - d6 * d3) / d10;
            d3 += d11 / d10;
            d2 = d4 + (d3 += -d9 * d12 / d10 / d10);
        }
        if (bl) {
            d2 = -d2;
        }
        return d2;
    }

    public static double acosh(double d) {
        return FastMath.log(d + FastMath.sqrt(d * d - 1.0));
    }

    /*
     * Unable to fully structure code
     */
    public static double asinh(double var0) {
        block13: {
            block14: {
                block15: {
                    var3_1 = false;
                    var2_2 = FastMath.b();
                    if (var0 < 0.0) {
                        var3_1 = true;
                        var0 = -var0;
                    }
                    if (!(var0 > 0.167)) break block15;
                    var4_3 = FastMath.log(FastMath.sqrt(var0 * var0 + 1.0) + var0);
                    if (var2_2 == null) break block13;
                }
                var6_4 = var0 * var0;
                if (!(var0 > 0.097)) ** GOTO lbl15
                var4_3 = var0 * (1.0 - var6_4 * (0.3333333333333333 - var6_4 * (0.2 - var6_4 * (0.14285714285714285 - var6_4 * (0.1111111111111111 - var6_4 * (0.09090909090909091 - var6_4 * (0.07692307692307693 - var6_4 * (0.06666666666666667 - var6_4 * 0.058823529411764705 * 0.9375) * 0.9285714285714286) * 0.9166666666666666) * 0.9) * 0.875) * 0.8333333333333334) * 0.75) * 0.5);
                try {
                    if (var2_2 == null) break block13;
lbl15:
                    // 2 sources

                    if (var0 > 0.036) {
                    }
                    ** GOTO lbl23
                }
                catch (MathArithmeticException v0) {
                    throw FastMath.b(v0);
                }
                var4_3 = var0 * (1.0 - var6_4 * (0.3333333333333333 - var6_4 * (0.2 - var6_4 * (0.14285714285714285 - var6_4 * (0.1111111111111111 - var6_4 * (0.09090909090909091 - var6_4 * 0.07692307692307693 * 0.9166666666666666) * 0.9) * 0.875) * 0.8333333333333334) * 0.75) * 0.5);
                try {
                    if (var2_2 == null) break block13;
lbl23:
                    // 2 sources

                    if (!(var0 > 0.0036)) break block14;
                }
                catch (MathArithmeticException v1) {
                    throw FastMath.b(v1);
                }
                var4_3 = var0 * (1.0 - var6_4 * (0.3333333333333333 - var6_4 * (0.2 - var6_4 * (0.14285714285714285 - var6_4 * 0.1111111111111111 * 0.875) * 0.8333333333333334) * 0.75) * 0.5);
                if (var2_2 == null) break block13;
            }
            var4_3 = var0 * (1.0 - var6_4 * (0.3333333333333333 - var6_4 * 0.2 * 0.75) * 0.5);
        }
        try {
            v2 = var3_1 != false ? -var4_3 : var4_3;
        }
        catch (MathArithmeticException v3) {
            throw FastMath.b(v3);
        }
        return v2;
    }

    /*
     * Unable to fully structure code
     */
    public static double atanh(double var0) {
        block13: {
            block14: {
                block15: {
                    var3_1 = false;
                    var2_2 = FastMath.b();
                    if (var0 < 0.0) {
                        var3_1 = true;
                        var0 = -var0;
                    }
                    if (!(var0 > 0.15)) break block15;
                    var4_3 = 0.5 * FastMath.log((1.0 + var0) / (1.0 - var0));
                    if (var2_2 == null) break block13;
                }
                var6_4 = var0 * var0;
                if (!(var0 > 0.087)) ** GOTO lbl15
                var4_3 = var0 * (1.0 + var6_4 * (0.3333333333333333 + var6_4 * (0.2 + var6_4 * (0.14285714285714285 + var6_4 * (0.1111111111111111 + var6_4 * (0.09090909090909091 + var6_4 * (0.07692307692307693 + var6_4 * (0.06666666666666667 + var6_4 * 0.058823529411764705))))))));
                try {
                    if (var2_2 == null) break block13;
lbl15:
                    // 2 sources

                    if (var0 > 0.031) {
                    }
                    ** GOTO lbl23
                }
                catch (MathArithmeticException v0) {
                    throw FastMath.b(v0);
                }
                var4_3 = var0 * (1.0 + var6_4 * (0.3333333333333333 + var6_4 * (0.2 + var6_4 * (0.14285714285714285 + var6_4 * (0.1111111111111111 + var6_4 * (0.09090909090909091 + var6_4 * 0.07692307692307693))))));
                try {
                    if (var2_2 == null) break block13;
lbl23:
                    // 2 sources

                    if (!(var0 > 0.003)) break block14;
                }
                catch (MathArithmeticException v1) {
                    throw FastMath.b(v1);
                }
                var4_3 = var0 * (1.0 + var6_4 * (0.3333333333333333 + var6_4 * (0.2 + var6_4 * (0.14285714285714285 + var6_4 * 0.1111111111111111))));
                if (var2_2 == null) break block13;
            }
            var4_3 = var0 * (1.0 + var6_4 * (0.3333333333333333 + var6_4 * 0.2));
        }
        try {
            v2 = var3_1 != false ? -var4_3 : var4_3;
        }
        catch (MathArithmeticException v3) {
            throw FastMath.b(v3);
        }
        return v2;
    }

    public static double signum(double d) {
        double d2;
        block5: {
            block4: {
                try {
                    if (!(d < 0.0)) break block4;
                    d2 = -1.0;
                    break block5;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            try {
                d2 = d > 0.0 ? 1.0 : d;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return d2;
    }

    public static float signum(float f) {
        float f2;
        block5: {
            block4: {
                try {
                    if (!(f < 0.0f)) break block4;
                    f2 = -1.0f;
                    break block5;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            try {
                f2 = f > 0.0f ? 1.0f : f;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return f2;
    }

    public static double nextUp(double d) {
        return FastMath.nextAfter(d, Double.POSITIVE_INFINITY);
    }

    public static float nextUp(float f) {
        return FastMath.nextAfter(f, Double.POSITIVE_INFINITY);
    }

    public static double nextDown(double d) {
        return FastMath.nextAfter(d, Double.NEGATIVE_INFINITY);
    }

    public static float nextDown(float f) {
        return FastMath.nextAfter(f, Double.NEGATIVE_INFINITY);
    }

    public static double random() {
        return Math.random();
    }

    public static double exp(double d) {
        return FastMath.exp(d, 0.0, null);
    }

    /*
     * Unable to fully structure code
     */
    private static double exp(double var0, double var2_2, double[] var4_1) {
        block38: {
            block37: {
                block35: {
                    block36: {
                        block33: {
                            block34: {
                                var10_3 = (int)var0;
                                var5_4 = FastMath.b();
                                try {
                                    try {
                                        try {
                                            if (var0 < 0.0) {
                                                if (!(var0 < -746.0)) break block33;
                                            }
                                            ** GOTO lbl49
                                        }
                                        catch (MathArithmeticException v0) {
                                            throw FastMath.b(v0);
                                        }
                                        if (var4_1 == null) break block34;
                                    }
                                    catch (MathArithmeticException v1) {
                                        throw FastMath.b(v1);
                                    }
                                    var4_1[0] = 0.0;
                                    var4_1[1] = 0.0;
                                }
                                catch (MathArithmeticException v2) {
                                    throw FastMath.b(v2);
                                }
                            }
                            return 0.0;
                        }
                        if (var10_3 < -709) {
                            var11_5 = FastMath.exp(var0 + 40.19140625, var2_2, var4_1) / 2.8504009514401178E17;
                            try {
                                if (var4_1 != null) {
                                    var4_1[0] = var4_1[0] / 2.8504009514401178E17;
                                    var4_1[1] = var4_1[1] / 2.8504009514401178E17;
                                }
                            }
                            catch (MathArithmeticException v3) {
                                throw FastMath.b(v3);
                            }
                            return var11_5;
                        }
                        if (var10_3 == -709) {
                            var11_6 = FastMath.exp(var0 + 1.494140625, var2_2, var4_1) / 4.455505956692757;
                            try {
                                if (var4_1 != null) {
                                    var4_1[0] = var4_1[0] / 4.455505956692757;
                                    var4_1[1] = var4_1[1] / 4.455505956692757;
                                }
                            }
                            catch (MathArithmeticException v4) {
                                throw FastMath.b(v4);
                            }
                            return var11_6;
                        }
                        try {
                            try {
                                try {
                                    --var10_3;
                                    if (var5_4 == null) break block35;
lbl49:
                                    // 2 sources

                                    if (var10_3 <= 709) break block35;
                                }
                                catch (MathArithmeticException v5) {
                                    throw FastMath.b(v5);
                                }
                                if (var4_1 == null) break block36;
                            }
                            catch (MathArithmeticException v6) {
                                throw FastMath.b(v6);
                            }
                            var4_1[0] = Infinity;
                            var4_1[1] = 0.0;
                        }
                        catch (MathArithmeticException v7) {
                            throw FastMath.b(v7);
                        }
                    }
                    return Infinity;
                }
                var6_8 = ExpIntTable.access$000()[750 + var10_3];
                var8_9 = ExpIntTable.access$100()[750 + var10_3];
                var11_7 = (int)((var0 - (double)var10_3) * 1024.0);
                var12_10 = ExpFracTable.access$200()[var11_7];
                var14_11 = ExpFracTable.access$300()[var11_7];
                var16_12 = var0 - ((double)var10_3 + (double)var11_7 / 1024.0);
                var18_13 = 0.04168701738764507;
                var18_13 = var18_13 * var16_12 + 0.1666666505023083;
                var18_13 = var18_13 * var16_12 + 0.5000000000042687;
                var18_13 = var18_13 * var16_12 + 1.0;
                var18_13 = var18_13 * var16_12 + -3.940510424527919E-20;
                var20_14 = var6_8 * var12_10;
                var22_15 = var6_8 * var14_11 + var8_9 * var12_10 + var8_9 * var14_11;
                var24_16 = var22_15 + var20_14;
                try {
                    if (var24_16 == Infinity) {
                        return Infinity;
                    }
                }
                catch (MathArithmeticException v8) {
                    throw FastMath.b(v8);
                }
                if (var2_2 == 0.0) break block37;
                var26_17 = var24_16 * var2_2 * var18_13 + var24_16 * var2_2 + var24_16 * var18_13 + var22_15 + var20_14;
                if (var5_4 == null) break block38;
            }
            var26_17 = var24_16 * var18_13 + var22_15 + var20_14;
        }
        try {
            if (var4_1 != null) {
                var4_1[0] = var20_14;
                var4_1[1] = var24_16 * var2_2 * var18_13 + var24_16 * var2_2 + var24_16 * var18_13 + var22_15;
            }
        }
        catch (MathArithmeticException v9) {
            throw FastMath.b(v9);
        }
        return var26_17;
    }

    public static double expm1(double d) {
        return FastMath.expm1(d, null);
    }

    private static double expm1(double d, double[] dArray) {
        block15: {
            block14: {
                try {
                    try {
                        if (d == d && d != 0.0) break block14;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                    return d;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            try {
                if (!(d <= -1.0) && !(d >= 1.0)) break block15;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            double[] dArray2 = new double[2];
            try {
                FastMath.exp(d, 0.0, dArray2);
                if (d > 0.0) {
                    return -1.0 + dArray2[0] + dArray2[1];
                }
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            double d2 = -1.0 + dArray2[0];
            double d3 = -(d2 + 1.0 - dArray2[0]);
            return d2 + (d3 += dArray2[1]);
        }
        boolean bl = false;
        if (d < 0.0) {
            d = -d;
            bl = true;
        }
        int n = (int)(d * 1024.0);
        double d4 = ExpFracTable.EXP_FRAC_TABLE_A[n] - 1.0;
        double d5 = ExpFracTable.EXP_FRAC_TABLE_B[n];
        double d6 = d4 + d5;
        d5 = -(d6 - d4 - d5);
        d4 = d6;
        d6 = d4 * 1.073741824E9;
        double d7 = d4 + d6 - d6;
        double d8 = d5 + (d4 - d7);
        double d9 = d - (double)n / 1024.0;
        double d10 = 0.008336750013465571;
        d10 = d10 * d9 + 0.041666663879186654;
        d10 = d10 * d9 + 0.16666666666745392;
        d10 = d10 * d9 + 0.49999999999999994;
        d10 *= d9;
        double d11 = d9;
        double d12 = d11 + (d10 *= d9);
        d10 = -(d12 - d11 - d10);
        d11 = d12;
        d12 = d11 * 1.073741824E9;
        d12 = d11 + d12 - d12;
        d10 += d11 - d12;
        d11 = d12;
        double d13 = d11 * d7;
        d12 = d13 + d11 * d8;
        double d14 = -(d12 - d13 - d11 * d8);
        d13 = d12;
        d12 = d13 + d10 * d7;
        d14 += -(d12 - d13 - d10 * d7);
        d13 = d12;
        d12 = d13 + d10 * d8;
        d14 += -(d12 - d13 - d10 * d8);
        d13 = d12;
        d12 = d13 + d7;
        d14 += -(d12 - d7 - d13);
        d13 = d12;
        d12 = d13 + d11;
        d14 += -(d12 - d13 - d11);
        d13 = d12;
        d12 = d13 + d8;
        d14 += -(d12 - d13 - d8);
        d13 = d12;
        d12 = d13 + d10;
        d14 += -(d12 - d13 - d10);
        d13 = d12;
        if (bl) {
            double d15 = 1.0 + d13;
            double d16 = 1.0 / d15;
            double d17 = -(d15 - 1.0 - d13) + d14;
            double d18 = d13 * d16;
            d12 = d18 * 1.073741824E9;
            double d19 = d18 + d12 - d12;
            double d20 = d18 - d19;
            d12 = d15 * 1.073741824E9;
            d11 = d15 + d12 - d12;
            d10 = d15 - d11;
            d20 += (d13 - d11 * d19 - d11 * d20 - d10 * d19 - d10 * d20) * d16;
            d20 += d14 * d16;
            d20 += -d13 * d17 * d16 * d16;
            d13 = -d19;
            d14 = -d20;
        }
        try {
            if (dArray != null) {
                dArray[0] = d13;
                dArray[1] = d14;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return d13 + d14;
    }

    public static double log(double d) {
        return FastMath.log(d, null);
    }

    private static double log(double d, double[] dArray) {
        double d2;
        double d3;
        double d4;
        double d5;
        int n;
        long l;
        block44: {
            block41: {
                block42: {
                    block43: {
                        block39: {
                            block40: {
                                block37: {
                                    block38: {
                                        try {
                                            if (d == 0.0) {
                                                return Double.NEGATIVE_INFINITY;
                                            }
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        l = Double.doubleToRawLongBits(d);
                                        try {
                                            try {
                                                try {
                                                    try {
                                                        if ((l & Long.MIN_VALUE) == 0L && d == d) break block37;
                                                    }
                                                    catch (MathArithmeticException mathArithmeticException) {
                                                        throw FastMath.b(mathArithmeticException);
                                                    }
                                                    if (d == 0.0) break block37;
                                                }
                                                catch (MathArithmeticException mathArithmeticException) {
                                                    throw FastMath.b(mathArithmeticException);
                                                }
                                                if (dArray == null) break block38;
                                            }
                                            catch (MathArithmeticException mathArithmeticException) {
                                                throw FastMath.b(mathArithmeticException);
                                            }
                                            dArray[0] = Double.NaN;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                    }
                                    return Double.NaN;
                                }
                                try {
                                    try {
                                        if (d != Double.POSITIVE_INFINITY) break block39;
                                        if (dArray == null) break block40;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                    dArray[0] = Double.POSITIVE_INFINITY;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                            }
                            return Double.POSITIVE_INFINITY;
                        }
                        n = (int)(l >> 52) - 1023;
                        try {
                            try {
                                try {
                                    if ((l & 0x7FF0000000000000L) != 0L) break block41;
                                    if (d != 0.0) break block42;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                                if (dArray == null) break block43;
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw FastMath.b(mathArithmeticException);
                            }
                            dArray[0] = Double.NEGATIVE_INFINITY;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                    }
                    return Double.NEGATIVE_INFINITY;
                }
                l <<= 1;
                while ((l & 0x10000000000000L) == 0L) {
                    --n;
                    l <<= 1;
                }
            }
            try {
                try {
                    try {
                        try {
                            if (n != -1 && n != 0) break block44;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        if (!(d < 1.01)) break block44;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                    if (!(d > 0.99)) break block44;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                if (dArray != null) break block44;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            double d6 = d - 1.0;
            double d7 = d6 - d + 1.0;
            double d8 = d6 * 1.073741824E9;
            double d9 = d6 + d8 - d8;
            double d10 = d6 - d9;
            d6 = d9;
            d7 = d10;
            double[] dArray2 = LN_QUICK_COEF[LN_QUICK_COEF.length - 1];
            double d11 = dArray2[0];
            double d12 = dArray2[1];
            for (int i = LN_QUICK_COEF.length - 2; i >= 0; --i) {
                d9 = d11 * d6;
                d10 = d11 * d7 + d12 * d6 + d12 * d7;
                d8 = d9 * 1.073741824E9;
                d11 = d9 + d8 - d8;
                d12 = d9 - d11 + d10;
                double[] dArray3 = LN_QUICK_COEF[i];
                d9 = d11 + dArray3[0];
                d10 = d12 + dArray3[1];
                d8 = d9 * 1.073741824E9;
                d11 = d9 + d8 - d8;
                d12 = d9 - d11 + d10;
            }
            d9 = d11 * d6;
            d10 = d11 * d7 + d12 * d6 + d12 * d7;
            d8 = d9 * 1.073741824E9;
            d11 = d9 + d8 - d8;
            d12 = d9 - d11 + d10;
            return d11 + d12;
        }
        double[] dArray4 = lnMant.LN_MANT[(int)((l & 0xFFC0000000000L) >> 42)];
        double d13 = (double)(l & 0x3FFFFFFFFFFL) / (4.503599627370496E15 + (double)(l & 0xFFC0000000000L));
        double d14 = 0.0;
        double d15 = 0.0;
        if (dArray != null) {
            d5 = d13 * 1.073741824E9;
            d4 = d13 + d5 - d5;
            d3 = d13 - d4;
            d2 = d4;
            double d16 = d3;
            double d17 = l & 0x3FFFFFFFFFFL;
            double d18 = 4.503599627370496E15 + (double)(l & 0xFFC0000000000L);
            d4 = d17 - d2 * d18 - d16 * d18;
            d16 += d4 / d18;
            double[] dArray5 = LN_HI_PREC_COEF[LN_HI_PREC_COEF.length - 1];
            double d19 = dArray5[0];
            double d20 = dArray5[1];
            for (int i = LN_HI_PREC_COEF.length - 2; i >= 0; --i) {
                d4 = d19 * d2;
                d3 = d19 * d16 + d20 * d2 + d20 * d16;
                d5 = d4 * 1.073741824E9;
                d19 = d4 + d5 - d5;
                d20 = d4 - d19 + d3;
                double[] dArray6 = LN_HI_PREC_COEF[i];
                d4 = d19 + dArray6[0];
                d3 = d20 + dArray6[1];
                d5 = d4 * 1.073741824E9;
                d19 = d4 + d5 - d5;
                d20 = d4 - d19 + d3;
            }
            d4 = d19 * d2;
            d3 = d19 * d16 + d20 * d2 + d20 * d16;
            d14 = d4 + d3;
            d15 = -(d14 - d4 - d3);
        } else {
            d14 = -0.16624882440418567;
            d14 = d14 * d13 + 0.19999954120254515;
            d14 = d14 * d13 + -0.2499999997677497;
            d14 = d14 * d13 + 0.3333333333332802;
            d14 = d14 * d13 + -0.5;
            d14 = d14 * d13 + 1.0;
            d14 *= d13;
        }
        d5 = 0.6931470632553101 * (double)n;
        d4 = 0.0;
        d3 = d5 + dArray4[0];
        d2 = -(d3 - d5 - dArray4[0]);
        d5 = d3;
        d4 += d2;
        d3 = d5 + d14;
        d2 = -(d3 - d5 - d14);
        d5 = d3;
        d4 += d2;
        d3 = d5 + 1.1730463525082348E-7 * (double)n;
        d2 = -(d3 - d5 - 1.1730463525082348E-7 * (double)n);
        d5 = d3;
        d4 += d2;
        d3 = d5 + dArray4[1];
        d2 = -(d3 - d5 - dArray4[1]);
        d5 = d3;
        d4 += d2;
        d3 = d5 + d15;
        d2 = -(d3 - d5 - d15);
        d5 = d3;
        d4 += d2;
        try {
            if (dArray != null) {
                dArray[0] = d5;
                dArray[1] = d4;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return d5 + d4;
    }

    public static double log1p(double d) {
        block11: {
            try {
                if (d == -1.0) {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            try {
                if (d == Double.POSITIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            try {
                if (!(d > 1.0E-6) && !(d < -1.0E-6)) break block11;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            double d2 = 1.0 + d;
            double d3 = -(d2 - 1.0 - d);
            double[] dArray = new double[2];
            double d4 = FastMath.log(d2, dArray);
            try {
                if (Double.isInfinite(d4)) {
                    return d4;
                }
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            double d5 = d3 / d2;
            double d6 = 0.5 * d5 + 1.0;
            return d6 * d5 + dArray[1] + dArray[0];
        }
        double d7 = (d * 0.3333333333333333 - 0.5) * d + 1.0;
        return d7 * d;
    }

    public static double log10(double d) {
        double[] dArray = new double[2];
        double d2 = FastMath.log(d, dArray);
        try {
            if (Double.isInfinite(d2)) {
                return d2;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        double d3 = dArray[0] * 1.073741824E9;
        double d4 = dArray[0] + d3 - d3;
        double d5 = dArray[0] - d4 + dArray[1];
        double d6 = 0.4342944622039795;
        double d7 = 1.9699272335463627E-8;
        return 1.9699272335463627E-8 * d5 + 1.9699272335463627E-8 * d4 + 0.4342944622039795 * d5 + 0.4342944622039795 * d4;
    }

    public static double log(double d, double d2) {
        return FastMath.log(d2) / FastMath.log(d);
    }

    public static double pow(double d, double d2) {
        block60: {
            block61: {
                double d3;
                block63: {
                    block62: {
                        long l;
                        int n;
                        block57: {
                            double d4;
                            block59: {
                                block58: {
                                    block64: {
                                        long l2;
                                        double d5;
                                        long l3;
                                        long l4;
                                        int n2;
                                        block65: {
                                            long l5;
                                            AdvancedEffect[] advancedEffectArray;
                                            block51: {
                                                boolean bl;
                                                boolean bl2;
                                                block55: {
                                                    block56: {
                                                        block54: {
                                                            advancedEffectArray = FastMath.b();
                                                            try {
                                                                if (d2 == 0.0) {
                                                                    return 1.0;
                                                                }
                                                            }
                                                            catch (MathArithmeticException mathArithmeticException) {
                                                                throw FastMath.b(mathArithmeticException);
                                                            }
                                                            long l6 = Double.doubleToRawLongBits(d2);
                                                            n2 = (int)((l6 & 0x7FF0000000000000L) >> 52);
                                                            l5 = l6 & 0xFFFFFFFFFFFFFL;
                                                            long l7 = Double.doubleToRawLongBits(d);
                                                            n = (int)((l7 & 0x7FF0000000000000L) >> 52);
                                                            l = l7 & 0xFFFFFFFFFFFFFL;
                                                            try {
                                                                block53: {
                                                                    try {
                                                                        try {
                                                                            block52: {
                                                                                try {
                                                                                    try {
                                                                                        if (n2 <= 1085) break block51;
                                                                                        if (n2 != 2047) break block52;
                                                                                    }
                                                                                    catch (MathArithmeticException mathArithmeticException) {
                                                                                        throw FastMath.b(mathArithmeticException);
                                                                                    }
                                                                                    if (l5 != 0L) break block53;
                                                                                }
                                                                                catch (MathArithmeticException mathArithmeticException) {
                                                                                    throw FastMath.b(mathArithmeticException);
                                                                                }
                                                                            }
                                                                            if (n != 2047) break block54;
                                                                        }
                                                                        catch (MathArithmeticException mathArithmeticException) {
                                                                            throw FastMath.b(mathArithmeticException);
                                                                        }
                                                                        if (l == 0L) break block54;
                                                                    }
                                                                    catch (MathArithmeticException mathArithmeticException) {
                                                                        throw FastMath.b(mathArithmeticException);
                                                                    }
                                                                }
                                                                return Double.NaN;
                                                            }
                                                            catch (MathArithmeticException mathArithmeticException) {
                                                                throw FastMath.b(mathArithmeticException);
                                                            }
                                                        }
                                                        try {
                                                            try {
                                                                try {
                                                                    if (n != 1023 || l != 0L) break block55;
                                                                }
                                                                catch (MathArithmeticException mathArithmeticException) {
                                                                    throw FastMath.b(mathArithmeticException);
                                                                }
                                                                if (n2 != 2047) break block56;
                                                            }
                                                            catch (MathArithmeticException mathArithmeticException) {
                                                                throw FastMath.b(mathArithmeticException);
                                                            }
                                                            return Double.NaN;
                                                        }
                                                        catch (MathArithmeticException mathArithmeticException) {
                                                            throw FastMath.b(mathArithmeticException);
                                                        }
                                                    }
                                                    return 1.0;
                                                }
                                                try {
                                                    bl2 = d2 > 0.0;
                                                }
                                                catch (MathArithmeticException mathArithmeticException) {
                                                    throw FastMath.b(mathArithmeticException);
                                                }
                                                try {
                                                    bl = n < 1023;
                                                }
                                                catch (MathArithmeticException mathArithmeticException) {
                                                    throw FastMath.b(mathArithmeticException);
                                                }
                                                try {
                                                    if (bl2 ^ bl) {
                                                        return Double.POSITIVE_INFINITY;
                                                    }
                                                }
                                                catch (MathArithmeticException mathArithmeticException) {
                                                    throw FastMath.b(mathArithmeticException);
                                                }
                                                return 0.0;
                                            }
                                            if (n2 < 1023) break block64;
                                            l4 = 0x10000000000000L | l5;
                                            if (n2 >= 1075) break block65;
                                            l3 = -1L << 1075 - n2;
                                            if ((l4 & l3) == l4) {
                                                long l8;
                                                double d6;
                                                long l9 = l4 >> 1075 - n2;
                                                try {
                                                    d6 = d;
                                                    l8 = d2 < 0.0 ? -l9 : l9;
                                                }
                                                catch (MathArithmeticException mathArithmeticException) {
                                                    throw FastMath.b(mathArithmeticException);
                                                }
                                                return FastMath.pow(d6, l8);
                                            }
                                            if (advancedEffectArray == null) break block64;
                                        }
                                        l3 = l4 << n2 - 1075;
                                        try {
                                            d5 = d;
                                            l2 = d2 < 0.0 ? -l3 : l3;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        return FastMath.pow(d5, l2);
                                    }
                                    try {
                                        try {
                                            if (d != 0.0) break block57;
                                            if (!(d2 < 0.0)) break block58;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        d4 = Double.POSITIVE_INFINITY;
                                        break block59;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                d4 = 0.0;
                            }
                            return d4;
                        }
                        try {
                            try {
                                try {
                                    if (n != 2047) break block60;
                                    if (l != 0L) break block61;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                                if (!(d2 < 0.0)) break block62;
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw FastMath.b(mathArithmeticException);
                            }
                            d3 = 0.0;
                            break block63;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                    }
                    d3 = Double.POSITIVE_INFINITY;
                }
                return d3;
            }
            return Double.NaN;
        }
        try {
            if (d < 0.0) {
                return Double.NaN;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        double d7 = d2 * 1.073741824E9;
        double d8 = d2 + d7 - d7;
        double d9 = d2 - d8;
        double[] dArray = new double[2];
        double d10 = FastMath.log(d, dArray);
        try {
            if (Double.isInfinite(d10)) {
                return d10;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        double d11 = dArray[0];
        double d12 = dArray[1];
        double d13 = d11 * 1.073741824E9;
        double d14 = d11 + d13 - d13;
        d12 += d11 - d14;
        d11 = d14;
        double d15 = d11 * d8;
        double d16 = d11 * d9 + d12 * d8 + d12 * d9;
        d11 = d15 + d16;
        d12 = -(d11 - d15 - d16);
        double d17 = 0.008333333333333333;
        d17 = d17 * d12 + 0.041666666666666664;
        d17 = d17 * d12 + 0.16666666666666666;
        d17 = d17 * d12 + 0.5;
        d17 = d17 * d12 + 1.0;
        double d18 = FastMath.exp(d11, d17 *= d12, null);
        return d18;
    }

    public static double pow(double d, int n) {
        return FastMath.pow(d, (long)n);
    }

    public static double pow(double d, long l) {
        try {
            if (l == 0L) {
                return 1.0;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (l > 0L) {
                return new Split(d).pow(l).full;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return new Split(d).reciprocal().pow(-l).full;
    }

    private static double polySine(double d) {
        double d2 = d * d;
        double d3 = 2.7553817452272217E-6;
        d3 = d3 * d2 + -1.9841269659586505E-4;
        d3 = d3 * d2 + 0.008333333333329196;
        d3 = d3 * d2 + -0.16666666666666666;
        d3 = d3 * d2 * d;
        return d3;
    }

    private static double polyCosine(double d) {
        double d2 = d * d;
        double d3 = 2.479773539153719E-5;
        d3 = d3 * d2 + -0.0013888888689039883;
        d3 = d3 * d2 + 0.041666666666621166;
        d3 = d3 * d2 + -0.49999999999999994;
        return d3 *= d2;
    }

    private static double sinQ(double d, double d2) {
        int n = (int)(d * 8.0 + 0.5);
        double d3 = d - EIGHTHS[n];
        double d4 = SINE_TABLE_A[n];
        double d5 = SINE_TABLE_B[n];
        double d6 = COSINE_TABLE_A[n];
        double d7 = COSINE_TABLE_B[n];
        double d8 = d3;
        double d9 = FastMath.polySine(d3);
        double d10 = 1.0;
        double d11 = FastMath.polyCosine(d3);
        double d12 = d8 * 1.073741824E9;
        double d13 = d8 + d12 - d12;
        d9 += d8 - d13;
        d8 = d13;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = d4;
        double d17 = d14 + d16;
        double d18 = -(d17 - d14 - d16);
        d14 = d17;
        d15 += d18;
        d16 = d6 * d8;
        d17 = d14 + d16;
        d18 = -(d17 - d14 - d16);
        d14 = d17;
        d15 += d18;
        d15 = d15 + d4 * d11 + d6 * d9;
        d15 = d15 + d5 + d7 * d8 + d5 * d11 + d7 * d9;
        if (d2 != 0.0) {
            d16 = ((d6 + d7) * (1.0 + d11) - (d4 + d5) * (d8 + d9)) * d2;
            d17 = d14 + d16;
            d18 = -(d17 - d14 - d16);
            d14 = d17;
            d15 += d18;
        }
        double d19 = d14 + d15;
        return d19;
    }

    private static double cosQ(double d, double d2) {
        double d3 = 1.5707963267948966;
        double d4 = 6.123233995736766E-17;
        double d5 = 1.5707963267948966 - d;
        double d6 = -(d5 - 1.5707963267948966 + d);
        return FastMath.sinQ(d5, d6 += 6.123233995736766E-17 - d2);
    }

    private static double tanQ(double d, double d2, boolean bl) {
        double d3;
        int n = (int)(d * 8.0 + 0.5);
        double d4 = d - EIGHTHS[n];
        double d5 = SINE_TABLE_A[n];
        double d6 = SINE_TABLE_B[n];
        double d7 = COSINE_TABLE_A[n];
        double d8 = COSINE_TABLE_B[n];
        double d9 = d4;
        double d10 = FastMath.polySine(d4);
        double d11 = 1.0;
        double d12 = FastMath.polyCosine(d4);
        double d13 = d9 * 1.073741824E9;
        double d14 = d9 + d13 - d13;
        d10 += d9 - d14;
        d9 = d14;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = d5;
        double d18 = d15 + d17;
        double d19 = -(d18 - d15 - d17);
        d15 = d18;
        d16 += d19;
        d17 = d7 * d9;
        d18 = d15 + d17;
        d19 = -(d18 - d15 - d17);
        d15 = d18;
        d16 += d19;
        d16 += d5 * d12 + d7 * d10;
        double d20 = d15 + (d16 += d6 + d8 * d9 + d6 * d12 + d8 * d10);
        double d21 = -(d20 - d15 - d16);
        d19 = 0.0;
        d18 = 0.0;
        d16 = 0.0;
        d15 = 0.0;
        d17 = d7 * 1.0;
        d18 = d15 + d17;
        d19 = -(d18 - d15 - d17);
        d15 = d18;
        d16 += d19;
        d17 = -d5 * d9;
        d18 = d15 + d17;
        d19 = -(d18 - d15 - d17);
        d15 = d18;
        d16 += d19;
        d16 += d8 * 1.0 + d7 * d12 + d8 * d12;
        double d22 = d15 + (d16 -= d6 * d9 + d5 * d10 + d6 * d10);
        double d23 = -(d22 - d15 - d16);
        if (bl) {
            d3 = d22;
            d22 = d20;
            d20 = d3;
            d3 = d23;
            d23 = d21;
            d21 = d3;
        }
        d3 = d20 / d22;
        d13 = d3 * 1.073741824E9;
        double d24 = d3 + d13 - d13;
        double d25 = d3 - d24;
        d13 = d22 * 1.073741824E9;
        double d26 = d22 + d13 - d13;
        double d27 = d22 - d26;
        double d28 = (d20 - d24 * d26 - d24 * d27 - d25 * d26 - d25 * d27) / d22;
        d28 += d21 / d22;
        d28 += -d20 * d23 / d22 / d22;
        if (d2 != 0.0) {
            double d29 = d2 + d3 * d3 * d2;
            if (bl) {
                d29 = -d29;
            }
            d28 += d29;
        }
        return d3 + d28;
    }

    /*
     * Unable to fully structure code
     */
    private static void reducePayneHanek(double var0, double[] var2_1) {
        block132: {
            block130: {
                block129: {
                    block127: {
                        block126: {
                            block124: {
                                block123: {
                                    block121: {
                                        block120: {
                                            block118: {
                                                block117: {
                                                    block115: {
                                                        block114: {
                                                            block112: {
                                                                block109: {
                                                                    block111: {
                                                                        block110: {
                                                                            block108: {
                                                                                block107: {
                                                                                    var4_2 = Double.doubleToRawLongBits(var0);
                                                                                    var6_3 = (int)(var4_2 >> 52 & 2047L) - 1023;
                                                                                    var4_2 &= 0xFFFFFFFFFFFFFL;
                                                                                    var4_2 |= 0x10000000000000L;
                                                                                    var4_2 <<= 11;
                                                                                    var3_4 = FastMath.b();
                                                                                    var13_5 = ++var6_3 >> 6;
                                                                                    var14_6 = var6_3 - (var13_5 << 6);
                                                                                    try {
                                                                                        try {
                                                                                            if (var14_6 != 0) {
                                                                                                if (var13_5 != 0) break block107;
                                                                                            }
                                                                                            ** GOTO lbl31
                                                                                        }
                                                                                        catch (MathArithmeticException v0) {
                                                                                            throw FastMath.b(v0);
                                                                                        }
                                                                                        v1 = 0L;
                                                                                        break block108;
                                                                                    }
                                                                                    catch (MathArithmeticException v2) {
                                                                                        throw FastMath.b(v2);
                                                                                    }
                                                                                }
                                                                                v1 = FastMath.RECIP_2PI[var13_5 - 1] << var14_6;
                                                                            }
                                                                            var7_7 = v1;
                                                                            var7_7 |= FastMath.RECIP_2PI[var13_5] >>> 64 - var14_6;
                                                                            var9_8 = FastMath.RECIP_2PI[var13_5] << var14_6 | FastMath.RECIP_2PI[var13_5 + 1] >>> 64 - var14_6;
                                                                            var11_9 = FastMath.RECIP_2PI[var13_5 + 1] << var14_6 | FastMath.RECIP_2PI[var13_5 + 2] >>> 64 - var14_6;
                                                                            try {
                                                                                try {
                                                                                    if (var3_4 == null) break block109;
lbl31:
                                                                                    // 2 sources

                                                                                    if (var13_5 != 0) break block110;
                                                                                }
                                                                                catch (MathArithmeticException v3) {
                                                                                    throw FastMath.b(v3);
                                                                                }
                                                                                v4 = 0L;
                                                                                break block111;
                                                                            }
                                                                            catch (MathArithmeticException v5) {
                                                                                throw FastMath.b(v5);
                                                                            }
                                                                        }
                                                                        v4 = FastMath.RECIP_2PI[var13_5 - 1];
                                                                    }
                                                                    var7_7 = v4;
                                                                    var9_8 = FastMath.RECIP_2PI[var13_5];
                                                                    var11_9 = FastMath.RECIP_2PI[var13_5 + 1];
                                                                }
                                                                var15_10 = var4_2 >>> 32;
                                                                var17_11 = var4_2 & 0xFFFFFFFFL;
                                                                var19_12 = var9_8 >>> 32;
                                                                var21_13 = var9_8 & 0xFFFFFFFFL;
                                                                var23_14 = var15_10 * var19_12;
                                                                var25_15 = var17_11 * var21_13;
                                                                var27_16 = var17_11 * var19_12;
                                                                var29_17 = var15_10 * var21_13;
                                                                var31_18 = var25_15 + (var29_17 << 32);
                                                                var33_19 = var23_14 + (var29_17 >>> 32);
                                                                try {
                                                                    v6 = (var25_15 & -9223372036854775808L) != 0L;
                                                                }
                                                                catch (MathArithmeticException v7) {
                                                                    throw FastMath.b(v7);
                                                                }
                                                                var35_20 = v6;
                                                                try {
                                                                    v8 = (var29_17 & 0x80000000L) != 0L;
                                                                }
                                                                catch (MathArithmeticException v9) {
                                                                    throw FastMath.b(v9);
                                                                }
                                                                var36_21 = v8;
                                                                try {
                                                                    v10 = (var31_18 & -9223372036854775808L) != 0L;
                                                                }
                                                                catch (MathArithmeticException v11) {
                                                                    throw FastMath.b(v11);
                                                                }
                                                                var37_22 = v10;
                                                                try {
                                                                    block113: {
                                                                        try {
                                                                            try {
                                                                                try {
                                                                                    if (var35_20 && var36_21) break block112;
                                                                                }
                                                                                catch (MathArithmeticException v12) {
                                                                                    throw FastMath.b(v12);
                                                                                }
                                                                                if (var35_20) break block113;
                                                                            }
                                                                            catch (MathArithmeticException v13) {
                                                                                throw FastMath.b(v13);
                                                                            }
                                                                            if (!var36_21) break block114;
                                                                        }
                                                                        catch (MathArithmeticException v14) {
                                                                            throw FastMath.b(v14);
                                                                        }
                                                                    }
                                                                    if (var37_22) break block114;
                                                                }
                                                                catch (MathArithmeticException v15) {
                                                                    throw FastMath.b(v15);
                                                                }
                                                            }
                                                            ++var33_19;
                                                        }
                                                        try {
                                                            v16 = (var31_18 & -9223372036854775808L) != 0L;
                                                        }
                                                        catch (MathArithmeticException v17) {
                                                            throw FastMath.b(v17);
                                                        }
                                                        var35_20 = v16;
                                                        try {
                                                            v18 = (var27_16 & 0x80000000L) != 0L;
                                                        }
                                                        catch (MathArithmeticException v19) {
                                                            throw FastMath.b(v19);
                                                        }
                                                        var36_21 = v18;
                                                        var31_18 += var27_16 << 32;
                                                        var33_19 += var27_16 >>> 32;
                                                        try {
                                                            v20 = (var31_18 & -9223372036854775808L) != 0L;
                                                        }
                                                        catch (MathArithmeticException v21) {
                                                            throw FastMath.b(v21);
                                                        }
                                                        var37_22 = v20;
                                                        try {
                                                            block116: {
                                                                try {
                                                                    try {
                                                                        try {
                                                                            if (var35_20 && var36_21) break block115;
                                                                        }
                                                                        catch (MathArithmeticException v22) {
                                                                            throw FastMath.b(v22);
                                                                        }
                                                                        if (var35_20) break block116;
                                                                    }
                                                                    catch (MathArithmeticException v23) {
                                                                        throw FastMath.b(v23);
                                                                    }
                                                                    if (!var36_21) break block117;
                                                                }
                                                                catch (MathArithmeticException v24) {
                                                                    throw FastMath.b(v24);
                                                                }
                                                            }
                                                            if (var37_22) break block117;
                                                        }
                                                        catch (MathArithmeticException v25) {
                                                            throw FastMath.b(v25);
                                                        }
                                                    }
                                                    ++var33_19;
                                                }
                                                var19_12 = var11_9 >>> 32;
                                                var21_13 = var11_9 & 0xFFFFFFFFL;
                                                var23_14 = var15_10 * var19_12;
                                                var27_16 = var17_11 * var19_12;
                                                var29_17 = var15_10 * var21_13;
                                                var23_14 += var27_16 + var29_17 >>> 32;
                                                try {
                                                    v26 = (var31_18 & -9223372036854775808L) != 0L;
                                                }
                                                catch (MathArithmeticException v27) {
                                                    throw FastMath.b(v27);
                                                }
                                                var35_20 = v26;
                                                try {
                                                    v28 = (var23_14 & -9223372036854775808L) != 0L;
                                                }
                                                catch (MathArithmeticException v29) {
                                                    throw FastMath.b(v29);
                                                }
                                                var36_21 = v28;
                                                var31_18 += var23_14;
                                                try {
                                                    v30 = (var31_18 & -9223372036854775808L) != 0L;
                                                }
                                                catch (MathArithmeticException v31) {
                                                    throw FastMath.b(v31);
                                                }
                                                var37_22 = v30;
                                                try {
                                                    block119: {
                                                        try {
                                                            try {
                                                                try {
                                                                    if (var35_20 && var36_21) break block118;
                                                                }
                                                                catch (MathArithmeticException v32) {
                                                                    throw FastMath.b(v32);
                                                                }
                                                                if (var35_20) break block119;
                                                            }
                                                            catch (MathArithmeticException v33) {
                                                                throw FastMath.b(v33);
                                                            }
                                                            if (!var36_21) break block120;
                                                        }
                                                        catch (MathArithmeticException v34) {
                                                            throw FastMath.b(v34);
                                                        }
                                                    }
                                                    if (var37_22) break block120;
                                                }
                                                catch (MathArithmeticException v35) {
                                                    throw FastMath.b(v35);
                                                }
                                            }
                                            ++var33_19;
                                        }
                                        var19_12 = var7_7 >>> 32;
                                        var21_13 = var7_7 & 0xFFFFFFFFL;
                                        var25_15 = var17_11 * var21_13;
                                        var27_16 = var17_11 * var19_12;
                                        var29_17 = var15_10 * var21_13;
                                        var38_23 = (int)((var33_19 += var25_15 + (var27_16 + var29_17 << 32)) >>> 62);
                                        var33_19 <<= 2;
                                        var33_19 |= var31_18 >>> 62;
                                        var31_18 <<= 2;
                                        var15_10 = var33_19 >>> 32;
                                        var17_11 = var33_19 & 0xFFFFFFFFL;
                                        var19_12 = FastMath.PI_O_4_BITS[0] >>> 32;
                                        var21_13 = FastMath.PI_O_4_BITS[0] & 0xFFFFFFFFL;
                                        var23_14 = var15_10 * var19_12;
                                        var25_15 = var17_11 * var21_13;
                                        var27_16 = var17_11 * var19_12;
                                        var29_17 = var15_10 * var21_13;
                                        var39_24 = var25_15 + (var29_17 << 32);
                                        var41_25 = var23_14 + (var29_17 >>> 32);
                                        try {
                                            v36 = (var25_15 & -9223372036854775808L) != 0L;
                                        }
                                        catch (MathArithmeticException v37) {
                                            throw FastMath.b(v37);
                                        }
                                        var35_20 = v36;
                                        try {
                                            v38 = (var29_17 & 0x80000000L) != 0L;
                                        }
                                        catch (MathArithmeticException v39) {
                                            throw FastMath.b(v39);
                                        }
                                        var36_21 = v38;
                                        try {
                                            v40 = (var39_24 & -9223372036854775808L) != 0L;
                                        }
                                        catch (MathArithmeticException v41) {
                                            throw FastMath.b(v41);
                                        }
                                        var37_22 = v40;
                                        try {
                                            block122: {
                                                try {
                                                    try {
                                                        try {
                                                            if (var35_20 && var36_21) break block121;
                                                        }
                                                        catch (MathArithmeticException v42) {
                                                            throw FastMath.b(v42);
                                                        }
                                                        if (var35_20) break block122;
                                                    }
                                                    catch (MathArithmeticException v43) {
                                                        throw FastMath.b(v43);
                                                    }
                                                    if (!var36_21) break block123;
                                                }
                                                catch (MathArithmeticException v44) {
                                                    throw FastMath.b(v44);
                                                }
                                            }
                                            if (var37_22) break block123;
                                        }
                                        catch (MathArithmeticException v45) {
                                            throw FastMath.b(v45);
                                        }
                                    }
                                    ++var41_25;
                                }
                                try {
                                    v46 = (var39_24 & -9223372036854775808L) != 0L;
                                }
                                catch (MathArithmeticException v47) {
                                    throw FastMath.b(v47);
                                }
                                var35_20 = v46;
                                try {
                                    v48 = (var27_16 & 0x80000000L) != 0L;
                                }
                                catch (MathArithmeticException v49) {
                                    throw FastMath.b(v49);
                                }
                                var36_21 = v48;
                                var39_24 += var27_16 << 32;
                                var41_25 += var27_16 >>> 32;
                                try {
                                    v50 = (var39_24 & -9223372036854775808L) != 0L;
                                }
                                catch (MathArithmeticException v51) {
                                    throw FastMath.b(v51);
                                }
                                var37_22 = v50;
                                try {
                                    block125: {
                                        try {
                                            try {
                                                try {
                                                    if (var35_20 && var36_21) break block124;
                                                }
                                                catch (MathArithmeticException v52) {
                                                    throw FastMath.b(v52);
                                                }
                                                if (var35_20) break block125;
                                            }
                                            catch (MathArithmeticException v53) {
                                                throw FastMath.b(v53);
                                            }
                                            if (!var36_21) break block126;
                                        }
                                        catch (MathArithmeticException v54) {
                                            throw FastMath.b(v54);
                                        }
                                    }
                                    if (var37_22) break block126;
                                }
                                catch (MathArithmeticException v55) {
                                    throw FastMath.b(v55);
                                }
                            }
                            ++var41_25;
                        }
                        var19_12 = FastMath.PI_O_4_BITS[1] >>> 32;
                        var21_13 = FastMath.PI_O_4_BITS[1] & 0xFFFFFFFFL;
                        var23_14 = var15_10 * var19_12;
                        var27_16 = var17_11 * var19_12;
                        var29_17 = var15_10 * var21_13;
                        var23_14 += var27_16 + var29_17 >>> 32;
                        try {
                            v56 = (var39_24 & -9223372036854775808L) != 0L;
                        }
                        catch (MathArithmeticException v57) {
                            throw FastMath.b(v57);
                        }
                        var35_20 = v56;
                        try {
                            v58 = (var23_14 & -9223372036854775808L) != 0L;
                        }
                        catch (MathArithmeticException v59) {
                            throw FastMath.b(v59);
                        }
                        var36_21 = v58;
                        var39_24 += var23_14;
                        try {
                            v60 = (var39_24 & -9223372036854775808L) != 0L;
                        }
                        catch (MathArithmeticException v61) {
                            throw FastMath.b(v61);
                        }
                        var37_22 = v60;
                        try {
                            block128: {
                                try {
                                    try {
                                        try {
                                            if (var35_20 && var36_21) break block127;
                                        }
                                        catch (MathArithmeticException v62) {
                                            throw FastMath.b(v62);
                                        }
                                        if (var35_20) break block128;
                                    }
                                    catch (MathArithmeticException v63) {
                                        throw FastMath.b(v63);
                                    }
                                    if (!var36_21) break block129;
                                }
                                catch (MathArithmeticException v64) {
                                    throw FastMath.b(v64);
                                }
                            }
                            if (var37_22) break block129;
                        }
                        catch (MathArithmeticException v65) {
                            throw FastMath.b(v65);
                        }
                    }
                    ++var41_25;
                }
                var15_10 = var31_18 >>> 32;
                var17_11 = var31_18 & 0xFFFFFFFFL;
                var19_12 = FastMath.PI_O_4_BITS[0] >>> 32;
                var21_13 = FastMath.PI_O_4_BITS[0] & 0xFFFFFFFFL;
                var23_14 = var15_10 * var19_12;
                var27_16 = var17_11 * var19_12;
                var29_17 = var15_10 * var21_13;
                var23_14 += var27_16 + var29_17 >>> 32;
                try {
                    v66 = (var39_24 & -9223372036854775808L) != 0L;
                }
                catch (MathArithmeticException v67) {
                    throw FastMath.b(v67);
                }
                var35_20 = v66;
                try {
                    v68 = (var23_14 & -9223372036854775808L) != 0L;
                }
                catch (MathArithmeticException v69) {
                    throw FastMath.b(v69);
                }
                var36_21 = v68;
                var39_24 += var23_14;
                try {
                    v70 = (var39_24 & -9223372036854775808L) != 0L;
                }
                catch (MathArithmeticException v71) {
                    throw FastMath.b(v71);
                }
                var37_22 = v70;
                try {
                    block131: {
                        try {
                            try {
                                try {
                                    if (var35_20 && var36_21) break block130;
                                }
                                catch (MathArithmeticException v72) {
                                    throw FastMath.b(v72);
                                }
                                if (var35_20) break block131;
                            }
                            catch (MathArithmeticException v73) {
                                throw FastMath.b(v73);
                            }
                            if (!var36_21) break block132;
                        }
                        catch (MathArithmeticException v74) {
                            throw FastMath.b(v74);
                        }
                    }
                    if (var37_22) break block132;
                }
                catch (MathArithmeticException v75) {
                    throw FastMath.b(v75);
                }
            }
            ++var41_25;
        }
        var43_26 = (double)(var41_25 >>> 12) / 4.503599627370496E15;
        var45_27 = (double)(((var41_25 & 4095L) << 40) + (var39_24 >>> 24)) / 4.503599627370496E15 / 4.503599627370496E15;
        var47_28 = var43_26 + var45_27;
        var49_29 = -(var47_28 - var43_26 - var45_27);
        var2_1[0] = var38_23;
        var2_1[1] = var47_28 * 2.0;
        var2_1[2] = var49_29 * 2.0;
    }

    /*
     * Exception decompiling
     */
    public static double sin(double var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static double cos(double var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public static double tan(double var0) {
        block21: {
            block20: {
                block19: {
                    block18: {
                        var3_1 = false;
                        var4_2 = 0;
                        var5_3 = var0;
                        var2_4 = FastMath.b();
                        if (var0 < 0.0) {
                            var3_1 = true;
                            var5_3 = -var5_3;
                        }
                        if (var5_3 == 0.0) {
                            var7_5 = Double.doubleToRawLongBits(var0);
                            try {
                                if (var7_5 < 0L) {
                                    return -0.0;
                                }
                            }
                            catch (MathArithmeticException v0) {
                                throw FastMath.b(v0);
                            }
                            return 0.0;
                        }
                        try {
                            try {
                                if (var5_3 == var5_3 && var5_3 != Infinity) break block18;
                            }
                            catch (MathArithmeticException v1) {
                                throw FastMath.b(v1);
                            }
                            return NaN;
                        }
                        catch (MathArithmeticException v2) {
                            throw FastMath.b(v2);
                        }
                    }
                    var7_6 = 0.0;
                    if (!(var5_3 > 3294198.0)) ** GOTO lbl36
                    var9_7 = new double[3];
                    FastMath.reducePayneHanek(var5_3, (double[])var9_7);
                    var4_2 = (int)var9_7[0] & 3;
                    var5_3 = (double)var9_7[1];
                    var7_6 = (double)var9_7[2];
                    try {
                        if (var2_4 == null) break block19;
lbl36:
                        // 2 sources

                        if (!(var5_3 > 1.5707963267948966)) break block19;
                    }
                    catch (MathArithmeticException v3) {
                        throw FastMath.b(v3);
                    }
                    var9_7 = new CodyWaite(var5_3);
                    var4_2 = var9_7.getK() & 3;
                    var5_3 = var9_7.getRemA();
                    var7_6 = var9_7.getRemB();
                }
                if (var5_3 > 1.5) {
                    var9_8 = 1.5707963267948966;
                    var11_10 = 6.123233995736766E-17;
                    var13_11 = 1.5707963267948966 - var5_3;
                    var15_12 = -(var13_11 - 1.5707963267948966 + var5_3);
                    var5_3 = var13_11 + (var15_12 += 6.123233995736766E-17 - var7_6);
                    var7_6 = -(var5_3 - var13_11 - var15_12);
                    var4_2 ^= 1;
                    var3_1 ^= true;
                }
                if (var4_2 & true) break block20;
                var9_9 = FastMath.tanQ(var5_3, var7_6, false);
                if (var2_4 == null) break block21;
            }
            var9_9 = -FastMath.tanQ(var5_3, var7_6, true);
        }
        if (var3_1) {
            var9_9 = -var9_9;
        }
        return var9_9;
    }

    public static double atan(double d) {
        return FastMath.atan(d, 0.0, false);
    }

    private static double atan(double d, double d2, boolean bl) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        int n;
        boolean bl2;
        block30: {
            double d15;
            double d16;
            block29: {
                AdvancedEffect[] advancedEffectArray;
                block28: {
                    block27: {
                        block22: {
                            double d17;
                            block24: {
                                block23: {
                                    block26: {
                                        block25: {
                                            block19: {
                                                double d18;
                                                block21: {
                                                    block20: {
                                                        advancedEffectArray = FastMath.b();
                                                        try {
                                                            try {
                                                                if (d != 0.0) break block19;
                                                                if (!bl) break block20;
                                                            }
                                                            catch (MathArithmeticException mathArithmeticException) {
                                                                throw FastMath.b(mathArithmeticException);
                                                            }
                                                            d18 = FastMath.copySign(Math.PI, d);
                                                            break block21;
                                                        }
                                                        catch (MathArithmeticException mathArithmeticException) {
                                                            throw FastMath.b(mathArithmeticException);
                                                        }
                                                    }
                                                    d18 = d;
                                                }
                                                return d18;
                                            }
                                            if (!(d < 0.0)) break block25;
                                            d = -d;
                                            d2 = -d2;
                                            bl2 = true;
                                            if (advancedEffectArray == null) break block26;
                                        }
                                        bl2 = false;
                                    }
                                    try {
                                        try {
                                            if (!(d > 1.633123935319537E16)) break block22;
                                            if (!(bl2 ^ bl)) break block23;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        d17 = -1.5707963267948966;
                                        break block24;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                d17 = 1.5707963267948966;
                            }
                            return d17;
                        }
                        if (!(d < 1.0)) break block27;
                        n = (int)((-1.7168146928204135 * d * d + 8.0) * d + 0.5);
                        if (advancedEffectArray == null) break block28;
                    }
                    d16 = 1.0 / d;
                    n = (int)(-((-1.7168146928204135 * d16 * d16 + 8.0) * d16) + 13.07);
                }
                d16 = TANGENT_TABLE_A[n];
                d15 = TANGENT_TABLE_B[n];
                d14 = d - d16;
                d13 = -(d14 - d + d16);
                d12 = d14 + (d13 += d2 - d15);
                d13 = -(d12 - d14 - d13);
                d14 = d12;
                d12 = d * 1.073741824E9;
                d11 = d + d12 - d12;
                d10 = d2 + d - d11;
                d = d11;
                d2 += d10;
                if (n != 0) break block29;
                d9 = 1.0 / (1.0 + (d + d2) * (d16 + d15));
                d11 = d14 * d9;
                d10 = d13 * d9;
                if (advancedEffectArray == null) break block30;
            }
            d9 = d * d16;
            d8 = 1.0 + d9;
            d7 = -(d8 - 1.0 - d9);
            d9 = d2 * d16 + d * d15;
            d12 = d8 + d9;
            d7 += -(d12 - d8 - d9);
            d8 = d12;
            d7 += d2 * d15;
            d11 = d14 / d8;
            d12 = d11 * 1.073741824E9;
            d6 = d11 + d12 - d12;
            d5 = d11 - d6;
            d12 = d8 * 1.073741824E9;
            d4 = d8 + d12 - d12;
            d3 = d8 - d4;
            d10 = (d14 - d6 * d4 - d6 * d3 - d5 * d4 - d5 * d3) / d8;
            d10 += -d14 * d7 / d8 / d8;
            d10 += d13 / d8;
        }
        d14 = d11;
        d13 = d10;
        d9 = d14 * d14;
        d10 = 0.07490822288864472;
        d10 = d10 * d9 - 0.09088450866185192;
        d10 = d10 * d9 + 0.11111095942313305;
        d10 = d10 * d9 - 0.1428571423679182;
        d10 = d10 * d9 + 0.19999999999923582;
        d10 = d10 * d9 - 0.33333333333333287;
        d10 = d10 * d9 * d14;
        d11 = d14;
        d12 = d11 + d10;
        d10 = -(d12 - d11 - d10);
        d11 = d12;
        d8 = EIGHTHS[n];
        d7 = d8 + d11;
        d6 = -(d7 - d8 - d11);
        d12 = d7 + (d10 += d13 / (1.0 + d14 * d14));
        d6 += -(d12 - d7 - d10);
        d7 = d12;
        d5 = d7 + d6;
        if (bl) {
            d4 = -(d5 - d7 - d6);
            d3 = Math.PI;
            double d19 = 1.2246467991473532E-16;
            d7 = Math.PI - d5;
            d6 = -(d7 - Math.PI + d5);
            d5 = d7 + (d6 += 1.2246467991473532E-16 - d4);
        }
        if (bl2 ^ bl) {
            d5 = -d5;
        }
        return d5;
    }

    public static double atan2(double d, double d2) {
        boolean bl;
        double d3;
        double d4;
        double d5;
        block87: {
            boolean bl2;
            double d6;
            double d7;
            block89: {
                block88: {
                    block84: {
                        block86: {
                            block81: {
                                block83: {
                                    block78: {
                                        block80: {
                                            block76: {
                                                block77: {
                                                    block74: {
                                                        block75: {
                                                            block68: {
                                                                try {
                                                                    try {
                                                                        if (d2 == d2 && d == d) break block68;
                                                                    }
                                                                    catch (MathArithmeticException mathArithmeticException) {
                                                                        throw FastMath.b(mathArithmeticException);
                                                                    }
                                                                    return Double.NaN;
                                                                }
                                                                catch (MathArithmeticException mathArithmeticException) {
                                                                    throw FastMath.b(mathArithmeticException);
                                                                }
                                                            }
                                                            if (d == 0.0) {
                                                                double d8;
                                                                block71: {
                                                                    block73: {
                                                                        double d9;
                                                                        double d10;
                                                                        block69: {
                                                                            block70: {
                                                                                d8 = d2 * d;
                                                                                d10 = 1.0 / d2;
                                                                                d9 = 1.0 / d;
                                                                                try {
                                                                                    try {
                                                                                        if (d10 != 0.0) break block69;
                                                                                        if (!(d2 > 0.0)) break block70;
                                                                                    }
                                                                                    catch (MathArithmeticException mathArithmeticException) {
                                                                                        throw FastMath.b(mathArithmeticException);
                                                                                    }
                                                                                    return d;
                                                                                }
                                                                                catch (MathArithmeticException mathArithmeticException) {
                                                                                    throw FastMath.b(mathArithmeticException);
                                                                                }
                                                                            }
                                                                            return FastMath.copySign(Math.PI, d);
                                                                        }
                                                                        try {
                                                                            block72: {
                                                                                try {
                                                                                    try {
                                                                                        try {
                                                                                            if (!(d2 < 0.0) && !(d10 < 0.0)) break block71;
                                                                                        }
                                                                                        catch (MathArithmeticException mathArithmeticException) {
                                                                                            throw FastMath.b(mathArithmeticException);
                                                                                        }
                                                                                        if (d < 0.0) break block72;
                                                                                    }
                                                                                    catch (MathArithmeticException mathArithmeticException) {
                                                                                        throw FastMath.b(mathArithmeticException);
                                                                                    }
                                                                                    if (!(d9 < 0.0)) break block73;
                                                                                }
                                                                                catch (MathArithmeticException mathArithmeticException) {
                                                                                    throw FastMath.b(mathArithmeticException);
                                                                                }
                                                                            }
                                                                            return -Math.PI;
                                                                        }
                                                                        catch (MathArithmeticException mathArithmeticException) {
                                                                            throw FastMath.b(mathArithmeticException);
                                                                        }
                                                                    }
                                                                    return Math.PI;
                                                                }
                                                                return d8;
                                                            }
                                                            try {
                                                                try {
                                                                    if (d != Double.POSITIVE_INFINITY) break block74;
                                                                    if (d2 != Double.POSITIVE_INFINITY) break block75;
                                                                }
                                                                catch (MathArithmeticException mathArithmeticException) {
                                                                    throw FastMath.b(mathArithmeticException);
                                                                }
                                                                return 0.7853981633974483;
                                                            }
                                                            catch (MathArithmeticException mathArithmeticException) {
                                                                throw FastMath.b(mathArithmeticException);
                                                            }
                                                        }
                                                        try {
                                                            if (d2 == Double.NEGATIVE_INFINITY) {
                                                                return 2.356194490192345;
                                                            }
                                                        }
                                                        catch (MathArithmeticException mathArithmeticException) {
                                                            throw FastMath.b(mathArithmeticException);
                                                        }
                                                        return 1.5707963267948966;
                                                    }
                                                    try {
                                                        try {
                                                            if (d != Double.NEGATIVE_INFINITY) break block76;
                                                            if (d2 != Double.POSITIVE_INFINITY) break block77;
                                                        }
                                                        catch (MathArithmeticException mathArithmeticException) {
                                                            throw FastMath.b(mathArithmeticException);
                                                        }
                                                        return -0.7853981633974483;
                                                    }
                                                    catch (MathArithmeticException mathArithmeticException) {
                                                        throw FastMath.b(mathArithmeticException);
                                                    }
                                                }
                                                try {
                                                    if (d2 == Double.NEGATIVE_INFINITY) {
                                                        return -2.356194490192345;
                                                    }
                                                }
                                                catch (MathArithmeticException mathArithmeticException) {
                                                    throw FastMath.b(mathArithmeticException);
                                                }
                                                return -1.5707963267948966;
                                            }
                                            try {
                                                block79: {
                                                    try {
                                                        try {
                                                            if (d2 != Double.POSITIVE_INFINITY) break block78;
                                                            if (d > 0.0) break block79;
                                                        }
                                                        catch (MathArithmeticException mathArithmeticException) {
                                                            throw FastMath.b(mathArithmeticException);
                                                        }
                                                        if (!(1.0 / d > 0.0)) break block80;
                                                    }
                                                    catch (MathArithmeticException mathArithmeticException) {
                                                        throw FastMath.b(mathArithmeticException);
                                                    }
                                                }
                                                return 0.0;
                                            }
                                            catch (MathArithmeticException mathArithmeticException) {
                                                throw FastMath.b(mathArithmeticException);
                                            }
                                        }
                                        try {
                                            try {
                                                if (!(d < 0.0) && !(1.0 / d < 0.0)) break block78;
                                            }
                                            catch (MathArithmeticException mathArithmeticException) {
                                                throw FastMath.b(mathArithmeticException);
                                            }
                                            return -0.0;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                    }
                                    try {
                                        block82: {
                                            try {
                                                try {
                                                    if (d2 != Double.NEGATIVE_INFINITY) break block81;
                                                    if (d > 0.0) break block82;
                                                }
                                                catch (MathArithmeticException mathArithmeticException) {
                                                    throw FastMath.b(mathArithmeticException);
                                                }
                                                if (!(1.0 / d > 0.0)) break block83;
                                            }
                                            catch (MathArithmeticException mathArithmeticException) {
                                                throw FastMath.b(mathArithmeticException);
                                            }
                                        }
                                        return Math.PI;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                try {
                                    try {
                                        if (!(d < 0.0) && !(1.0 / d < 0.0)) break block81;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                    return -Math.PI;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                            }
                            try {
                                block85: {
                                    try {
                                        try {
                                            if (d2 != 0.0) break block84;
                                            if (d > 0.0) break block85;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        if (!(1.0 / d > 0.0)) break block86;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                return 1.5707963267948966;
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw FastMath.b(mathArithmeticException);
                            }
                        }
                        try {
                            try {
                                if (!(d < 0.0) && !(1.0 / d < 0.0)) break block84;
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw FastMath.b(mathArithmeticException);
                            }
                            return -1.5707963267948966;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                    }
                    d5 = d / d2;
                    try {
                        try {
                            if (!Double.isInfinite(d5)) break block87;
                            d7 = d5;
                            d6 = 0.0;
                            if (!(d2 < 0.0)) break block88;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        bl2 = true;
                        break block89;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                }
                bl2 = false;
            }
            return FastMath.atan(d7, d6, bl2);
        }
        double d11 = FastMath.doubleHighPart(d5);
        double d12 = d5 - d11;
        double d13 = FastMath.doubleHighPart(d2);
        double d14 = d2 - d13;
        d12 += (d - d11 * d13 - d11 * d14 - d12 * d13 - d12 * d14) / d2;
        double d15 = d11 + d12;
        d12 = -(d15 - d11 - d12);
        d11 = d15;
        if (d11 == 0.0) {
            d11 = FastMath.copySign(0.0, d);
        }
        try {
            d4 = d11;
            d3 = d12;
            bl = d2 < 0.0;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        double d16 = FastMath.atan(d4, d3, bl);
        return d16;
    }

    public static double asin(double d) {
        block16: {
            try {
                if (d != d) {
                    return Double.NaN;
                }
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            try {
                try {
                    if (!(d > 1.0) && !(d < -1.0)) break block16;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                return Double.NaN;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        try {
            if (d == 1.0) {
                return 1.5707963267948966;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (d == -1.0) {
                return -1.5707963267948966;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (d == 0.0) {
                return d;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        double d2 = d * 1.073741824E9;
        double d3 = d + d2 - d2;
        double d4 = d - d3;
        double d5 = d3 * d3;
        double d6 = d3 * d4 * 2.0 + d4 * d4;
        d5 = -d5;
        d6 = -d6;
        double d7 = 1.0 + d5;
        double d8 = -(d7 - 1.0 - d5);
        d2 = d7 + d6;
        d8 += -(d2 - d7 - d6);
        d7 = d2;
        double d9 = FastMath.sqrt(d7);
        d2 = d9 * 1.073741824E9;
        d5 = d9 + d2 - d2;
        d6 = d9 - d5;
        d6 += (d7 - d5 * d5 - 2.0 * d5 * d6 - d6 * d6) / (2.0 * d9);
        double d10 = d8 / (2.0 * d9);
        double d11 = d / d9;
        d2 = d11 * 1.073741824E9;
        double d12 = d11 + d2 - d2;
        double d13 = d11 - d12;
        d13 += (d - d12 * d5 - d12 * d6 - d13 * d5 - d13 * d6) / d9;
        d2 = d12 + (d13 += -d * d10 / d9 / d9);
        d13 = -(d2 - d12 - d13);
        d12 = d2;
        return FastMath.atan(d12, d13, false);
    }

    public static double acos(double d) {
        boolean bl;
        double d2;
        double d3;
        block21: {
            try {
                if (d != d) {
                    return Double.NaN;
                }
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            try {
                try {
                    if (!(d > 1.0) && !(d < -1.0)) break block21;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                return Double.NaN;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        try {
            if (d == -1.0) {
                return Math.PI;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (d == 1.0) {
                return 0.0;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (d == 0.0) {
                return 1.5707963267948966;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        double d4 = d * 1.073741824E9;
        double d5 = d + d4 - d4;
        double d6 = d - d5;
        double d7 = d5 * d5;
        double d8 = d5 * d6 * 2.0 + d6 * d6;
        d7 = -d7;
        d8 = -d8;
        double d9 = 1.0 + d7;
        double d10 = -(d9 - 1.0 - d7);
        d4 = d9 + d8;
        d10 += -(d4 - d9 - d8);
        d9 = d4;
        double d11 = FastMath.sqrt(d9);
        d4 = d11 * 1.073741824E9;
        d7 = d11 + d4 - d4;
        d8 = d11 - d7;
        d8 += (d9 - d7 * d7 - 2.0 * d7 * d8 - d8 * d8) / (2.0 * d11);
        d8 += d10 / (2.0 * d11);
        d11 = d7 + d8;
        d8 = -(d11 - d7 - d8);
        double d12 = d11 / d;
        try {
            if (Double.isInfinite(d12)) {
                return 1.5707963267948966;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        double d13 = FastMath.doubleHighPart(d12);
        double d14 = d12 - d13;
        d14 += (d11 - d13 * d5 - d13 * d6 - d14 * d5 - d14 * d6) / d;
        d4 = d13 + (d14 += d8 / d);
        d14 = -(d4 - d13 - d14);
        d13 = d4;
        try {
            d3 = d13;
            d2 = d14;
            bl = d < 0.0;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return FastMath.atan(d3, d2, bl);
    }

    public static double cbrt(double d) {
        boolean bl;
        int n;
        long l;
        block8: {
            block9: {
                l = Double.doubleToRawLongBits(d);
                n = (int)(l >> 52 & 0x7FFL) - 1023;
                bl = false;
                try {
                    try {
                        if (n != -1023) break block8;
                        if (d != 0.0) break block9;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                    return d;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            bl = true;
            l = Double.doubleToRawLongBits(d *= 1.8014398509481984E16);
            n = (int)(l >> 52 & 0x7FFL) - 1023;
        }
        try {
            if (n == 1024) {
                return d;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        int n2 = n / 3;
        double d2 = Double.longBitsToDouble(l & Long.MIN_VALUE | (long)(n2 + 1023 & 0x7FF) << 52);
        double d3 = Double.longBitsToDouble(l & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
        double d4 = -0.010714690733195933;
        d4 = d4 * d3 + 0.0875862700108075;
        d4 = d4 * d3 + -0.3058015757857271;
        d4 = d4 * d3 + 0.7249995199969751;
        d4 = d4 * d3 + 0.5039018405998233;
        d4 *= CBRTTWO[n % 3 + 2];
        double d5 = d / (d2 * d2 * d2);
        d4 += (d5 - d4 * d4 * d4) / (3.0 * d4 * d4);
        d4 += (d5 - d4 * d4 * d4) / (3.0 * d4 * d4);
        double d6 = d4 * 1.073741824E9;
        double d7 = d4 + d6 - d6;
        double d8 = d4 - d7;
        double d9 = d7 * d7;
        double d10 = d7 * d8 * 2.0 + d8 * d8;
        d6 = d9 * 1.073741824E9;
        double d11 = d9 + d6 - d6;
        d10 += d9 - d11;
        d9 = d11;
        d10 = d9 * d8 + d7 * d10 + d10 * d8;
        double d12 = d5 - (d9 *= d7);
        double d13 = -(d12 - d5 + d9);
        d4 += (d12 + (d13 -= d10)) / (3.0 * d4 * d4);
        d4 *= d2;
        if (bl) {
            d4 *= 3.814697265625E-6;
        }
        return d4;
    }

    public static double toRadians(double d) {
        block5: {
            try {
                try {
                    if (!Double.isInfinite(d) && d != 0.0) break block5;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                return d;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        double d2 = 0.01745329052209854;
        double d3 = 1.997844754509471E-9;
        double d4 = FastMath.doubleHighPart(d);
        double d5 = d - d4;
        double d6 = d5 * 1.997844754509471E-9 + d5 * 0.01745329052209854 + d4 * 1.997844754509471E-9 + d4 * 0.01745329052209854;
        if (d6 == 0.0) {
            d6 *= d;
        }
        return d6;
    }

    public static double toDegrees(double d) {
        block4: {
            try {
                try {
                    if (!Double.isInfinite(d) && d != 0.0) break block4;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                return d;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        double d2 = 57.2957763671875;
        double d3 = 3.145894820876798E-6;
        double d4 = FastMath.doubleHighPart(d);
        double d5 = d - d4;
        return d5 * 3.145894820876798E-6 + d5 * 57.2957763671875 + d4 * 3.145894820876798E-6 + d4 * 57.2957763671875;
    }

    public static int abs(int n) {
        int n2 = n >>> 31;
        return (n ^ ~n2 + 1) + n2;
    }

    public static long abs(long l) {
        long l2 = l >>> 63;
        return (l ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL) + 1L) + l2;
    }

    public static float abs(float f) {
        return Float.intBitsToFloat(Integer.MAX_VALUE & Float.floatToRawIntBits(f));
    }

    public static double abs(double d) {
        return Double.longBitsToDouble(Long.MAX_VALUE & Double.doubleToRawLongBits(d));
    }

    public static double ulp(double d) {
        try {
            if (Double.isInfinite(d)) {
                return Double.POSITIVE_INFINITY;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return FastMath.abs(d - Double.longBitsToDouble(Double.doubleToRawLongBits(d) ^ 1L));
    }

    public static float ulp(float f) {
        try {
            if (Float.isInfinite(f)) {
                return Float.POSITIVE_INFINITY;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return FastMath.abs(f - Float.intBitsToFloat(Float.floatToIntBits(f) ^ 1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double scalb(double d, int n) {
        int n2;
        long l;
        long l2;
        block52: {
            AdvancedEffect[] advancedEffectArray;
            block51: {
                block50: {
                    int n3;
                    block48: {
                        block47: {
                            block46: {
                                advancedEffectArray = FastMath.b();
                                try {
                                    try {
                                        if (n > -1023 && n < 1024) {
                                            return d * Double.longBitsToDouble((long)(n + 1023) << 52);
                                        }
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                                try {
                                    try {
                                        try {
                                            if (Double.isNaN(d)) return d;
                                            if (Double.isInfinite(d)) return d;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        if (d == 0.0) {
                                            return d;
                                        }
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                                try {
                                    try {
                                        if (n >= -2098) break block46;
                                        if (!(d > 0.0)) return -0.0;
                                        return 0.0;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                            }
                            try {
                                try {
                                    if (n <= 2097) break block47;
                                    if (!(d > 0.0)) return Double.NEGATIVE_INFINITY;
                                    return Double.POSITIVE_INFINITY;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw FastMath.b(mathArithmeticException);
                            }
                        }
                        long l3 = Double.doubleToRawLongBits(d);
                        l2 = l3 & Long.MIN_VALUE;
                        n3 = (int)(l3 >>> 52) & 0x7FF;
                        l = l3 & 0xFFFFFFFFFFFFFL;
                        n2 = n3 + n;
                        try {
                            try {
                                if (n >= 0) break block48;
                                if (n2 > 0) {
                                    return Double.longBitsToDouble(l2 | (long)n2 << 52 | l);
                                }
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw FastMath.b(mathArithmeticException);
                            }
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        if (n2 > -53) {
                            long l4 = (l |= 0x10000000000000L) & 1L << -n2;
                            if (l4 == 0L) return Double.longBitsToDouble(l2 | (l >>>= 1 - n2));
                            ++l;
                            return Double.longBitsToDouble(l2 | (l >>>= 1 - n2));
                        }
                        try {
                            if (l2 != 0L) return -0.0;
                            return 0.0;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                    }
                    try {
                        if (n3 != 0) break block50;
                        break block51;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                }
                try {
                    if (n2 < 2047) {
                        return Double.longBitsToDouble(l2 | (long)n2 << 52 | l);
                    }
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                try {
                    if (l2 != 0L) return Double.NEGATIVE_INFINITY;
                    return Double.POSITIVE_INFINITY;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            while (l >>> 52 != 1L) {
                l <<= 1;
                try {
                    --n2;
                    if (advancedEffectArray == null) {
                        if (advancedEffectArray == null) continue;
                        break;
                    }
                    break block52;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            ++n2;
            l &= 0xFFFFFFFFFFFFFL;
        }
        try {
            if (n2 < 2047) {
                return Double.longBitsToDouble(l2 | (long)n2 << 52 | l);
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (l2 != 0L) return Double.NEGATIVE_INFINITY;
            return Double.POSITIVE_INFINITY;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static float scalb(float f, int n) {
        int n2;
        int n3;
        int n4;
        block54: {
            AdvancedEffect[] advancedEffectArray;
            block53: {
                block52: {
                    int n5;
                    block50: {
                        block49: {
                            block48: {
                                advancedEffectArray = FastMath.b();
                                try {
                                    try {
                                        if (n > -127 && n < 128) {
                                            return f * Float.intBitsToFloat(n + 127 << 23);
                                        }
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                                try {
                                    try {
                                        try {
                                            if (Float.isNaN(f)) return f;
                                            if (Float.isInfinite(f)) return f;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        if (f == 0.0f) {
                                            return f;
                                        }
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                                try {
                                    try {
                                        if (n >= -277) break block48;
                                        if (!(f > 0.0f)) return -0.0f;
                                        return 0.0f;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                            }
                            try {
                                try {
                                    if (n <= 276) break block49;
                                    if (!(f > 0.0f)) return Float.NEGATIVE_INFINITY;
                                    return Float.POSITIVE_INFINITY;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw FastMath.b(mathArithmeticException);
                            }
                        }
                        int n6 = Float.floatToIntBits(f);
                        n4 = n6 & Integer.MIN_VALUE;
                        n5 = n6 >>> 23 & 0xFF;
                        n3 = n6 & 0x7FFFFF;
                        n2 = n5 + n;
                        try {
                            try {
                                if (n >= 0) break block50;
                                if (n2 > 0) {
                                    return Float.intBitsToFloat(n4 | n2 << 23 | n3);
                                }
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw FastMath.b(mathArithmeticException);
                            }
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        if (n2 > -24) {
                            int n7 = (n3 |= 0x800000) & 1 << -n2;
                            n3 >>>= 1 - n2;
                            try {
                                if (n7 == 0) return Float.intBitsToFloat(n4 | n3);
                                return Float.intBitsToFloat(n4 | ++n3);
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw FastMath.b(mathArithmeticException);
                            }
                        }
                        try {
                            if (n4 != 0) return -0.0f;
                            return 0.0f;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                    }
                    try {
                        if (n5 != 0) break block52;
                        break block53;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                }
                try {
                    if (n2 < 255) {
                        return Float.intBitsToFloat(n4 | n2 << 23 | n3);
                    }
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                try {
                    if (n4 != 0) return Float.NEGATIVE_INFINITY;
                    return Float.POSITIVE_INFINITY;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            while (n3 >>> 23 != 1) {
                n3 <<= 1;
                try {
                    --n2;
                    if (advancedEffectArray == null) {
                        if (advancedEffectArray == null) continue;
                        break;
                    }
                    break block54;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            ++n2;
            n3 &= 0x7FFFFF;
        }
        try {
            if (n2 < 255) {
                return Float.intBitsToFloat(n4 | n2 << 23 | n3);
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (n4 != 0) return Float.NEGATIVE_INFINITY;
            return Float.POSITIVE_INFINITY;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
    }

    public static double nextAfter(double d, double d2) {
        boolean bl;
        boolean bl2;
        block26: {
            double d3;
            block28: {
                block27: {
                    block23: {
                        double d4;
                        block25: {
                            block24: {
                                block22: {
                                    try {
                                        try {
                                            if (!Double.isNaN(d) && !Double.isNaN(d2)) break block22;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        return Double.NaN;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                try {
                                    if (d == d2) {
                                        return d2;
                                    }
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                                try {
                                    try {
                                        if (!Double.isInfinite(d)) break block23;
                                        if (!(d < 0.0)) break block24;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                    d4 = -1.7976931348623157E308;
                                    break block25;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                            }
                            d4 = Double.MAX_VALUE;
                        }
                        return d4;
                    }
                    try {
                        try {
                            if (d != 0.0) break block26;
                            if (!(d2 < 0.0)) break block27;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        d3 = -4.9E-324;
                        break block28;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                }
                d3 = Double.MIN_VALUE;
            }
            return d3;
        }
        long l = Double.doubleToRawLongBits(d);
        long l2 = l & Long.MIN_VALUE;
        try {
            bl2 = d2 < d;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            bl = l2 == 0L;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (bl2 ^ bl) {
                return Double.longBitsToDouble(l2 | (l & Long.MAX_VALUE) + 1L);
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return Double.longBitsToDouble(l2 | (l & Long.MAX_VALUE) - 1L);
    }

    public static float nextAfter(float f, double d) {
        boolean bl;
        boolean bl2;
        block26: {
            float f2;
            block28: {
                block27: {
                    block23: {
                        float f3;
                        block25: {
                            block24: {
                                block22: {
                                    try {
                                        try {
                                            if (!Double.isNaN(f) && !Double.isNaN(d)) break block22;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        return Float.NaN;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                }
                                try {
                                    if ((double)f == d) {
                                        return (float)d;
                                    }
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                                try {
                                    try {
                                        if (!Float.isInfinite(f)) break block23;
                                        if (!(f < 0.0f)) break block24;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                    f3 = -3.4028235E38f;
                                    break block25;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                            }
                            f3 = Float.MAX_VALUE;
                        }
                        return f3;
                    }
                    try {
                        try {
                            if (f != 0.0f) break block26;
                            if (!(d < 0.0)) break block27;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        f2 = -1.4E-45f;
                        break block28;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                }
                f2 = Float.MIN_VALUE;
            }
            return f2;
        }
        int n = Float.floatToIntBits(f);
        int n2 = n & Integer.MIN_VALUE;
        try {
            bl2 = d < (double)f;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            bl = n2 == 0;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (bl2 ^ bl) {
                return Float.intBitsToFloat(n2 | (n & Integer.MAX_VALUE) + 1);
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return Float.intBitsToFloat(n2 | (n & Integer.MAX_VALUE) - 1);
    }

    public static double floor(double d) {
        long l;
        block13: {
            block12: {
                try {
                    if (d != d) {
                        return d;
                    }
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                try {
                    try {
                        if (!(d >= 4.503599627370496E15) && !(d <= -4.503599627370496E15)) break block12;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                    return d;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            l = (long)d;
            try {
                if (!(d < 0.0) || (double)l == d) break block13;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            --l;
        }
        try {
            if (l == 0L) {
                return d * (double)l;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return l;
    }

    public static double ceil(double d) {
        try {
            if (d != d) {
                return d;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        double d2 = FastMath.floor(d);
        try {
            if (d2 == d) {
                return d2;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        d2 += 1.0;
        try {
            if (d2 == 0.0) {
                return d * d2;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return d2;
    }

    public static double rint(double d) {
        double d2;
        double d3;
        double d4;
        block9: {
            block10: {
                d4 = FastMath.floor(d);
                d3 = d - d4;
                try {
                    try {
                        if (!(d3 > 0.5)) break block9;
                        if (d4 != -1.0) break block10;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                    return -0.0;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            return d4 + 1.0;
        }
        try {
            if (d3 < 0.5) {
                return d4;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        long l = (long)d4;
        try {
            d2 = (l & 1L) == 0L ? d4 : d4 + 1.0;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return d2;
    }

    public static long round(double d) {
        return (long)FastMath.floor(d + 0.5);
    }

    public static int round(float f) {
        return (int)FastMath.floor(f + 0.5f);
    }

    public static int min(int n, int n2) {
        int n3;
        try {
            n3 = n <= n2 ? n : n2;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return n3;
    }

    public static long min(long l, long l2) {
        long l3;
        try {
            l3 = l <= l2 ? l : l2;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return l3;
    }

    public static float min(float f, float f2) {
        try {
            if (f > f2) {
                return f2;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (f < f2) {
                return f;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (f != f2) {
                return Float.NaN;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        int n = Float.floatToRawIntBits(f);
        try {
            if (n == Integer.MIN_VALUE) {
                return f;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return f2;
    }

    public static double min(double d, double d2) {
        try {
            if (d > d2) {
                return d2;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (d < d2) {
                return d;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (d != d2) {
                return Double.NaN;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        long l = Double.doubleToRawLongBits(d);
        try {
            if (l == Long.MIN_VALUE) {
                return d;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return d2;
    }

    public static int max(int n, int n2) {
        int n3;
        try {
            n3 = n <= n2 ? n2 : n;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return n3;
    }

    public static long max(long l, long l2) {
        long l3;
        try {
            l3 = l <= l2 ? l2 : l;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return l3;
    }

    public static float max(float f, float f2) {
        try {
            if (f > f2) {
                return f;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (f < f2) {
                return f2;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (f != f2) {
                return Float.NaN;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        int n = Float.floatToRawIntBits(f);
        try {
            if (n == Integer.MIN_VALUE) {
                return f2;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return f;
    }

    public static double max(double d, double d2) {
        try {
            if (d > d2) {
                return d;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (d < d2) {
                return d2;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (d != d2) {
                return Double.NaN;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        long l = Double.doubleToRawLongBits(d);
        try {
            if (l == Long.MIN_VALUE) {
                return d2;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return d;
    }

    public static double hypot(double d, double d2) {
        block15: {
            block14: {
                try {
                    try {
                        if (!Double.isInfinite(d) && !Double.isInfinite(d2)) break block14;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                    return Double.POSITIVE_INFINITY;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
            }
            try {
                try {
                    if (!Double.isNaN(d) && !Double.isNaN(d2)) break block15;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                return Double.NaN;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        int n = FastMath.getExponent(d);
        int n2 = FastMath.getExponent(d2);
        try {
            if (n > n2 + 27) {
                return FastMath.abs(d);
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        try {
            if (n2 > n + 27) {
                return FastMath.abs(d2);
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        int n3 = (n + n2) / 2;
        double d3 = FastMath.scalb(d, -n3);
        double d4 = FastMath.scalb(d2, -n3);
        double d5 = FastMath.sqrt(d3 * d3 + d4 * d4);
        return FastMath.scalb(d5, n3);
    }

    public static double IEEEremainder(double d, double d2) {
        return StrictMath.IEEEremainder(d, d2);
    }

    public static int toIntExact(long l) {
        block4: {
            try {
                try {
                    if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) break block4;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return (int)l;
    }

    public static int incrementExact(int n) {
        try {
            if (n == Integer.MAX_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, n, 1);
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return n + 1;
    }

    public static long incrementExact(long l) {
        try {
            if (l == Long.MAX_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, l, 1);
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return l + 1L;
    }

    public static int decrementExact(int n) {
        try {
            if (n == Integer.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, n, 1);
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return n - 1;
    }

    public static long decrementExact(long l) {
        try {
            if (l == Long.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, l, 1);
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return l - 1L;
    }

    public static int addExact(int n, int n2) {
        int n3;
        block4: {
            n3 = n + n2;
            try {
                try {
                    if ((n ^ n2) < 0 || (n3 ^ n2) >= 0) break block4;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, n, n2);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return n3;
    }

    public static long addExact(long l, long l2) {
        long l3;
        block4: {
            l3 = l + l2;
            try {
                try {
                    if ((l ^ l2) < 0L || (l3 ^ l2) >= 0L) break block4;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, l, l2);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return l3;
    }

    public static int subtractExact(int n, int n2) {
        int n3;
        block4: {
            n3 = n - n2;
            try {
                try {
                    if ((n ^ n2) >= 0 || (n3 ^ n2) < 0) break block4;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, n, n2);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return n3;
    }

    public static long subtractExact(long l, long l2) {
        long l3;
        block4: {
            l3 = l - l2;
            try {
                try {
                    if ((l ^ l2) >= 0L || (l3 ^ l2) < 0L) break block4;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, l, l2);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return l3;
    }

    public static int multiplyExact(int n, int n2) {
        block19: {
            try {
                block17: {
                    try {
                        try {
                            block18: {
                                try {
                                    try {
                                        try {
                                            block16: {
                                                try {
                                                    try {
                                                        if (n2 <= 0) break block16;
                                                        if (n > Integer.MAX_VALUE / n2) break block17;
                                                    }
                                                    catch (MathArithmeticException mathArithmeticException) {
                                                        throw FastMath.b(mathArithmeticException);
                                                    }
                                                    if (n < Integer.MIN_VALUE / n2) break block17;
                                                }
                                                catch (MathArithmeticException mathArithmeticException) {
                                                    throw FastMath.b(mathArithmeticException);
                                                }
                                            }
                                            if (n2 >= -1) break block18;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        if (n > Integer.MIN_VALUE / n2) break block17;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                    if (n < Integer.MAX_VALUE / n2) break block17;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                            }
                            if (n2 != -1) break block19;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        if (n != Integer.MIN_VALUE) break block19;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_MULTIPLICATION, n, n2);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return n * n2;
    }

    public static long multiplyExact(long l, long l2) {
        block19: {
            try {
                block17: {
                    try {
                        try {
                            block18: {
                                try {
                                    try {
                                        try {
                                            block16: {
                                                try {
                                                    try {
                                                        if (l2 <= 0L) break block16;
                                                        if (l > Long.MAX_VALUE / l2) break block17;
                                                    }
                                                    catch (MathArithmeticException mathArithmeticException) {
                                                        throw FastMath.b(mathArithmeticException);
                                                    }
                                                    if (l < Long.MIN_VALUE / l2) break block17;
                                                }
                                                catch (MathArithmeticException mathArithmeticException) {
                                                    throw FastMath.b(mathArithmeticException);
                                                }
                                            }
                                            if (l2 >= -1L) break block18;
                                        }
                                        catch (MathArithmeticException mathArithmeticException) {
                                            throw FastMath.b(mathArithmeticException);
                                        }
                                        if (l > Long.MIN_VALUE / l2) break block17;
                                    }
                                    catch (MathArithmeticException mathArithmeticException) {
                                        throw FastMath.b(mathArithmeticException);
                                    }
                                    if (l < Long.MAX_VALUE / l2) break block17;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw FastMath.b(mathArithmeticException);
                                }
                            }
                            if (l2 != -1L) break block19;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw FastMath.b(mathArithmeticException);
                        }
                        if (l != Long.MIN_VALUE) break block19;
                    }
                    catch (MathArithmeticException mathArithmeticException) {
                        throw FastMath.b(mathArithmeticException);
                    }
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_MULTIPLICATION, l, l2);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return l * l2;
    }

    public static int floorDiv(int n, int n2) {
        block7: {
            try {
                if (n2 == 0) {
                    throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
                }
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            int n3 = n % n2;
            try {
                try {
                    if ((n ^ n2) < 0 && n3 != 0) break block7;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                return n / n2;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return n / n2 - 1;
    }

    public static long floorDiv(long l, long l2) {
        block7: {
            try {
                if (l2 == 0L) {
                    throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
                }
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            long l3 = l % l2;
            try {
                try {
                    if ((l ^ l2) < 0L && l3 != 0L) break block7;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                return l / l2;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return l / l2 - 1L;
    }

    public static int floorMod(int n, int n2) {
        int n3;
        block7: {
            try {
                if (n2 == 0) {
                    throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
                }
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            n3 = n % n2;
            try {
                try {
                    if ((n ^ n2) < 0 && n3 != 0) break block7;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                return n3;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return n2 + n3;
    }

    public static long floorMod(long l, long l2) {
        long l3;
        block7: {
            try {
                if (l2 == 0L) {
                    throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
                }
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
            l3 = l % l2;
            try {
                try {
                    if ((l ^ l2) < 0L && l3 != 0L) break block7;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw FastMath.b(mathArithmeticException);
                }
                return l3;
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw FastMath.b(mathArithmeticException);
            }
        }
        return l2 + l3;
    }

    public static double copySign(double d, double d2) {
        long l = Double.doubleToRawLongBits(d);
        long l2 = Double.doubleToRawLongBits(d2);
        try {
            if ((l ^ l2) >= 0L) {
                return d;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return -d;
    }

    public static float copySign(float f, float f2) {
        int n = Float.floatToRawIntBits(f);
        int n2 = Float.floatToRawIntBits(f2);
        try {
            if ((n ^ n2) >= 0) {
                return f;
            }
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw FastMath.b(mathArithmeticException);
        }
        return -f;
    }

    public static int getExponent(double d) {
        return (int)(Double.doubleToRawLongBits(d) >>> 52 & 0x7FFL) - 1023;
    }

    public static int getExponent(float f) {
        return (Float.floatToRawIntBits(f) >>> 23 & 0xFF) - 127;
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        String[] stringArray2 = b;
        FastMathCalc.printarray(printStream, stringArray2[7], 1500, ExpIntTable.EXP_INT_TABLE_A);
        FastMathCalc.printarray(printStream, stringArray2[4], 1500, ExpIntTable.EXP_INT_TABLE_B);
        FastMathCalc.printarray(printStream, stringArray2[1], 1025, ExpFracTable.EXP_FRAC_TABLE_A);
        FastMathCalc.printarray(printStream, stringArray2[5], 1025, ExpFracTable.EXP_FRAC_TABLE_B);
        FastMathCalc.printarray(printStream, stringArray2[2], 1024, lnMant.LN_MANT);
        FastMathCalc.printarray(printStream, stringArray2[0], 14, SINE_TABLE_A);
        FastMathCalc.printarray(printStream, stringArray2[9], 14, SINE_TABLE_B);
        FastMathCalc.printarray(printStream, stringArray2[3], 14, COSINE_TABLE_A);
        FastMathCalc.printarray(printStream, stringArray2[8], 14, COSINE_TABLE_B);
        FastMathCalc.printarray(printStream, stringArray2[10], 14, TANGENT_TABLE_A);
        FastMathCalc.printarray(printStream, stringArray2[6], 14, TANGENT_TABLE_B);
    }

    static {
        Object var6_6;
        String[] stringArray = new String[11];
        int n = 0;
        String string = "z< \u0002L\t\u0007k9+\u0018R\u0010l->\u0018U\u000f\u0007j*:\u0006Q\u0011\u0003v4\u0007e;1\nR\u0013\u0012\u000ej:=\u000e]\u0018\u0019}4,\u000bV\u0002\u0007\u000fl->\u0018Z\u0013\u0012v!/\u0005_\u0018\u0019k\u0010l->\u0018U\u000f\u0007j*:\u0006Q\u0011\u0003v7\u000f}4 \u0000V\u0013\u0012v!/\u0005_\u0018\u0019k\u000fl->\u0018Z\u0013\u0012v!/\u0005_\u0018\u0019h\u000ej:=\u000e]\u0018\u0019}4,\u000bV\u0002\u0004";
        int n2 = "z< \u0002L\t\u0007k9+\u0018R\u0010l->\u0018U\u000f\u0007j*:\u0006Q\u0011\u0003v4\u0007e;1\nR\u0013\u0012\u000ej:=\u000e]\u0018\u0019}4,\u000bV\u0002\u0007\u000fl->\u0018Z\u0013\u0012v!/\u0005_\u0018\u0019k\u0010l->\u0018U\u000f\u0007j*:\u0006Q\u0011\u0003v7\u000f}4 \u0000V\u0013\u0012v!/\u0005_\u0018\u0019k\u000fl->\u0018Z\u0013\u0012v!/\u0005_\u0018\u0019h\u000ej:=\u000e]\u0018\u0019}4,\u000bV\u0002\u0004".length();
        FastMath.b(null);
        int n3 = 12;
        int n4 = -1;
        while (true) {
            int n5 = ++n4;
            var6_6 = null;
            stringArray[n++] = FastMath.a(7, FastMath.a(string.substring(n5, n5 + n3)));
            if ((n4 += n3) >= n2) break;
            n3 = string.charAt(n4);
        }
        string = "\u0007A]\u007f1tz\u0016DVe,\u000f\u0000I]}+no\u000b\\Rx\"ed\u0015";
        n2 = "\u0007A]\u007f1tz\u0016DVe,\u000f\u0000I]}+no\u000b\\Rx\"ed\u0015".length();
        n3 = 12;
        n4 = -1;
        while (true) {
            int n6 = ++n4;
            var6_6 = null;
            stringArray[n++] = FastMath.a(122, FastMath.a(string.substring(n6, n6 + n3)));
            if ((n4 += n3) >= n2) break;
            n3 = string.charAt(n4);
        }
        b = stringArray;
        LOG_MAX_VALUE = StrictMath.log(Double.MAX_VALUE);
        LN_QUICK_COEF = new double[][]{{1.0, 5.669184079525E-24}, {-0.25, -0.25}, {0.3333333134651184, 1.986821492305628E-8}, {-0.25, -6.663542893624021E-14}, {0.19999998807907104, 1.1921056801463227E-8}, {-0.1666666567325592, -7.800414592973399E-9}, {0.1428571343421936, 5.650007086920087E-9}, {-0.1250253f, -7.44321345601866E-11}, {0.11113807559013367, 9.219544613762692E-9}};
        LN_HI_PREC_COEF = new double[][]{{1.0, -6.032174644509064E-23}, {-0.25, -0.25}, {0.3333333134651184, 1.9868161777724352E-8}, {-0.2499999701976776, -2.957007209750105E-8}, {0.19999954104423523, 1.5830993332061267E-10}, {-0.1662488f, -2.6033824355191673E-8}};
        SINE_TABLE_A = new double[]{0.0, 0.1246747374534607, 0.24740394949913025, 0.366272509098053, 0.4794255495071411, 0.5850973129272461, 0.6816387176513672, 0.7675435543060303, 0.8414709568023682, 0.902267575263977, 0.9489846229553223, 0.980893f, 0.9974949359893799, 0.9985313415527344};
        SINE_TABLE_B = new double[]{0.0, -4.068233003401932E-9, 9.755392680573412E-9, 1.9987994582857286E-8, -1.0902938113007961E-8, -3.9986783938944604E-8, 4.23719669792332E-8, -5.207000323380292E-8, 2.800552834259E-8, 1.883511811213715E-8, -3.5997360512765566E-9, 4.116164446561962E-8, 5.0614674548127384E-8, -1.0129027912496858E-9};
        COSINE_TABLE_A = new double[]{1.0, 0.9921976327896118, 0.9689123630523682, 0.9305076599121094, 0.8775825500488281, 0.8109631538391113, 0.7316888570785522, 0.6409968137741089, 0.5403022766113281, 0.4311765432357788, 0.3153223395347595, 0.19454771280288696, 0.0707372f, -0.05417713522911072};
        COSINE_TABLE_B = new double[]{0.0, 3.4439717236742845E-8, 5.865827662008209E-8, -3.7999795083850525E-8, 1.184154459111628E-8, -3.43338934259355E-8, 1.1795268640216787E-8, 4.438921624363781E-8, 2.925681159240093E-8, -2.6437112632041807E-8, 2.2860509143963117E-8, -4.813899778443457E-9, 3.6725170580355583E-9, 2.0217439756338078E-10};
        TANGENT_TABLE_A = new double[]{0.0, 0.1256551444530487, 0.25534194707870483, 0.3936265707015991, 0.5463024377822876, 0.7214844226837158, 0.9315965175628662, 1.1974215507507324, 1.5574076175689697, 2.092571258544922, 3.0095696449279785, 5.041914939880371, 14.101419448852539, -18.430862426757812};
        TANGENT_TABLE_B = new double[]{0.0, -7.877917738262007E-9, -2.5857668567479893E-8, 5.2240336371356666E-9, 5.206150291559893E-8, 1.8307188599677033E-8, -5.7618793749770706E-8, 7.848361555046424E-8, 1.0708593250394448E-7, 1.7827257129423813E-8, 2.893485277253286E-8, 3.1660099222737955E-7, 4.983191803254889E-7, -3.356118100840571E-7};
        RECIP_2PI = new long[]{2935890503282001226L, 9154082963658192752L, 3952090531849364496L, 9193070505571053912L, 7910884519577875640L, 113236205062349959L, 4577762542105553359L, -5034868814120038111L, 4208363204685324176L, 5648769086999809661L, 2819561105158720014L, -4035746434778044925L, -302932621132653753L, -2644281811660520851L, -3183605296591799669L, 6722166367014452318L, -3512299194304650054L, -7278142539171889152L};
        PI_O_4_BITS = new long[]{-3958705157555305932L, -4267615245585081135L};
        EIGHTHS = new double[]{0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0, 1.125, 1.25, 1.375, 1.5, 1.625};
        CBRTTWO = new double[]{0.6299605249474366, 0.7937005259840998, 1.0, 1.2599210498948732, 1.5874010519681994};
    }

    public static void b(AdvancedEffect[] advancedEffectArray) {
        a = advancedEffectArray;
    }

    public static AdvancedEffect[] b() {
        return a;
    }

    private static MathArithmeticException b(MathArithmeticException mathArithmeticException) {
        return mathArithmeticException;
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x41);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 46;
                        break;
                    }
                    case 1: {
                        n5 = 114;
                        break;
                    }
                    case 2: {
                        n5 = 105;
                        break;
                    }
                    case 3: {
                        n5 = 64;
                        break;
                    }
                    case 4: {
                        n5 = 20;
                        break;
                    }
                    case 5: {
                        n5 = 90;
                        break;
                    }
                    default: {
                        n5 = 65;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }

    private static class CodyWaite {
        private final int finalK;
        private final double finalRemA;
        private final double finalRemB;

        CodyWaite(double d) {
            double d2;
            double d3;
            int n = (int)(d * 0.6366197723675814);
            AdvancedEffect[] advancedEffectArray = FastMath.b();
            do {
                double d4 = (double)(-n) * 1.570796251296997;
                d3 = d + d4;
                d2 = -(d3 - d - d4);
                d4 = (double)(-n) * 7.549789948768648E-8;
                double d5 = d3;
                d3 = d4 + d5;
                d2 += -(d3 - d5 - d4);
                d4 = (double)(-n) * 6.123233995736766E-17;
                d5 = d3;
                d3 = d4 + d5;
                d2 += -(d3 - d5 - d4);
                if (d3 > 0.0) {
                    if (advancedEffectArray != null) continue;
                    if (advancedEffectArray == null) break;
                }
                --n;
            } while (advancedEffectArray == null);
            this.finalK = n;
            this.finalRemA = d3;
            this.finalRemB = d2;
        }

        int getK() {
            return this.finalK;
        }

        double getRemA() {
            return this.finalRemA;
        }

        double getRemB() {
            return this.finalRemB;
        }
    }

    private static class lnMant {
        private static final double[][] LN_MANT = FastMathLiteralArrays.loadLnMant();

        private lnMant() {
        }
    }

    private static class ExpFracTable {
        private static final double[] EXP_FRAC_TABLE_A = FastMathLiteralArrays.loadExpFracA();
        private static final double[] EXP_FRAC_TABLE_B = FastMathLiteralArrays.loadExpFracB();

        private ExpFracTable() {
        }
    }

    private static class ExpIntTable {
        private static final double[] EXP_INT_TABLE_A = FastMathLiteralArrays.loadExpIntA();
        private static final double[] EXP_INT_TABLE_B = FastMathLiteralArrays.loadExpIntB();

        private ExpIntTable() {
        }
    }

    private static class Split {
        public static final Split NAN = new Split(Double.NaN, 0.0);
        public static final Split POSITIVE_INFINITY = new Split(Double.POSITIVE_INFINITY, 0.0);
        public static final Split NEGATIVE_INFINITY = new Split(Double.NEGATIVE_INFINITY, 0.0);
        private final double full;
        private final double high;
        private final double low;

        Split(double d) {
            this.full = d;
            this.high = Double.longBitsToDouble(Double.doubleToRawLongBits(d) & 0xFFFFFFFFF8000000L);
            this.low = d - this.high;
        }

        Split(double d, double d2) {
            this(d == 0.0 ? (d2 == 0.0 && Double.doubleToRawLongBits(d) == Long.MIN_VALUE ? -0.0 : d2) : d + d2, d, d2);
        }

        Split(double d, double d2, double d3) {
            this.full = d;
            this.high = d2;
            this.low = d3;
        }

        public Split multiply(Split split) {
            Split split2 = new Split(this.full * split.full);
            double d = this.low * split.low - (split2.full - this.high * split.high - this.low * split.high - this.high * split.low);
            return new Split(split2.high, split2.low + d);
        }

        public Split reciprocal() {
            double d = 1.0 / this.full;
            Split split = new Split(d);
            Split split2 = this.multiply(split);
            double d2 = split2.high - 1.0 + split2.low;
            return Double.isNaN(d2) ? split : new Split(split.high, split.low - d2 / this.full);
        }

        private Split pow(long l) {
            Split split = new Split(1.0);
            Split split2 = new Split(this.full, this.high, this.low);
            for (long i = l; i != 0L; i >>>= 1) {
                if ((i & 1L) != 0L) {
                    split = split.multiply(split2);
                }
                split2 = split2.multiply(split2);
            }
            if (Double.isNaN(split.full)) {
                if (Double.isNaN(this.full)) {
                    return NAN;
                }
                if (FastMath.abs(this.full) < 1.0) {
                    return new Split(FastMath.copySign(0.0, this.full), 0.0);
                }
                if (this.full < 0.0 && (l & 1L) == 1L) {
                    return NEGATIVE_INFINITY;
                }
                return POSITIVE_INFINITY;
            }
            return split;
        }
    }
}

