/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.pets.libs.apache.commons.math3.special;

import net.advancedplugins.pets.impl.commons.effects.effects.AdvancedEffect;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.MaxCountExceededException;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.NumberIsTooLargeException;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.NumberIsTooSmallException;
import net.advancedplugins.pets.libs.apache.commons.math3.util.ContinuedFraction;
import net.advancedplugins.pets.libs.apache.commons.math3.util.FastMath;

public class Gamma {
    public static final double GAMMA = 0.5772156649015329;
    public static final double LANCZOS_G = 4.7421875;
    private static final double DEFAULT_EPSILON = 1.0E-14;
    private static final double[] LANCZOS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    private static final double HALF_LOG_2_PI;
    private static final double SQRT_TWO_PI = 2.5066282746310007;
    private static final double C_LIMIT = 49.0;
    private static final double S_LIMIT = 1.0E-5;
    private static final double INV_GAMMA1P_M1_A0 = 6.116095104481416E-9;
    private static final double INV_GAMMA1P_M1_A1 = 6.247308301164655E-9;
    private static final double INV_GAMMA1P_M1_B1 = 0.203610414066807;
    private static final double INV_GAMMA1P_M1_B2 = 0.026620534842894922;
    private static final double INV_GAMMA1P_M1_B3 = 4.939449793824468E-4;
    private static final double INV_GAMMA1P_M1_B4 = -8.514194324403149E-6;
    private static final double INV_GAMMA1P_M1_B5 = -6.4304548177935305E-6;
    private static final double INV_GAMMA1P_M1_B6 = 9.926418406727737E-7;
    private static final double INV_GAMMA1P_M1_B7 = -6.077618957228252E-8;
    private static final double INV_GAMMA1P_M1_B8 = 1.9575583661463974E-10;
    private static final double INV_GAMMA1P_M1_P0 = 6.116095104481416E-9;
    private static final double INV_GAMMA1P_M1_P1 = 6.8716741130671986E-9;
    private static final double INV_GAMMA1P_M1_P2 = 6.820161668496171E-10;
    private static final double INV_GAMMA1P_M1_P3 = 4.686843322948848E-11;
    private static final double INV_GAMMA1P_M1_P4 = 1.5728330277104463E-12;
    private static final double INV_GAMMA1P_M1_P5 = -1.2494415722763663E-13;
    private static final double INV_GAMMA1P_M1_P6 = 4.343529937408594E-15;
    private static final double INV_GAMMA1P_M1_Q1 = 0.3056961078365221;
    private static final double INV_GAMMA1P_M1_Q2 = 0.054642130860422966;
    private static final double INV_GAMMA1P_M1_Q3 = 0.004956830093825887;
    private static final double INV_GAMMA1P_M1_Q4 = 2.6923694661863613E-4;
    private static final double INV_GAMMA1P_M1_C = -0.42278433509846713;
    private static final double INV_GAMMA1P_M1_C0 = 0.5772156649015329;
    private static final double INV_GAMMA1P_M1_C1 = -0.6558780715202539;
    private static final double INV_GAMMA1P_M1_C2 = -0.04200263503409524;
    private static final double INV_GAMMA1P_M1_C3 = 0.16653861138229148;
    private static final double INV_GAMMA1P_M1_C4 = -0.04219773455554433;
    private static final double INV_GAMMA1P_M1_C5 = -0.009621971527876973;
    private static final double INV_GAMMA1P_M1_C6 = 0.0072189432466631;
    private static final double INV_GAMMA1P_M1_C7 = -0.0011651675918590652;
    private static final double INV_GAMMA1P_M1_C8 = -2.1524167411495098E-4;
    private static final double INV_GAMMA1P_M1_C9 = 1.280502823881162E-4;
    private static final double INV_GAMMA1P_M1_C10 = -2.013485478078824E-5;
    private static final double INV_GAMMA1P_M1_C11 = -1.2504934821426706E-6;
    private static final double INV_GAMMA1P_M1_C12 = 1.133027231981696E-6;
    private static final double INV_GAMMA1P_M1_C13 = -2.056338416977607E-7;
    private static boolean a;

    private Gamma() {
    }

    /*
     * Unable to fully structure code
     */
    public static double logGamma(double var0) {
        block13: {
            block14: {
                var2_1 = Gamma.c();
                try {
                    if (Double.isNaN(var0) || var0 <= 0.0) {
                    }
                    ** GOTO lbl12
                }
                catch (MaxCountExceededException v0) {
                    throw Gamma.b(v0);
                }
                var3_2 = NaN;
                try {
                    try {
                        if (!var2_1) break block13;
lbl12:
                        // 2 sources

                        if (!(var0 < 0.5)) break block14;
                    }
                    catch (MaxCountExceededException v1) {
                        throw Gamma.b(v1);
                    }
                    return Gamma.logGamma1p(var0) - FastMath.log(var0);
                }
                catch (MaxCountExceededException v2) {
                    throw Gamma.b(v2);
                }
            }
            try {
                if (var0 <= 2.5) {
                    return Gamma.logGamma1p(var0 - 0.5 - 0.5);
                }
            }
            catch (MaxCountExceededException v3) {
                throw Gamma.b(v3);
            }
            if (var0 <= 8.0) {
                block15: {
                    var5_3 = (int)FastMath.floor(var0 - 1.5);
                    var6_5 = 1.0;
                    for (var8_6 = 1; var8_6 <= var5_3; ++var8_6) {
                        v4 = var6_5 * (var0 - (double)var8_6);
                        if (!var2_1) {
                            var6_5 = v4;
                            if (!var2_1) continue;
                        }
                        break block15;
                    }
                    v4 = Gamma.logGamma1p(var0 - (double)(var5_3 + 1)) + FastMath.log(var6_5);
                }
                return v4;
            }
            var5_4 = Gamma.lanczos(var0);
            var7_7 = var0 + 4.7421875 + 0.5;
            var3_2 = (var0 + 0.5) * FastMath.log(var7_7) - var7_7 + Gamma.HALF_LOG_2_PI + FastMath.log(var5_4 / var0);
        }
        return var3_2;
    }

    public static double regularizedGammaP(double d, double d2) {
        return Gamma.regularizedGammaP(d, d2, 1.0E-14, Integer.MAX_VALUE);
    }

    /*
     * Unable to fully structure code
     */
    public static double regularizedGammaP(double var0, double var2_1, double var4_2, int var6_3) {
        block27: {
            block30: {
                block29: {
                    block28: {
                        block26: {
                            var7_4 = Gamma.b();
                            try {
                                try {
                                    try {
                                        if (Double.isNaN(var0) || Double.isNaN(var2_1)) break block26;
                                    }
                                    catch (MaxCountExceededException v0) {
                                        throw Gamma.b(v0);
                                    }
                                    if (var0 <= 0.0) break block26;
                                }
                                catch (MaxCountExceededException v1) {
                                    throw Gamma.b(v1);
                                }
                                if (var2_1 < 0.0) {
                                }
                                ** GOTO lbl22
                            }
                            catch (MaxCountExceededException v2) {
                                throw Gamma.b(v2);
                            }
                        }
                        var8_5 = NaN;
                        try {
                            if (var7_4) break block27;
lbl22:
                            // 2 sources

                            if (var2_1 == 0.0) {
                            }
                            ** GOTO lbl30
                        }
                        catch (MaxCountExceededException v3) {
                            throw Gamma.b(v3);
                        }
                        var8_5 = 0.0;
                        try {
                            if (var7_4) break block27;
lbl30:
                            // 2 sources

                            if (!(var2_1 >= var0 + 1.0)) break block28;
                        }
                        catch (MaxCountExceededException v4) {
                            throw Gamma.b(v4);
                        }
                        var8_5 = 1.0 - Gamma.regularizedGammaQ(var0, var2_1, var4_2, var6_3);
                        if (var7_4) break block27;
                    }
                    var10_6 = 0.0;
                    var14_8 = var12_7 = 1.0 / var0;
                    while (FastMath.abs(var12_7 / var14_8) > var4_2) {
                        try {
                            try {
                                cfr_temp_0 = var10_6 - (double)var6_3;
                                v5 = cfr_temp_0 == 0.0 ? 0 : (cfr_temp_0 < 0.0 ? -1 : 1);
                                if (!var7_4) break block29;
                                if (v5 >= 0) break;
                            }
                            catch (MaxCountExceededException v6) {
                                throw Gamma.b(v6);
                            }
                            if (!(var14_8 < Infinity)) break;
                        }
                        catch (MaxCountExceededException v7) {
                            throw Gamma.b(v7);
                        }
                        var14_8 += (var12_7 *= var2_1 / (var0 + (var10_6 += 1.0)));
                        if (var7_4) continue;
                    }
                    v5 = (cfr_temp_1 = var10_6 - (double)var6_3) == 0.0 ? 0 : (cfr_temp_1 > 0.0 ? 1 : -1);
                }
                try {
                    if (v5 >= 0) {
                        throw new MaxCountExceededException(var6_3);
                    }
                }
                catch (MaxCountExceededException v8) {
                    throw Gamma.b(v8);
                }
                if (!Double.isInfinite(var14_8)) break block30;
                var8_5 = 1.0;
                if (var7_4) break block27;
            }
            var8_5 = FastMath.exp(-var2_1 + var0 * FastMath.log(var2_1) - Gamma.logGamma(var0)) * var14_8;
        }
        return var8_5;
    }

    public static double regularizedGammaQ(double d, double d2) {
        return Gamma.regularizedGammaQ(d, d2, 1.0E-14, Integer.MAX_VALUE);
    }

    /*
     * Unable to fully structure code
     */
    public static double regularizedGammaQ(final double var0, double var2_1, double var4_2, int var6_3) {
        block17: {
            block18: {
                block16: {
                    var7_4 = Gamma.b();
                    try {
                        try {
                            try {
                                if (Double.isNaN(var0) || Double.isNaN(var2_1)) break block16;
                            }
                            catch (MaxCountExceededException v0) {
                                throw Gamma.b(v0);
                            }
                            if (var0 <= 0.0) break block16;
                        }
                        catch (MaxCountExceededException v1) {
                            throw Gamma.b(v1);
                        }
                        if (var2_1 < 0.0) {
                        }
                        ** GOTO lbl22
                    }
                    catch (MaxCountExceededException v2) {
                        throw Gamma.b(v2);
                    }
                }
                var8_5 = NaN;
                try {
                    if (var7_4) break block17;
lbl22:
                    // 2 sources

                    if (var2_1 == 0.0) {
                    }
                    ** GOTO lbl30
                }
                catch (MaxCountExceededException v3) {
                    throw Gamma.b(v3);
                }
                var8_5 = 1.0;
                try {
                    if (var7_4) break block17;
lbl30:
                    // 2 sources

                    if (!(var2_1 < var0 + 1.0)) break block18;
                }
                catch (MaxCountExceededException v4) {
                    throw Gamma.b(v4);
                }
                var8_5 = 1.0 - Gamma.regularizedGammaP(var0, var2_1, var4_2, var6_3);
                if (var7_4) break block17;
            }
            var10_6 = new ContinuedFraction(){

                protected double getA(int n, double d) {
                    return 2.0 * (double)n + 1.0 - var0 + d;
                }

                protected double getB(int n, double d) {
                    return (double)n * (var0 - (double)n);
                }
            };
            var8_5 = 1.0 / var10_6.evaluate(var2_1, var4_2, var6_3);
            var8_5 = FastMath.exp(-var2_1 + var0 * FastMath.log(var2_1) - Gamma.logGamma(var0)) * var8_5;
        }
        return var8_5;
    }

    public static double digamma(double d) {
        block10: {
            block9: {
                try {
                    try {
                        if (!Double.isNaN(d) && !Double.isInfinite(d)) break block9;
                    }
                    catch (MaxCountExceededException maxCountExceededException) {
                        throw Gamma.b(maxCountExceededException);
                    }
                    return d;
                }
                catch (MaxCountExceededException maxCountExceededException) {
                    throw Gamma.b(maxCountExceededException);
                }
            }
            try {
                try {
                    if (!(d > 0.0) || !(d <= 1.0E-5)) break block10;
                }
                catch (MaxCountExceededException maxCountExceededException) {
                    throw Gamma.b(maxCountExceededException);
                }
                return -0.5772156649015329 - 1.0 / d;
            }
            catch (MaxCountExceededException maxCountExceededException) {
                throw Gamma.b(maxCountExceededException);
            }
        }
        if (d >= 49.0) {
            double d2 = 1.0 / (d * d);
            return FastMath.log(d) - 0.5 / d - d2 * (0.08333333333333333 + d2 * (0.008333333333333333 - d2 / 252.0));
        }
        return Gamma.digamma(d + 1.0) - 1.0 / d;
    }

    public static double trigamma(double d) {
        block10: {
            block9: {
                try {
                    try {
                        if (!Double.isNaN(d) && !Double.isInfinite(d)) break block9;
                    }
                    catch (MaxCountExceededException maxCountExceededException) {
                        throw Gamma.b(maxCountExceededException);
                    }
                    return d;
                }
                catch (MaxCountExceededException maxCountExceededException) {
                    throw Gamma.b(maxCountExceededException);
                }
            }
            try {
                try {
                    if (!(d > 0.0) || !(d <= 1.0E-5)) break block10;
                }
                catch (MaxCountExceededException maxCountExceededException) {
                    throw Gamma.b(maxCountExceededException);
                }
                return 1.0 / (d * d);
            }
            catch (MaxCountExceededException maxCountExceededException) {
                throw Gamma.b(maxCountExceededException);
            }
        }
        if (d >= 49.0) {
            double d2 = 1.0 / (d * d);
            return 1.0 / d + d2 / 2.0 + d2 / d * (0.16666666666666666 - d2 * (0.03333333333333333 + d2 / 42.0));
        }
        return Gamma.trigamma(d + 1.0) + 1.0 / (d * d);
    }

    public static double lanczos(double d) {
        double d2;
        block2: {
            double d3 = 0.0;
            boolean bl = Gamma.c();
            for (int i = LANCZOS.length - 1; i > 0; --i) {
                d2 = d3 + LANCZOS[i] / (d + (double)i);
                if (!bl) {
                    d3 = d2;
                    if (!bl) continue;
                }
                break block2;
            }
            d2 = d3 + LANCZOS[0];
        }
        return d2;
    }

    public static double invGamma1pm1(double d) {
        double d2;
        block18: {
            double d3;
            block19: {
                double d4;
                double d5;
                double d6;
                boolean bl;
                block17: {
                    block16: {
                        bl = Gamma.c();
                        try {
                            if (d < -0.5) {
                                throw new NumberIsTooSmallException(d, (Number)-0.5, true);
                            }
                        }
                        catch (MaxCountExceededException maxCountExceededException) {
                            throw Gamma.b(maxCountExceededException);
                        }
                        try {
                            if (d > 1.5) {
                                throw new NumberIsTooLargeException(d, (Number)1.5, true);
                            }
                        }
                        catch (MaxCountExceededException maxCountExceededException) {
                            throw Gamma.b(maxCountExceededException);
                        }
                        try {
                            double d7 = d6 = d <= 0.5 ? d : d - 0.5 - 0.5;
                        }
                        catch (MaxCountExceededException maxCountExceededException) {
                            throw Gamma.b(maxCountExceededException);
                        }
                        if (!(d6 < 0.0)) break block17;
                        d5 = 6.116095104481416E-9 + d6 * 6.247308301164655E-9;
                        d4 = 1.9575583661463974E-10;
                        d4 = -6.077618957228252E-8 + d6 * d4;
                        d4 = 9.926418406727737E-7 + d6 * d4;
                        d4 = -6.4304548177935305E-6 + d6 * d4;
                        d4 = -8.514194324403149E-6 + d6 * d4;
                        d4 = 4.939449793824468E-4 + d6 * d4;
                        d4 = 0.026620534842894922 + d6 * d4;
                        d4 = 0.203610414066807 + d6 * d4;
                        d4 = 1.0 + d6 * d4;
                        d3 = -2.056338416977607E-7 + d6 * (d5 / d4);
                        d3 = 1.133027231981696E-6 + d6 * d3;
                        d3 = -1.2504934821426706E-6 + d6 * d3;
                        d3 = -2.013485478078824E-5 + d6 * d3;
                        d3 = 1.280502823881162E-4 + d6 * d3;
                        d3 = -2.1524167411495098E-4 + d6 * d3;
                        d3 = -0.0011651675918590652 + d6 * d3;
                        d3 = 0.0072189432466631 + d6 * d3;
                        d3 = -0.009621971527876973 + d6 * d3;
                        d3 = -0.04219773455554433 + d6 * d3;
                        d3 = 0.16653861138229148 + d6 * d3;
                        d3 = -0.04200263503409524 + d6 * d3;
                        d3 = -0.6558780715202539 + d6 * d3;
                        d3 = -0.42278433509846713 + d6 * d3;
                        if (d > 0.5) {
                            d2 = d6 * d3 / d;
                            try {
                                if (!bl) break block16;
                                AdvancedEffect.b(new AdvancedEffect[2]);
                            }
                            catch (MaxCountExceededException maxCountExceededException) {
                                throw Gamma.b(maxCountExceededException);
                            }
                        }
                        d2 = d * (d3 + 0.5 + 0.5);
                    }
                    if (!bl) break block18;
                }
                d5 = 4.343529937408594E-15;
                d5 = -1.2494415722763663E-13 + d6 * d5;
                d5 = 1.5728330277104463E-12 + d6 * d5;
                d5 = 4.686843322948848E-11 + d6 * d5;
                d5 = 6.820161668496171E-10 + d6 * d5;
                d5 = 6.8716741130671986E-9 + d6 * d5;
                d5 = 6.116095104481416E-9 + d6 * d5;
                d4 = 2.6923694661863613E-4;
                d4 = 0.004956830093825887 + d6 * d4;
                d4 = 0.054642130860422966 + d6 * d4;
                d4 = 0.3056961078365221 + d6 * d4;
                d4 = 1.0 + d6 * d4;
                d3 = -2.056338416977607E-7 + d5 / d4 * d6;
                d3 = 1.133027231981696E-6 + d6 * d3;
                d3 = -1.2504934821426706E-6 + d6 * d3;
                d3 = -2.013485478078824E-5 + d6 * d3;
                d3 = 1.280502823881162E-4 + d6 * d3;
                d3 = -2.1524167411495098E-4 + d6 * d3;
                d3 = -0.0011651675918590652 + d6 * d3;
                d3 = 0.0072189432466631 + d6 * d3;
                d3 = -0.009621971527876973 + d6 * d3;
                d3 = -0.04219773455554433 + d6 * d3;
                d3 = 0.16653861138229148 + d6 * d3;
                d3 = -0.04200263503409524 + d6 * d3;
                d3 = -0.6558780715202539 + d6 * d3;
                d3 = 0.5772156649015329 + d6 * d3;
                if (!(d > 0.5)) break block19;
                d2 = d6 / d * (d3 - 0.5 - 0.5);
                if (!bl) break block18;
            }
            d2 = d * d3;
        }
        return d2;
    }

    public static double logGamma1p(double d) {
        try {
            if (d < -0.5) {
                throw new NumberIsTooSmallException(d, (Number)-0.5, true);
            }
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            throw Gamma.b(numberIsTooSmallException);
        }
        try {
            if (d > 1.5) {
                throw new NumberIsTooLargeException(d, (Number)1.5, true);
            }
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            throw Gamma.b(numberIsTooSmallException);
        }
        return -FastMath.log1p(Gamma.invGamma1pm1(d));
    }

    public static double gamma(double d) {
        double d2;
        block19: {
            double d3;
            block20: {
                double d4;
                double d5;
                boolean bl;
                block15: {
                    block18: {
                        double d6;
                        block16: {
                            block17: {
                                double d7;
                                block14: {
                                    bl = Gamma.b();
                                    try {
                                        try {
                                            if (d != FastMath.rint(d) || !(d <= 0.0)) break block14;
                                        }
                                        catch (MaxCountExceededException maxCountExceededException) {
                                            throw Gamma.b(maxCountExceededException);
                                        }
                                        return Double.NaN;
                                    }
                                    catch (MaxCountExceededException maxCountExceededException) {
                                        throw Gamma.b(maxCountExceededException);
                                    }
                                }
                                d5 = FastMath.abs(d);
                                try {
                                    if (!(d5 <= 20.0)) break block15;
                                    if (!(d >= 1.0)) break block16;
                                }
                                catch (MaxCountExceededException maxCountExceededException) {
                                    throw Gamma.b(maxCountExceededException);
                                }
                                d4 = 1.0;
                                d3 = d;
                                while (d3 > 2.5) {
                                    d7 = d4 * (d3 -= 1.0);
                                    if (bl) {
                                        d4 = d7;
                                        if (bl) continue;
                                    }
                                    break block17;
                                }
                                d7 = d2 = d4 / (1.0 + Gamma.invGamma1pm1(d3 - 1.0));
                            }
                            if (bl) break block19;
                        }
                        d4 = d;
                        d3 = d;
                        while (d3 < -0.5) {
                            d6 = d4 * (d3 += 1.0);
                            if (bl) {
                                d4 = d6;
                                if (bl) continue;
                            }
                            break block18;
                        }
                        d6 = d2 = 1.0 / (d4 * (1.0 + Gamma.invGamma1pm1(d3)));
                    }
                    if (bl) break block19;
                }
                d4 = d5 + 4.7421875 + 0.5;
                d3 = 2.5066282746310007 / d5 * FastMath.pow(d4, d5 + 0.5) * FastMath.exp(-d4) * Gamma.lanczos(d5);
                if (!(d > 0.0)) break block20;
                d2 = d3;
                if (bl) break block19;
            }
            d2 = -Math.PI / (d * FastMath.sin(Math.PI * d) * d3);
        }
        return d2;
    }

    static {
        Gamma.b(true);
        HALF_LOG_2_PI = 0.5 * FastMath.log(Math.PI * 2);
    }

    public static void b(boolean bl) {
        a = bl;
    }

    public static boolean b() {
        return a;
    }

    public static boolean c() {
        boolean bl = Gamma.b();
        try {
            if (!bl) {
                return true;
            }
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw Gamma.b(maxCountExceededException);
        }
        return false;
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }
}

