/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.hooks.HookPlugin;
import net.advancedplugins.as.impl.utils.hooks.HooksHandler;
import net.advancedplugins.as.impl.utils.hooks.factions.FactionsPluginHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class AreaUtils {
    private static final List<EntityType> ignoredEntities = Collections.unmodifiableList(Arrays.asList(EntityType.ARMOR_STAND, EntityType.ITEM_FRAME, EntityType.PAINTING, EntityType.LEASH_HITCH, EntityType.MINECART, EntityType.MINECART_CHEST, EntityType.MINECART_COMMAND, EntityType.MINECART_FURNACE, EntityType.MINECART_HOPPER, EntityType.MINECART_MOB_SPAWNER, EntityType.MINECART_TNT, EntityType.BOAT, EntityType.FISHING_HOOK, EntityType.DROPPED_ITEM, EntityType.ARROW, EntityType.SPECTRAL_ARROW, EntityType.EGG, EntityType.ENDER_PEARL, EntityType.ENDER_SIGNAL, EntityType.EXPERIENCE_ORB, EntityType.FIREBALL, EntityType.FIREWORK, EntityType.SMALL_FIREBALL, EntityType.LLAMA_SPIT, EntityType.SNOWBALL, EntityType.SPLASH_POTION, EntityType.THROWN_EXP_BOTTLE, EntityType.WITHER_SKULL, EntityType.SHULKER_BULLET, EntityType.PRIMED_TNT, EntityType.TRIDENT, EntityType.DRAGON_FIREBALL, EntityType.LIGHTNING, EntityType.AREA_EFFECT_CLOUD, EntityType.UNKNOWN));

    public static List<LivingEntity> getEntitiesInRadius(int n, Entity entity, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<LivingEntity> arrayList = new ArrayList<LivingEntity>();
        if (!bl3) {
            for (Entity entity2 : entity.getNearbyEntities((double)n, (double)n, (double)n)) {
                if (!(entity2 instanceof Player)) continue;
                Player player = (Player)entity2;
                if (bl) {
                    player.setMetadata("ae_ignore", (MetadataValue)new FixedMetadataValue((Plugin)ASManager.getInstance(), (Object)true));
                    EntityDamageByEntityEvent entityDamageByEntityEvent = new EntityDamageByEntityEvent(entity, (Entity)player, EntityDamageEvent.DamageCause.CUSTOM, 0.0);
                    Bukkit.getPluginManager().callEvent((Event)entityDamageByEntityEvent);
                    player.removeMetadata("ae_ignore", (Plugin)ASManager.getInstance());
                    if (entityDamageByEntityEvent.isCancelled() ? bl2 : !bl2) continue;
                }
                arrayList.add((LivingEntity)player);
            }
        } else {
            for (Entity entity3 : entity.getNearbyEntities((double)n, (double)n, (double)n)) {
                if (!(entity3 instanceof LivingEntity) || entity3 instanceof Player || entity3 instanceof ArmorStand) continue;
                arrayList.add((LivingEntity)entity3);
            }
        }
        return arrayList;
    }

    public static List<LivingEntity> getEntitiesInRadius(int n, Entity entity, RadiusTarget radiusTarget) {
        ArrayList<LivingEntity> arrayList = new ArrayList<LivingEntity>();
        switch (radiusTarget) {
            case ALL: {
                for (Entity entity2 : entity.getNearbyEntities((double)n, (double)n, (double)n)) {
                    if (!(entity2 instanceof LivingEntity) || ignoredEntities.contains(entity2.getType())) continue;
                    arrayList.add((LivingEntity)entity2);
                }
                break;
            }
            case PLAYERS: {
                for (Entity entity3 : entity.getNearbyEntities((double)n, (double)n, (double)n)) {
                    if (!(entity3 instanceof Player)) continue;
                    arrayList.add((LivingEntity)((Player)entity3));
                }
                break;
            }
            case MOBS: {
                for (Entity entity4 : entity.getNearbyEntities((double)n, (double)n, (double)n)) {
                    if (!(entity4 instanceof LivingEntity) || !AreaUtils.isDamageable(entity, entity4) || ignoredEntities.contains(entity4.getType()) || entity4 instanceof Player) continue;
                    arrayList.add((LivingEntity)entity4);
                }
                break;
            }
            case DAMAGEABLE: {
                for (Entity entity5 : entity.getNearbyEntities((double)n, (double)n, (double)n)) {
                    if (!(entity5 instanceof LivingEntity) || !AreaUtils.isDamageable(entity, entity5) || ignoredEntities.contains(entity5.getType())) continue;
                    arrayList.add((LivingEntity)entity5);
                }
                break;
            }
            case UNDAMAGEABLE: {
                for (Entity entity6 : entity.getNearbyEntities((double)n, (double)n, (double)n)) {
                    if (!(entity6 instanceof LivingEntity) || AreaUtils.isDamageable(entity, entity6) || ignoredEntities.contains(entity6.getType())) continue;
                    arrayList.add((LivingEntity)entity6);
                }
                break;
            }
        }
        return arrayList;
    }

    private static boolean isDamageable(Entity entity, Entity entity2) {
        FactionsPluginHook factionsPluginHook;
        String string;
        entity2.setMetadata("ae_ignore", (MetadataValue)new FixedMetadataValue((Plugin)ASManager.getInstance(), (Object)true));
        EntityDamageByEntityEvent entityDamageByEntityEvent = new EntityDamageByEntityEvent(entity2, entity2, EntityDamageEvent.DamageCause.CUSTOM, 0.0);
        Bukkit.getPluginManager().callEvent((Event)entityDamageByEntityEvent);
        entity2.removeMetadata("ae_ignore", (Plugin)ASManager.getInstance());
        if (entity2 instanceof Player && entity instanceof Player && HooksHandler.isEnabled(HookPlugin.FACTIONS) && (string = (factionsPluginHook = (FactionsPluginHook)HooksHandler.getHook(HookPlugin.FACTIONS)).getRelation((Player)entity2, (Player)entity)).equals("member")) {
            return false;
        }
        return !entityDamageByEntityEvent.isCancelled();
    }

    public static enum RadiusTarget {
        ALL,
        PLAYERS,
        MOBS,
        DAMAGEABLE,
        UNDAMAGEABLE;

    }
}

