/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.utils.commands.argument;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.advancedplugins.as.impl.utils.commands.argument.ArgumentType;
import org.bukkit.command.CommandSender;

public class Argument<T> {
    private final ArgumentType<T> type;
    private final String argument;
    private final Set<String> aliases;
    private final Function<CommandSender, List<String>> onTabComplete;
    private boolean optional;

    public Argument(ArgumentType<T> argumentType, String string, Function<CommandSender, List<String>> function, String ... stringArray) {
        this.type = argumentType;
        this.argument = string;
        this.aliases = Sets.newHashSet((Object[])stringArray);
        this.onTabComplete = function;
    }

    public Argument(ArgumentType<T> argumentType, String string, String ... stringArray) {
        this.type = argumentType;
        this.argument = string;
        this.aliases = Sets.newHashSet((Object[])stringArray);
        this.onTabComplete = commandSender -> Lists.newArrayList((Object[])new String[]{string});
    }

    public Argument asOptional() {
        this.optional = true;
        return this;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public ArgumentType<T> getType() {
        return this.type;
    }

    public String getArgument() {
        return this.argument;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Function<CommandSender, List<String>> getOnTabComplete() {
        return this.onTabComplete;
    }
}

