/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.utils.hooks.plugins;

import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.CustomStack;
import dev.lone.itemsadder.api.Events.CustomBlockBreakEvent;
import java.util.Collections;
import java.util.List;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.SchedulerUtils;
import net.advancedplugins.as.impl.utils.hooks.HookPlugin;
import net.advancedplugins.as.impl.utils.hooks.PluginHookInstance;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemsAdderHook
extends PluginHookInstance
implements Listener {
    private final Plugin plugin;

    public ItemsAdderHook(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return HookPlugin.ITEMSADDER.getPluginName();
    }

    public boolean isCustomItem(ItemStack itemStack) {
        return CustomStack.byItemStack((ItemStack)itemStack) != null;
    }

    public boolean isCustomBlock(Block block) {
        if (block == null) {
            return false;
        }
        return CustomBlock.byAlreadyPlaced((Block)block) != null;
    }

    public boolean removeBlock(Block block) {
        if (!this.isCustomBlock(block)) {
            return false;
        }
        return CustomBlock.byAlreadyPlaced((Block)block).remove();
    }

    public List<ItemStack> getLootForCustomBlock(Block block) {
        if (!this.isCustomBlock(block)) {
            return Collections.emptyList();
        }
        return CustomBlock.byAlreadyPlaced((Block)block).getLoot();
    }

    public List<ItemStack> getLootForCustomBlock(ItemStack itemStack, Block block) {
        if (!this.isCustomBlock(block)) {
            return Collections.emptyList();
        }
        return CustomBlock.byAlreadyPlaced((Block)block).getLoot(itemStack, false);
    }

    public ItemStack setCustomItemDurability(ItemStack itemStack, int n) {
        CustomStack customStack = CustomStack.byItemStack((ItemStack)itemStack);
        customStack.setDurability(n);
        return customStack.getItemStack();
    }

    public boolean canBeBrokenWith(ItemStack itemStack, Block block) {
        return !CustomBlock.byAlreadyPlaced((Block)block).getLoot(itemStack, false).isEmpty();
    }

    public ItemStack getByName(String string) {
        CustomStack customStack = CustomStack.getInstance((String)string);
        if (customStack == null) {
            return null;
        }
        return customStack.getItemStack();
    }

    public int getCustomItemDurability(ItemStack itemStack) {
        return CustomStack.byItemStack((ItemStack)itemStack).getDurability();
    }

    public int getCustomItemMaxDurability(ItemStack itemStack) {
        return CustomStack.byItemStack((ItemStack)itemStack).getMaxDurability();
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onCustomBlockBreak(CustomBlockBreakEvent customBlockBreakEvent) {
        Player player = customBlockBreakEvent.getPlayer();
        Block block = customBlockBreakEvent.getBlock();
        if (block.hasMetadata("telepathy-broken-itemsadder")) {
            block.removeMetadata("telepathy-broken-itemsadder", this.plugin);
            customBlockBreakEvent.setCancelled(true);
            SchedulerUtils.runTaskLater(() -> {
                CustomBlock customBlock = CustomBlock.byAlreadyPlaced((Block)block);
                ItemStack[] itemStackArray = customBlock.getLoot(player.getEquipment().getItemInMainHand(), false).toArray(new ItemStack[0]);
                if (customBlock.remove()) {
                    ASManager.giveItem(player, itemStackArray);
                }
            });
        }
    }
}

