/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons.biomes;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import net.advancedplugins.seasons.Core;
import net.advancedplugins.seasons.biomes.AdvancedBiomeBase;
import net.advancedplugins.seasons.biomes.BiomeUtils;
import net.advancedplugins.seasons.biomes.SeasonData;
import net.advancedplugins.seasons.biomes.nms.NMSBiome_1_19_4;
import net.advancedplugins.seasons.biomes.nms.NMSBiome_1_20_1;
import net.advancedplugins.seasons.biomes.nms.NMSBiome_1_20_2;
import net.advancedplugins.seasons.biomes.nms.NMSBiome_1_20_3;
import net.advancedplugins.seasons.biomes.nms.Packets_1_19_4;
import net.advancedplugins.seasons.biomes.nms.Packets_1_20_1;
import net.advancedplugins.seasons.biomes.nms.Packets_1_20_2;
import net.advancedplugins.seasons.biomes.nms.Packets_1_20_3;
import net.advancedplugins.seasons.enums.ColorType;
import net.advancedplugins.seasons.enums.Season;
import net.advancedplugins.seasons.enums.SeasonType;
import net.advancedplugins.seasons.handlers.RenderHandler;
import net.advancedplugins.seasons.objects.INMSBiome;
import net.advancedplugins.seasons.objects.IProtocolLib;
import net.advancedplugins.seasons.utils.TransitionColors;
import org.bukkit.block.Biome;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class BiomesHandler {
    private final ImmutableMap<String, AdvancedBiomeBase> biomeMap;
    private INMSBiome nmsBiome;
    private IProtocolLib protocolLib;
    private final EnumMap<Season, ImmutableMap<Integer, Integer>> seasonToBiomeMap = new EnumMap(Season.class);
    private ImmutableMap<Integer, Biome> optimizedIDs;
    private final RenderHandler renderHandler;
    private HashSet<Integer> reported = new HashSet();

    public BiomesHandler(JavaPlugin javaPlugin) {
        javaPlugin.getLogger().warning("Minecraft Version: " + MinecraftVersion.getCurrentVersion().name());
        this.loadNMSBiome(javaPlugin);
        this.biomeMap = this.loadAllBiomes(javaPlugin, "biomeConfiguration");
        this.generateBiomes();
        this.generateTransitions();
        this.populateSeasonTransitionMap();
        this.generateOptimizedIDs();
        ASManager.debug("[BiomesHandler] Registered total of " + this.biomeMap.size() + " biomes");
        this.renderHandler = new RenderHandler(this);
        BiomeUtils.init(this);
    }

    private void generateOptimizedIDs() {
        HashMap<Integer, Biome> hashMap = new HashMap<Integer, Biome>();
        for (Biome biome : Biome.values()) {
            Integer n = this.nmsBiome.getVanillaBiomeId(biome);
            if (n == null) {
                ASManager.debug("NULL ID for Biome " + n);
                continue;
            }
            hashMap.put(n, biome);
        }
        this.optimizedIDs = ImmutableMap.builder().putAll(hashMap).build();
    }

    private void loadNMSBiome(JavaPlugin javaPlugin) {
        MinecraftVersion minecraftVersion = MinecraftVersion.getCurrentVersion();
        switch (minecraftVersion) {
            case MC1_19_R3: {
                this.nmsBiome = new NMSBiome_1_19_4();
                this.protocolLib = new Packets_1_19_4(javaPlugin, this, this.nmsBiome);
                break;
            }
            case MC1_20_R1: {
                this.nmsBiome = new NMSBiome_1_20_1();
                this.protocolLib = new Packets_1_20_1(javaPlugin, this, this.nmsBiome);
                break;
            }
            case MC1_20_R2: {
                this.nmsBiome = new NMSBiome_1_20_2();
                this.protocolLib = new Packets_1_20_2(javaPlugin, this, this.nmsBiome);
                break;
            }
            case MC1_20_R3: 
            case MC1_20_R4: {
                this.nmsBiome = new NMSBiome_1_20_3();
                this.protocolLib = new Packets_1_20_3(javaPlugin, this, this.nmsBiome);
            }
        }
    }

    private INMSBiome loadNMSBiome(AdvancedBiomeBase advancedBiomeBase, SeasonType seasonType, SeasonData seasonData, int n) {
        MinecraftVersion minecraftVersion = MinecraftVersion.getCurrentVersion();
        switch (minecraftVersion) {
            case MC1_19_R3: {
                this.nmsBiome = new NMSBiome_1_19_4(advancedBiomeBase, seasonType, seasonData, n);
                return this.nmsBiome;
            }
            case MC1_20_R1: {
                this.nmsBiome = new NMSBiome_1_20_1(advancedBiomeBase, seasonType, seasonData, n);
                return this.nmsBiome;
            }
            case MC1_20_R2: {
                this.nmsBiome = new NMSBiome_1_20_2(advancedBiomeBase, seasonType, seasonData, n);
                return this.nmsBiome;
            }
            case MC1_20_R3: 
            case MC1_20_R4: {
                this.nmsBiome = new NMSBiome_1_20_3(advancedBiomeBase, seasonType, seasonData, n);
                return this.nmsBiome;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void generateTransitions() {
        for (Map.Entry entry : this.biomeMap.entrySet()) {
            AdvancedBiomeBase advancedBiomeBase = (AdvancedBiomeBase)entry.getValue();
            SeasonType[] seasonTypeArray = SeasonType.values();
            for (int i = 0; i < seasonTypeArray.length; ++i) {
                void object;
                SeasonType seasonType = seasonTypeArray[i];
                SeasonType seasonType2 = i == seasonTypeArray.length - 1 ? seasonTypeArray[0] : seasonTypeArray[i + 1];
                SeasonData seasonData = advancedBiomeBase.getSeasons().get((Object)seasonType);
                SeasonData seasonData2 = advancedBiomeBase.getSeasons().get((Object)seasonType2);
                HashMap<Integer, INMSBiome> hashMap = new HashMap<Integer, INMSBiome>();
                HashMap<ColorType, String[]> hashMap2 = new HashMap<ColorType, String[]>();
                ColorType[] colorTypeArray = ColorType.values();
                int n = colorTypeArray.length;
                boolean bl = false;
                while (object < n) {
                    ColorType colorType = colorTypeArray[object];
                    String string = seasonData.getColors().get((Object)colorType);
                    String string2 = seasonData2.getColors().get((Object)colorType);
                    String[] stringArray = TransitionColors.getBlendedPhases(string, string2);
                    hashMap2.put(colorType, stringArray);
                    ++object;
                }
                for (int j = 1; j < 4; ++j) {
                    SeasonData seasonData3 = new SeasonData();
                    if (j == 3 && seasonData2.isSnow()) {
                        seasonData3.setSnow(true);
                    }
                    for (ColorType colorType : ColorType.values()) {
                        seasonData3.setColor(colorType, ((String[])hashMap2.get((Object)colorType))[j - 1]);
                    }
                    INMSBiome iNMSBiome = this.loadNMSBiome(advancedBiomeBase, seasonType, seasonData3, j);
                    hashMap.put(j, iNMSBiome);
                }
                advancedBiomeBase.getSubbiomes().put(seasonType, hashMap);
            }
        }
    }

    public ImmutableMap<String, AdvancedBiomeBase> loadAllBiomes(JavaPlugin javaPlugin, String string2) {
        File file2 = new File(javaPlugin.getDataFolder(), string2);
        File[] fileArray = file2.listFiles((file, string) -> string.endsWith(".yml"));
        HashMap<String, AdvancedBiomeBase> hashMap = new HashMap<String, AdvancedBiomeBase>();
        for (File file3 : fileArray) {
            AdvancedBiomeBase advancedBiomeBase = this.loadBiomeFromFile(file3);
            hashMap.put(file3.getName().replace(".yml", ""), advancedBiomeBase);
        }
        return ImmutableMap.builder().putAll(hashMap).build();
    }

    public AdvancedBiomeBase loadBiomeFromFile(File file) {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        AdvancedBiomeBase advancedBiomeBase = new AdvancedBiomeBase();
        advancedBiomeBase.setBiomes(yamlConfiguration.getStringList("biomes"));
        advancedBiomeBase.setTemperature(yamlConfiguration.getInt("temperature"));
        advancedBiomeBase.setName(file.getName().replace(".yml", ""));
        for (String string : yamlConfiguration.getConfigurationSection("seasons").getKeys(false)) {
            SeasonData seasonData = new SeasonData();
            SeasonType seasonType = SeasonType.valueOf(string.toUpperCase());
            for (ColorType colorType : ColorType.values()) {
                if (!yamlConfiguration.contains("seasons." + string + "." + colorType.getPath())) {
                    Core.getInstance().getLogger().warning("Failed to load COLOR " + colorType.getPath() + " for " + advancedBiomeBase.getName() + " " + string);
                    continue;
                }
                seasonData.setColor(colorType, yamlConfiguration.getString("seasons." + string + "." + colorType.getPath()));
            }
            seasonData.setSnow(yamlConfiguration.getBoolean("seasons." + string + ".snow", false));
            if (yamlConfiguration.contains("seasons." + string + ".winter-freeze")) {
                seasonData.setWinterFreeze(yamlConfiguration.getBoolean("seasons." + string + ".winter-freeze"));
            }
            advancedBiomeBase.getSeasons().put(seasonType, seasonData);
        }
        return advancedBiomeBase;
    }

    public Integer getBiomeReplacement(Integer n, Season season, boolean bl) {
        Integer n2;
        if (bl) {
            return this.nmsBiome.getVanillaBiomeId(season.getBedrockBiome());
        }
        if (!BiomeUtils.getFallNoMixBiomes().contains((Object)n)) {
            season = season.getRandomTransition();
        }
        if ((n2 = (Integer)this.seasonToBiomeMap.get((Object)season).getOrDefault((Object)n, null)) == null) {
            return null;
        }
        return n2;
    }

    private void populateSeasonTransitionMap() {
        for (Season season : Season.values()) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (AdvancedBiomeBase advancedBiomeBase : this.biomeMap.values()) {
                SeasonType seasonType = BiomeUtils.getSeasonType(season.getSeasonId());
                int n = season.getTransition() == 0 ? advancedBiomeBase.getBiome().get((Object)seasonType).getBiomeID() : advancedBiomeBase.getSubbiomes().get((Object)seasonType).get(season.getTransition()).getBiomeID();
                for (String string : advancedBiomeBase.getBiomes()) {
                    Biome biome = Biome.valueOf((String)string);
                    Integer n2 = this.nmsBiome.getVanillaBiomeId(biome);
                    if (n2 == null) {
                        ASManager.debug("INVALID ID FOR VANILLA BIOME: " + string);
                        continue;
                    }
                    hashMap.put(n2, n);
                }
            }
            this.seasonToBiomeMap.put(season, (ImmutableMap<Integer, Integer>)ImmutableMap.copyOf(hashMap));
        }
    }

    private void generateBiomes() {
        for (AdvancedBiomeBase advancedBiomeBase : this.biomeMap.values()) {
            for (SeasonType seasonType : SeasonType.values()) {
                try {
                    SeasonData seasonData = advancedBiomeBase.getSeasons().get((Object)seasonType);
                    INMSBiome iNMSBiome = this.loadNMSBiome(advancedBiomeBase, seasonType, seasonData, 0);
                    advancedBiomeBase.getBiome().put(seasonType, iNMSBiome);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public AdvancedBiomeBase getBiome(Biome biome) {
        return this.biomeMap.values().stream().filter(advancedBiomeBase -> advancedBiomeBase.getBiomes().contains(biome.name())).findFirst().orElse(null);
    }

    public boolean isFrozen(Biome biome, SeasonType seasonType) {
        if (!seasonType.equals((Object)SeasonType.WINTER)) {
            return false;
        }
        AdvancedBiomeBase advancedBiomeBase = this.getBiome(biome);
        if (advancedBiomeBase == null) {
            return false;
        }
        return advancedBiomeBase.getSeasons().get((Object)SeasonType.WINTER).getWinterFreeze();
    }

    public ImmutableMap<String, AdvancedBiomeBase> getBiomeMap() {
        return this.biomeMap;
    }

    public INMSBiome getNmsBiome() {
        return this.nmsBiome;
    }

    public IProtocolLib getProtocolLib() {
        return this.protocolLib;
    }

    public EnumMap<Season, ImmutableMap<Integer, Integer>> getSeasonToBiomeMap() {
        return this.seasonToBiomeMap;
    }

    public ImmutableMap<Integer, Biome> getOptimizedIDs() {
        return this.optimizedIDs;
    }

    public RenderHandler getRenderHandler() {
        return this.renderHandler;
    }

    public HashSet<Integer> getReported() {
        return this.reported;
    }
}

