/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons.handlers.sub;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.Pair;
import net.advancedplugins.as.impl.utils.ReallyFastBlockHandler;
import net.advancedplugins.as.impl.utils.hooks.HookPlugin;
import net.advancedplugins.as.impl.utils.hooks.HooksHandler;
import net.advancedplugins.as.impl.utils.hooks.plugins.ResidenceHook;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import net.advancedplugins.seasons.Core;
import net.advancedplugins.seasons.biomes.BiomeUtils;
import net.advancedplugins.seasons.enums.SeasonType;
import net.advancedplugins.seasons.handlers.grass.GrassPatternsUtil;
import net.advancedplugins.seasons.handlers.sub.CustomChunkData;
import net.advancedplugins.seasons.handlers.sub.SnowPatternUtil;
import net.advancedplugins.seasons.utils.LocalChunkSnapshot;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.bukkit.util.VoxelShape;

public class BlockProcessHandler {
    private final HashMap<String, Queue<Pair<Location, SeasonType>>> locationQueue = new HashMap();
    private BukkitTask snowGenerator;
    private BukkitTask locationScanner;
    private final ConcurrentHashMap<String, LocalChunkSnapshot> snapshotCache = new ConcurrentHashMap();
    private final int chunkScanRadius;
    private final List<Pair<Integer, Integer>> randomizedChunks;
    private ReallyFastBlockHandler handler = null;
    private static NamespacedKey KEY_CHUNK_STAGE;
    private static NamespacedKey KEY_CHUNK_STAGE_SEASON;
    private final ImmutableList<String> materialBlacklist = ImmutableList.builder().add((Object[])new String[]{"STAIRS", "FENCE", "DIRT_PATH", "ICE"}).build();
    private final boolean checkProtection;
    private boolean lock = false;

    public BlockProcessHandler(JavaPlugin javaPlugin) {
        this.chunkScanRadius = javaPlugin.getConfig().getInt("chunkRadius", 7);
        this.randomizedChunks = this.generateRandomizedChunkCoordinates();
        KEY_CHUNK_STAGE = new NamespacedKey((Plugin)javaPlugin, "chunk_stage");
        KEY_CHUNK_STAGE_SEASON = new NamespacedKey((Plugin)javaPlugin, "chunk_stage_season");
        boolean bl = this.checkProtection = !javaPlugin.getConfig().getBoolean("ignoreLandProtection", false);
        if (javaPlugin.getConfig().getBoolean("snowEnabled", true)) {
            this.initScanner();
            this.initGenerator();
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)javaPlugin, this::cleanupOldSnapshots, 20L, 20L);
        }
    }

    private List<Pair<Integer, Integer>> generateRandomizedChunkCoordinates() {
        ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>();
        for (int i = -this.chunkScanRadius; i <= this.chunkScanRadius; ++i) {
            for (int j = -this.chunkScanRadius; j <= this.chunkScanRadius; ++j) {
                arrayList.add(new Pair<Integer, Integer>(i, j));
            }
        }
        return arrayList;
    }

    private void initGenerator() {
        this.snowGenerator = new BukkitRunnable(){

            public void run() {
                for (String string2 : Core.getWorldHandler().getEnabledWorlds()) {
                    World world = Bukkit.getWorld((String)string2);
                    if (world == null || BlockProcessHandler.this.locationQueue.computeIfAbsent(world.getName(), string -> new ArrayDeque()).isEmpty() || !Core.getWorldHandler().isWorldEnabled(world.getName())) continue;
                    SeasonType seasonType = Core.getSeasonHandler().getSeason(world.getName()).getType();
                    BlockProcessHandler.this.handler = ReallyFastBlockHandler.getForWorld(world);
                    EnumMap<Material, HashSet> enumMap = new EnumMap<Material, HashSet>(Material.class);
                    SeasonType seasonType2 = Core.getSeasonHandler().getSeason(world.getName()).getType();
                    Queue<Pair<Location, SeasonType>> queue = BlockProcessHandler.this.locationQueue.get(world.getName());
                    int n = queue.size() < 100 ? queue.size() : queue.size() / 3;
                    for (int i = 0; i < n; ++i) {
                        Block block;
                        Block block2;
                        Pair<Material, Block> pair;
                        Location location;
                        Pair<Location, SeasonType> pair2 = queue.remove();
                        if (!pair2.getValue().equals((Object)seasonType) || (location = pair2.getKey()) == null || !location.getChunk().isLoaded() || (pair = BlockProcessHandler.this.handleBlock(block2 = location.getBlock(), block = block2.getRelative(0, 1, 0), seasonType2)) == null) continue;
                        enumMap.computeIfAbsent(pair.getKey(), material -> new HashSet()).add(pair.getValue());
                    }
                    for (Map.Entry entry : enumMap.entrySet()) {
                        BlockProcessHandler.this.handler.setType(entry.getKey(), ((HashSet)entry.getValue()).toArray(new Block[0]));
                    }
                }
            }
        }.runTaskTimer((Plugin)Core.getInstance(), 2L, 2L);
    }

    private void initScanner() {
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (BlockProcessHandler.this.lock) {
                    ASManager.debug("\u00a7c[AdvancedSeasons] skipping block processing, server behind ticks.");
                    return;
                }
                BlockProcessHandler.this.lock = true;
                try {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!Core.getWorldHandler().isWorldEnabled(player.getWorld().getName())) continue;
                        SeasonType seasonType = Core.getSeasonHandler().getSeason(player.getWorld().getName()).getType();
                        boolean bl = seasonType.equals((Object)SeasonType.WINTER);
                        boolean bl2 = seasonType.equals((Object)SeasonType.SPRING);
                        if (bl && player.getWorld().isClearWeather()) continue;
                        Chunk chunk = player.getLocation().getChunk();
                        for (Pair<Integer, Integer> pair : BlockProcessHandler.this.randomizedChunks) {
                            int n;
                            LocalChunkSnapshot localChunkSnapshot;
                            boolean bl3;
                            int n2;
                            int n3 = pair.getKey();
                            int n4 = pair.getValue();
                            int n5 = chunk.getX() + n3;
                            Chunk chunk2 = BlockProcessHandler.this.getChunk(chunk, n5, n2 = chunk.getZ() + n4);
                            if (chunk2 == null) continue;
                            int n6 = (Integer)chunk2.getPersistentDataContainer().getOrDefault(KEY_CHUNK_STAGE, PersistentDataType.INTEGER, (Object)1);
                            String string2 = (String)chunk2.getPersistentDataContainer().getOrDefault(KEY_CHUNK_STAGE_SEASON, PersistentDataType.STRING, (Object)"");
                            if (n6 > 16 && string2.equals(seasonType.name())) continue;
                            String string3 = n5 + ";" + n2 + ";" + chunk.getWorld().getName();
                            boolean bl4 = bl3 = string2.equals(SeasonType.WINTER.name()) && seasonType.equals((Object)SeasonType.SUMMER);
                            if (!string2.equals(seasonType.name())) {
                                chunk2.getPersistentDataContainer().set(KEY_CHUNK_STAGE, PersistentDataType.INTEGER, (Object)1);
                                chunk2.getPersistentDataContainer().set(KEY_CHUNK_STAGE_SEASON, PersistentDataType.STRING, (Object)seasonType.name());
                                n6 = 1;
                            }
                            if ((localChunkSnapshot = BlockProcessHandler.this.snapshotCache.computeIfAbsent(string3, string -> BlockProcessHandler.this.getSnapshot(n5, n2, chunk2))) == null) continue;
                            if (bl || bl2) {
                                for (Vector vector : SnowPatternUtil.getOffsetsForStage(n6)) {
                                    if (!BlockProcessHandler.this.processChunkScan(chunk, n5, n2, localChunkSnapshot, vector, seasonType)) continue;
                                }
                                n = n6 + 1;
                            } else {
                                int n7 = 0;
                                int n8 = 0;
                                for (Vector vector : (List)SnowPatternUtil.MELT_STATE_TO_OFFSETS_MAP.get((Object)1)) {
                                    ++n7;
                                    if (!BlockProcessHandler.this.processChunkScan(chunk, n5, n2, localChunkSnapshot, vector, seasonType)) continue;
                                    ++n8;
                                }
                                n = 17;
                                if (bl3) {
                                    // empty if block
                                }
                            }
                            chunk2.getPersistentDataContainer().set(KEY_CHUNK_STAGE, PersistentDataType.INTEGER, (Object)n);
                            if (n != 16) continue;
                            BlockProcessHandler.this.snapshotCache.remove(string3);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    BlockProcessHandler.this.lock = false;
                }
            }
        };
        this.locationScanner = MinecraftVersion.isPaper() ? bukkitRunnable.runTaskTimerAsynchronously((Plugin)Core.getInstance(), 20L, 20L) : bukkitRunnable.runTaskTimer((Plugin)Core.getInstance(), 40L, 40L);
    }

    private LocalChunkSnapshot getSnapshot(int n, int n2, Chunk chunk) {
        try {
            return new LocalChunkSnapshot(n, n2, chunk, chunk.getWorld());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean processChunkScan(Chunk chunk, int n, int n2, LocalChunkSnapshot localChunkSnapshot, Vector vector, SeasonType seasonType) {
        CustomChunkData.BlockData blockData = localChunkSnapshot.getChunkSnapshot().getBlockData(vector.getBlockX(), vector.getBlockZ());
        if (!this.shouldAddToLocGen(blockData.getMaterial(), blockData.getMaterialAbove(), blockData.getBiome(), seasonType)) {
            return true;
        }
        Location location = new Location(chunk.getWorld(), (double)(n * 16 + vector.getBlockX()), (double)blockData.getHighestY(), (double)(n2 * 16 + vector.getBlockZ()));
        this.locationQueue.computeIfAbsent(chunk.getWorld().getName(), string -> new ArrayDeque()).add(new Pair<Location, SeasonType>(location, seasonType));
        return false;
    }

    private boolean shouldAddToLocGen(Material material, Material material2, Biome biome, SeasonType seasonType) {
        switch (seasonType) {
            case WINTER: {
                if (BiomeUtils.getNoSnowBiomes().contains((Object)biome) || BiomeUtils.getSnowyBiomes().contains((Object)biome.name())) {
                    return false;
                }
                if (material.equals((Object)Material.WATER)) {
                    return true;
                }
                if (material2.equals((Object)Material.SNOW)) {
                    return false;
                }
                if (!this.isAllowedOnTop(material.name())) {
                    return false;
                }
                return this.isMaterialCorrect(material);
            }
        }
        if (BiomeUtils.getNoSnowBiomes().contains((Object)biome) || BiomeUtils.getSnowyBiomes().contains((Object)biome.name())) {
            return false;
        }
        if (material.equals((Object)Material.ICE)) {
            return true;
        }
        return true;
    }

    private Pair<Material, Block> handleBlock(Block block, Block block2, SeasonType seasonType) {
        if (this.checkProtection && Core.getProtectionHandler().isProtected(block2.getLocation())) {
            return null;
        }
        switch (seasonType) {
            case WINTER: {
                if (block.getLightFromBlocks() >= 12) {
                    return null;
                }
                if (block.getType().equals((Object)Material.WATER)) {
                    if (HooksHandler.isEnabled(HookPlugin.RESIDENCE) && ((ResidenceHook)HooksHandler.getHook(HookPlugin.RESIDENCE)).isProtected(block.getLocation())) {
                        return null;
                    }
                    if (Core.getBiomesHandler().isFrozen(block.getBiome(), seasonType) && ((Levelled)block.getBlockData()).getLevel() == 0) {
                        return new Pair<Material, Block>(Material.ICE, block);
                    }
                }
                if (block.getType().isTransparent() || block.isLiquid()) {
                    return null;
                }
                if (!this.isCube(block)) {
                    return null;
                }
                if (!this.isMaterialCorrect(block.getType())) {
                    return null;
                }
                if (!block2.getType().equals((Object)Material.AIR) && !ASManager.isVegetation(block2.getType())) {
                    return null;
                }
                return new Pair<Material, Block>(Material.SNOW, block2);
            }
        }
        Biome biome = block.getBiome();
        if (BiomeUtils.getNoSnowBiomes().contains((Object)biome) || BiomeUtils.getSnowyBiomes().contains((Object)biome.name())) {
            return null;
        }
        if (block.getType().equals((Object)Material.ICE)) {
            return new Pair<Material, Block>(Material.WATER, block);
        }
        if (block2.getType().equals((Object)Material.SNOW)) {
            if (!block.getType().equals((Object)Material.GRASS_BLOCK)) {
                return new Pair<Material, Block>(Material.AIR, block2);
            }
            Material material = GrassPatternsUtil.process(block2);
            if (material == null) {
                return null;
            }
            return new Pair<Material, Block>(material, block2);
        }
        return null;
    }

    private boolean isCube(Block block) {
        VoxelShape voxelShape = block.getCollisionShape();
        BoundingBox boundingBox = block.getBoundingBox();
        return voxelShape.getBoundingBoxes().size() == 1 && boundingBox.getWidthX() == 1.0 && boundingBox.getHeight() == 1.0 && boundingBox.getWidthZ() == 1.0;
    }

    private boolean isAllowedOnTop(String string) {
        for (String string2 : this.materialBlacklist) {
            if (!string.contains(string2)) continue;
            return false;
        }
        return true;
    }

    private boolean isMaterialCorrect(Material material) {
        if (!material.isSolid()) {
            return false;
        }
        if (material.isTransparent()) {
            return false;
        }
        return !material.equals((Object)Material.SNOW);
    }

    public void resetLocations(String string2) {
        this.locationQueue.computeIfAbsent(string2, string -> new ArrayDeque()).removeIf(pair -> ((Location)pair.getKey()).getWorld().getName().equals(string2));
        this.cleanupOldSnapshots();
    }

    private Chunk getChunk(Chunk chunk, int n, int n2) {
        if (MinecraftVersion.isPaper()) {
            try {
                return (Chunk)chunk.getWorld().getChunkAtAsync(n, n2).get();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return chunk.getWorld().getChunkAt(n, n2);
    }

    private void cleanupOldSnapshots() {
        Iterator<Map.Entry<String, LocalChunkSnapshot>> iterator = this.snapshotCache.entrySet().iterator();
        ASManager.debug("chunk size: " + this.snapshotCache.size() + " ");
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Map.Entry<String, LocalChunkSnapshot> entry = iterator.next();
            LocalChunkSnapshot localChunkSnapshot = entry.getValue();
            if (l - localChunkSnapshot.getLastGet() <= 2000L) continue;
            iterator.remove();
        }
    }

    public void stopTasks() {
        Bukkit.getServer().getScheduler().cancelTask(this.locationScanner.getTaskId());
        Bukkit.getServer().getScheduler().cancelTask(this.snowGenerator.getTaskId());
    }

    public static NamespacedKey getKEY_CHUNK_STAGE() {
        return KEY_CHUNK_STAGE;
    }

    public static NamespacedKey getKEY_CHUNK_STAGE_SEASON() {
        return KEY_CHUNK_STAGE_SEASON;
    }
}

