/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons.temperature;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.DataHandler;
import net.advancedplugins.as.impl.utils.text.Text;
import net.advancedplugins.seasons.Core;
import net.advancedplugins.seasons.biomes.AdvancedBiomeBase;
import net.advancedplugins.seasons.enums.SeasonType;
import net.advancedplugins.seasons.enums.TemperatureEvent;
import net.advancedplugins.seasons.objects.CustomWeatherType;
import net.advancedplugins.seasons.temperature.PlayerTemperature;
import net.advancedplugins.seasons.temperature.TemperatureAbilitiesHandler;
import net.advancedplugins.seasons.temperature.TemperatureEventTrigger;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TemperatureHandler
extends DataHandler {
    private final int baseTemperature;
    private final String formula;
    private final String actionbar;
    private final ImmutableMap<SeasonType, Integer> seasonTemperature;
    private final ImmutableList<String> biomesWithoutWinter;
    private int noWinterBiomeTemperature = 0;
    private int breathVisibility = 0;
    private final TreeMap<Integer, TemperatureEvent> temperatureEvents = new TreeMap();
    private final ConcurrentHashMap<UUID, PlayerTemperature> playerTemperatureMap = new ConcurrentHashMap();
    private final boolean temperatureEventsEnabled;
    private static ImmutableMap<CustomWeatherType, String> weatherIcon;
    private final boolean temperatureActionbar;
    private final boolean temperatureEventsActionbar;
    private final TemperatureAbilitiesHandler abilities = new TemperatureAbilitiesHandler(this);
    private HashMap<UUID, Integer> temp = new HashMap();

    public TemperatureHandler(JavaPlugin javaPlugin) {
        super("temperature", javaPlugin);
        this.temperatureActionbar = javaPlugin.getConfig().getBoolean("temperatureActionbar", true);
        this.temperatureEventsActionbar = javaPlugin.getConfig().getBoolean("temperatureEventsActionbar", true);
        this.baseTemperature = this.getInt("base");
        this.formula = this.getString("temperatureFormula");
        this.actionbar = Core.getLocaleHandler().getString("temperature.actionBar");
        this.biomesWithoutWinter = ImmutableList.builder().addAll(this.getStringList("noWinterBiomes")).build();
        this.temperatureEventsEnabled = this.getBoolean("temperatureEventsEnabled");
        weatherIcon = ASManager.configToImmutableMap(Core.getLocaleHandler().getFile().getLocaleConfig(), "temperature.icon", CustomWeatherType::valueOf, String.class);
        this.seasonTemperature = ASManager.configToImmutableMap(this.getConfig(), "temperature", SeasonType::valueOf, Integer.class);
        this.noWinterBiomeTemperature = ((Integer)this.seasonTemperature.get((Object)SeasonType.FALL) + (Integer)this.seasonTemperature.get((Object)SeasonType.SPRING)) / 2;
        this.loadTemperatureEvents(javaPlugin);
        this.startTemperatureDisplay(javaPlugin);
    }

    @Override
    public void unload() {
        for (int n : this.getActiveTasks()) {
            Bukkit.getServer().getScheduler().cancelTask(n);
        }
    }

    private void startTemperatureDisplay(JavaPlugin javaPlugin) {
        this.addTask(new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!Core.getWorldHandler().isWorldEnabled(player.getWorld().getName())) continue;
                    PlayerTemperature playerTemperature = TemperatureHandler.this.playerTemperatureMap.computeIfAbsent(player.getUniqueId(), uUID -> new PlayerTemperature());
                    playerTemperature.realTemperature = TemperatureHandler.this.getPlayerTemperature(player);
                    if (playerTemperature.init) continue;
                    playerTemperature.init = true;
                    playerTemperature.displayTemperature = playerTemperature.realTemperature;
                }
            }
        }.runTaskTimerAsynchronously((Plugin)javaPlugin, 35L, 35L).getTaskId());
        this.addTask(new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!Core.getWorldHandler().isWorldEnabled(player.getWorld().getName())) continue;
                    PlayerTemperature playerTemperature = TemperatureHandler.this.playerTemperatureMap.computeIfAbsent(player.getUniqueId(), uUID -> new PlayerTemperature());
                    if (!playerTemperature.init || System.currentTimeMillis() - playerTemperature.lastShow < 2500L) continue;
                    if (playerTemperature.displayTemperature < playerTemperature.realTemperature) {
                        ++playerTemperature.displayTemperature;
                    } else if (playerTemperature.displayTemperature > playerTemperature.realTemperature) {
                        --playerTemperature.displayTemperature;
                    }
                    if (!TemperatureHandler.this.temperatureActionbar) continue;
                    ASManager.sendActionBar(Text.parsePapi(TemperatureHandler.this.parseTemperatureDisplay(playerTemperature.getDisplayTemperature(), TemperatureHandler.this.actionbar, player.getWorld().getName()), (OfflinePlayer)player), player);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)javaPlugin, 10L, 10L).getTaskId());
        this.addTask(Bukkit.getScheduler().runTaskTimer((Plugin)javaPlugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                PlayerTemperature playerTemperature;
                if (!Core.getWorldHandler().isWorldEnabled(player.getWorld().getName()) || (playerTemperature = this.playerTemperatureMap.get(player.getUniqueId())) == null) continue;
                TemperatureEvent temperatureEvent = this.handlePlayerTemperature(player, playerTemperature.getDisplayTemperature());
                if (temperatureEvent != null) {
                    if (temperatureEvent.equals((Object)playerTemperature.lastEvent)) continue;
                    playerTemperature.lastShow = System.currentTimeMillis();
                    playerTemperature.lastEvent = temperatureEvent;
                    if (!this.temperatureEventsActionbar || temperatureEvent.equals((Object)TemperatureEvent.BREATH_VISIBILITY)) continue;
                    ASManager.sendActionBar(Text.parsePapi(Core.getLocaleHandler().getString("temperature.eventMessage").replace("%event%", Core.getLocaleHandler().getString("temperature.events." + temperatureEvent.name().toLowerCase())), (OfflinePlayer)player), player);
                    continue;
                }
                if (temperatureEvent != null || playerTemperature.lastEvent == null) continue;
                playerTemperature.lastEvent = null;
            }
        }, 20L, 20L).getTaskId());
    }

    public String parseTemperatureDisplay(int n, String string, String string2) {
        string = string.replace("%icon%", Text.modify((String)weatherIcon.get((Object)Core.getWeatherHandler().getWeather(string2)))).replace("%season%", Core.getLocaleHandler().getString("seasons." + Core.getSeasonHandler().getSeason(string2).getType().name(), ""));
        if (Core.getInstance().getConfig().getBoolean("convertToFahrenheit")) {
            return string.replace("%temperature%", String.valueOf((int)((double)n * 1.8 + 32.0))).replace("%unit%", "F");
        }
        return string.replace("%temperature%", String.valueOf(n)).replace("%unit%", "C");
    }

    private void loadTemperatureEvents(JavaPlugin javaPlugin) {
        for (TemperatureEvent temperatureEvent : TemperatureEvent.values()) {
            int n = this.getInt("temperatureEvents." + temperatureEvent.name().toLowerCase(Locale.ROOT) + ".temperature");
            if (temperatureEvent.equals((Object)TemperatureEvent.BREATH_VISIBILITY)) {
                this.breathVisibility = n;
            }
            this.temperatureEvents.put(n, temperatureEvent);
        }
    }

    public int getPlayerTemperature(Player player) {
        Location location = player.getLocation();
        if (this.temp.containsKey(player.getUniqueId())) {
            return this.temp.get(player.getUniqueId());
        }
        Biome biome = location.getBlock().getBiome();
        SeasonType seasonType = Core.getSeasonHandler().getSeason(player.getWorld()).getType();
        AdvancedBiomeBase advancedBiomeBase = Core.getBiomesHandler().getBiome(biome);
        int n = advancedBiomeBase == null ? 0 : advancedBiomeBase.getTemperature();
        double d = location.getBlock().getLightFromBlocks();
        int n2 = this.getSeasonTemperature(seasonType, advancedBiomeBase);
        int n3 = (int)(d * (seasonType.equals((Object)SeasonType.SUMMER) ? 0.8 : Math.max(1.5, d / (double)(n2 < 0 ? 5 : 8))));
        int n4 = (int)Arrays.stream(player.getInventory().getArmorContents()).filter(Objects::nonNull).count();
        int n5 = TemperatureHandler.getConditional(player);
        int n6 = (int)ASManager.parseThroughCalculator(this.formula.replace("%base%", Integer.toString(this.baseTemperature)).replace("%biome%", Integer.toString(n)).replace("%seasonTemp%", Integer.toString(n2)).replace("%lightLevel%", Integer.toString(n3)).replace("%conditionalTemp%", Integer.toString(n5)).replace("%armorItemsCount%", Integer.toString(n4)));
        return n6;
    }

    public int getLocationTemperature(Location location) {
        Biome biome = location.getBlock().getBiome();
        SeasonType seasonType = Core.getSeasonHandler().getSeason(location.getWorld()).getType();
        AdvancedBiomeBase advancedBiomeBase = Core.getBiomesHandler().getBiome(biome);
        int n = advancedBiomeBase == null ? 0 : advancedBiomeBase.getTemperature();
        double d = location.getBlock().getLightFromBlocks();
        int n2 = this.getSeasonTemperature(seasonType, advancedBiomeBase);
        int n3 = (int)(d * (seasonType.equals((Object)SeasonType.SUMMER) ? 1.0 : Math.max(1.5, d / (double)(n2 < 0 ? 5 : 8))));
        int n4 = (int)ASManager.parseThroughCalculator(this.formula.replace("%base%", Integer.toString(this.baseTemperature)).replace("%biome%", Integer.toString(n)).replace("%seasonTemp%", Integer.toString(n2)).replace("%lightLevel%", Integer.toString(n3)).replace("%conditionalTemp%", "0").replace("%armorItemsCount%", "0"));
        return n4;
    }

    private int getSeasonTemperature(SeasonType seasonType, AdvancedBiomeBase advancedBiomeBase) {
        if (advancedBiomeBase == null) {
            return 0;
        }
        if (SeasonType.WINTER.equals((Object)seasonType) && this.biomesWithoutWinter.contains((Object)advancedBiomeBase.getName())) {
            return this.noWinterBiomeTemperature;
        }
        return (Integer)this.seasonTemperature.getOrDefault((Object)seasonType, (Object)0);
    }

    private static int getConditional(Player player) {
        int n = 0;
        boolean bl = ASManager.isDay(player.getWorld().getTime());
        if (bl) {
            n -= Math.abs(15 - player.getLocation().getBlock().getLightFromSky()) / 2;
        }
        if (player.isInWater()) {
            n -= 4;
        }
        if (!player.getWorld().isClearWeather()) {
            n -= 4;
        }
        if (!bl) {
            n -= 8;
        }
        return n;
    }

    private TemperatureEvent handlePlayerTemperature(Player player, int n) {
        TemperatureEvent temperatureEvent = this.getEventForTemperature(n);
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Core.getInstance().getConfig().getBoolean("creativeTemperatureEffects")) {
            return null;
        }
        if (!this.temperatureEventsEnabled) {
            return null;
        }
        if (temperatureEvent == null) {
            return null;
        }
        TemperatureEventTrigger.trigger(player);
        return temperatureEvent;
    }

    public TemperatureEvent getEventForTemperature(int n) {
        TemperatureEvent temperatureEvent = null;
        if (n < 0) {
            for (Map.Entry<Integer, TemperatureEvent> entry : this.temperatureEvents.entrySet()) {
                if (entry.getKey() >= 0 || n > entry.getKey()) continue;
                temperatureEvent = entry.getValue();
                break;
            }
        } else if (n > 0) {
            for (Map.Entry<Integer, TemperatureEvent> entry : this.temperatureEvents.entrySet()) {
                if (entry.getKey() <= 0 || n < entry.getKey()) continue;
                temperatureEvent = entry.getValue();
            }
        } else {
            temperatureEvent = this.temperatureEvents.get(0);
        }
        return temperatureEvent;
    }

    public void setTemperature(Player player, int n) {
        if (n == 0) {
            this.temp.remove(player.getUniqueId());
        } else {
            this.temp.put(player.getUniqueId(), n);
        }
    }

    public int getBreathVisibility() {
        return this.breathVisibility;
    }

    public ConcurrentHashMap<UUID, PlayerTemperature> getPlayerTemperatureMap() {
        return this.playerTemperatureMap;
    }

    public TemperatureAbilitiesHandler getAbilities() {
        return this.abilities;
    }
}

