/*
 * Decompiled with CFR 0.152.
 */
package gcspawners;

import gcspawners.ConfigValue;
import gcspawners.CreatorMenu;
import gcspawners.RandomSpawnDenyCause;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class RandomSpawnHandler {
    private List<UUID> a = new ArrayList<UUID>();
    private List<String> e;
    private int f = 0;
    private Long d;
    private Long c;
    public static int b;

    public RandomSpawnHandler() {
        int n = b;
        this.d = System.currentTimeMillis();
        this.c = System.currentTimeMillis();
        this.e = ConfigValue.RANDOM_ALLOWED_MOBS.getStringList();
        if (n != 0) {
            CreatorMenu.b = !CreatorMenu.b;
        }
    }

    public void addMob(UUID uUID) {
        this.a.add(uUID);
        this.d = System.currentTimeMillis();
        int n = b;
        ++this.f;
        if (CreatorMenu.b) {
            b = ++n;
        }
    }

    public String getRandomMob() {
        return this.e.get(ThreadLocalRandom.current().nextInt(this.e.size()));
    }

    public boolean canSpawnCustom() {
        return this.a.size() < ConfigValue.RANDOM_LIMIT.getInt();
    }

    public RandomSpawnDenyCause canSpawnAtLocation(Location location) {
        if (location.getBlock().getLightFromSky() == 0) {
            return RandomSpawnDenyCause.NO_LIGHT;
        }
        if (System.currentTimeMillis() - this.c < 100L) {
            return RandomSpawnDenyCause.ATTEMPT_DELAY;
        }
        this.c = System.currentTimeMillis();
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return RandomSpawnDenyCause.NO_PLAYERS;
        }
        if (System.currentTimeMillis() - this.d < 1000L) {
            return RandomSpawnDenyCause.SPAWN_DELAY;
        }
        if (!this.canSpawnCustom()) {
            return RandomSpawnDenyCause.LIMIT_REACHED;
        }
        if (ConfigValue.RANDOM_WORLD_LIST.getStringList().stream().noneMatch(string -> string.equalsIgnoreCase(location.getWorld().getName()))) {
            return RandomSpawnDenyCause.INVALID_WORLD;
        }
        int n = ConfigValue.RANDOM_PLAYER_RADIUS.getInt();
        if (Bukkit.getOnlinePlayers().stream().noneMatch(player -> player.getWorld().equals(location.getWorld()) && player.getLocation().distance(location) <= (double)n)) {
            return RandomSpawnDenyCause.NO_CLOSE_PLAYER;
        }
        if (location.getY() > (double)(location.getWorld().getHighestBlockAt(location).getY() + 3)) {
            return RandomSpawnDenyCause.TOO_HIGH;
        }
        return null;
    }

    public void removeMob(UUID uUID) {
        this.a.remove(uUID);
    }

    public int getCount() {
        return this.a.size();
    }

    public int getTotal() {
        return this.f;
    }
}

