/*
 * Decompiled with CFR 0.152.
 */
package gcspawners.b;

import gcspawners.d.MinecraftVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private ItemStack a;
    private ItemMeta b;
    public static boolean c;

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder(ItemStack itemStack) {
        this.a = itemStack;
        this.b = itemStack.getItemMeta();
    }

    public ItemBuilder(Material material, int n) {
        this.a = new ItemStack(material, n);
        this.b = this.a.getItemMeta();
    }

    public ItemBuilder(Material material, int n, byte by) {
        this.a = new ItemStack(material, n, (short)by);
        this.b = this.a.getItemMeta();
    }

    public ItemBuilder setDurability(short s) {
        this.a.setDurability(s);
        return this;
    }

    public ItemBuilder setName(String string) {
        this.b.setDisplayName(string);
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment enchantment, int n) {
        this.b.addEnchant(enchantment, n, true);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.a.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder setSkullOwner(String string) {
        try {
            SkullMeta skullMeta = (SkullMeta)this.b;
            skullMeta.setOwner(string);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int n) {
        this.b.addEnchant(enchantment, n, true);
        return this;
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> map) {
        this.a.addEnchantments(map);
        return this;
    }

    public ItemBuilder setInfinityDurability() {
        this.a.setDurability((short)Short.MAX_VALUE);
        return this;
    }

    public ItemBuilder setLore(String ... stringArray) {
        this.b.setLore(Arrays.asList(stringArray));
        return this;
    }

    public ItemBuilder setLore(List<String> list) {
        this.b.setLore(list);
        this.a.setItemMeta(this.b);
        return this;
    }

    public ItemBuilder removeLoreLine(String string) {
        ArrayList arrayList = new ArrayList(this.b.getLore());
        if (!arrayList.contains(string)) {
            return this;
        }
        arrayList.remove(string);
        this.b.setLore(arrayList);
        return this;
    }

    public ItemBuilder removeLoreLine(int n) {
        ArrayList arrayList;
        block4: {
            arrayList = new ArrayList(this.b.getLore());
            if (n >= 0 && n <= arrayList.size()) break block4;
            return this;
        }
        arrayList.remove(n);
        this.b.setLore(arrayList);
        return this;
    }

    public ItemBuilder addLoreLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.b.hasLore()) {
            arrayList = new ArrayList(this.b.getLore());
        }
        arrayList.add(string);
        this.b.setLore(arrayList);
        return this;
    }

    public ItemBuilder addLoreLine(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>(this.b.getLore());
        arrayList.set(n, string);
        this.b.setLore(arrayList);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemBuilder setColor(Color color) {
        block6: {
            LeatherArmorMeta leatherArmorMeta;
            block5: {
                boolean bl = c;
                if (!(this.b instanceof LeatherArmorMeta)) break block5;
                leatherArmorMeta = (LeatherArmorMeta)this.b;
                leatherArmorMeta.setColor(color);
                if (!bl) break block6;
            }
            if (this.b instanceof FireworkEffectMeta) {
                leatherArmorMeta = (FireworkEffectMeta)this.b;
                leatherArmorMeta.setEffect(FireworkEffect.builder().withColor(color).build());
            }
        }
        return this;
    }

    public ItemBuilder setItemFlags(ItemFlag ... itemFlagArray) {
        this.b.addItemFlags(itemFlagArray);
        return this;
    }

    public ItemBuilder addAttribute(Attribute attribute, AttributeModifier attributeModifier) {
        this.b.addAttributeModifier(attribute, attributeModifier);
        return this;
    }

    public ItemBuilder setAmount(int n) {
        this.a.setAmount(n);
        return this;
    }

    public ItemBuilder addItemFlag(ItemFlag itemFlag) {
        this.b.addItemFlags(new ItemFlag[]{itemFlag});
        return this;
    }

    public ItemBuilder setCustomModelData(Integer n) {
        if (MinecraftVersion.getVersionNumber() >= 1140) {
            this.b.setCustomModelData(n);
        }
        return this;
    }

    public ItemMeta getItemMeta() {
        return this.b;
    }

    public ItemStack toItemStack() {
        this.a.setItemMeta(this.b);
        return this.a;
    }
}

