/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.advancedplugins.at.Core;
import net.advancedplugins.at.editor.gui.EditorEditItem;
import net.advancedplugins.at.editor.gui.EditorEditTrade;
import net.advancedplugins.at.editor.gui.EditorMainMenu;
import net.advancedplugins.at.editor.state.EditorState;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TradeEditorHandler {
    private final HashMap<UUID, EditorState> editorsMap = new HashMap();
    private final EditorMainMenu editorMainMenu;
    private final EditorEditTrade editorEditTrade;
    private final EditorEditItem editorEditItem;
    private static TradeEditorHandler handler;

    public TradeEditorHandler() {
        Core core = Core.getInstance();
        handler = this;
        this.editorMainMenu = new EditorMainMenu(core);
        this.editorEditTrade = new EditorEditTrade(core);
        this.editorEditItem = new EditorEditItem(core);
        new BukkitRunnable(){

            public void run() {
                for (Map.Entry entry : TradeEditorHandler.this.editorsMap.entrySet()) {
                    Player player = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
                    if (player == null || !player.isOnline()) continue;
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(EditorMainMenu.color("&cPress &lF&c to continue editing your Advanced Trade")));
                }
            }
        }.runTaskTimer((Plugin)core, 20L, 20L);
    }

    public static TradeEditorHandler getHandler() {
        return handler;
    }

    public EditorEditTrade getEditorEditTrade() {
        return this.editorEditTrade;
    }

    public EditorMainMenu getEditorMainMenu() {
        return this.editorMainMenu;
    }

    public EditorState startEditor(UUID uUID) {
        if (this.isEditing(uUID)) {
            this.endEditor(uUID);
        }
        EditorState editorState = new EditorState(uUID);
        editorState.open();
        this.editorsMap.put(uUID, editorState);
        return editorState;
    }

    private boolean isEditing(UUID uUID) {
        return this.editorsMap.containsKey(uUID);
    }

    public void endEditor(UUID uUID) {
        this.editorsMap.get(uUID).close();
        this.editorsMap.remove(uUID);
    }

    public EditorState getState(UUID uUID) {
        return this.editorsMap.get(uUID);
    }
}

