/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.editor.state;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.advancedplugins.at.Core;
import net.advancedplugins.at.editor.gui.EditorEditTrade;
import net.advancedplugins.at.editor.gui.EditorMainMenu;
import net.advancedplugins.at.editor.requests.ChatInputRequest;
import net.advancedplugins.at.editor.requests.ChatInputType;
import net.advancedplugins.at.editor.state.EditorMenu;
import net.advancedplugins.at.handlers.TradesHandler;
import net.advancedplugins.at.settings.TradeSetting;
import net.advancedplugins.at.trading.AdvancedTrade;
import net.advancedplugins.utils.nbt.backend.NBTItem;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class EditorState {
    private final UUID editor;
    private final Optional<Player> playerInstance;
    private TradeSetting tradeSetting;
    private String trade;
    private ChatInputRequest chatRequest = null;

    public EditorState(UUID uUID) {
        this.editor = uUID;
        this.playerInstance = Optional.ofNullable(Bukkit.getPlayer((UUID)uUID));
        this.tradeSetting = TradeSetting.NONE;
    }

    public void open() {
        EditorMainMenu.open(this.playerInstance.orElse(null));
    }

    public Player getPlayer() {
        return this.playerInstance.orElse(null);
    }

    public String getTrade() {
        return this.trade;
    }

    public void setTrade(String string) {
        this.trade = string;
        if (this.trade != null) {
            EditorEditTrade.open(this.playerInstance.get());
        }
    }

    public void addChatRequest(ChatInputRequest chatInputRequest) {
        this.chatRequest = chatInputRequest;
        chatInputRequest.init();
    }

    public void setTradeSetting(TradeSetting tradeSetting) {
        this.tradeSetting = tradeSetting;
    }

    public TradeSetting getTradeSetting() {
        return this.tradeSetting;
    }

    public void close() {
        this.playerInstance.get().closeInventory();
        this.saveChanges();
    }

    private void saveChanges() {
    }

    public AdvancedTrade getTradeInstance() {
        return Core.getTradesHandler().getAdvancedTrade(this.trade);
    }

    public boolean hasChatRequest() {
        return this.chatRequest != null;
    }

    public void fulfillChatRequest(String string) {
        ChatInputType chatInputType = this.chatRequest.getType();
        TradeSetting tradeSetting = this.getTradeSetting();
        if (string.equalsIgnoreCase("cancel")) {
            this.getPlayer().sendMessage(EditorMenu.color("&cCancelled chat input."));
            Bukkit.getScheduler().runTask((Plugin)Core.getInstance(), this::open);
            return;
        }
        if (chatInputType == ChatInputType.RENAME_TRADE) {
            if (this.getTradeInstance() == null) {
                // empty if block
            }
            this.getPlayer().sendMessage(EditorMenu.color("&a&l!() &aSuccessfully set your trade name to &f" + string + ""));
            this.setTrade(string);
            return;
        }
        if (tradeSetting == null) {
            return;
        }
        this.chatRequest = null;
        String string2 = tradeSetting.getInstanceOf();
        List<String> list = null;
        if (string2.equalsIgnoreCase("int")) {
            try {
                list = Integer.parseInt(string);
            }
            catch (Exception exception) {}
        } else if (string2.equalsIgnoreCase("boolean")) {
            try {
                list = Boolean.parseBoolean(string);
            }
            catch (Exception exception) {}
        } else if (string2.equalsIgnoreCase("list")) {
            if (string.startsWith("[") && string.endsWith("]")) {
                list = Arrays.asList(string.substring(1, string.length() - 1).split(", "));
            }
        } else if (string2.equalsIgnoreCase("string")) {
            list = string;
        }
        if (list == null) {
            this.getPlayer().sendMessage(EditorMenu.color("&c&l(!) &cInvalid input provided. Expected &n" + string2 + "&c, received &n" + string));
            return;
        }
        Core.getTradesHandler().getTradesConfig().set("trades." + this.trade + "." + tradeSetting.getPath(), (Object)list);
        Core.getTradesHandler().saveTradesConfig();
        Core.getInstance().init();
        Bukkit.getScheduler().runTask((Plugin)Core.getInstance(), () -> EditorEditTrade.open(this.getPlayer()));
        this.getPlayer().sendMessage(EditorMenu.color("&a&l(!) &aSuccessfully changed &n" + tradeSetting.getName() + "&7 (" + this.trade + "&7) &avalue to &f" + string));
    }

    public void setItems(ItemStack ... itemStackArray) {
        if (itemStackArray.length == 0 || itemStackArray[0] == null) {
            this.getPlayer().sendMessage(EditorMenu.color("&c&l(!) &cInvalid items provided."));
            return;
        }
        if (this.getTradeSetting() == TradeSetting.TRADE_RESULT) {
            Core.getTradesHandler().getTradesConfig().set(this.getTradeSetting().getPath() + ".item", null);
            this.convertItemToConfigItem(itemStackArray[0], this.getTradeSetting().getPath() + ".item");
        } else if (this.getTradeSetting() == TradeSetting.TRADE_INGREDIENTS) {
            Core.getTradesHandler().getTradesConfig().set(this.getTradeSetting().getPath() + ".1", null);
            this.convertItemToConfigItem(itemStackArray[0], this.getTradeSetting().getPath() + ".1");
            if (itemStackArray.length > 1) {
                Core.getTradesHandler().getTradesConfig().set(this.getTradeSetting().getPath() + ".2", null);
                this.convertItemToConfigItem(itemStackArray[1], this.getTradeSetting().getPath() + ".2");
            }
        }
        Core.getInstance().init();
        Bukkit.getScheduler().runTask((Plugin)Core.getInstance(), () -> EditorEditTrade.open(this.getPlayer()));
        this.getPlayer().sendMessage(EditorMenu.color("&a&l(!) &aSuccessfully changed &n" + this.getTradeSetting().getName() + "&7 (" + this.trade + "&7) &avalue"));
    }

    private void convertItemToConfigItem(ItemStack itemStack, String string) {
        ItemMeta itemMeta;
        TradesHandler tradesHandler = Core.getTradesHandler();
        string = "trades." + this.trade + "." + string;
        tradesHandler.getTradesConfig().set(string, null);
        tradesHandler.setInConfig(string + ".type", itemStack.getType().name());
        tradesHandler.setInConfig(string + ".amount", itemStack.getAmount());
        if (itemStack.hasItemMeta()) {
            itemMeta = itemStack.getItemMeta();
            tradesHandler.setInConfig(string + ".name", itemMeta.getDisplayName());
            tradesHandler.setInConfig(string + ".lore", itemMeta.getLore());
            if (!itemMeta.getEnchants().isEmpty()) {
                tradesHandler.setInConfig(string + ".enchantments", itemMeta.getEnchants().entrySet().stream().map(entry -> ((Enchantment)entry.getKey()).getName() + ":" + entry.getValue()).collect(Collectors.toList()));
            }
            if (!itemMeta.getItemFlags().isEmpty()) {
                tradesHandler.setInConfig(string + ".item-flags", itemMeta.getItemFlags().stream().map(itemFlag -> itemFlag.name()).collect(Collectors.toList()));
            }
            if (itemMeta.hasCustomModelData()) {
                tradesHandler.setInConfig(string + ".custom-model-data", itemMeta.getCustomModelData());
            }
        }
        if (itemStack.hasItemMeta()) {
            itemMeta = itemStack.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(0));
            itemMeta.setLore(null);
            itemMeta.setDisplayName(null);
            itemMeta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)itemMeta).removeEnchant(arg_0));
            itemMeta.getItemFlags().forEach(itemFlag -> itemMeta.removeItemFlags(new ItemFlag[]{itemFlag}));
            itemStack.setItemMeta(itemMeta);
            NBTItem nBTItem = new NBTItem(itemStack);
            String string2 = nBTItem.asNBTString();
            if (!(string2 == null || string2.isEmpty() || string2.equalsIgnoreCase("{}") || string2.equalsIgnoreCase("{CustomModelData:0}") || string2.equalsIgnoreCase("{CustomModelData:0,Damage:0}"))) {
                tradesHandler.setInConfig(string + ".nbt", string2);
            }
        }
        tradesHandler.saveTradesConfig();
    }
}

