/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.handlers;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.advancedplugins.at.handlers.TradesFile;
import net.advancedplugins.at.trading.AdvancedTrade;
import net.advancedplugins.at.trading.options.TradeResult;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class TradesHandler {
    private ImmutableMap<String, AdvancedTrade> tradeMap;
    private final TradesFile tradesFile;

    public TradesHandler(JavaPlugin javaPlugin) {
        this.tradesFile = new TradesFile(javaPlugin);
        this.loadTrades(javaPlugin);
    }

    private void loadTrades(JavaPlugin javaPlugin) {
        HashMap<String, AdvancedTrade> hashMap = new HashMap<String, AdvancedTrade>();
        for (String string : this.tradesFile.getConfig().getConfigurationSection("trades").getKeys(false)) {
            AdvancedTrade advancedTrade;
            try {
                advancedTrade = new AdvancedTrade(javaPlugin, string, (ConfigurationSection)this.tradesFile.getConfig());
            }
            catch (Exception exception) {
                javaPlugin.getLogger().warning("Failed to load trade " + string + "! Check if there are any configuration issues first.");
                exception.printStackTrace();
                continue;
            }
            hashMap.put(string, advancedTrade);
        }
        this.tradeMap = ImmutableMap.copyOf(hashMap);
        javaPlugin.getLogger().info("Successfully loaded " + this.tradeMap.size() + " custom trades.");
    }

    public FileConfiguration getTradesConfig() {
        return this.tradesFile.getConfig();
    }

    public boolean setInConfig(String string, Object object) {
        if (object != null) {
            this.tradesFile.getConfig().set(string, object);
            return true;
        }
        return false;
    }

    public void saveTradesConfig() {
        this.tradesFile.saveFile();
    }

    public AdvancedTrade getRandomTrade() {
        return this.getRandomTrade((Collection<AdvancedTrade>)this.tradeMap.values());
    }

    public AdvancedTrade getRandomTrade(Collection<AdvancedTrade> collection) {
        double d = ThreadLocalRandom.current().nextDouble() * 100.0;
        ArrayList<AdvancedTrade> arrayList = new ArrayList<AdvancedTrade>(collection);
        Collections.shuffle(arrayList);
        return arrayList.stream().filter(advancedTrade -> advancedTrade.getTradeSettings().getChance() >= d).findAny().orElse(null);
    }

    public ImmutableCollection<AdvancedTrade> getTrades() {
        return this.tradeMap.values();
    }

    public TradeResult getTrade(String string) {
        return ((AdvancedTrade)this.tradeMap.get((Object)string)).getTradeResult();
    }

    public AdvancedTrade getAdvancedTrade(String string) {
        return (AdvancedTrade)this.tradeMap.get((Object)string);
    }
}

