/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.listeners;

import java.util.List;
import net.advancedplugins.at.Core;
import net.advancedplugins.at.trading.AdvancedTrade;
import net.advancedplugins.utils.nbt.NBTapi;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.MerchantRecipe;

public class VillagerOpenEvent
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onOpen(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        Entity entity = playerInteractAtEntityEvent.getRightClicked();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        this.updateTrades(villager);
    }

    private void updateTrades(Villager villager) {
        if (villager.getRecipeCount() == 0) {
            return;
        }
        List list = villager.getRecipes();
        for (int i = 0; i < list.size(); ++i) {
            AdvancedTrade advancedTrade;
            MerchantRecipe merchantRecipe = (MerchantRecipe)list.get(i);
            String string = this.getTradeName(merchantRecipe);
            if (string == null || (advancedTrade = Core.getTradesHandler().getAdvancedTrade(string)) == null) continue;
            villager.setRecipe(i, this.updateRecipe(merchantRecipe, advancedTrade));
        }
    }

    private String getTradeName(MerchantRecipe merchantRecipe) {
        return NBTapi.get("tradeIdentifier", merchantRecipe.getResult());
    }

    private MerchantRecipe updateRecipe(MerchantRecipe merchantRecipe, AdvancedTrade advancedTrade) {
        MerchantRecipe merchantRecipe2 = new MerchantRecipe(advancedTrade.getTradeResult().getConfigItem(), merchantRecipe.getUses(), advancedTrade.getTradeSettings().getMaxTradeUses().intValue(), true, advancedTrade.getTradeResult().getVillagerExperience(), merchantRecipe.getPriceMultiplier());
        advancedTrade.getTradeIngredients().getItems().forEach(arg_0 -> ((MerchantRecipe)merchantRecipe2).addIngredient(arg_0));
        return merchantRecipe2;
    }
}

