/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.trading;

import net.advancedplugins.at.settings.TradeSetting;
import net.advancedplugins.at.trading.options.TradeIngredients;
import net.advancedplugins.at.trading.options.TradeResult;
import net.advancedplugins.at.trading.options.TradeSettings;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.java.JavaPlugin;

public class AdvancedTrade {
    private String tradeName;
    private final TradeSettings tradeSettings;
    private final TradeIngredients tradeIngredients;
    private final TradeResult tradeResult;

    public AdvancedTrade(JavaPlugin javaPlugin, String string, ConfigurationSection configurationSection) {
        this.tradeName = string;
        this.tradeSettings = new TradeSettings(configurationSection.getConfigurationSection("trades." + string + ".tradeSettings"));
        this.tradeIngredients = new TradeIngredients(string, configurationSection.getConfigurationSection("trades." + string + ".tradeIngredients"));
        this.tradeResult = new TradeResult(string, configurationSection.getConfigurationSection("trades." + string + ".tradeResult"));
    }

    public String getTradeName() {
        return this.tradeName;
    }

    public TradeIngredients getTradeIngredients() {
        return this.tradeIngredients;
    }

    public TradeResult getTradeResult() {
        return this.tradeResult;
    }

    public TradeSettings getTradeSettings() {
        return this.tradeSettings;
    }

    public Object getSetting(TradeSetting tradeSetting) {
        switch (tradeSetting) {
            case CHANCE: {
                return this.getTradeSettings().getChance();
            }
            case REQUIRED_VILLAGER_LEVEL: {
                return this.getTradeSettings().getRequiredVillagerLevel();
            }
            case REQUIRED_PROFESSION: {
                return this.getTradeSettings().getRequiredProfession();
            }
            case REQUIRED_BIOME: {
                return this.getTradeSettings().getRequiredBiome();
            }
            case MAX_TRADE_USES: {
                return this.getTradeSettings().getMaxTradeUses();
            }
            case EXPERIENCE: {
                return this.getTradeResult().getVillagerExperience();
            }
            case TRADE_RESULT: {
                return this.getTradeResult().getConfigItem().getType().name();
            }
            case TRADE_INGREDIENTS: {
                return this.getTradeIngredients().getContents();
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    public void setName(String string) {
        this.tradeName = string;
    }
}

