/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.trading.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.advancedplugins.at.utils.AManager;
import org.bukkit.configuration.ConfigurationSection;

public class TradeSettings {
    private final double chance;
    private final Integer requiredVillagerLevel;
    private final Integer maxTradeUses;
    private final ImmutableList<String> requiredProfession;
    private final ImmutableList<String> requiredBiome;
    private final ImmutableList<String> excludedWorlds;

    public TradeSettings(ConfigurationSection configurationSection) {
        this.chance = configurationSection.getInt("chance");
        this.requiredVillagerLevel = AManager.parseInt(configurationSection.get("requiredVillagerLevel").toString(), 0);
        this.maxTradeUses = AManager.parseInt(configurationSection.get("maxTradeUses").toString(), 128);
        this.requiredProfession = ImmutableList.copyOf((Collection)this.isListSetToNone(configurationSection.getStringList("requiredProfession")).stream().map(String::toLowerCase).collect(Collectors.toList())).asList();
        this.requiredBiome = ImmutableList.copyOf(this.isListSetToNone(configurationSection.getStringList("requiredBiome").stream().map(String::toLowerCase).collect(Collectors.toList()))).asList();
        this.excludedWorlds = ImmutableList.copyOf((Collection)this.isListSetToNone(configurationSection.getStringList("excludedWorlds")).stream().map(String::toLowerCase).collect(Collectors.toList())).asList();
    }

    public double getChance() {
        return this.chance;
    }

    public Integer getMaxTradeUses() {
        return this.maxTradeUses == 0 ? Integer.MAX_VALUE : this.maxTradeUses;
    }

    public Integer getRequiredVillagerLevel() {
        return this.requiredVillagerLevel;
    }

    public ImmutableList<String> getExcludedWorlds() {
        return this.excludedWorlds;
    }

    public ImmutableList<String> getRequiredBiome() {
        return this.requiredBiome;
    }

    public ImmutableList<String> getRequiredProfession() {
        return this.requiredProfession;
    }

    private List<String> isListSetToNone(List<String> list) {
        if (list == null || list.contains("none")) {
            return Collections.emptyList();
        }
        return list;
    }
}

