/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.utils;

import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.advancedplugins.at.Core;
import net.advancedplugins.at.utils.GlowEffect;
import net.advancedplugins.at.utils.MathUtils;
import net.advancedplugins.at.utils.evalex.Expression;
import net.advancedplugins.utils.ColorUtils;
import net.advancedplugins.utils.nbt.NBTapi;
import net.advancedplugins.utils.nbt.utils.MinecraftVersion;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class AManager {
    private static int version = 0;

    public static String color(String string) {
        return ColorUtils.format(string);
    }

    public static String formatNumber(int n) {
        return AManager.formatNumber((long)n);
    }

    public static String formatNumber(long l) {
        String string = NumberFormat.getNumberInstance().format(l);
        string = string.replace("\u00a0", "");
        return string;
    }

    public static int getResponsiveInventorySize(int n) {
        if (n <= 9) {
            return 9;
        }
        int n2 = n;
        if ((double)n / 9.0 > 0.0) {
            n2 = n / 9 * 9 + 9;
        }
        return Math.min(n2, 54);
    }

    public static int parseInt(Player player, String string, String string2) {
        try {
            return AManager.parseInt(string2);
        }
        catch (Exception exception) {
            player.sendMessage("\ufffd7Error activating effect \ufffdc" + string + "");
            player.sendMessage("\ufffd7Reason: \ufffdfCannot parse \ufffdc" + string2 + "\ufffdf as number.");
            return 0;
        }
    }

    public static Integer parseInt(String string, Integer n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static boolean isWheat(Material material) {
        if (!AManager.isValid(material)) {
            return false;
        }
        String string = material.name();
        return string.equals("WHEAT") || string.equals("CROPS");
    }

    public static int getCropAmount() {
        return MathUtils.randomBetween(2, 5);
    }

    public static int getSeedAmount() {
        return MathUtils.randomBetween(1, 3);
    }

    public static boolean isCrop(Material material) {
        String string;
        if (!AManager.isValid(material)) {
            return false;
        }
        switch (string = material.name()) {
            case "CROPS": 
            case "WHEAT": 
            case "CARROTS": 
            case "POTATOES": 
            case "CARROT": 
            case "POTATO": 
            case "BEETROOTS": 
            case "COCOA": 
            case "NETHER_WART_BLOCK": 
            case "SWEET_BERRY_BUSH": {
                return true;
            }
        }
        return false;
    }

    public static boolean isStandingBlock(Material material) {
        String string;
        if (!AManager.isValid(material)) {
            return false;
        }
        switch (string = material.name()) {
            case "REDSTONE": 
            case "REPEATER": 
            case "COMPARATOR": 
            case "LEVER": 
            case "CROPS": 
            case "WHEAT": 
            case "CARROTS": 
            case "POTATOES": 
            case "CARROT": 
            case "POTATO": 
            case "BEETROOTS": 
            case "ROSE_BUSH": 
            case "WITHER_ROSE": 
            case "PEONY": 
            case "LILAC": 
            case "SUNFLOWER": 
            case "CORNFLOWER": 
            case "OXEYE_DAISY": {
                return true;
            }
        }
        return string.contains("TORCH") || string.contains("SIGN") || string.contains("_DOOR") || string.contains("RAIL") || string.contains("BUTTON") || string.contains("PRESSURE_PLATE") || string.contains("TULIP");
    }

    public static boolean isWallBlock(Material material) {
        if (!AManager.isValid(material)) {
            return false;
        }
        String string = material.name();
        return string.contains("WALL_") || string.contains("TRIPWIRE_HOOK") || string.contains("LADDER") || string.contains("LEVER") || string.contains("BUTTON") || string.contains("BANNER") || string.equals("COCOA");
    }

    public static boolean isHangingBlock(Material material) {
        if (!AManager.isValid(material)) {
            return false;
        }
        String string = material.name();
        return string.equalsIgnoreCase("LANTERN") || string.equalsIgnoreCase("SOUL_LANTERN") || string.contains("LEVER") || string.contains("BUTTON");
    }

    public static Material getNonWallMaterial(Material material) {
        if (!AManager.isValid(material)) {
            return material;
        }
        String string = material.name();
        string = string.replace("WALL_", "");
        return Material.getMaterial((String)string);
    }

    public static boolean isAttached(Block block, Block block2) {
        if (AManager.isStandingBlock(block2.getType())) {
            return block2.getRelative(BlockFace.DOWN).equals(block);
        }
        if (AManager.isHangingBlock(block2.getType())) {
            return block2.getRelative(BlockFace.UP).equals(block);
        }
        if (block2.getBlockData() instanceof Directional && AManager.isWallBlock(block2.getType())) {
            Directional directional = (Directional)block2.getBlockData();
            return block2.getRelative(directional.getFacing().getOppositeFace()).equals(block);
        }
        return false;
    }

    public static List<ItemStack> condense(ItemStack[] itemStackArray) {
        for (int i = 0; i < itemStackArray.length; ++i) {
            if (itemStackArray[i] == null) continue;
            for (int j = i + 1; j < itemStackArray.length; ++j) {
                if (itemStackArray[j] == null || itemStackArray[j] == null || !itemStackArray[i].isSimilar(itemStackArray[j]) || itemStackArray[i].getAmount() + itemStackArray[j].getAmount() > itemStackArray[i].getMaxStackSize()) continue;
                itemStackArray[i].setAmount(itemStackArray[i].getAmount() + itemStackArray[j].getAmount());
                itemStackArray[j] = null;
            }
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>(Arrays.asList(itemStackArray));
        while (arrayList.remove(null)) {
        }
        return arrayList;
    }

    public static int getAmountWithFortune(Material material, ItemStack itemStack) {
        int n = itemStack.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS);
        int n2 = ThreadLocalRandom.current().nextInt(4) + 1;
        if (n >= 30) {
            int n3 = n / 6;
            int n4 = n / 7;
            n2 = ThreadLocalRandom.current().nextInt(n3) + n4;
        }
        switch (material.name()) {
            case "GLOWSTONE": {
                n2 = MathUtils.clamp(n2, 2, 4);
                break;
            }
            case "NETHER_WART": {
                n2 = ThreadLocalRandom.current().nextInt(6) + 1;
                n2 = MathUtils.clamp(n2, 2, 7);
                break;
            }
            case "SWEET_BERRIES": {
                n2 = MathUtils.clamp(n2, 1, 6);
                break;
            }
            case "SEA_LANTERN": {
                n2 = ThreadLocalRandom.current().nextInt(5) + 1;
                n2 = MathUtils.clamp(n2, 2, 5);
            }
        }
        return n2;
    }

    public static boolean isTall(Material material) {
        if (material.name().endsWith("_DOOR")) {
            return true;
        }
        if (MinecraftVersion.isNew()) {
            return material == Material.SUNFLOWER || material == Material.LILAC || material == Material.ROSE_BUSH || material == Material.PEONY;
        }
        return false;
    }

    public static boolean isValid(Material material) {
        return material != null && !AManager.isAir(material);
    }

    public static boolean isValid(ItemStack itemStack) {
        return itemStack != null && itemStack.getAmount() > 0 && !AManager.isAir(itemStack.getType());
    }

    public static boolean isValid(Block block) {
        return block != null && !AManager.isAir(block.getType());
    }

    public static boolean isAir(Material material) {
        if (MinecraftVersion.getVersionNumber() >= 1130) {
            return material == Material.AIR || material == Material.CAVE_AIR || material == Material.VOID_AIR || material == Material.LEGACY_AIR;
        }
        return material == Material.AIR;
    }

    public static boolean isAir(Block block) {
        return AManager.isAir(block.getType());
    }

    public static boolean isAir(ItemStack itemStack) {
        return AManager.isAir(itemStack.getType());
    }

    public static boolean dropItem(Location location, ItemStack itemStack) {
        if (AManager.isValid(itemStack)) {
            location.getWorld().dropItem(location, itemStack);
            return true;
        }
        return false;
    }

    public static void giveItem(Player player, ItemStack itemStack) {
        if (!AManager.isValid(itemStack)) {
            return;
        }
        if (!player.getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) {
            AManager.dropItem(player.getLocation(), itemStack);
        }
    }

    public static boolean canTake(Player player, ItemStack itemStack) {
        for (ItemStack itemStack2 : player.getInventory().getContents()) {
            if (itemStack2 == null || AManager.isAir(itemStack2)) {
                return true;
            }
            if (!itemStack2.getType().equals((Object)itemStack.getType()) || itemStack2.getType().getMaxStackSize() >= itemStack2.getAmount() + itemStack.getAmount()) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnbreakable(ItemStack itemStack) {
        return NBTapi.contains("Unbreakable", itemStack);
    }

    public static ItemStack setUnbreakable(ItemStack itemStack) {
        return NBTapi.addNBTTag("Unbreakable", "1", itemStack);
    }

    public static void reportIssue(Exception exception, String string) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        String string2 = "";
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string3 = stackTraceElement + "";
            if (!string3.contains("net.advancedplugins.at")) continue;
            string2 = string3;
            break;
        }
        exception.printStackTrace();
        Bukkit.getLogger().info("[AdvancedTrades ERROR] Could not pass " + ExceptionUtils.getRootCauseMessage((Throwable)exception) + "");
        Core.getInstance().getLogger().info("   Class: " + string2);
        Core.getInstance().getLogger().info("If you cannot indentify cause of this, contact developer providing this report. ");
    }

    private static void updateVer() {
        if (version == 0) {
            version = Bukkit.getVersion().contains("1.10") ? 10 : (Bukkit.getVersion().contains("1.11") ? 11 : (Bukkit.getVersion().contains("1.12") ? 12 : (Bukkit.getVersion().contains("1.13") ? 13 : (Bukkit.getVersion().contains("1.14") ? 14 : (Bukkit.getVersion().contains("1.15") ? 15 : (Bukkit.getVersion().contains("1.16") ? 16 : Integer.parseInt(Character.toString(Core.getInstance().getServer().getBukkitVersion().charAt(4)))))))));
        }
    }

    public static void playEffect(String string, int n, int n2, Location location) {
        AManager.updateVer();
        if (version < 13) {
            try {
                Class<?> clazz = Class.forName("org.bukkit.Effect");
                Object obj = Enum.valueOf(clazz, string);
                Method method = location.getWorld().spigot().getClass().getMethod("playEffect", Location.class, clazz, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)location.getWorld().spigot(), location, obj, 0, 0, n, n, n, Float.valueOf(0.0f), n2, 32);
            }
            catch (Exception exception) {}
        } else {
            try {
                Class<?> clazz = Class.forName("org.bukkit.Particle");
                Object obj = Enum.valueOf(clazz, string);
                Method method = location.getWorld().getClass().getMethod("spawnParticle", clazz, Location.class, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)location.getWorld(), obj, location, n2, n, n, n, Float.valueOf(0.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int parseThroughCalculator(String string) {
        string = string.replaceAll(" ", "");
        Expression expression = new Expression(string);
        try {
            return expression.eval().intValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AManager.error("Failed to calculate '" + string + "': Invalid syntax or outcome");
            return 0;
        }
    }

    public static boolean hasAmount(Player player, Material material, int n) {
        for (ItemStack itemStack : player.getInventory().getContents()) {
            if (itemStack == null || !itemStack.getType().equals((Object)material) || (n -= itemStack.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public static int removeItems(Inventory inventory, Material material, int n) {
        if (material == null || inventory == null) {
            return -1;
        }
        if (n <= 0) {
            return -1;
        }
        if (n == Integer.MAX_VALUE) {
            inventory.remove(material);
            return 0;
        }
        inventory.removeItem(new ItemStack[]{new ItemStack(material, n)});
        return 0;
    }

    public static int parseInt(String string) {
        try {
            return Integer.parseInt(string.replaceAll("[^0-9]", ""));
        }
        catch (Exception exception) {
            Core.getInstance().getLogger().info("Failed to parse " + string + " from String to Integer.");
            return 0;
        }
    }

    public static List<String> replaceInList(List<String> list, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            for (String string2 : stringArray) {
                String string3 = string2.split(";")[0];
                String string4 = string2.split(";")[1];
                string = string.replace(string3, string4);
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static void error(String ... stringArray) {
        for (String string : stringArray) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.hasPermission("ae.admin")) continue;
                player.sendMessage(string);
            }
            Bukkit.getLogger().info(string);
        }
    }

    public static int getRandomFreeSlot(Inventory inventory) {
        if (inventory.firstEmpty() == -1) {
            return -1;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (!AManager.isValid(inventory.getItem(i))) continue;
            arrayList.add(i);
        }
        if (arrayList.isEmpty()) {
            return -1;
        }
        return ThreadLocalRandom.current().nextInt(arrayList.size());
    }

    private static String getVer() {
        return Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    }

    public static ItemStack addGlow(ItemStack itemStack) {
        if (!MinecraftVersion.isNew()) {
            try {
                AManager.updateVer();
                String string = AManager.getVer();
                Class<?> clazz = Class.forName("org.bukkit.craftbukkit." + string + ".inventory.CraftItemStack");
                Method method = clazz.getMethod("asNMSCopy", ItemStack.class);
                Object object = method.invoke((Object)itemStack, itemStack);
                Object object2 = null;
                Class<?> clazz2 = Class.forName("net.minecraft.server." + string + ".NBTTagCompound");
                Method method2 = object.getClass().getMethod("hasTag", new Class[0]);
                if (!((Boolean)method2.invoke(object, new Object[0])).booleanValue()) {
                    object2 = clazz2.getConstructors()[0].newInstance(new Object[0]);
                    object.getClass().getMethod("setTag", object2.getClass()).invoke(object, object2);
                }
                if (object2 == null) {
                    object2 = object.getClass().getMethod("getTag", new Class[0]).invoke(object, new Object[0]);
                }
                Class<?> clazz3 = Class.forName("net.minecraft.server." + string + ".NBTTagList");
                Object obj = clazz3.getConstructors()[0].newInstance(new Object[0]);
                Class<?> clazz4 = Class.forName("net.minecraft.server." + string + ".NBTBase");
                object2.getClass().getMethod("set", String.class, clazz4).invoke(object2, "ench", obj);
                object.getClass().getMethod("setTag", clazz2).invoke(object, object2);
                object2.getClass().getMethod("set", String.class, clazz4).invoke(object2, "Enchantments", obj);
                object.getClass().getMethod("setTag", clazz2).invoke(object, object2);
                Class<?> clazz5 = Class.forName("net.minecraft.server." + string + ".ItemStack");
                return (ItemStack)Class.forName("org.bukkit.craftbukkit." + string + ".inventory.CraftItemStack").getMethod("asCraftMirror", clazz5).invoke(object, object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return itemStack;
            }
        }
        itemStack.addUnsafeEnchantment(GlowEffect.GLOW, 1);
        return itemStack;
    }
}

