/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.utils.nbt.backend;

import net.advancedplugins.utils.nbt.backend.NBTCompound;
import net.advancedplugins.utils.nbt.backend.NBTContainer;
import net.advancedplugins.utils.nbt.backend.NBTReflectionUtil;
import net.advancedplugins.utils.nbt.backend.ReflectionMethod;
import org.bukkit.inventory.ItemStack;

public class NBTItem
extends NBTCompound {
    private ItemStack bukkitItem;

    public NBTItem(ItemStack itemStack) {
        super(null, null);
        if (itemStack == null) {
            throw new NullPointerException("ItemStack can't be null!");
        }
        this.bukkitItem = itemStack.clone();
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getItemRootNBTTagCompound(ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem));
    }

    @Override
    protected void setCompound(Object object) {
        Object object2 = ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem);
        ReflectionMethod.ITEMSTACK_SET_TAG.run(object2, object);
        this.bukkitItem = (ItemStack)ReflectionMethod.ITEMSTACK_BUKKITMIRROR.run(null, object2);
    }

    public ItemStack getItem() {
        return this.bukkitItem;
    }

    protected void setItem(ItemStack itemStack) {
        this.bukkitItem = itemStack;
    }

    public boolean hasNBTData() {
        return this.getCompound() != null;
    }

    public static NBTContainer convertItemtoNBT(ItemStack itemStack) {
        return NBTReflectionUtil.convertNMSItemtoNBTCompound(ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, itemStack));
    }

    public static ItemStack convertNBTtoItem(NBTCompound nBTCompound) {
        return (ItemStack)ReflectionMethod.ITEMSTACK_BUKKITMIRROR.run(null, NBTReflectionUtil.convertNBTCompoundtoNMSItem(nBTCompound));
    }
}

