/*
 * Decompiled with CFR 0.152.
 */
package me.josn3r.plugin.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.util.Vector;

public class Cuboid
implements Cloneable,
ConfigurationSerializable,
Iterable<Block> {
    public static String gay = "uhc.txt";
    protected String worldName;
    protected final Vector minimumPoint;
    protected final Vector maximumPoint;

    public Cuboid(Cuboid cuboid) {
        this(cuboid.worldName, cuboid.minimumPoint.getX(), cuboid.minimumPoint.getY(), cuboid.minimumPoint.getZ(), cuboid.maximumPoint.getX(), cuboid.maximumPoint.getY(), cuboid.maximumPoint.getZ());
    }

    public Cuboid(Location location) {
        this(location, location);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cuboid(Location location, Location location2) {
        if (location == null || location2 == null) throw new NullPointerException("One/both of the locations is/are null!");
        if (location.getWorld() == null || location2.getWorld() == null) throw new NullPointerException("One/both of the worlds is/are null!");
        if (!location.getWorld().getUID().equals(location2.getWorld().getUID())) {
            throw new IllegalStateException("The 2 locations of the cuboid must be in the same world!");
        }
        this.worldName = location.getWorld().getName();
        double d = Math.min(location.getX(), location2.getX());
        double d2 = Math.min(location.getY(), location2.getY());
        double d3 = Math.min(location.getZ(), location2.getZ());
        double d4 = Math.max(location.getX(), location2.getX());
        double d5 = Math.max(location.getY(), location2.getY());
        double d6 = Math.max(location.getZ(), location2.getZ());
        this.minimumPoint = new Vector(d, d2, d3);
        this.maximumPoint = new Vector(d4, d5, d6);
    }

    public Cuboid(String string, double d, double d2, double d3, double d4, double d5, double d6) {
        if (string == null || Bukkit.getServer().getWorld(string) == null) {
            throw new NullPointerException("One/both of the worlds is/are null!");
        }
        this.worldName = string;
        double d7 = Math.min(d, d4);
        double d8 = Math.max(d, d4);
        double d9 = Math.min(d2, d5);
        double d10 = Math.max(d2, d5);
        double d11 = Math.min(d3, d6);
        double d12 = Math.max(d3, d6);
        this.minimumPoint = new Vector(d7, d9, d11);
        this.maximumPoint = new Vector(d8, d10, d12);
    }

    public boolean containsLocation(Location location) {
        return location != null && location.getWorld().getName().equals(this.worldName) && location.toVector().isInAABB(this.minimumPoint, this.maximumPoint);
    }

    public boolean containsVector(Vector vector) {
        return vector != null && vector.isInAABB(this.minimumPoint, this.maximumPoint);
    }

    public List<Block> getBlocks() {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        World world = this.getWorld();
        if (world != null) {
            for (int i = this.minimumPoint.getBlockX(); i <= this.maximumPoint.getBlockX(); ++i) {
                for (int j = this.minimumPoint.getBlockY(); j <= this.maximumPoint.getBlockY() && j <= world.getMaxHeight(); ++j) {
                    for (int k = this.minimumPoint.getBlockZ(); k <= this.maximumPoint.getBlockZ(); ++k) {
                        arrayList.add(world.getBlockAt(i, j, k));
                    }
                }
            }
        }
        return arrayList;
    }

    public Location getLowerLocation() {
        return this.minimumPoint.toLocation(this.getWorld());
    }

    public double getLowerX() {
        return this.minimumPoint.getX();
    }

    public double getLowerY() {
        return this.minimumPoint.getY();
    }

    public double getLowerZ() {
        return this.minimumPoint.getZ();
    }

    public Location getUpperLocation() {
        return this.maximumPoint.toLocation(this.getWorld());
    }

    public double getUpperX() {
        return this.maximumPoint.getX();
    }

    public double getUpperY() {
        return this.maximumPoint.getY();
    }

    public double getUpperZ() {
        return this.maximumPoint.getZ();
    }

    public double getVolume() {
        return (this.getUpperX() - this.getLowerX() + 1.0) * (this.getUpperY() - this.getLowerY() + 1.0) * (this.getUpperZ() - this.getLowerZ() + 1.0);
    }

    public World getWorld() {
        World world = Bukkit.getServer().getWorld(this.worldName);
        if (world == null) {
            throw new NullPointerException("World '" + this.worldName + "' is not loaded.");
        }
        return world;
    }

    public void setWorld(World world) {
        if (world == null) {
            throw new NullPointerException("The world cannot be null.");
        }
        this.worldName = world.getName();
    }

    public Cuboid clone() {
        return new Cuboid(this);
    }

    @Override
    public ListIterator<Block> iterator() {
        return this.getBlocks().listIterator();
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("worldName", this.worldName);
        hashMap.put("x1", this.minimumPoint.getX());
        hashMap.put("x2", this.maximumPoint.getX());
        hashMap.put("y1", this.minimumPoint.getY());
        hashMap.put("y2", this.maximumPoint.getY());
        hashMap.put("z1", this.minimumPoint.getZ());
        hashMap.put("z2", this.maximumPoint.getZ());
        return hashMap;
    }

    public static Cuboid deserialize(Map<String, Object> map) {
        try {
            String string = (String)map.get("worldName");
            double d = (Double)map.get("x1");
            double d2 = (Double)map.get("x2");
            double d3 = (Double)map.get("y1");
            double d4 = (Double)map.get("y2");
            double d5 = (Double)map.get("z1");
            double d6 = (Double)map.get("z2");
            return new Cuboid(string, d, d3, d5, d2, d4, d6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

