/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsoplus.commands;

import com.alonsoaliaga.alonsoplus.AlonsoPlus;
import com.alonsoaliaga.alonsoplus.api.events.ColorSelectEvent;
import com.alonsoaliaga.alonsoplus.commands.AbstractCommand;
import com.alonsoaliaga.alonsoplus.others.ColorData;
import com.alonsoaliaga.alonsoplus.others.PlayerData;
import com.alonsoaliaga.alonsoplus.others.RankData;
import com.alonsoaliaga.alonsoplus.others.Sounds;
import com.alonsoaliaga.alonsoplus.utils.AlonsoUtils;
import com.alonsoaliaga.alonsoplus.utils.LocalUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class MainCommand
extends AbstractCommand {
    private AlonsoPlus plugin;
    private List<String> adminList = Arrays.asList("color", "set", "clear", "reload");
    private List<String> userList = Collections.singletonList("color");
    private List<String> emptyList = Collections.emptyList();
    protected boolean testServer = false;
    private String testError = LocalUtils.colorize("&cHey {PLAYER}! For security reasons, you can only use commands to modify your player in this test server!");
    private String testReloadError = LocalUtils.colorize("&cHey {PLAYER}! For security reasons, this command is disabled in this test server!");
    private String testPaste = LocalUtils.colorize("&cHey {PLAYER}! For security reasons, this command is disabled in this test server!");
    private boolean supportDeveloper;

    public MainCommand(AlonsoPlus alonsoPlus, String string, List<String> list, String string2) {
        super(string, "/" + string, string2, list);
        this.plugin = alonsoPlus;
        this.reloadMessages();
        this.register();
    }

    private void reloadMessages() {
        this.supportDeveloper = this.plugin.getFiles().getConfig().get().getBoolean("Options.Support-developer", true);
    }

    @Override
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (this.plugin.permissions.mainPermission != null && !commandSender.hasPermission(this.plugin.permissions.mainPermission)) {
            commandSender.sendMessage(this.plugin.messages.noMainPermission);
            return true;
        }
        if (stringArray.length >= 1) {
            if (stringArray[0].equalsIgnoreCase("paste") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && !commandSender.isOp()) {
                    LocalUtils.send(commandSender, this.testPaste.replace("{PLAYER}", commandSender.getName()));
                    return true;
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    String string;
                    String string2 = string = "Plugin: " + this.plugin.getDescription().getName() + "\nVersion: " + this.plugin.getDescription().getVersion() + "\nServer: " + this.plugin.getServer().getName() + " (" + this.plugin.getServer().getVersion() + ")\nUser: www.spigotmc.org/members/997807/\nDebug: " + this.plugin.debugMode + "\nDatabase:" + (this.plugin.hikariCPEnabled ? "HikariCP" : (this.plugin.mysqlEnabled ? "MySQL" : "SQLite")) + "\nChat compatibility: " + this.plugin.chatCompatibility + "\nCustom placeholders: " + (!this.plugin.customPlaceholderEnabled ? "false\n" : "true " + (this.plugin.rankMap.isEmpty() ? "(Empty)" : "\n" + this.plugin.rankMap.entrySet().stream().map(entry -> "  " + (String)entry.getKey() + ": " + ((RankData)entry.getValue()).getReplacement() + "|" + ((RankData)entry.getValue()).getPlaceholderRanked() + "|" + ((RankData)entry.getValue()).getPlaceholderNoRanked()).collect(Collectors.joining("\n")))) + "\nDate: " + new Date() + "\nColors: " + this.plugin.getColorsMap().size();
                    int n = ThreadLocalRandom.current().nextInt(1, 15);
                    for (int i = 0; i < n; ++i) {
                        string2 = Base64.getEncoder().encodeToString(string2.getBytes());
                    }
                    String string3 = String.valueOf(n).length() + "" + n + string2 + n + "A";
                    if (commandSender instanceof Player) {
                        Player player = (Player)commandSender;
                        player.playSound(player.getLocation(), Sounds.EXP_ORB.getSound(), 1.0f, 1.0f);
                        LocalUtils.send(commandSender, "&aRequired data has been sent to console!");
                    }
                    LocalUtils.log("&c***************************************************************************");
                    LocalUtils.log("&eRequested data by " + commandSender.getName() + ":");
                    Bukkit.getServer().getConsoleSender().sendMessage("\u00a7e" + string3);
                    LocalUtils.log("&c***************************************************************************");
                });
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("color")) {
                if (stringArray.length >= 2 && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        return true;
                    }
                    if (!this.plugin.getDataMap().containsKey(player.getUniqueId())) {
                        player.sendMessage(this.plugin.messages.pleaseReconnect);
                        return true;
                    }
                    PlayerData playerData = this.plugin.getDataMap().get(player.getUniqueId());
                    player.playSound(player.getLocation(), Sounds.CHEST_OPEN.getSound(), 1.0f, 1.0f);
                    this.plugin.openColors(player, playerData);
                } else if (commandSender instanceof Player) {
                    Player player = (Player)commandSender;
                    if (!this.plugin.getDataMap().containsKey(player.getUniqueId())) {
                        player.sendMessage(this.plugin.messages.pleaseReconnect);
                        return true;
                    }
                    PlayerData playerData = this.plugin.getDataMap().get(player.getUniqueId());
                    player.playSound(player.getLocation(), Sounds.CHEST_OPEN.getSound(), 1.0f, 1.0f);
                    this.plugin.openColors(player, playerData);
                } else {
                    LocalUtils.logp("&cConsole cannot select a color.. Try /" + command.getName() + " color <player>");
                }
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("set") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (stringArray.length >= 3) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        return true;
                    }
                    if (!this.plugin.getDataMap().containsKey(player.getUniqueId())) {
                        player.sendMessage(this.plugin.messages.pleaseReconnect);
                        return true;
                    }
                    if (!player.hasPermission(this.plugin.permissions.rankedPermission)) {
                        player.sendMessage(this.plugin.messages.noRankedPermission);
                        return true;
                    }
                    String string2 = stringArray[2];
                    if (!this.plugin.getColorsMap().containsKey(string2)) {
                        commandSender.sendMessage(this.plugin.messages.setInvalidColor);
                        return true;
                    }
                    ColorData colorData = this.plugin.getColorsMap().get(string2);
                    PlayerData playerData = this.plugin.getDataMap().get(player.getUniqueId());
                    ColorSelectEvent colorSelectEvent = new ColorSelectEvent(player, colorData.getColorIdentifier(), colorData.getColor(), ColorSelectEvent.Reason.COMMAND);
                    Bukkit.getPluginManager().callEvent((Event)colorSelectEvent);
                    if (colorSelectEvent.isCancelled()) {
                        return true;
                    }
                    playerData.updateColorData(colorData.getColorIdentifier(), colorData);
                    if (this.plugin.instantUpdate) {
                        this.plugin.connectionListener.savePlayer(playerData, false);
                    }
                    if (this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                        player.sendMessage(LocalUtils.colorize(PlaceholderAPI.setPlaceholders((Player)player, (String)colorData.getSelectedMessage()).replace(this.plugin.messages.placeholderToReplace, colorData.getColor())));
                    } else {
                        player.sendMessage(colorData.getSelectedMessage());
                    }
                    player.playSound(player.getLocation(), Sounds.EXP_ORB.getSound(), 1.0f, 1.0f);
                    return true;
                }
                LocalUtils.send(commandSender, "&cUse: /" + command.getName() + " set <player> <color-identifier>");
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("clear") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (stringArray.length >= 2) {
                    Player player = Bukkit.getPlayer((String)stringArray[1]);
                    if (player == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        return true;
                    }
                    if (!this.plugin.getDataMap().containsKey(player.getUniqueId())) {
                        player.sendMessage(this.plugin.messages.pleaseReconnect);
                        return true;
                    }
                    PlayerData playerData = this.plugin.getDataMap().get(player.getUniqueId());
                    playerData.updateColorData(null, this.plugin.colorData);
                    if (this.plugin.instantUpdate) {
                        this.plugin.connectionListener.savePlayer(playerData, false);
                    }
                    if (player.hasPermission(this.plugin.permissions.rankedPermission)) {
                        player.sendMessage(this.plugin.messages.clearColor);
                    }
                    return true;
                }
                LocalUtils.send(commandSender, "&cUse: /" + command.getName() + " clear <player>");
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("reload") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && commandSender instanceof Player && !commandSender.isOp()) {
                    LocalUtils.send(commandSender, this.testReloadError.replace("{PLAYER}", commandSender.getName()));
                    return true;
                }
                this.plugin.closeInventories();
                this.plugin.getFiles().getConfig().reload();
                this.plugin.permissions.reloadMessages();
                this.plugin.messages.reloadMessages();
                this.plugin.reloadMessages();
                this.plugin.loadColors();
                this.reloadMessages();
                this.plugin.rankCommand.reloadMessages();
                this.plugin.clickListener.reloadMessages();
                this.plugin.connectionListener.reloadMessages();
                this.plugin.chatListener.reloadMessages();
                commandSender.sendMessage(this.plugin.messages.reloaded);
                return true;
            }
        }
        LocalUtils.send(commandSender, " ");
        if (this.supportDeveloper) {
            LocalUtils.send(commandSender, AlonsoUtils.second + "&l" + "AlonsoPlus" + " " + AlonsoUtils.first + "by " + AlonsoUtils.second + "&lAlonsoAliaga " + AlonsoUtils.first + "Version &6" + this.plugin.getDescription().getVersion());
        }
        if (commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
            for (String string3 : this.plugin.messages.adminHelpList) {
                commandSender.sendMessage(string3);
            }
        } else {
            for (String string4 : this.plugin.messages.userHelpList) {
                commandSender.sendMessage(string4);
            }
        }
        LocalUtils.send(commandSender, " ");
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            player.playSound(player.getLocation(), Sounds.PICKUP.getSound(), 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (stringArray.length >= 1) {
            if (stringArray.length == 1) {
                return commandSender.hasPermission(this.plugin.permissions.adminPermission) ? this.adminList : this.userList;
            }
            if (commandSender.hasPermission(this.plugin.permissions.adminPermission) && this.adminList.contains(stringArray[0].toLowerCase())) {
                if (stringArray[0].equalsIgnoreCase("set") && stringArray.length == 3) {
                    return new ArrayList<String>(this.plugin.getColorsMap().keySet());
                }
            } else {
                return this.emptyList;
            }
        }
        return this.onlinePlayers(commandSender, stringArray);
    }
}

