/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsoplus.commands;

import com.alonsoaliaga.alonsoplus.AlonsoPlus;
import com.alonsoaliaga.alonsoplus.commands.AbstractCommand;
import com.alonsoaliaga.alonsoplus.others.PlayerData;
import com.alonsoaliaga.alonsoplus.others.Sounds;
import com.alonsoaliaga.alonsoplus.utils.LocalUtils;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RankCommand
extends AbstractCommand {
    private AlonsoPlus plugin;
    private String testError = LocalUtils.colorize("&cHey {PLAYER}! For security reasons, you can only use commands to modify your player in this test server!");

    public RankCommand(AlonsoPlus alonsoPlus, String string, List<String> list, String string2) {
        super(string, "/" + string, string2, list);
        this.plugin = alonsoPlus;
        this.reloadMessages();
        this.register();
    }

    public void reloadMessages() {
    }

    @Override
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (this.plugin.permissions.mainPermission != null && !commandSender.hasPermission(this.plugin.permissions.mainPermission)) {
            commandSender.sendMessage(this.plugin.messages.noMainPermission);
            return true;
        }
        if (stringArray.length >= 2 && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
            Player player = Bukkit.getPlayer((String)stringArray[1]);
            if (player == null) {
                commandSender.sendMessage(this.plugin.messages.invalidTarget);
                return true;
            }
            if (this.plugin.mainCommand.testServer && !player.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                return true;
            }
            if (!this.plugin.getDataMap().containsKey(player.getUniqueId())) {
                player.sendMessage(this.plugin.messages.pleaseReconnect);
                return true;
            }
            PlayerData playerData = this.plugin.getDataMap().get(player.getUniqueId());
            player.playSound(player.getLocation(), Sounds.CHEST_OPEN.getSound(), 1.0f, 1.0f);
            this.plugin.openColors(player, playerData);
        } else if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (!this.plugin.getDataMap().containsKey(player.getUniqueId())) {
                player.sendMessage(this.plugin.messages.pleaseReconnect);
                return true;
            }
            PlayerData playerData = this.plugin.getDataMap().get(player.getUniqueId());
            player.playSound(player.getLocation(), Sounds.CHEST_OPEN.getSound(), 1.0f, 1.0f);
            this.plugin.openColors(player, playerData);
        } else {
            LocalUtils.logp("&cConsole cannot select a color.. Try /" + command.getName() + " <player>");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (stringArray.length >= 1 && stringArray.length == 1) {
            return commandSender.hasPermission(this.plugin.permissions.adminPermission) ? this.onlinePlayers(commandSender, stringArray) : Collections.emptyList();
        }
        return this.onlinePlayers(commandSender, stringArray);
    }
}

