/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsoplus.enums;

import com.alonsoaliaga.alonsoplus.others.CommandData;

public enum CommandType {
    PLAYER("[PLAYER]"),
    CONSOLE("[CONSOLE]"),
    CHAT("[CHAT]"),
    OP("[OP]"),
    MESSAGE("[MESSAGE]"),
    MESSAGE_BROADCAST("[MESSAGE_BROADCAST]"),
    MESSAGE_WORLD_BROADCAST("[MESSAGE_WORLD_BROADCAST]"),
    SOUND("[SOUND]"),
    SOUND_BROADCAST("[SOUND_BROADCAST]"),
    SOUND_WORLD_BROADCAST("[SOUND_WORLD_BROADCAST]");

    private String toRemove;

    private CommandType(String string2) {
        this.toRemove = string2;
    }

    public String getToRemove() {
        return this.toRemove;
    }

    public CommandData getCommandData(String string) {
        return new CommandData(string);
    }

    public CommandData getCommandData(String string, CommandType commandType) {
        string = string.trim();
        for (CommandType commandType2 : CommandType.values()) {
            if (!string.startsWith(commandType2.getToRemove())) continue;
            return new CommandData(string.substring(commandType2.getToRemove().length()), commandType2);
        }
        return new CommandData(string, commandType);
    }

    public static CommandType getFromCommand(String string) {
        for (CommandType commandType : CommandType.values()) {
            if (!string.startsWith(commandType.getToRemove())) continue;
            return commandType;
        }
        return null;
    }

    public static CommandType getCommandType(String string) {
        return CommandType.getCommandType(string, null);
    }

    public static CommandType getCommandType(String string, CommandType commandType) {
        try {
            return CommandType.valueOf(string);
        }
        catch (Throwable throwable) {
            return commandType;
        }
    }
}

