/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsoplus.listeners;

import com.alonsoaliaga.alonsoplus.AlonsoPlus;
import com.alonsoaliaga.alonsoplus.api.events.ColorSelectEvent;
import com.alonsoaliaga.alonsoplus.others.ColorData;
import com.alonsoaliaga.alonsoplus.others.PlayerData;
import com.alonsoaliaga.alonsoplus.others.PlusHolder;
import com.alonsoaliaga.alonsoplus.others.Sounds;
import com.alonsoaliaga.alonsoplus.utils.LocalUtils;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;

public class ClickListener
implements Listener {
    private AlonsoPlus plugin;
    private int colorsType = 0;

    public ClickListener(AlonsoPlus alonsoPlus) {
        this.plugin = alonsoPlus;
        alonsoPlus.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)alonsoPlus);
        this.reloadMessages();
    }

    public void reloadMessages() {
    }

    @EventHandler
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getInventory().getHolder() instanceof PlusHolder) {
            PlusHolder plusHolder = (PlusHolder)inventoryClickEvent.getInventory().getHolder();
            inventoryClickEvent.setCancelled(true);
            if (plusHolder.getType() == this.colorsType) {
                if (inventoryClickEvent.getRawSlot() == this.plugin.closeSlot) {
                    Player player = (Player)inventoryClickEvent.getWhoClicked();
                    if (this.plugin.closeItemClose) {
                        player.closeInventory();
                    }
                    if (this.plugin.closeItemCommand != null) {
                        this.plugin.closeItemCommand.performCommand(player);
                    }
                    return;
                }
                if (inventoryClickEvent.getRawSlot() == this.plugin.backSlot) {
                    Player player = (Player)inventoryClickEvent.getWhoClicked();
                    if (this.plugin.backItemClose) {
                        player.closeInventory();
                    }
                    if (this.plugin.backItemCommand != null) {
                        this.plugin.backItemCommand.performCommand(player);
                    }
                    return;
                }
                if (this.plugin.getColorsSlotsMap().containsKey(inventoryClickEvent.getRawSlot())) {
                    Player player = (Player)inventoryClickEvent.getWhoClicked();
                    if (!this.plugin.getDataMap().containsKey(player.getUniqueId())) {
                        player.closeInventory();
                        player.sendMessage(this.plugin.messages.pleaseReconnect);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    if (!player.hasPermission(this.plugin.permissions.rankedPermission)) {
                        player.sendMessage(this.plugin.messages.noRankedPermission);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    ColorData colorData = this.plugin.getColorsSlotsMap().get(inventoryClickEvent.getRawSlot());
                    PlayerData playerData = this.plugin.getDataMap().get(player.getUniqueId());
                    if (playerData.hasSelectedColor() && playerData.getSelectedColor().equals(colorData.getColorIdentifier())) {
                        player.sendMessage(colorData.getAlreadySelectedMessage());
                        player.playSound(player.getLocation(), Sounds.CLICK_ON.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    if (colorData.hasPermission() && !player.hasPermission(colorData.getPermission())) {
                        player.sendMessage(colorData.getLockedMessage());
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    ColorSelectEvent colorSelectEvent = new ColorSelectEvent(player, colorData.getColorIdentifier(), colorData.getColor(), ColorSelectEvent.Reason.CLICK);
                    Bukkit.getPluginManager().callEvent((Event)colorSelectEvent);
                    if (colorSelectEvent.isCancelled()) {
                        return;
                    }
                    playerData.updateColorData(colorData.getColorIdentifier(), colorData);
                    if (this.plugin.instantUpdate) {
                        this.plugin.connectionListener.savePlayer(playerData, false);
                    }
                    if (this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                        player.sendMessage(LocalUtils.colorize(PlaceholderAPI.setPlaceholders((Player)player, (String)colorData.getSelectedMessage()).replace(this.plugin.messages.placeholderToReplace, colorData.getColor())));
                    } else {
                        player.sendMessage(colorData.getSelectedMessage());
                    }
                    player.playSound(player.getLocation(), Sounds.EXP_ORB.getSound(), 1.0f, 1.0f);
                    if (this.plugin.closeOnSelect) {
                        player.closeInventory();
                    } else {
                        this.plugin.openColors(player, playerData);
                    }
                }
            }
        }
    }
}

