/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.commands;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public abstract class AbstractCommand
implements CommandExecutor,
TabExecutor {
    protected final String command;
    protected final String description;
    protected final List<String> alias;
    protected final String usage;
    protected final String permMessage;
    protected static CommandMap cmap;

    public AbstractCommand(String string) {
        this(string, null, null, null, null);
    }

    public AbstractCommand(String string, String string2) {
        this(string, string2, null, null, null);
    }

    public AbstractCommand(String string, String string2, String string3) {
        this(string, string2, string3, null, null);
    }

    public AbstractCommand(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, null);
    }

    public AbstractCommand(String string, String string2, String string3, List<String> list) {
        this(string, string2, string3, null, list);
    }

    public AbstractCommand(String string, String string2, String string3, String string4, List<String> list) {
        this.command = string.toLowerCase();
        this.usage = string2;
        this.description = string3;
        this.permMessage = string4;
        this.alias = list;
    }

    public void register() {
        ReflectCommand reflectCommand = new ReflectCommand(this.command);
        if (this.alias != null) {
            reflectCommand.setAliases(this.alias);
        }
        if (this.description != null) {
            reflectCommand.setDescription(this.description);
        }
        if (this.usage != null) {
            reflectCommand.setUsage(this.usage);
        }
        if (this.permMessage != null) {
            reflectCommand.setPermissionMessage(this.permMessage);
        }
        this.getCommandMap().register(this.command, (Command)reflectCommand);
        reflectCommand.setExecutor(this);
    }

    final CommandMap getCommandMap() {
        if (cmap == null) {
            try {
                Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                field.setAccessible(true);
                cmap = (CommandMap)field.get(Bukkit.getServer());
                return this.getCommandMap();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (cmap != null) {
            return cmap;
        }
        return this.getCommandMap();
    }

    public abstract boolean onCommand(CommandSender var1, Command var2, String var3, String[] var4);

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        return null;
    }

    public List<String> onlinePlayers(CommandSender commandSender, String[] stringArray) {
        String string = stringArray[stringArray.length - 1];
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Player player2 : commandSender.getServer().getOnlinePlayers()) {
            String string2 = player2.getName();
            if (player != null && !player.canSee(player2) || !StringUtil.startsWithIgnoreCase((String)string2, (String)string)) continue;
            arrayList.add(string2);
        }
        arrayList.sort(String.CASE_INSENSITIVE_ORDER);
        return arrayList;
    }

    private final class ReflectCommand
    extends Command {
        private AbstractCommand exe;

        protected ReflectCommand(String string) {
            super(string);
            this.exe = null;
        }

        public void setExecutor(AbstractCommand abstractCommand) {
            this.exe = abstractCommand;
        }

        public boolean execute(CommandSender commandSender, String string, String[] stringArray) {
            if (this.exe != null) {
                return this.exe.onCommand(commandSender, this, string, stringArray);
            }
            return false;
        }

        public List<String> tabComplete(CommandSender commandSender, String string, String[] stringArray) {
            if (this.exe != null) {
                return this.exe.onTabComplete(commandSender, this, string, stringArray);
            }
            return null;
        }
    }
}

