/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.economy;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.economy.LevelsHook;
import com.alonsoaliaga.alonsotags.economy.MaterialHook;
import com.alonsoaliaga.alonsotags.economy.PlayerPointsHook;
import com.alonsoaliaga.alonsotags.economy.TokenManagerHook;
import com.alonsoaliaga.alonsotags.economy.VaultHook;
import com.alonsoaliaga.alonsotags.enums.CostType;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import java.util.UUID;
import me.realized.tokenmanager.TokenManagerPlugin;
import org.black_ixx.playerpoints.PlayerPoints;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public interface CurrencyManager {
    public boolean hasEnough(Player var1, int var2);

    public boolean hasEnough(Player var1, double var2);

    public boolean hasEnough(UUID var1, double var2);

    public boolean withdraw(Player var1, int var2);

    public boolean withdraw(Player var1, double var2);

    public boolean withdraw(UUID var1, double var2);

    public boolean add(Player var1, int var2);

    public boolean add(Player var1, double var2);

    public boolean add(UUID var1, double var2);

    public CostType getType();

    public static CurrencyManager initializeManager(String costTypeString, CostType defaultCostType, Material material) {
        CostType costType;
        try {
            costType = CostType.valueOf(costTypeString);
        }
        catch (Throwable e) {
            costType = defaultCostType;
        }
        if (costType == null || costType == CostType.DISABLED) {
            LocalUtils.logp("Cost type is not valid or is 'DISABLED'. Disabling economy support..");
            return null;
        }
        if (costType == CostType.VAULT) {
            if (AlonsoTags.getInstance().setupEconomy()) {
                LocalUtils.logp("Cost type 'VAULT' has been enabled!");
            } else {
                costType = defaultCostType;
                if (costType == null || costType == CostType.DISABLED) {
                    LocalUtils.logp("Vault is not available! Disabling economy support..");
                    return null;
                }
                LocalUtils.logp("Vault is not available! Changing cost type to " + costType.name() + "' type!");
            }
        } else if (costType == CostType.TOKEN_MANAGER) {
            if (Bukkit.getPluginManager().isPluginEnabled("TokenManager")) {
                try {
                    TokenManagerPlugin.getInstance().getConfig();
                    LocalUtils.logp("TokenManager available! THIS IS IN BETA, report issues in our discord! Hooking..");
                }
                catch (Throwable e) {
                    costType = defaultCostType;
                    if (costType == null || costType == CostType.DISABLED) {
                        LocalUtils.logp("TokenManager is not available! Disabling economy support..");
                        return null;
                    }
                    LocalUtils.logp("TokenManager is not available! Changing cost type to " + costType.name() + "' type!");
                }
            } else {
                costType = defaultCostType;
                if (costType == null || costType == CostType.DISABLED) {
                    LocalUtils.logp("TokenManager is not available! Disabling economy support..");
                    return null;
                }
                LocalUtils.logp("TokenManager is not available! Changing cost type to " + costType.name() + "' type!");
            }
        } else if (costType == CostType.PLAYER_POINTS) {
            if (Bukkit.getPluginManager().isPluginEnabled("PlayerPoints")) {
                try {
                    PlayerPoints.getInstance().getAPI();
                    LocalUtils.logp("PlayerPoints available! THIS IS IN BETA, report issues in our discord! Hooking..");
                }
                catch (Throwable e) {
                    costType = defaultCostType;
                    if (costType == null || costType == CostType.DISABLED) {
                        LocalUtils.logp("PlayerPoints is not available! Disabling economy support..");
                        return null;
                    }
                    LocalUtils.logp("PlayerPoints is not available! Changing cost type to " + costType.name() + "' type!");
                }
            } else {
                costType = defaultCostType;
                if (costType == null || costType == CostType.DISABLED) {
                    LocalUtils.logp("PlayerPoints is not available! Disabling economy support..");
                    return null;
                }
                LocalUtils.logp("PlayerPoints is not available! Changing cost type to " + costType.name() + "' type!");
            }
        } else if (costType == CostType.MATERIAL) {
            if (material == null) {
                costType = defaultCostType;
                if (costType == null || costType == CostType.DISABLED) {
                    LocalUtils.logp("Material por payment is not available! Disabling economy support..");
                    return null;
                }
                LocalUtils.logp("Material for payment is not valid. Switched to '" + costType.name() + "' type!");
            } else {
                LocalUtils.logp("Material for payment is '" + material.name() + "'!");
            }
        }
        switch (costType) {
            case PLAYER_POINTS: {
                return new PlayerPointsHook(PlayerPoints.getInstance().getAPI());
            }
            case TOKEN_MANAGER: {
                return new TokenManagerHook((TokenManagerPlugin)Bukkit.getPluginManager().getPlugin("TokenManager"));
            }
            case VAULT: {
                return new VaultHook(AlonsoTags.getInstance().economy);
            }
            case MATERIAL: {
                return new MaterialHook(material);
            }
            case LEVEL: {
                return new LevelsHook();
            }
        }
        return null;
    }
}

