/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.listeners;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatListener
implements Listener {
    private AlonsoTags plugin;
    private Pattern BRACKET_PLACEHOLDER_PATTERN = Pattern.compile("[{]([^{}]+)[}]");
    private boolean registered = false;
    private String respectMyWork = "%%__USER__%%";

    public ChatListener(AlonsoTags alonsoTags) {
        this.plugin = alonsoTags;
        this.reloadMessages();
    }

    public void reloadMessages() {
        if (this.plugin.chatCompatibility) {
            this.BRACKET_PLACEHOLDER_PATTERN = PlaceholderAPI.getBracketPlaceholderPattern();
            if (!this.registered) {
                LocalUtils.logp("Enabling compatibility with chat plugins that don't support PlaceholderAPI..");
                LocalUtils.logp("Make sure you only enable this if necessary and once only. (Not in all my plugins)");
                this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
                this.registered = true;
            }
        } else if (this.registered) {
            AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this);
            this.registered = false;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Matcher matcher = this.BRACKET_PLACEHOLDER_PATTERN.matcher(asyncPlayerChatEvent.getFormat());
        if (matcher.find()) {
            asyncPlayerChatEvent.setFormat(PlaceholderAPI.setBracketPlaceholders((Player)asyncPlayerChatEvent.getPlayer(), (String)asyncPlayerChatEvent.getFormat()));
        }
    }
}

