/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.listeners;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.api.events.PlayerRegisterEvent;
import com.alonsoaliaga.alonsotags.others.ColorData;
import com.alonsoaliaga.alonsotags.others.PlayerData;
import com.alonsoaliaga.alonsotags.others.TagData;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ConnectionListener
implements Listener {
    private AlonsoTags plugin;
    public HashMap<UUID, BukkitTask> loadingProcess = new HashMap();

    public ConnectionListener(AlonsoTags alonsoTags) {
        this.plugin = alonsoTags;
        alonsoTags.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)alonsoTags);
        this.reloadMessages();
    }

    public void reloadMessages() {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        if (this.plugin.joinDelay == 0) {
            if (playerJoinEvent.getPlayer().isOnline()) {
                this.loadPlayer(playerJoinEvent.getPlayer());
            }
        } else {
            if (this.loadingProcess.containsKey(playerJoinEvent.getPlayer().getUniqueId())) {
                this.loadingProcess.remove(playerJoinEvent.getPlayer().getUniqueId()).cancel();
            }
            this.loadingProcess.put(playerJoinEvent.getPlayer().getUniqueId(), Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
                if (playerJoinEvent.getPlayer().isOnline()) {
                    this.loadPlayerSync(playerJoinEvent.getPlayer());
                }
                this.loadingProcess.remove(playerJoinEvent.getPlayer().getUniqueId());
            }, (long)this.plugin.joinDelay));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        PlayerData playerData;
        if (this.loadingProcess.containsKey(playerQuitEvent.getPlayer().getUniqueId())) {
            this.loadingProcess.remove(playerQuitEvent.getPlayer().getUniqueId()).cancel();
        }
        if (this.plugin.getDataMap().containsKey(playerQuitEvent.getPlayer().getUniqueId()) && (playerData = this.plugin.getDataMap().get(playerQuitEvent.getPlayer().getUniqueId())).isModified()) {
            this.savePlayer(playerData);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuitRemove(PlayerQuitEvent playerQuitEvent) {
        this.plugin.getDataMap().remove(playerQuitEvent.getPlayer().getUniqueId());
    }

    public void loadPlayer(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (this.plugin.hikariEnabled) {
                try (Connection connection = this.plugin.getDatabase().getConnection(false);){
                    PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.plugin.getDatabase().getTable() + " WHERE uuid=?");
                    preparedStatement.setString(1, player.getUniqueId().toString());
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        String string = resultSet.getString("selected_tag");
                        String string2 = resultSet.getString("playername");
                        String string3 = resultSet.getString("purchased_tags");
                        String string4 = resultSet.getString("selected_color");
                        int n = resultSet.getInt("selected_filter");
                        boolean bl = n == 0 || !LocalUtils.hasPermission((CommandSender)player, this.plugin.permissions.filterPermission);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (string3.length() > 0) {
                            Collections.addAll(arrayList, string3.split(","));
                        }
                        if (string.equalsIgnoreCase("none")) {
                            PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                            if (!player.getName().equals(string2)) {
                                playerData.markModified();
                            }
                            this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                        } else if (this.plugin.getTagsMap().containsKey(string)) {
                            TagData tagData = this.plugin.getTagsMap().get(string);
                            ColorData colorData = this.plugin.getColorsMap().get(string4);
                            if (!arrayList.contains(tagData.getTagIdentifier()) && tagData.hasPermission() && !player.hasPermission(tagData.getPermission())) {
                                PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                                playerData.markModified();
                                this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                            } else {
                                Object object;
                                String string5 = tagData.getTag();
                                String string6 = tagData.getRecognitionTitle();
                                boolean bl2 = false;
                                if (tagData.isDyeable()) {
                                    if (colorData == null) {
                                        string5 = string5.replace("{COLOR}", tagData.getDefaultColor());
                                        string6 = string6.replace("{COLOR}", tagData.getDefaultColor());
                                    } else if (!colorData.hasPermission() || player.hasPermission(colorData.getPermission())) {
                                        object = colorData.isDefaultColor() ? tagData.getDefaultColor() : colorData.getColor();
                                        string5 = string5.replace("{COLOR}", (CharSequence)object);
                                        string6 = string6.replace("{COLOR}", (CharSequence)object);
                                    } else {
                                        colorData = null;
                                        bl2 = true;
                                        string5 = string5.replace("{COLOR}", tagData.getDefaultColor());
                                        string6 = string6.replace("{COLOR}", tagData.getDefaultColor());
                                    }
                                } else if (colorData == null || !colorData.getColorIdentifier().equals("default")) {
                                    colorData = null;
                                    bl2 = true;
                                }
                                object = new PlayerData(player, tagData.getTagIdentifier(), string5, string6, colorData == null ? "default" : colorData.getColorIdentifier(), colorData == null ? "" : colorData.getColor(), bl, arrayList);
                                if (!player.getName().equals(string2) || bl2) {
                                    ((PlayerData)object).markModified();
                                }
                                this.plugin.getDataMap().put(player.getUniqueId(), (PlayerData)object);
                            }
                        } else {
                            PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                            playerData.markModified();
                            this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("&aSuccessfully loaded player '" + player.getName() + "' from database!");
                        }
                    } else {
                        this.registerPlayer(player);
                    }
                }
                catch (SQLException sQLException) {
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("&cCouldn't load player '" + player.getName() + "' from database!");
                    }
                    sQLException.printStackTrace();
                }
            } else {
                try {
                    PreparedStatement preparedStatement = this.plugin.getDatabase().getConnection(false).prepareStatement("SELECT * FROM " + this.plugin.getDatabase().getTable() + " WHERE uuid=?");
                    preparedStatement.setString(1, player.getUniqueId().toString());
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        String string = resultSet.getString("selected_tag");
                        String string7 = resultSet.getString("playername");
                        String string8 = resultSet.getString("purchased_tags");
                        String string9 = resultSet.getString("selected_color");
                        int n = resultSet.getInt("selected_filter");
                        boolean bl = n == 0 || !LocalUtils.hasPermission((CommandSender)player, this.plugin.permissions.filterPermission);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (string8.length() > 0) {
                            Collections.addAll(arrayList, string8.split(","));
                        }
                        if (string.equalsIgnoreCase("none")) {
                            PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                            if (!player.getName().equals(string7)) {
                                playerData.markModified();
                            }
                            this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                        } else if (this.plugin.getTagsMap().containsKey(string)) {
                            TagData tagData = this.plugin.getTagsMap().get(string);
                            ColorData colorData = this.plugin.getColorsMap().get(string9);
                            if (!arrayList.contains(tagData.getTagIdentifier()) && tagData.hasPermission() && !player.hasPermission(tagData.getPermission())) {
                                PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                                playerData.markModified();
                                this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                            } else {
                                Object object;
                                String string10 = tagData.getTag();
                                String string11 = tagData.getRecognitionTitle();
                                boolean bl3 = false;
                                if (tagData.isDyeable()) {
                                    if (colorData == null) {
                                        string10 = string10.replace("{COLOR}", tagData.getDefaultColor());
                                        string11 = string11.replace("{COLOR}", tagData.getDefaultColor());
                                    } else if (!colorData.hasPermission() || player.hasPermission(colorData.getPermission())) {
                                        object = colorData.isDefaultColor() ? tagData.getDefaultColor() : colorData.getColor();
                                        string10 = string10.replace("{COLOR}", (CharSequence)object);
                                        string11 = string11.replace("{COLOR}", (CharSequence)object);
                                    } else {
                                        colorData = null;
                                        bl3 = true;
                                        string10 = string10.replace("{COLOR}", tagData.getDefaultColor());
                                        string11 = string11.replace("{COLOR}", tagData.getDefaultColor());
                                    }
                                } else if (colorData == null || !colorData.getColorIdentifier().equals("default")) {
                                    colorData = null;
                                    bl3 = true;
                                }
                                object = new PlayerData(player, tagData.getTagIdentifier(), string10, string11, colorData == null ? "default" : colorData.getColorIdentifier(), colorData == null ? "" : colorData.getColor(), bl, arrayList);
                                if (!player.getName().equals(string7) || bl3) {
                                    ((PlayerData)object).markModified();
                                }
                                this.plugin.getDataMap().put(player.getUniqueId(), (PlayerData)object);
                            }
                        } else {
                            PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                            playerData.markModified();
                            this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("&aSuccessfully loaded player '" + player.getName() + "' from database!");
                        }
                    } else {
                        this.registerPlayer(player);
                    }
                }
                catch (SQLException sQLException) {
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("&cCouldn't load player '" + player.getName() + "' from database!");
                    }
                    sQLException.printStackTrace();
                }
            }
        });
    }

    public void loadPlayerSync(Player player) {
        if (this.plugin.hikariEnabled) {
            try (Connection connection = this.plugin.getDatabase().getConnection(false);){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.plugin.getDatabase().getTable() + " WHERE uuid=?");
                preparedStatement.setString(1, player.getUniqueId().toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    String string = resultSet.getString("selected_tag");
                    String string2 = resultSet.getString("playername");
                    String string3 = resultSet.getString("purchased_tags");
                    String string4 = resultSet.getString("selected_color");
                    int n = resultSet.getInt("selected_filter");
                    boolean bl = n == 0 || !LocalUtils.hasPermission((CommandSender)player, this.plugin.permissions.filterPermission);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (string3.length() > 0) {
                        Collections.addAll(arrayList, string3.split(","));
                    }
                    if (string.equalsIgnoreCase("none")) {
                        PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                        if (!player.getName().equals(string2)) {
                            playerData.markModified();
                        }
                        this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                    } else if (this.plugin.getTagsMap().containsKey(string)) {
                        TagData tagData = this.plugin.getTagsMap().get(string);
                        ColorData colorData = this.plugin.getColorsMap().get(string4);
                        if (!arrayList.contains(tagData.getTagIdentifier()) && tagData.hasPermission() && !player.hasPermission(tagData.getPermission())) {
                            PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                            playerData.markModified();
                            this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                        } else {
                            Object object;
                            String string5 = tagData.getTag();
                            String string6 = tagData.getRecognitionTitle();
                            boolean bl2 = false;
                            if (tagData.isDyeable()) {
                                if (colorData == null) {
                                    string5 = string5.replace("{COLOR}", tagData.getDefaultColor());
                                    string6 = string6.replace("{COLOR}", tagData.getDefaultColor());
                                } else if (!colorData.hasPermission() || player.hasPermission(colorData.getPermission())) {
                                    object = colorData.isDefaultColor() ? tagData.getDefaultColor() : colorData.getColor();
                                    string5 = string5.replace("{COLOR}", (CharSequence)object);
                                    string6 = string6.replace("{COLOR}", (CharSequence)object);
                                } else {
                                    colorData = null;
                                    bl2 = true;
                                    string5 = string5.replace("{COLOR}", tagData.getDefaultColor());
                                    string6 = string6.replace("{COLOR}", tagData.getDefaultColor());
                                }
                            } else if (colorData == null || !colorData.getColorIdentifier().equals("default")) {
                                colorData = null;
                                bl2 = true;
                            }
                            object = new PlayerData(player, tagData.getTagIdentifier(), string5, string6, colorData == null ? "default" : colorData.getColorIdentifier(), colorData == null ? "" : colorData.getColor(), bl, arrayList);
                            if (!player.getName().equals(string2) || bl2) {
                                ((PlayerData)object).markModified();
                            }
                            this.plugin.getDataMap().put(player.getUniqueId(), (PlayerData)object);
                        }
                    } else {
                        PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                        playerData.markModified();
                        this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                    }
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("&aSuccessfully loaded player '" + player.getName() + "' from database!");
                    }
                } else {
                    this.registerPlayer(player);
                }
            }
            catch (SQLException sQLException) {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&cCouldn't load player '" + player.getName() + "' from database!");
                }
                sQLException.printStackTrace();
            }
        } else {
            try {
                PreparedStatement preparedStatement = this.plugin.getDatabase().getConnection(false).prepareStatement("SELECT * FROM " + this.plugin.getDatabase().getTable() + " WHERE uuid=?");
                preparedStatement.setString(1, player.getUniqueId().toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    String string = resultSet.getString("selected_tag");
                    String string7 = resultSet.getString("playername");
                    String string8 = resultSet.getString("purchased_tags");
                    String string9 = resultSet.getString("selected_color");
                    int n = resultSet.getInt("selected_filter");
                    boolean bl = n == 0 || !LocalUtils.hasPermission((CommandSender)player, this.plugin.permissions.filterPermission);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (string8.length() > 0) {
                        Collections.addAll(arrayList, string8.split(","));
                    }
                    if (string.equalsIgnoreCase("none")) {
                        PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                        if (!player.getName().equals(string7)) {
                            playerData.markModified();
                        }
                        this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                    } else if (this.plugin.getTagsMap().containsKey(string)) {
                        TagData tagData = this.plugin.getTagsMap().get(string);
                        ColorData colorData = this.plugin.getColorsMap().get(string9);
                        if (!arrayList.contains(tagData.getTagIdentifier()) && tagData.hasPermission() && !player.hasPermission(tagData.getPermission())) {
                            PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                            playerData.markModified();
                            this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                        } else {
                            Object object;
                            String string10 = tagData.getTag();
                            String string11 = tagData.getRecognitionTitle();
                            boolean bl3 = false;
                            if (tagData.isDyeable()) {
                                if (colorData == null) {
                                    string10 = string10.replace("{COLOR}", tagData.getDefaultColor());
                                    string11 = string11.replace("{COLOR}", tagData.getDefaultColor());
                                } else if (!colorData.hasPermission() || player.hasPermission(colorData.getPermission())) {
                                    object = colorData.isDefaultColor() ? tagData.getDefaultColor() : colorData.getColor();
                                    string10 = string10.replace("{COLOR}", (CharSequence)object);
                                    string11 = string11.replace("{COLOR}", (CharSequence)object);
                                } else {
                                    colorData = null;
                                    bl3 = true;
                                    string10 = string10.replace("{COLOR}", tagData.getDefaultColor());
                                    string11 = string11.replace("{COLOR}", tagData.getDefaultColor());
                                }
                            } else if (colorData == null || !colorData.getColorIdentifier().equals("default")) {
                                colorData = null;
                                bl3 = true;
                            }
                            object = new PlayerData(player, tagData.getTagIdentifier(), string10, string11, colorData == null ? "default" : colorData.getColorIdentifier(), colorData == null ? "" : colorData.getColor(), bl, arrayList);
                            if (!player.getName().equals(string7) || bl3) {
                                ((PlayerData)object).markModified();
                            }
                            this.plugin.getDataMap().put(player.getUniqueId(), (PlayerData)object);
                        }
                    } else {
                        PlayerData playerData = new PlayerData(player, null, null, "", null, "", bl, arrayList);
                        playerData.markModified();
                        this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                    }
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("&aSuccessfully loaded player '" + player.getName() + "' from database!");
                    }
                } else {
                    this.registerPlayer(player);
                }
            }
            catch (SQLException sQLException) {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&cCouldn't load player '" + player.getName() + "' from database!");
                }
                sQLException.printStackTrace();
            }
        }
    }

    public void loadPlayerUnused(Player player) {
        try {
            PreparedStatement preparedStatement = this.plugin.getDatabase().getConnection(false).prepareStatement("SELECT * FROM " + this.plugin.getDatabase().getTable() + " WHERE uuid=?");
            preparedStatement.setString(1, player.getUniqueId().toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString("selected_tag");
                String string2 = resultSet.getString("playername");
                String string3 = resultSet.getString("purchased_tags");
                int n = resultSet.getInt("selected_filter");
                ArrayList<String> arrayList = new ArrayList<String>();
                if (string3.length() > 0) {
                    Collections.addAll(arrayList, string3.split(","));
                }
                if (string.equalsIgnoreCase("none")) {
                    PlayerData playerData = new PlayerData(player, null, null, "", "default", "", n == 0, arrayList);
                    if (!player.getName().equals(string2)) {
                        playerData.markModified();
                    }
                    this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                } else if (this.plugin.getTagsMap().containsKey(string)) {
                    TagData tagData = this.plugin.getTagsMap().get(string);
                    PlayerData playerData = new PlayerData(player, tagData.getTagIdentifier(), tagData.getTag(), tagData.getRecognitionTitle(), "default", "", n == 0, arrayList);
                    if (!player.getName().equals(string2)) {
                        playerData.markModified();
                    }
                    this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                } else {
                    PlayerData playerData = new PlayerData(player, null, null, "", "default", "", n == 0, arrayList);
                    playerData.markModified();
                    this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                }
            } else {
                this.registerPlayer(player);
                return;
            }
            if (this.plugin.debugMode) {
                LocalUtils.logp("&aSuccessfully loaded player '" + player.getName() + "' from database!");
            }
        }
        catch (SQLException sQLException) {
            LocalUtils.logp("&cCouldn't load player '" + player.getName() + "' from database!");
            sQLException.printStackTrace();
        }
    }

    public void savePlayer(PlayerData playerData) {
        Object object;
        String string = "none";
        String string2 = "default";
        if (playerData.hasEnabledTag() && this.plugin.getTagsMap().containsKey(playerData.getEnabledTag())) {
            if (playerData.getPurchasedTags().contains(playerData.getEnabledTag())) {
                string = playerData.getEnabledTag();
            } else {
                object = this.plugin.getTagsMap().get(playerData.getEnabledTag());
                if (!((TagData)object).hasPermission() || playerData.getPlayer().hasPermission(((TagData)object).getPermission())) {
                    string = playerData.getEnabledTag();
                }
            }
        }
        if (playerData.hasEnabledColor() && this.plugin.getColorsMap().containsKey(playerData.getEnabledColor()) && (!((ColorData)(object = this.plugin.getColorsMap().get(playerData.getEnabledColor()))).hasPermission() || playerData.getPlayer().hasPermission(((ColorData)object).getPermission()))) {
            string2 = playerData.getEnabledColor();
        }
        object = string;
        String string3 = string2;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.lambda$savePlayer$2(playerData, (String)object, string3));
    }

    public void savePlayerWithConnection(Connection connection, PlayerData playerData) {
        Object object;
        PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.plugin.getDatabase().getTable() + " SET playername=?,selected_tag=?,purchased_tags=?,selected_color=?,selected_filter=? WHERE uuid=?");
        String string = "none";
        String string2 = "default";
        if (playerData.hasEnabledTag() && this.plugin.getTagsMap().containsKey(playerData.getEnabledTag())) {
            if (playerData.getPurchasedTags().contains(playerData.getEnabledTag())) {
                string = playerData.getEnabledTag();
            } else {
                object = this.plugin.getTagsMap().get(playerData.getEnabledTag());
                if (!((TagData)object).hasPermission() || playerData.getPlayer().hasPermission(((TagData)object).getPermission())) {
                    string = playerData.getEnabledTag();
                }
            }
        }
        if (playerData.hasEnabledColor() && this.plugin.getColorsMap().containsKey(playerData.getEnabledColor()) && (!((ColorData)(object = this.plugin.getColorsMap().get(playerData.getEnabledColor()))).hasPermission() || playerData.getPlayer().hasPermission(((ColorData)object).getPermission()))) {
            string2 = playerData.getEnabledColor();
        }
        preparedStatement.setString(1, playerData.getPlayer().getName());
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, playerData.getPurchasedTags().isEmpty() ? "" : String.join((CharSequence)",", playerData.getPurchasedTags()));
        preparedStatement.setString(4, string2);
        preparedStatement.setInt(5, playerData.hasAllTagsMode() ? 0 : 1);
        preparedStatement.setString(6, playerData.getPlayer().getUniqueId().toString());
        preparedStatement.executeUpdate();
        playerData.markUpdated();
        if (this.plugin.debugMode) {
            LocalUtils.logp("&aSuccessfully saved player '" + playerData.getPlayer().getName() + "' in database!");
        }
    }

    public void savePlayerSync(PlayerData playerData) {
        if (this.plugin.hikariEnabled) {
            try (Connection connection = this.plugin.getDatabase().getConnection(false);){
                Object object;
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.plugin.getDatabase().getTable() + " SET playername=?,selected_tag=?,purchased_tags=?,selected_color=?,selected_filter=? WHERE uuid=?");
                String string = "none";
                String string2 = "default";
                if (playerData.hasEnabledTag() && this.plugin.getTagsMap().containsKey(playerData.getEnabledTag())) {
                    if (playerData.getPurchasedTags().contains(playerData.getEnabledTag())) {
                        string = playerData.getEnabledTag();
                    } else {
                        object = this.plugin.getTagsMap().get(playerData.getEnabledTag());
                        if (!((TagData)object).hasPermission() || playerData.getPlayer().hasPermission(((TagData)object).getPermission())) {
                            string = playerData.getEnabledTag();
                        }
                    }
                }
                if (playerData.hasEnabledColor() && this.plugin.getColorsMap().containsKey(playerData.getEnabledColor()) && (!((ColorData)(object = this.plugin.getColorsMap().get(playerData.getEnabledColor()))).hasPermission() || playerData.getPlayer().hasPermission(((ColorData)object).getPermission()))) {
                    string2 = playerData.getEnabledColor();
                }
                preparedStatement.setString(1, playerData.getPlayer().getName());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, playerData.getPurchasedTags().isEmpty() ? "" : String.join((CharSequence)",", playerData.getPurchasedTags()));
                preparedStatement.setString(4, string2);
                preparedStatement.setInt(5, playerData.hasAllTagsMode() ? 0 : 1);
                preparedStatement.setString(6, playerData.getPlayer().getUniqueId().toString());
                preparedStatement.executeUpdate();
                playerData.markUpdated();
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&aSuccessfully saved player '" + playerData.getPlayer().getName() + "' in database!");
                }
            }
            catch (SQLException sQLException) {
                LocalUtils.logp("&cCouldn't save player '" + playerData.getPlayer().getName() + "' in database!");
                sQLException.printStackTrace();
            }
        } else {
            try {
                Object object;
                PreparedStatement preparedStatement = this.plugin.getDatabase().getConnection(false).prepareStatement("UPDATE " + this.plugin.getDatabase().getTable() + " SET playername=?,selected_tag=?,purchased_tags=?,selected_color=?,selected_filter=? WHERE uuid=?");
                String string = "none";
                String string3 = "default";
                if (playerData.hasEnabledTag() && this.plugin.getTagsMap().containsKey(playerData.getEnabledTag())) {
                    if (playerData.getPurchasedTags().contains(playerData.getEnabledTag())) {
                        string = playerData.getEnabledTag();
                    } else {
                        object = this.plugin.getTagsMap().get(playerData.getEnabledTag());
                        if (!((TagData)object).hasPermission() || playerData.getPlayer().hasPermission(((TagData)object).getPermission())) {
                            string = playerData.getEnabledTag();
                        }
                    }
                }
                if (playerData.hasEnabledColor() && this.plugin.getColorsMap().containsKey(playerData.getEnabledColor()) && (!((ColorData)(object = this.plugin.getColorsMap().get(playerData.getEnabledColor()))).hasPermission() || playerData.getPlayer().hasPermission(((ColorData)object).getPermission()))) {
                    string3 = playerData.getEnabledColor();
                }
                preparedStatement.setString(1, playerData.getPlayer().getName());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, playerData.getPurchasedTags().isEmpty() ? "" : String.join((CharSequence)",", playerData.getPurchasedTags()));
                preparedStatement.setString(4, string3);
                preparedStatement.setInt(5, playerData.hasAllTagsMode() ? 0 : 1);
                preparedStatement.setString(6, playerData.getPlayer().getUniqueId().toString());
                preparedStatement.executeUpdate();
                playerData.markUpdated();
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&aSuccessfully saved player '" + playerData.getPlayer().getName() + "' in database!");
                }
            }
            catch (SQLException sQLException) {
                LocalUtils.logp("&cCouldn't save player '" + playerData.getPlayer().getName() + "' in database!");
                sQLException.printStackTrace();
            }
        }
    }

    private void registerPlayer(Player player) {
        if (this.plugin.hikariEnabled) {
            try (Connection connection = this.plugin.getDatabase().getConnection(false);){
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + this.plugin.getDatabase().getTable() + " (uuid,playername) VALUES (?,?)");
                preparedStatement.setString(1, player.getUniqueId().toString());
                preparedStatement.setString(2, player.getName());
                preparedStatement.execute();
                this.plugin.getDataMap().put(player.getUniqueId(), new PlayerData(player, null, null, "", "default", "", true, new ArrayList<String>()));
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&aSuccessfully registered player '" + player.getName() + "' in database!");
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    PlayerRegisterEvent playerRegisterEvent = new PlayerRegisterEvent(player);
                    Bukkit.getPluginManager().callEvent((Event)playerRegisterEvent);
                });
            }
            catch (SQLException sQLException) {
                LocalUtils.logp("&cCouldn't register player '" + player.getName() + "' in database!");
                sQLException.printStackTrace();
            }
        } else {
            try {
                PreparedStatement preparedStatement = this.plugin.getDatabase().getConnection(false).prepareStatement("INSERT INTO " + this.plugin.getDatabase().getTable() + " (uuid,playername) VALUES (?,?)");
                preparedStatement.setString(1, player.getUniqueId().toString());
                preparedStatement.setString(2, player.getName());
                preparedStatement.execute();
                this.plugin.getDataMap().put(player.getUniqueId(), new PlayerData(player, null, null, "", "default", "", true, new ArrayList<String>()));
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&aSuccessfully registered player '" + player.getName() + "' in database!");
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    PlayerRegisterEvent playerRegisterEvent = new PlayerRegisterEvent(player);
                    Bukkit.getPluginManager().callEvent((Event)playerRegisterEvent);
                });
            }
            catch (SQLException sQLException) {
                LocalUtils.logp("&cCouldn't register player '" + player.getName() + "' in database!");
                sQLException.printStackTrace();
            }
        }
    }

    private /* synthetic */ void lambda$savePlayer$2(PlayerData playerData, String string, String string2) {
        if (this.plugin.hikariEnabled) {
            try (Connection connection = this.plugin.getDatabase().getConnection(false);){
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.plugin.getDatabase().getTable() + " SET playername=?,selected_tag=?,purchased_tags=?,selected_color=?,selected_filter=? WHERE uuid=?");
                preparedStatement.setString(1, playerData.getPlayer().getName());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, playerData.getPurchasedTags().isEmpty() ? "" : String.join((CharSequence)",", playerData.getPurchasedTags()));
                preparedStatement.setString(4, string2);
                preparedStatement.setInt(5, playerData.hasAllTagsMode() ? 0 : 1);
                preparedStatement.setString(6, playerData.getPlayer().getUniqueId().toString());
                preparedStatement.executeUpdate();
                playerData.markUpdated();
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&aSuccessfully saved player '" + playerData.getPlayer().getName() + "' in database!");
                }
            }
            catch (SQLException sQLException) {
                LocalUtils.logp("&cCouldn't save player '" + playerData.getPlayer().getName() + "' in database!");
                sQLException.printStackTrace();
            }
        } else {
            try {
                PreparedStatement preparedStatement = this.plugin.getDatabase().getConnection(false).prepareStatement("UPDATE " + this.plugin.getDatabase().getTable() + " SET playername=?,selected_tag=?,purchased_tags=?,selected_color=?,selected_filter=? WHERE uuid=?");
                preparedStatement.setString(1, playerData.getPlayer().getName());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, playerData.getPurchasedTags().isEmpty() ? "" : String.join((CharSequence)",", playerData.getPurchasedTags()));
                preparedStatement.setString(4, string2);
                preparedStatement.setInt(5, playerData.hasAllTagsMode() ? 0 : 1);
                preparedStatement.setString(6, playerData.getPlayer().getUniqueId().toString());
                preparedStatement.executeUpdate();
                playerData.markUpdated();
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&aSuccessfully saved player '" + playerData.getPlayer().getName() + "' in database!");
                }
            }
            catch (SQLException sQLException) {
                LocalUtils.logp("&cCouldn't save player '" + playerData.getPlayer().getName() + "' in database!");
                sQLException.printStackTrace();
            }
        }
    }
}

