/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.others;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.libraries.hikari.HikariConfig;
import com.alonsoaliaga.alonsotags.libraries.hikari.HikariDataSource;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class Database {
    public static String SQLITE_PLAYERS_QUERY = "uuid VARCHAR(36) PRIMARY KEY,playername VARCHAR(36) DEFAULT 'Unknown',selected_tag VARCHAR(36) DEFAULT 'none',purchased_tags VARCHAR(3000) DEFAULT '',selected_color VARCHAR(50) DEFAULT 'default',selected_filter INTEGER DEFAULT 0";
    public static String MYSQL_PLAYERS_QUERY = "uuid VARCHAR(36) PRIMARY KEY,playername VARCHAR(36) DEFAULT 'Unknown',selected_tag VARCHAR(36) DEFAULT 'none',purchased_tags VARCHAR(3000) DEFAULT '',selected_color VARCHAR(50) DEFAULT 'default',selected_filter INTEGER DEFAULT 0";
    public static String defaultDriver = null;

    static {
        try {
            Class.forName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
            defaultDriver = "com.mysql.jdbc.jdbc2.optional.MysqlDataSource";
            LocalUtils.logp("[HikariCP] Using " + defaultDriver + " for source class name..");
        }
        catch (Throwable throwable) {
            try {
                Class.forName("com.mysql.cj.jdbc.MysqlDataSource");
                defaultDriver = "com.mysql.cj.jdbc.MysqlDataSource";
                LocalUtils.logp("[HikariCP] Using " + defaultDriver + " for source class name..");
            }
            catch (Throwable throwable2) {
                LocalUtils.logp("[HikariCP] Couldn't find exact path for 'MysqlDataSource'. HikariCP (if enabled) won't specify source class name..");
                LocalUtils.logp("[HikariCP] MySQL might NOT work if selected. Please modify 'Database.HikariCP.Custom-source-class-name' to the available one.");
                LocalUtils.logp("[HikariCP] For more information about Source class names go to https://alonsoaliaga.com/HikariCP-cn");
                LocalUtils.logp("[HikariCP] If you have issues with MySQL please join our server on https://alonsoaliaga.com/discord");
            }
        }
    }

    public class HikariCP
    implements Data {
        private String host;
        private String database;
        private String username;
        private String password;
        private String table;
        private String query;
        private int port;
        private AlonsoTags plugin;
        private HikariDataSource dataSource = null;

        public HikariCP(AlonsoTags alonsoTags) {
            this.plugin = alonsoTags;
            this.table = alonsoTags.getFiles().getConfig().get().getString("Database.Table");
            this.query = MYSQL_PLAYERS_QUERY;
            this.firstConnection();
        }

        @Override
        public Connection getConnection(boolean bl) {
            return this.dataSource.getConnection();
        }

        @Override
        public String getTable() {
            return this.table;
        }

        @Override
        public void closeConnection(boolean bl) {
            if (bl) {
                LocalUtils.logp("[MySQL] Forcing connection close..");
            }
            if (this.dataSource != null && !this.dataSource.isClosed()) {
                this.dataSource.close();
            }
        }

        @Override
        public void firstConnection() {
            Object object;
            String string;
            this.host = this.plugin.getFiles().getConfig().get().getString("Database.Host");
            this.port = this.plugin.getFiles().getConfig().get().getInt("Database.Port");
            this.database = this.plugin.getFiles().getConfig().get().getString("Database.Database");
            this.username = this.plugin.getFiles().getConfig().get().getString("Database.Username");
            this.password = this.plugin.getFiles().getConfig().get().getString("Database.Password", "ignore");
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setConnectionTestQuery("SELECT 1");
            hikariConfig.setMaximumPoolSize(Math.max(1, this.plugin.getFiles().getConfig().get().getInt("Database.HikariCP.Max-pool-size", 3)));
            String string2 = this.plugin.getFiles().getConfig().get().getString("Database.Type", "sqlite");
            if (string2.equalsIgnoreCase("mysql") || string2.equalsIgnoreCase("hikaricp")) {
                string = this.plugin.getFiles().getConfig().get().getString("Database.HikariCP.Custom-source-class-name", "default");
                if (string.equals("default")) {
                    if (defaultDriver != null) {
                        hikariConfig.setDataSourceClassName(defaultDriver);
                    }
                } else {
                    hikariConfig.setDataSourceClassName(string);
                }
                hikariConfig.addDataSourceProperty("serverName", this.host);
                hikariConfig.addDataSourceProperty("port", this.port + "");
                hikariConfig.addDataSourceProperty("databaseName", this.database);
                hikariConfig.addDataSourceProperty("user", this.username);
                if (!this.password.equals("ignore")) {
                    hikariConfig.addDataSourceProperty("password", this.password);
                }
            } else {
                string = this.plugin.getFiles().getConfig().get().getString("Database.File");
                this.database = string.endsWith(".db") ? string : string + ".db";
                object = "jdbc:sqlite:" + this.plugin.getDataFolder() + File.separator + this.database;
                hikariConfig.setDriverClassName("org.sqlite.JDBC");
                hikariConfig.setJdbcUrl((String)object);
            }
            string = this.plugin.getFiles().getConfig().get().getConfigurationSection("Database.HikariCP.Source-properties");
            if (string != null) {
                for (Object object2 : string.getKeys(false)) {
                    Object object3 = string.get((String)object2);
                    hikariConfig.addDataSourceProperty((String)object2, object3);
                }
            }
            this.dataSource = new HikariDataSource(hikariConfig);
            try {
                LocalUtils.logp(String.format("[HikariCP] Attempting to create '%s' table..", this.table));
                object = this.getConnection(true).prepareStatement(String.format("CREATE TABLE IF NOT EXISTS %s (%s)", this.table, this.query));
                object.executeUpdate();
                LocalUtils.logp(String.format("[HikariCP] Table '%s' has been created if didn't exist.", this.table));
            }
            catch (SQLException sQLException) {
                LocalUtils.log(String.format("&c%s[HikariCP] Error creating '%s' table.", "[AlonsoTags] ", this.table));
                sQLException.printStackTrace();
            }
            try {
                object = this.dataSource.getConnection();
                try {
                    Object object2;
                    object2 = object.getMetaData();
                    LocalUtils.log(String.format("[HikariCP] Driver available: %s | %s", object2.getDriverName(), object2.getDatabaseProductVersion()));
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            catch (Throwable throwable) {
                LocalUtils.log(String.format("[HikariCP] Error getting drive name and version: %s", throwable.getMessage()));
            }
        }
    }

    public class MySQL
    implements Data {
        private Connection connection;
        private String host;
        private String database;
        private String username;
        private String password;
        private String table;
        private String query;
        private int port;
        private String additionalQuery;
        private AlonsoTags plugin;

        public MySQL(AlonsoTags alonsoTags) {
            this.plugin = alonsoTags;
            this.table = alonsoTags.getFiles().getConfig().get().getString("Database.Table");
            this.query = MYSQL_PLAYERS_QUERY;
            this.additionalQuery = alonsoTags.getFiles().getConfig().get().getString("Database.Additional-url", "");
            this.firstConnection();
        }

        @Override
        public Connection getConnection(boolean bl) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    block9: {
                        Class.forName("com.mysql.jdbc.Driver");
                        if (bl) {
                            LocalUtils.logp("[MySQL] Attempting to connect to database..");
                        }
                        this.connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s%s", this.host, this.port, this.database, this.additionalQuery), this.username, this.password);
                        try {
                            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
                            if (bl) {
                                LocalUtils.log(String.format("[MySQL] Driver available: %s | %s", databaseMetaData.getDriverName(), databaseMetaData.getDatabaseProductVersion()));
                            }
                        }
                        catch (Throwable throwable) {
                            if (!bl) break block9;
                            LocalUtils.log(String.format("[MySQL] Error getting drive name and version: %s", throwable.getMessage()));
                        }
                    }
                    if (bl) {
                        LocalUtils.logp("[MySQL] Successfully connected to database!");
                    }
                }
                return this.connection;
            }
            catch (ClassNotFoundException classNotFoundException) {
                LocalUtils.logp(String.format("&c%s[MySQL] Drivers for MySQL couldn't be found!", "[AlonsoTags] "));
                classNotFoundException.printStackTrace();
                return null;
            }
            catch (SQLException sQLException) {
                LocalUtils.log(String.format("&c%s[MySQL] Error connecting to database!", "[AlonsoTags] "));
                sQLException.printStackTrace();
                return null;
            }
        }

        @Override
        public String getTable() {
            return this.table;
        }

        @Override
        public void closeConnection(boolean bl) {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
                if (bl) {
                    LocalUtils.logp("[MySQL] Forcing connection close..");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        @Override
        public void firstConnection() {
            this.host = this.plugin.getFiles().getConfig().get().getString("Database.Host");
            this.port = this.plugin.getFiles().getConfig().get().getInt("Database.Port");
            this.database = this.plugin.getFiles().getConfig().get().getString("Database.Database");
            this.username = this.plugin.getFiles().getConfig().get().getString("Database.Username");
            this.password = this.plugin.getFiles().getConfig().get().getString("Database.Password");
            try {
                LocalUtils.logp(String.format("[MySQL] Attempting to create '%s' table..", this.table));
                PreparedStatement preparedStatement = this.getConnection(true).prepareStatement(String.format("CREATE TABLE IF NOT EXISTS %s (%s)", this.table, this.query));
                preparedStatement.executeUpdate();
                LocalUtils.logp(String.format("[MySQL] Table '%s' has been created if didn't exist.", this.table));
            }
            catch (SQLException sQLException) {
                LocalUtils.log(String.format("&c%s[MySQL] Error creating '%s' table.", "[AlonsoTags] ", this.table));
                sQLException.printStackTrace();
            }
        }
    }

    public class SQLite
    implements Data {
        private AlonsoTags plugin;
        private Connection connection;
        private String database;
        private String table;
        private String url;
        private String query;
        private String additionalQuery;

        public SQLite(AlonsoTags alonsoTags) {
            this.plugin = alonsoTags;
            this.table = alonsoTags.getFiles().getConfig().get().getString("Database.Table");
            this.query = SQLITE_PLAYERS_QUERY;
            this.additionalQuery = alonsoTags.getFiles().getConfig().get().getString("Database.Additional-url", "");
            this.firstConnection();
        }

        @Override
        public Connection getConnection(boolean bl) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    block9: {
                        Class.forName("org.sqlite.JDBC");
                        if (bl) {
                            LocalUtils.log(String.format("[SQLite] Connecting to database '%s'!", this.database));
                        }
                        this.connection = DriverManager.getConnection(this.url);
                        try {
                            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
                            if (bl) {
                                LocalUtils.log(String.format("[SQLite] Driver available: %s | %s", databaseMetaData.getDriverName(), databaseMetaData.getDatabaseProductVersion()));
                            }
                        }
                        catch (Throwable throwable) {
                            if (!bl) break block9;
                            LocalUtils.log(String.format("[SQLite] Error getting drive name and version: %s", throwable.getMessage()));
                        }
                    }
                    if (bl) {
                        LocalUtils.log("[SQLite] Successfully connected to database!");
                    }
                }
                return this.connection;
            }
            catch (ClassNotFoundException classNotFoundException) {
                LocalUtils.log(String.format("&c%s[SQLite] Drivers for SQLite couldn't be found!", "[AlonsoTags] "));
                classNotFoundException.printStackTrace();
                return null;
            }
            catch (SQLException sQLException) {
                LocalUtils.log(String.format("&c%s[SQLite] Error connecting to database!", "[AlonsoTags] "));
                sQLException.printStackTrace();
                return null;
            }
        }

        @Override
        public String getTable() {
            return this.table;
        }

        @Override
        public void closeConnection(boolean bl) {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
                if (bl) {
                    LocalUtils.log("[SQLite] Forcing connection close..");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        @Override
        public void firstConnection() {
            String string = this.plugin.getFiles().getConfig().get().getString("Database.File");
            this.database = string.endsWith(".db") ? string : string + ".db";
            this.url = "jdbc:sqlite:" + this.plugin.getDataFolder() + File.separator + this.database + (this.additionalQuery.equals("?useSSL=false") ? "" : this.additionalQuery);
            try {
                LocalUtils.logp(String.format("[SQLite] Attempting to create '%s' table..", this.table));
                PreparedStatement preparedStatement = this.getConnection(true).prepareStatement(String.format("CREATE TABLE IF NOT EXISTS %s (%s)", this.table, this.query));
                preparedStatement.executeUpdate();
                LocalUtils.logp(String.format("[SQLite] Table '%s' has been created if didn't exist.", this.table));
            }
            catch (SQLException sQLException) {
                LocalUtils.log(String.format("&c%s[SQLite] Error creating '%s' table.", "[AlonsoTags] ", this.table));
                sQLException.printStackTrace();
            }
        }
    }

    public static interface Data {
        public Connection getConnection(boolean var1) throws SQLException;

        public String getTable();

        public void closeConnection(boolean var1);

        public void firstConnection();
    }
}

