/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.others;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.economy.CurrencyManager;
import com.alonsoaliaga.alonsotags.enums.ItemType;
import com.alonsoaliaga.alonsotags.enums.PurchaseType;
import com.alonsoaliaga.alonsotags.others.ColorData;
import com.alonsoaliaga.alonsotags.others.CommandData;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TagData {
    private String tagIdentifier;
    private String originalTagIdentifier;
    private String tag;
    private String recognitionTitle;
    private String tagName;
    private String defaultColor;
    private String permission;
    private int price;
    private ItemType itemType;
    private String noPermissionMessage;
    private String notEnoughMoneyMessage;
    private String dyeableMessage;
    private String rightClickToPreviewMessage;
    private List<String> description;
    private ItemStack baseItem;
    private ItemStack lockedBaseItem;
    private ItemStack lockedItem;
    private ItemStack unlockedItem;
    private ItemStack selectedItem;
    private PurchaseType purchaseType;
    private boolean dyeable;
    private boolean hideFlags;
    private CurrencyManager currencyManager;
    private List<CommandData> purchaseCommands;
    private List<CommandData> preSelectCommands;
    private List<CommandData> postSelectCommands;
    private String vaultCurrencyName = null;

    public TagData(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, ItemType itemType, String string8, String string9, ItemStack itemStack, ItemStack itemStack2, String string10, List<String> list, List<String> list2, List<String> list3, String string11, String string12, List<String> list4, PurchaseType purchaseType, CurrencyManager currencyManager, boolean bl, boolean bl2, List<CommandData> list5, List<CommandData> list6, List<CommandData> list7) {
        this.tagIdentifier = string;
        this.originalTagIdentifier = string2;
        this.tag = string3;
        this.recognitionTitle = string4;
        this.tagName = string5;
        this.defaultColor = string6;
        this.permission = string7;
        this.price = n;
        this.itemType = itemType;
        this.noPermissionMessage = string8;
        this.notEnoughMoneyMessage = string9;
        this.baseItem = itemStack;
        this.lockedBaseItem = itemStack2;
        this.dyeableMessage = string11;
        this.rightClickToPreviewMessage = string12;
        this.description = list4;
        this.purchaseType = purchaseType;
        this.currencyManager = currencyManager;
        this.dyeable = bl;
        this.hideFlags = bl2;
        this.purchaseCommands = list5;
        this.preSelectCommands = list6;
        this.postSelectCommands = list7;
        this.buildItems(string10, list, list2, list3);
    }

    public List<CommandData> getPurchaseCommands() {
        return this.purchaseCommands;
    }

    public List<CommandData> getPreSelectCommands() {
        return this.preSelectCommands;
    }

    public List<CommandData> getPostSelectCommands() {
        return this.postSelectCommands;
    }

    public String getTagName() {
        return this.tagName;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public int getPrice() {
        return this.price;
    }

    public boolean isPurchasable() {
        return this.purchaseType == PurchaseType.ECONOMY;
    }

    public CurrencyManager getCurrencyManager() {
        return this.currencyManager;
    }

    public PurchaseType getPurchaseType() {
        return this.purchaseType;
    }

    private void buildItems(String string2, List<String> list, List<String> list2, List<String> list3) {
        String string4;
        if (this.dyeable) {
            list = list.stream().map(string -> string.replace("{DYEABLE}", this.dyeableMessage)).collect(Collectors.toList());
            list2 = list2.stream().map(string -> string.replace("{DYEABLE}", this.dyeableMessage)).collect(Collectors.toList());
            list3 = list3.stream().map(string -> string.replace("{DYEABLE}", this.dyeableMessage)).collect(Collectors.toList());
        } else {
            list = list.stream().filter(string -> !string.contains("{DYEABLE}")).collect(Collectors.toList());
            list2 = list2.stream().filter(string -> !string.contains("{DYEABLE}")).collect(Collectors.toList());
            list3 = list3.stream().filter(string -> !string.contains("{DYEABLE}")).collect(Collectors.toList());
        }
        if (AlonsoTags.getInstance().previewEnabled) {
            list = list.stream().map(string -> string.replace("{RIGHT-CLICK-TO-PREVIEW-MESSAGE}", this.rightClickToPreviewMessage)).collect(Collectors.toList());
            list2 = list2.stream().map(string -> string.replace("{RIGHT-CLICK-TO-PREVIEW-MESSAGE}", this.rightClickToPreviewMessage)).collect(Collectors.toList());
            list3 = list3.stream().map(string -> string.replace("{RIGHT-CLICK-TO-PREVIEW-MESSAGE}", this.rightClickToPreviewMessage)).collect(Collectors.toList());
        } else {
            list = list.stream().filter(string -> !string.contains("{RIGHT-CLICK-TO-PREVIEW-MESSAGE}")).collect(Collectors.toList());
            list2 = list2.stream().filter(string -> !string.contains("{RIGHT-CLICK-TO-PREVIEW-MESSAGE}")).collect(Collectors.toList());
            list3 = list3.stream().filter(string -> !string.contains("{RIGHT-CLICK-TO-PREVIEW-MESSAGE}")).collect(Collectors.toList());
        }
        String string5 = this.dyeable ? this.tag.replace("{COLOR}", this.defaultColor) : this.tag;
        String string6 = string4 = this.dyeable ? this.recognitionTitle.replace("{COLOR}", this.defaultColor) : this.recognitionTitle;
        if (AlonsoTags.getInstance().obfuscateEnabled) {
            string5 = LocalUtils.setNullPlaceholders(AlonsoTags.getInstance().obfuscateTagLoreColor + LocalUtils.removeFormatting(string5));
            string4 = LocalUtils.setNullPlaceholders(AlonsoTags.getInstance().obfuscateTagLoreColor + LocalUtils.removeFormatting(string4));
        }
        ItemMeta itemMeta = (AlonsoTags.getInstance().lockedIconEnabled ? this.lockedBaseItem : this.baseItem).getItemMeta();
        itemMeta.setDisplayName(string2.replace("{COLOR}", AlonsoTags.getInstance().obfuscateEnabled ? AlonsoTags.getInstance().obfuscateDisplaynameColor : "\u00a7c"));
        String string7 = string5;
        String string8 = string4;
        itemMeta.setLore(list.stream().map(string3 -> LocalUtils.colorize(string3.replace("{TAG}", string7).replace("{RECOGNITION-TITLE}", string8).replace("{PRICE}", String.valueOf(this.price)))).collect(Collectors.toList()));
        if (this.hideFlags) {
            itemMeta.addItemFlags(ItemFlag.values());
        }
        this.lockedItem = (AlonsoTags.getInstance().lockedIconEnabled ? this.lockedBaseItem : this.baseItem).clone();
        this.lockedItem.setItemMeta(itemMeta);
        String string9 = this.dyeable ? this.tag.replace("{COLOR}", this.defaultColor) : this.tag;
        String string10 = this.dyeable ? this.recognitionTitle.replace("{COLOR}", this.defaultColor) : this.recognitionTitle;
        ItemMeta itemMeta2 = this.baseItem.getItemMeta();
        itemMeta2.setDisplayName(string2.replace("{COLOR}", this.dyeable ? this.defaultColor : ""));
        itemMeta2.setLore(list2.stream().map(string3 -> LocalUtils.colorize(string3.replace("{TAG}", string9).replace("{PRICE}", String.valueOf(this.price)).replace("{RECOGNITION-TITLE}", string10))).collect(Collectors.toList()));
        if (this.hideFlags) {
            itemMeta2.addItemFlags(ItemFlag.values());
        }
        this.unlockedItem = this.baseItem.clone();
        this.unlockedItem.setItemMeta(itemMeta2);
        ItemMeta itemMeta3 = this.baseItem.getItemMeta();
        itemMeta3.setDisplayName(string2.replace("{COLOR}", this.dyeable ? this.defaultColor : ""));
        itemMeta3.setLore(list3.stream().map(string3 -> LocalUtils.colorize(string3.replace("{TAG}", string9).replace("{PRICE}", String.valueOf(this.price)).replace("{RECOGNITION-TITLE}", string10))).collect(Collectors.toList()));
        if (this.hideFlags) {
            itemMeta3.addItemFlags(ItemFlag.values());
        }
        this.selectedItem = this.baseItem.clone();
        this.selectedItem.setItemMeta(itemMeta3);
    }

    public String getTagIdentifier() {
        return this.tagIdentifier;
    }

    public String getOriginalTagIdentifier() {
        return this.originalTagIdentifier;
    }

    public String getTag() {
        return this.tag;
    }

    public String getRecognitionTitle() {
        return this.recognitionTitle;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public String getDefaultColor() {
        return this.defaultColor;
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public boolean hasPermission(Player player) {
        return this.permission == null || player.hasPermission(this.permission);
    }

    public String getPermission() {
        return this.permission;
    }

    public String getNoPermissionMessage() {
        return this.noPermissionMessage;
    }

    public String getNotEnoughMoneyMessage() {
        return this.notEnoughMoneyMessage;
    }

    public ItemStack getLockedItem() {
        return this.lockedItem;
    }

    public ItemStack getUnlockedItem() {
        return this.unlockedItem;
    }

    public ItemStack getSelectedItem() {
        return this.selectedItem;
    }

    public boolean isDyeable() {
        return this.dyeable;
    }

    public String getPreview() {
        return this.dyeable ? this.tag.replace("{COLOR}", this.defaultColor) : this.tag;
    }

    public String getRecognitionTitlePreview() {
        return this.dyeable ? this.recognitionTitle.replace("{COLOR}", this.defaultColor) : this.recognitionTitle;
    }

    public String getPreview(ColorData colorData) {
        if (colorData == null) {
            return this.getPreview();
        }
        return this.dyeable ? this.tag.replace("{COLOR}", colorData.isDefaultColor() ? this.defaultColor : colorData.getColor()) : this.tag;
    }

    public String getRecognitionTitlePreview(ColorData colorData) {
        if (colorData == null) {
            return this.getRecognitionTitlePreview();
        }
        return this.dyeable ? this.recognitionTitle.replace("{COLOR}", colorData.isDefaultColor() ? this.defaultColor : colorData.getColor()) : this.recognitionTitle;
    }

    public void setVaultCurrencyName(String string) {
        this.vaultCurrencyName = string;
    }

    public String getVaultCurrencyName() {
        return this.vaultCurrencyName;
    }

    public void setCurrencyManager(CurrencyManager currencyManager) {
        this.currencyManager = currencyManager;
    }
}

