/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.utils;

import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import java.lang.reflect.Method;
import java.util.List;
import org.bukkit.configuration.file.FileConfigurationOptions;

public class PlatformCompatibilityUtils {
    private static boolean legacyHeaderSupport;
    private static boolean setHeaderSupport;
    private static Method setHeaderMethod;
    private static Method oldHeaderMethod;

    public static void setHeader(FileConfigurationOptions fileConfigurationOptions, List<String> list) {
        if (setHeaderSupport) {
            try {
                setHeaderMethod.invoke((Object)fileConfigurationOptions, list);
            }
            catch (Throwable throwable) {
                LocalUtils.logp("Error setting header for configuration with new method:" + throwable.getMessage());
            }
        } else if (legacyHeaderSupport) {
            try {
                oldHeaderMethod.invoke((Object)fileConfigurationOptions, String.join((CharSequence)"\n", list));
            }
            catch (Throwable throwable) {
                LocalUtils.logp("Error setting header for configuration with old method:" + throwable.getMessage());
            }
        }
    }

    static {
        setHeaderMethod = null;
        oldHeaderMethod = null;
        try {
            oldHeaderMethod = FileConfigurationOptions.class.getMethod("header", String.class);
            legacyHeaderSupport = true;
        }
        catch (Throwable throwable) {
            legacyHeaderSupport = false;
        }
        try {
            setHeaderMethod = FileConfigurationOptions.class.getMethod("setHeader", List.class);
            setHeaderSupport = true;
        }
        catch (Throwable throwable) {
            setHeaderSupport = false;
        }
    }
}

