/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.utils;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ProtocolLibUtils {
    private static AlonsoTags plugin = AlonsoTags.getInstance();
    private static int jsonType;

    public static int getProtocolActionBarMethod() {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)"Plugin made by AlonsoAliaga"));
        try {
            packetContainer.getBytes().write(0, (Object)2);
            LocalUtils.logp("ProtocolLib available for action bars. Method: '(byte)2' Hooking..");
            return 0;
        }
        catch (Throwable throwable) {
            try {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
                LocalUtils.logp("ProtocolLib available for action bars. Method: 'GAME_INFO'. Hooking..");
                return 1;
            }
            catch (Throwable throwable2) {
                LocalUtils.logp("Your version of ProtocolLib seems to be outdated. Please download latest version");
                LocalUtils.logp("to enable action bar compatibility. This is just a warning, if this plugin doesn't");
                LocalUtils.logp("use action bar to send messages just ignore this message. However remember that");
                LocalUtils.logp("you must use latest version of plugins to make sure everything works correctly.");
                LocalUtils.logp("ProtocolLib not available for action bars. Skipping..");
                return -1;
            }
        }
    }

    public static void playExplosion(Location location, int n, Collection<Player> collection) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.EXPLOSION);
        packetContainer.getModifier().writeDefaults();
        packetContainer.getDoubles().write(0, (Object)location.getX()).write(1, (Object)location.getY()).write(2, (Object)location.getZ());
        packetContainer.getFloat().write(0, (Object)Float.valueOf(n));
        collection.forEach(player -> {
            try {
                protocolManager.sendServerPacket(player, packetContainer);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        });
    }

    public static void playExplosion(Location location, int n) {
        ProtocolLibUtils.playExplosion(location, n, location.getWorld().getPlayers());
    }

    public static void playExplosion(Location location) {
        ProtocolLibUtils.playExplosion(location, 4, location.getWorld().getPlayers());
    }

    public static void sendActionBar(int n, Player player, String string) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)string));
        try {
            if (n == 0) {
                packetContainer.getBytes().write(0, (Object)2);
            } else {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            protocolManager.sendServerPacket(player, packetContainer);
        }
        catch (Exception exception) {
            LocalUtils.logd("&c[ProtocolLib] Error sending Action Bar to player '" + player.getName() + "'.");
        }
    }

    public static void sendActionBar(int n, Collection<Player> collection, String string) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)string));
        try {
            if (n == 0) {
                packetContainer.getBytes().write(0, (Object)2);
            } else {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            for (Player player : collection) {
                protocolManager.sendServerPacket(player, packetContainer);
            }
        }
        catch (Exception exception) {
            LocalUtils.logd("&c[ProtocolLib] Error sending Action Bar to players.");
        }
    }

    public static void sendJSON(Collection<? extends Player> collection, String string) {
        if (jsonType == -1) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.logp("JsonType is -1!");
            }
            return;
        }
        if (ProtocolLibUtils.plugin.debugMode) {
            LocalUtils.loge("Attempting to send JSON to " + collection.size() + " players!");
        }
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getModifier().writeDefaults();
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)string));
        try {
            if (jsonType == 0) {
                packetContainer.getBytes().write(0, (Object)1);
            } else {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.CHAT);
            }
            for (Player player : collection) {
                protocolManager.sendServerPacket(player, packetContainer);
            }
        }
        catch (Throwable throwable) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.loge("Error sending JSON chat packet! You are reading the stacktrace below because debug mode is enabled!");
                throwable.printStackTrace();
            }
            LocalUtils.logp("Error sending JSON chat packet.");
        }
    }

    public static void sendJSON(Player player, String string) {
        if (jsonType == -1) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.logp("JsonType is -1!");
            }
            return;
        }
        if (ProtocolLibUtils.plugin.debugMode) {
            LocalUtils.loge("Attempting to send JSON to " + player.getName() + "!");
        }
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getModifier().writeDefaults();
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)string));
        try {
            if (jsonType == 0) {
                packetContainer.getBytes().write(0, (Object)1);
            } else {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.CHAT);
            }
            protocolManager.sendServerPacket(player, packetContainer);
        }
        catch (Throwable throwable) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.loge("Error sending JSON chat packet! You are reading the stacktrace below because debug mode is enabled!");
                throwable.printStackTrace();
            }
            LocalUtils.logp("Error sending JSON chat packet.");
        }
    }

    public static void sendJSON(String string) {
        if (jsonType == -1) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.logp("JsonType is -1!");
            }
            return;
        }
        if (ProtocolLibUtils.plugin.debugMode) {
            LocalUtils.loge("Attempting to send JSON to " + Bukkit.getOnlinePlayers().size() + " players!");
        }
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getModifier().writeDefaults();
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)string));
        try {
            if (jsonType == 0) {
                packetContainer.getBytes().write(0, (Object)1);
            } else {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.CHAT);
            }
            protocolManager.broadcastServerPacket(packetContainer);
        }
        catch (Throwable throwable) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.loge("Error sending JSON chat packet! You are reading the stacktrace below because debug mode is enabled!");
                throwable.printStackTrace();
            }
            LocalUtils.logp("Error sending JSON chat packet.");
        }
    }

    public static void sendBook(Player player, ItemStack itemStack) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CUSTOM_PAYLOAD);
        int n = player.getInventory().getHeldItemSlot();
        ItemStack itemStack2 = player.getInventory().getItem(n);
        try {
            player.getInventory().setItem(n, itemStack);
            packetContainer.getModifier().writeDefaults();
            ByteBuf byteBuf = Unpooled.buffer((int)256);
            byteBuf.setByte(0, 0);
            byteBuf.writerIndex(1);
            packetContainer.getModifier().write(1, MinecraftReflection.getPacketDataSerializer((Object)byteBuf));
            packetContainer.getStrings().write(0, (Object)"MC|BOpen");
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
            player.getInventory().setItem(n, itemStack2);
        }
        catch (Throwable throwable) {
            player.getInventory().setItem(n, itemStack2);
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.loge("Error sending book packet! You are reading the stacktrace below because debug mode is enabled!");
                throwable.printStackTrace();
            }
            LocalUtils.logp("Error sending book packet: " + throwable.getMessage());
        }
    }

    static {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)"Plugin made by AlonsoAliaga"));
        try {
            packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.CHAT);
            LocalUtils.logp("ProtocolLib available for JSON. Method: 'CHAT'. Hooking..");
            jsonType = 1;
        }
        catch (Throwable throwable) {
            try {
                packetContainer.getBytes().write(0, (Object)1);
                LocalUtils.logp("ProtocolLib available for JSON. Method: '(byte)1' Hooking..");
                jsonType = 0;
            }
            catch (Throwable throwable2) {
                LocalUtils.logp("ProtocolLib not available for JSON. Skipping..");
                jsonType = -1;
            }
        }
    }
}

