/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.angelchest.jefflib.internal.nms.v1_16_R2;

import de.jeff_media.angelchest.jefflib.data.tuples.Pair;
import net.minecraft.server.v1_16_R2.BiomeBase;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.Chunk;
import net.minecraft.server.v1_16_R2.DedicatedServer;
import net.minecraft.server.v1_16_R2.IRegistry;
import net.minecraft.server.v1_16_R2.IRegistryWritable;
import net.minecraft.server.v1_16_R2.MinecraftKey;
import net.minecraft.server.v1_16_R2.ResourceKey;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R2.CraftServer;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;

final class NMSBiomeUtils {
    private static final ResourceKey<IRegistry<BiomeBase>> BIOME_REGISTRY_RESOURCE_KEY = IRegistry.ay;

    static Pair<String, String> getBiomeName(Location location) {
        MinecraftKey minecraftKey = NMSBiomeUtils.getBiomeKey(location);
        return new Pair((Object)minecraftKey.getNamespace(), (Object)minecraftKey.getKey());
    }

    static MinecraftKey getBiomeKey(Location location) {
        IRegistryWritable<BiomeBase> iRegistryWritable = NMSBiomeUtils.getBiomeRegistry();
        return iRegistryWritable.getKey((Object)NMSBiomeUtils.getBiomeBase(location));
    }

    static IRegistryWritable<BiomeBase> getBiomeRegistry() {
        DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
        return dedicatedServer.getCustomRegistry().b(BIOME_REGISTRY_RESOURCE_KEY);
    }

    static BiomeBase getBiomeBase(Location location) {
        BlockPosition blockPosition = new BlockPosition(location.getBlockX(), 0, location.getBlockZ());
        Chunk chunk = ((CraftWorld)location.getWorld()).getHandle().getChunkAtWorldCoords(blockPosition);
        if (chunk != null) {
            return chunk.getBiomeIndex().getBiome(blockPosition.getX(), 0, blockPosition.getZ());
        }
        return null;
    }

    private NMSBiomeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

