/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.angelchest.thirdparty.co.aikar.commands;

import com.google.common.collect.SetMultimap;
import de.jeff_media.angelchest.thirdparty.co.aikar.commands.ACFUtil;
import de.jeff_media.angelchest.thirdparty.co.aikar.commands.CommandManager;
import de.jeff_media.angelchest.thirdparty.co.aikar.commands.CommandParameter;
import de.jeff_media.angelchest.thirdparty.co.aikar.commands.RegisteredCommand;
import de.jeff_media.angelchest.thirdparty.co.aikar.commands.RootCommand;
import de.jeff_media.angelchest.thirdparty.co.aikar.commands.apachecommonslang.ApacheCommonsLangUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

class CommandRouter {
    private final CommandManager manager;

    CommandRouter(CommandManager commandManager) {
        this.manager = commandManager;
    }

    CommandRouteResult matchCommand(RouteSearch routeSearch, boolean bl) {
        Set<RegisteredCommand> set = routeSearch.commands;
        String[] stringArray = routeSearch.args;
        if (!set.isEmpty()) {
            if (set.size() == 1) {
                return new CommandRouteResult(ACFUtil.getFirstElement(set), routeSearch);
            }
            Optional<RegisteredCommand> optional = set.stream().filter(registeredCommand -> this.isProbableMatch((RegisteredCommand)registeredCommand, stringArray, bl)).min((registeredCommand, registeredCommand2) -> {
                int n2 = registeredCommand.consumeInputResolvers;
                int n3 = registeredCommand2.consumeInputResolvers;
                if (n2 == n3) {
                    return 0;
                }
                return n2 < n3 ? 1 : -1;
            });
            if (optional.isPresent()) {
                return new CommandRouteResult(optional.get(), routeSearch);
            }
        }
        return null;
    }

    private boolean isProbableMatch(RegisteredCommand registeredCommand, String[] stringArray, boolean bl) {
        int n2 = registeredCommand.requiredResolvers;
        int n3 = registeredCommand.optionalResolvers;
        return stringArray.length <= n2 + n3 && (bl || stringArray.length >= n2);
    }

    RouteSearch routeCommand(RootCommand rootCommand, String string, String[] stringArray, boolean bl) {
        HashSet<RegisteredCommand> hashSet;
        Object object;
        int n2;
        SetMultimap<String, RegisteredCommand> setMultimap = rootCommand.getSubCommands();
        for (int i2 = n2 = stringArray.length; i2 >= 0; --i2) {
            object = ApacheCommonsLangUtil.join((Object[])stringArray, " ", 0, i2).toLowerCase(Locale.ENGLISH);
            hashSet = setMultimap.get(object);
            if (hashSet.isEmpty()) continue;
            return new RouteSearch(hashSet, Arrays.copyOfRange(stringArray, i2, n2), string, (String)object, bl);
        }
        Set set = setMultimap.get((Object)"__default");
        object = setMultimap.get((Object)"__catchunknown");
        if (!set.isEmpty()) {
            hashSet = new HashSet<RegisteredCommand>();
            for (RegisteredCommand registeredCommand : set) {
                CommandParameter commandParameter;
                int n3 = registeredCommand.requiredResolvers;
                int n4 = registeredCommand.optionalResolvers;
                CommandParameter commandParameter2 = commandParameter = registeredCommand.parameters.length > 0 ? registeredCommand.parameters[registeredCommand.parameters.length - 1] : null;
                if (n2 > n3 + n4 && (commandParameter == null || commandParameter.getType() != String[].class && (n2 < n3 || !commandParameter.consumesRest))) continue;
                hashSet.add(registeredCommand);
            }
            if (!hashSet.isEmpty()) {
                return new RouteSearch(hashSet, stringArray, string, null, bl);
            }
        }
        if (!object.isEmpty()) {
            return new RouteSearch((Set<RegisteredCommand>)object, stringArray, string, null, bl);
        }
        return null;
    }

    static class RouteSearch {
        final String[] args;
        final Set<RegisteredCommand> commands;
        final String commandLabel;
        final String subcommand;

        RouteSearch(Set<RegisteredCommand> set, String[] stringArray, String string, String string2, boolean bl) {
            this.commands = set;
            this.args = stringArray;
            this.commandLabel = string.toLowerCase(Locale.ENGLISH);
            this.subcommand = string2;
        }
    }

    static class CommandRouteResult {
        final RegisteredCommand cmd;
        final String[] args;
        final String commandLabel;
        final String subcommand;

        CommandRouteResult(RegisteredCommand registeredCommand, RouteSearch routeSearch) {
            this(registeredCommand, routeSearch.args, routeSearch.subcommand, routeSearch.commandLabel);
        }

        CommandRouteResult(RegisteredCommand registeredCommand, String[] stringArray, String string, String string2) {
            this.cmd = registeredCommand;
            this.args = stringArray;
            this.commandLabel = string2;
            this.subcommand = string;
        }
    }
}

