/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.config;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.config.Config;
import cz.larkyy.aquaticcratestesting.crate.MultiCrate;
import cz.larkyy.aquaticcratestesting.crate.inventories.MultiPreviewGUI;
import cz.larkyy.aquaticcratestesting.crate.model.ModelAnimation;
import cz.larkyy.aquaticcratestesting.crate.model.ModelAnimations;
import cz.larkyy.aquaticcratestesting.crate.model.ModelSettings;
import cz.larkyy.aquaticcratestesting.utils.colors.Colors;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.larkyy.itemlibrary.CustomItem;
import xyz.larkyy.menulib.Menu;
import xyz.larkyy.menulib.MenuItem;

public class MultiCrateConfig
extends Config {
    private final String identifier;

    public MultiCrateConfig(JavaPlugin javaPlugin, File file) {
        super(javaPlugin, file);
        this.identifier = file.getName().substring(0, file.getName().length() - 4);
    }

    public MultiCrate loadCrate() {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        MultiCrate multiCrate = new MultiCrate(this.identifier, Colors.format(this.getConfiguration().getString("display-name", this.identifier)), this.loadModelSettings(), this.loadHologram("hologram"), this.getConfiguration().getDouble("hologram-y-offset", 0.0), this.getConfiguration().getStringList("crates"), atomicReference, this.getConfiguration().getInt("hitbox-height", 1), this.getConfiguration().getInt("hitbox-width", 1));
        this.loadMultiPreviewGUI(multiCrate, atomicReference);
        multiCrate.setBlockType(Material.valueOf((String)this.getConfiguration().getString("block-type", "BARRIER").toUpperCase()));
        return multiCrate;
    }

    private ModelSettings loadModelSettings() {
        String string = this.getConfiguration().getString("model");
        int n = this.getConfiguration().getInt("idle-animation-period", -1);
        if (!this.getConfiguration().contains("idle-animations")) {
            return new ModelSettings(string, new ModelAnimations(new ArrayList<ModelAnimation>(), n));
        }
        ArrayList<ModelAnimation> arrayList = new ArrayList<ModelAnimation>();
        for (String string2 : this.getConfiguration().getConfigurationSection("idle-animations").getKeys(false)) {
            String string3 = this.getConfiguration().getString("idle-animations." + string2 + ".animation");
            int n2 = this.getConfiguration().getInt("idle-animations." + string2 + ".length");
            arrayList.add(new ModelAnimation(string3, n2));
        }
        return new ModelSettings(string, new ModelAnimations(arrayList, n));
    }

    private List<String> loadHologram(String string) {
        if (!this.getConfiguration().contains(string)) {
            return new ArrayList<String>();
        }
        return this.getConfiguration().getStringList(string);
    }

    private void loadMultiPreviewGUI(MultiCrate multiCrate, AtomicReference<MultiPreviewGUI> atomicReference) {
        if (!this.getConfiguration().contains("preview") || !this.getConfiguration().getBoolean("preview.enabled", true)) {
            return;
        }
        Object object = this.getConfiguration().contains("preview.title") ? Colors.format(this.getConfiguration().getString("preview.title")) : multiCrate.getDisplayName() + "\u00a78 Preview";
        Menu.Builder builder = Menu.builder(AquaticCratesTesting.instance()).size(this.getConfiguration().getInt("preview.size", 54)).title((String)object);
        if (this.getConfiguration().contains("preview.items")) {
            for (String string : this.getConfiguration().getConfigurationSection("preview.items").getKeys(false)) {
                MenuItem menuItem = this.loadMenuItem(string, "preview.items." + string);
                if (menuItem == null) continue;
                builder.addItem(menuItem);
            }
        }
        atomicReference.set(new MultiPreviewGUI(multiCrate, builder));
    }

    private MenuItem loadMenuItem(String string, String string2) {
        CustomItem customItem = this.loadItem(string2);
        if (customItem == null) {
            Bukkit.getConsoleSender().sendMessage("\u00a7cMenu Item " + string2 + " could not be loaded, because the item is null!");
            return null;
        }
        List<Integer> list = this.getConfiguration().contains(string2 + ".slot") ? Arrays.asList(this.getConfiguration().getInt(string2 + ".slot")) : this.getConfiguration().getIntegerList(string2 + ".slots");
        return MenuItem.builder(string, customItem.getItem()).slots(list).build();
    }

    private CustomItem loadItem(String string) {
        return CustomItem.loadFromYaml(this.getConfiguration(), string);
    }
}

