/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.animation.RewardItem;
import cz.larkyy.aquaticcratestesting.api.AquaticCratesAPI;
import cz.larkyy.aquaticcratestesting.api.events.CrateInteractEvent;
import cz.larkyy.aquaticcratestesting.api.events.KeyInteractEvent;
import cz.larkyy.aquaticcratestesting.api.events.MultiCrateInteractEvent;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.Key;
import cz.larkyy.aquaticcratestesting.crate.MultiCrate;
import cz.larkyy.aquaticcratestesting.crate.PlacedCrate;
import cz.larkyy.aquaticcratestesting.crate.PlacedMultiCrate;
import cz.larkyy.aquaticcratestesting.crate.reroll.Reroll;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class CrateListener
implements Listener {
    @EventHandler
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        PlacedCrate placedCrate = PlacedCrate.get(blockBreakEvent.getBlock().getLocation());
        if (placedCrate != null) {
            Player player = blockBreakEvent.getPlayer();
            blockBreakEvent.setCancelled(true);
            Bukkit.getPluginManager().callEvent((Event)new CrateInteractEvent(player, placedCrate, Action.LEFT_CLICK_BLOCK, blockBreakEvent.getBlock().getLocation()));
            return;
        }
        PlacedMultiCrate placedMultiCrate = AquaticCratesTesting.getCrateHandler().getPlacedMultiCrate(blockBreakEvent.getBlock().getLocation());
        if (placedMultiCrate != null) {
            Player player = blockBreakEvent.getPlayer();
            blockBreakEvent.setCancelled(true);
            Bukkit.getPluginManager().callEvent((Event)new MultiCrateInteractEvent(player, placedMultiCrate, Action.LEFT_CLICK_BLOCK, blockBreakEvent.getBlock().getLocation()));
            return;
        }
    }

    @EventHandler
    public void onInvClose(InventoryCloseEvent inventoryCloseEvent) {
        Object object = inventoryCloseEvent.getPlayer();
        if (!(object instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        object = Reroll.get(player);
        if (object != null && ((Reroll)object).isRerolling()) {
            ((Reroll)object).activate((Event)inventoryCloseEvent);
        }
    }

    @EventHandler
    public void onEntityDamagedByEntity(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Object object = entityDamageByEntityEvent.getDamager();
        if (!(object instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        object = Reroll.get(player);
        if (object != null && ((Reroll)object).isRerolling()) {
            ((Reroll)object).activate((Event)new PlayerInteractEvent(player, Action.LEFT_CLICK_AIR, player.getInventory().getItemInMainHand(), null, BlockFace.SELF));
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent entityPickupItemEvent) {
        if (entityPickupItemEvent.getItem().getPersistentDataContainer().has(RewardItem.REWARD_ITEM_KEY, PersistentDataType.INTEGER)) {
            entityPickupItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent playerInteractEvent) {
        PlacedCrate placedCrate;
        if (playerInteractEvent.getHand() == null) {
            return;
        }
        if (playerInteractEvent.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        Reroll reroll = Reroll.get(player);
        if (reroll != null && reroll.isRerolling()) {
            reroll.activate((Event)playerInteractEvent);
            return;
        }
        ItemStack itemStack = playerInteractEvent.getItem();
        Location location = null;
        Action action = playerInteractEvent.getAction();
        if (player.getGameMode() == GameMode.ADVENTURE && playerInteractEvent.getAction() == Action.LEFT_CLICK_AIR && (placedCrate = player.getTargetBlockExact(5)) != null) {
            location = placedCrate.getLocation();
            action = Action.LEFT_CLICK_BLOCK;
        }
        if (playerInteractEvent.getClickedBlock() != null) {
            location = playerInteractEvent.getClickedBlock().getLocation();
        }
        if ((placedCrate = PlacedCrate.get(location)) != null) {
            playerInteractEvent.setCancelled(true);
            Bukkit.getPluginManager().callEvent((Event)new CrateInteractEvent(player, placedCrate, action, playerInteractEvent.getClickedBlock().getLocation()));
            return;
        }
        PlacedMultiCrate placedMultiCrate = AquaticCratesTesting.getCrateHandler().getPlacedMultiCrate(location);
        if (placedMultiCrate != null) {
            playerInteractEvent.setCancelled(true);
            Bukkit.getPluginManager().callEvent((Event)new MultiCrateInteractEvent(player, placedMultiCrate, action, playerInteractEvent.getClickedBlock().getLocation()));
            return;
        }
        Key key = Key.get(itemStack);
        if (key != null) {
            playerInteractEvent.setCancelled(true);
            Bukkit.getPluginManager().callEvent((Event)new KeyInteractEvent(player, key, location, action));
            return;
        }
        Crate crate = Crate.get(itemStack);
        if (crate != null) {
            if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            playerInteractEvent.setCancelled(true);
            Location location2 = location.clone().add(0.5, 1.0, 0.5);
            location2.setYaw(player.getLocation().getYaw() + 180.0f);
            crate.spawn(location2);
            AquaticCratesAPI.getCrateHandler().saveCrates();
            return;
        }
        MultiCrate multiCrate = MultiCrate.get(itemStack);
        if (multiCrate != null) {
            if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            playerInteractEvent.setCancelled(true);
            Location location3 = location.clone().add(0.5, 1.0, 0.5);
            location3.setYaw(player.getLocation().getYaw() + 180.0f);
            AquaticCratesTesting.getCrateHandler().spawnMultiCrate(location3, multiCrate);
            AquaticCratesAPI.getCrateHandler().saveCrates();
        }
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent playerToggleSneakEvent) {
        if (!playerToggleSneakEvent.isSneaking()) {
            return;
        }
        Player player = playerToggleSneakEvent.getPlayer();
        Reroll reroll = Reroll.get(player);
        if (reroll == null || !reroll.isRerolling()) {
            if (AquaticCratesTesting.getCrateHandler().skipAnimation(playerToggleSneakEvent.getPlayer())) {
                return;
            }
        } else {
            reroll.activate((Event)playerToggleSneakEvent);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCrateInteract(CrateInteractEvent crateInteractEvent) {
        Player player = crateInteractEvent.getPlayer();
        PlacedCrate placedCrate = crateInteractEvent.getPlacedCrate();
        if (crateInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
            placedCrate.open(CratePlayer.get(crateInteractEvent.getPlayer()), player.isSneaking());
        } else if (crateInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK) {
            if (player.isSneaking() && player.hasPermission("aquaticcrates.break")) {
                AquaticCratesAPI.getCrateHandler().removePlacedCrate(crateInteractEvent.getLocation());
            } else {
                placedCrate.getCrate().openPreview(player, placedCrate);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMultiCrateInteract(MultiCrateInteractEvent multiCrateInteractEvent) {
        Player player = multiCrateInteractEvent.getPlayer();
        PlacedMultiCrate placedMultiCrate = multiCrateInteractEvent.getPlacedCrate();
        if (multiCrateInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Key key = Key.get(player.getInventory().getItemInMainHand());
            if (key != null && placedMultiCrate.getMultiCrate().getCrates().contains(key.getCrate().getIdentifier())) {
                key.getCrate().open(CratePlayer.get(player), placedMultiCrate.getPlacedCrates().get(key.getCrate().getIdentifier()), player.isSneaking());
                return;
            }
            placedMultiCrate.getMultiCrate().openPreview(player, placedMultiCrate);
        } else if (multiCrateInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK) {
            if (player.isSneaking() && player.hasPermission("aquaticcrates.break")) {
                AquaticCratesAPI.getCrateHandler().removePlacedMultiCrate(multiCrateInteractEvent.getLocation());
            } else {
                placedMultiCrate.getMultiCrate().openPreview(player, placedMultiCrate);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onKeyInteract(KeyInteractEvent keyInteractEvent) {
        Key key = keyInteractEvent.getKey();
        if (keyInteractEvent.getAction() == Action.RIGHT_CLICK_AIR || keyInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (key.requiresCrateToOpen()) {
                return;
            }
            key.getCrate().open(CratePlayer.get(keyInteractEvent.getPlayer()), null, keyInteractEvent.getPlayer().isSneaking());
        } else if (keyInteractEvent.getAction() == Action.LEFT_CLICK_AIR || keyInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK) {
            key.getCrate().openPreview(keyInteractEvent.getPlayer(), null);
        }
    }
}

