/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate.milestone;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.milestone.Milestone;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MilestoneHandler {
    private final TreeMap<Integer, Milestone> milestones;
    private final HashMap<Integer, Milestone> repeatableMilestones;
    private final NamespacedKey namespacedKey;

    public MilestoneHandler(Crate crate, TreeMap<Integer, Milestone> treeMap, HashMap<Integer, Milestone> hashMap) {
        this.milestones = treeMap;
        this.repeatableMilestones = hashMap;
        this.namespacedKey = new NamespacedKey((Plugin)AquaticCratesTesting.instance(), crate.getIdentifier() + "-milestone");
    }

    public TreeMap<Integer, Milestone> getMilestones() {
        return this.milestones;
    }

    public HashMap<Integer, Milestone> getRepeatableMilestones() {
        return this.repeatableMilestones;
    }

    public Milestone getNext(Player player) {
        int n = this.getAmt(player);
        Map.Entry<Integer, Milestone> entry = this.milestones.higherEntry(n);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public int requiredToReach(Player player) {
        int n = this.getAmt(player);
        Map.Entry<Integer, Milestone> entry = this.milestones.higherEntry(n);
        if (entry == null) {
            return -1;
        }
        return entry.getKey() - n;
    }

    public void increaseAmt(Player player) {
        int n = this.getAmt(player) + 1;
        PersistentDataContainer persistentDataContainer = player.getPersistentDataContainer();
        persistentDataContainer.set(this.namespacedKey, PersistentDataType.INTEGER, (Object)n);
        this.checkMilestones(player, n);
    }

    public int getAmt(Player player) {
        PersistentDataContainer persistentDataContainer = player.getPersistentDataContainer();
        Integer n = (Integer)persistentDataContainer.get(this.namespacedKey, PersistentDataType.INTEGER);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void checkMilestones(Player player, int n) {
        if (this.milestones.containsKey(n)) {
            Milestone milestone = this.milestones.get(n);
            milestone.giveRandomReward(player);
        }
        for (Milestone milestone : this.repeatableMilestones.values()) {
            if ((double)n % (double)milestone.getMilestone() != 0.0) continue;
            milestone.giveRandomReward(player);
        }
    }
}

