/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.dabatase;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.config.Config;
import cz.larkyy.aquaticcratestesting.dabatase.drivers.Driver;
import cz.larkyy.aquaticcratestesting.dabatase.drivers.MySQLDriver;
import cz.larkyy.aquaticcratestesting.dabatase.drivers.SQLiteDriver;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private final Config config = new Config((JavaPlugin)AquaticCratesTesting.instance(), "database-settings.yml");
    private final Map<String, Driver> availableDrivers = new HashMap<String, Driver>(){
        {
            this.put("sqlite", new SQLiteDriver());
            this.put("mysql", new MySQLDriver());
        }
    };
    private final Driver driver;

    public DatabaseManager() {
        this.config.load();
        this.driver = this.availableDrivers.get(this.config.getConfiguration().getString("type", "sqlite").toLowerCase());
    }

    public void setup() {
        this.driver.setup();
    }

    public void loadPlayer(Player player, Consumer<CratePlayer> consumer) {
        CratePlayer cratePlayer = CratePlayer.get(player);
        this.driver.loadPlayer(player, (ResultSet resultSet) -> {
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString("Identifier");
                    int n = resultSet.getInt("Amount");
                    cratePlayer.addKeys(string, n);
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
            consumer.accept(cratePlayer);
        });
    }

    public void loadPlayers(Runnable runnable) {
        this.driver.loadPlayers((ResultSet resultSet) -> {
            try {
                while (resultSet.next()) {
                    Player player = Bukkit.getPlayer((UUID)UUID.fromString(resultSet.getString("UniqueID")));
                    if (player == null || !player.isOnline()) continue;
                    CratePlayer cratePlayer = CratePlayer.get(player);
                    String string = resultSet.getString("Identifier");
                    int n = resultSet.getInt("Amount");
                    cratePlayer.addKeys(string, n);
                }
                runnable.run();
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        });
    }

    public void savePlayer(CratePlayer cratePlayer) {
        this.driver.savePlayer(cratePlayer, true);
    }

    public void savePlayers(boolean bl) {
        this.driver.savePlayers(bl);
    }

    public FileConfiguration getCfg() {
        return this.config.getConfiguration();
    }
}

