/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.player;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.api.AquaticCratesAPI;
import cz.larkyy.aquaticcratestesting.crate.reroll.Reroll;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlayerHandler {
    private final Map<OfflinePlayer, CratePlayer> players = new HashMap<OfflinePlayer, CratePlayer>();
    private final Map<Player, Reroll> rerollPlayers = new HashMap<Player, Reroll>();

    public void loadPlayer(Player player, Consumer<CratePlayer> consumer) {
        AquaticCratesTesting.getDatabaseManager().loadPlayer(player, consumer);
    }

    public void savePlayer(CratePlayer cratePlayer) {
        AquaticCratesTesting.getDatabaseManager().savePlayer(cratePlayer);
    }

    public void savePlayers(boolean bl) {
        AquaticCratesTesting.getDatabaseManager().savePlayers(bl);
    }

    public void addPlayer(OfflinePlayer offlinePlayer, CratePlayer cratePlayer) {
        this.players.put(offlinePlayer, cratePlayer);
    }

    public void loadPlayers(Runnable runnable) {
        AquaticCratesTesting.getDatabaseManager().loadPlayers(runnable);
    }

    public void unloadPlayer(OfflinePlayer offlinePlayer) {
        this.players.remove(offlinePlayer);
    }

    public void unloadPlayers() {
        this.players.clear();
    }

    public List<CratePlayer> getPlayers() {
        return new ArrayList<CratePlayer>(this.players.values());
    }

    public CratePlayer getPlayer(Player player) {
        CratePlayer cratePlayer = this.players.get(player);
        if (cratePlayer == null) {
            cratePlayer = new CratePlayer(player);
            this.players.put((OfflinePlayer)player, cratePlayer);
        }
        return cratePlayer;
    }

    public Reroll getRerollPlayer(Player player) {
        return this.rerollPlayers.get(player);
    }

    public void addRerollPlayer(Reroll reroll) {
        this.rerollPlayers.put(reroll.getPlayer(), reroll);
    }

    public void removeRerollPlayer(Player player) {
        this.rerollPlayers.remove(player);
    }

    public boolean isInAnimation(Player player) {
        return AquaticCratesAPI.getCrateHandler().isInAnimation(player);
    }
}

