/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.spi;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.DefaultLoggingEvent;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.event.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;

public class DefaultLoggingEventBuilder
implements LoggingEventBuilder {
    DefaultLoggingEvent loggingEvent;
    Logger logger;

    public DefaultLoggingEventBuilder(Logger logger, Level level) {
        this.logger = logger;
        this.loggingEvent = new DefaultLoggingEvent(level, logger);
    }

    @Override
    public LoggingEventBuilder addMarker(Marker marker) {
        this.loggingEvent.addMarker(marker);
        return this;
    }

    @Override
    public LoggingEventBuilder setCause(Throwable throwable) {
        this.loggingEvent.setThrowable(throwable);
        return this;
    }

    @Override
    public LoggingEventBuilder addArgument(Object object) {
        this.loggingEvent.addArgument(object);
        return this;
    }

    @Override
    public LoggingEventBuilder addArgument(Supplier<Object> supplier) {
        this.loggingEvent.addArgument(supplier.get());
        return this;
    }

    @Override
    public void log(String string) {
        this.loggingEvent.setMessage(string);
        this.innerLog(this.loggingEvent);
    }

    @Override
    public void log(String string, Object object) {
        this.loggingEvent.setMessage(string);
        this.loggingEvent.addArgument(object);
        this.innerLog(this.loggingEvent);
    }

    @Override
    public void log(String string, Object object, Object object2) {
        this.loggingEvent.setMessage(string);
        this.loggingEvent.addArgument(object);
        this.loggingEvent.addArgument(object2);
        this.innerLog(this.loggingEvent);
    }

    @Override
    public void log(String string, Object ... objectArray) {
        this.loggingEvent.setMessage(string);
        this.loggingEvent.addArguments(objectArray);
        this.innerLog(this.loggingEvent);
    }

    private void innerLog(LoggingEvent loggingEvent) {
        if (this.logger instanceof LoggingEventAware) {
            ((LoggingEventAware)((Object)this.logger)).log(loggingEvent);
        } else {
            this.logViaPublicLoggerAPI(loggingEvent);
        }
    }

    private void logViaPublicLoggerAPI(LoggingEvent loggingEvent) {
        Object[] objectArray = loggingEvent.getArgumentArray();
        int n = objectArray == null ? 0 : objectArray.length;
        Throwable throwable = loggingEvent.getThrowable();
        int n2 = throwable == null ? 0 : 1;
        String string = loggingEvent.getMessage();
        Object[] objectArray2 = new Object[n + n2];
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (throwable != null) {
            objectArray2[n] = throwable;
        }
        string = this.mergeMarkersAndKeyValuePairs(loggingEvent, string);
        switch (loggingEvent.getLevel()) {
            case TRACE: {
                this.logger.trace(string, objectArray2);
                break;
            }
            case DEBUG: {
                this.logger.debug(string, objectArray2);
                break;
            }
            case INFO: {
                this.logger.info(string, objectArray2);
                break;
            }
            case WARN: {
                this.logger.warn(string, objectArray2);
                break;
            }
            case ERROR: {
                this.logger.error(string, objectArray2);
            }
        }
    }

    private String mergeMarkersAndKeyValuePairs(LoggingEvent loggingEvent, String string) {
        StringBuilder stringBuilder = null;
        if (this.loggingEvent.getMarkers() != null) {
            stringBuilder = new StringBuilder();
            for (Marker object : loggingEvent.getMarkers()) {
                stringBuilder.append(object);
                stringBuilder.append(' ');
            }
        }
        if (loggingEvent.getKeyValuePairs() != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            for (KeyValuePair keyValuePair : loggingEvent.getKeyValuePairs()) {
                stringBuilder.append(keyValuePair.key);
                stringBuilder.append('=');
                stringBuilder.append(keyValuePair.value);
                stringBuilder.append(' ');
            }
        }
        if (stringBuilder != null) {
            stringBuilder.append(string);
            return stringBuilder.toString();
        }
        return string;
    }

    @Override
    public void log(Supplier<String> supplier) {
        if (supplier == null) {
            this.log((String)null);
        } else {
            this.log(supplier.get());
        }
    }

    @Override
    public LoggingEventBuilder addKeyValue(String string, Object object) {
        this.loggingEvent.addKeyValue(string, object);
        return this;
    }

    @Override
    public LoggingEventBuilder addKeyValue(String string, Supplier<Object> supplier) {
        this.loggingEvent.addKeyValue(string, supplier.get());
        return this;
    }
}

