/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.common.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.serverct.ersha.taboolib.common.SkipIsolatedClassLoader;

public class IsolatedClassLoader
extends URLClassLoader {
    private static final Set<String> excludeClasses = new HashSet<String>();
    private static boolean isEnabled = false;

    public IsolatedClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name2, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name2);
            if (loadedClass == null) {
                ClassLoader parent;
                if (!excludeClasses.contains(name2)) {
                    try {
                        loadedClass = this.findClass(name2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (loadedClass == null && (parent = this.getParent()) != null) {
                    loadedClass = parent.loadClass(name2);
                }
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    static {
        try {
            Class<SkipIsolatedClassLoader> clazz = SkipIsolatedClassLoader.class;
        }
        catch (NoClassDefFoundError ignored) {
            isEnabled = true;
            excludeClasses.addAll(Arrays.asList("org.serverct.ersha.taboolib.common.classloader.IsolatedClassLoader", "org.serverct.ersha.taboolib.common.platform.Plugin", "org.serverct.ersha.taboolib.platform.BukkitPlugin", "org.serverct.ersha.taboolib.platform.BungeePlugin", "org.serverct.ersha.taboolib.platform.VelocityPlugin", "org.serverct.ersha.taboolib.platform.CloudNetV3Plugin", "org.serverct.ersha.taboolib.platform.NukkitPlugin", "org.serverct.ersha.taboolib.platform.Sponge7Plugin", "org.serverct.ersha.taboolib.platform.Sponge8Plugin", "org.serverct.ersha.taboolib.platform.Sponge9Plugin"));
        }
    }
}

