/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.common.env;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.serverct.ersha.taboolib.common.TabooLibCommon;
import org.serverct.ersha.taboolib.common.env.AbstractXmlParser;
import org.serverct.ersha.taboolib.common.env.Dependency;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Repository
extends AbstractXmlParser {
    private static final String MAVEN_CENTRAL = "https://maven.aliyun.com/repository/central";
    private final String url;

    public Repository(String url) {
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public Repository(Element node) throws ParseException {
        this(Repository.find("url", node, null));
    }

    public Repository() {
        this(MAVEN_CENTRAL);
    }

    public void downloadToFile(Dependency dep, File out) throws IOException {
        URL url = new URL(String.format("%s/%s/%s/%s/%s", this.getUrl(), dep.getGroupId().replace('.', '/'), dep.getArtifactId(), dep.getVersion(), out.getName()));
        TabooLibCommon.print(String.format("Downloading ... %s", url));
        Repository.downloadToFile(url, out);
    }

    public void setVersion(Dependency dep) throws IOException {
        URL url = new URL(String.format("%s/%s/%s/maven-metadata.xml", this.getUrl(), dep.getGroupId().replace('.', '/'), dep.getArtifactId()));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream ins = url.openStream();
            Document doc = builder.parse(ins);
            dep.setVersion(Repository.find("release", doc.getDocumentElement(), Repository.find("version", doc.getDocumentElement(), null)));
        }
        catch (IOException | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public static void downloadToFile(URL url, File out) throws IOException {
        int len;
        InputStream ins = url.openStream();
        OutputStream outs = Files.newOutputStream(out.toPath(), new OpenOption[0]);
        byte[] buffer = new byte[4096];
        while ((len = ins.read(buffer)) > 0) {
            outs.write(buffer, 0, len);
        }
        outs.close();
        ins.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Repository)) {
            return false;
        }
        Repository that = (Repository)o;
        return Objects.equals(this.getUrl(), that.getUrl());
    }

    public int hashCode() {
        return Objects.hash(this.getUrl());
    }

    public String toString() {
        return "Repository{url='" + this.url + '\'' + '}';
    }
}

