/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.common5;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.serverct.ersha.taboolib.common.Isolated;

@Isolated
public final class Coerce {
    private static final Pattern listPattern = Pattern.compile("^([(\\[{]?)(.+?)([)\\]}]?)$");
    private static final String[] listPairings = new String[]{"([{", ")]}"};

    private Coerce() {
    }

    public static double format(double value) {
        return BigDecimal.valueOf(value).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public static double format(double value, int scale) {
        return BigDecimal.valueOf(value).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static String toString(@Nullable Object obj2) {
        if (obj2 == null) {
            return "";
        }
        if (obj2.getClass().isArray()) {
            return Coerce.toList(obj2).toString();
        }
        return obj2.toString();
    }

    public static Optional<String> asString(@Nullable Object obj2) {
        if (obj2 instanceof String) {
            return Optional.of((String)obj2);
        }
        if (obj2 == null) {
            return Optional.empty();
        }
        return Optional.of(obj2.toString());
    }

    public static List<?> toList(@Nullable Object obj2) {
        if (obj2 == null) {
            return Collections.emptyList();
        }
        if (obj2 instanceof List) {
            return (List)obj2;
        }
        Class<?> clazz = obj2.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return Coerce.primitiveArrayToList(obj2);
            }
            return Arrays.asList((Object[])obj2);
        }
        return Coerce.parseStringToList(obj2.toString());
    }

    public static Optional<List<?>> asList(@Nullable Object obj2) {
        if (obj2 == null) {
            return Optional.empty();
        }
        if (obj2 instanceof List) {
            return Optional.of((List)obj2);
        }
        Class<?> clazz = obj2.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return Optional.of(Coerce.primitiveArrayToList(obj2));
            }
            return Optional.of(Arrays.asList((Object[])obj2));
        }
        return Optional.of(Coerce.parseStringToList(obj2.toString()));
    }

    public static <T> List<T> toListOf(@Nullable Object obj2, Class<T> ofClass) {
        Preconditions.checkNotNull(ofClass, (Object)"ofClass");
        ArrayList filteredList = Lists.newArrayList();
        for (Object o : Coerce.toList(obj2)) {
            if (ofClass.isAssignableFrom(o.getClass())) {
                filteredList.add(o);
                continue;
            }
            if (ofClass.equals(String.class)) {
                filteredList.add(Coerce.toString(o));
                continue;
            }
            if (ofClass.equals(Integer.TYPE) || ofClass.equals(Integer.class)) {
                filteredList.add(Coerce.toInteger(o));
                continue;
            }
            if (ofClass.equals(Float.TYPE) || ofClass.equals(Float.class)) {
                filteredList.add(new Float(Coerce.toDouble(o)));
                continue;
            }
            if (ofClass.equals(Double.TYPE) || ofClass.equals(Double.class)) {
                filteredList.add(Coerce.toDouble(o));
                continue;
            }
            if (!ofClass.equals(Boolean.TYPE) && !ofClass.equals(Boolean.class)) continue;
            filteredList.add(Coerce.toBoolean(o));
        }
        return filteredList;
    }

    public static boolean toBoolean(@Nullable Object obj2) {
        if (obj2 == null) {
            return false;
        }
        if (obj2 instanceof Boolean) {
            return (Boolean)obj2;
        }
        String value = obj2.toString().trim();
        return value.equals("1") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    public static Optional<Boolean> asBoolean(@Nullable Object obj2) {
        if (obj2 instanceof Boolean) {
            return Optional.of((Boolean)obj2);
        }
        if (obj2 instanceof Byte) {
            return Optional.of((Byte)obj2 != 0);
        }
        return Optional.empty();
    }

    public static int toInteger(@Nullable Object obj2) {
        if (obj2 == null) {
            return 0;
        }
        if (obj2 instanceof Number) {
            return ((Number)obj2).intValue();
        }
        String strObj = Coerce.sanitiseNumber(obj2);
        Integer iParsed = Ints.tryParse((String)strObj);
        if (iParsed != null) {
            return iParsed;
        }
        Double dParsed = Doubles.tryParse((String)strObj);
        return dParsed != null ? dParsed.intValue() : 0;
    }

    public static Optional<Integer> asInteger(@Nullable Object obj2) {
        if (obj2 == null) {
            return Optional.empty();
        }
        if (obj2 instanceof Number) {
            return Optional.of(((Number)obj2).intValue());
        }
        try {
            return Optional.of(Integer.valueOf(obj2.toString()));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String strObj = Coerce.sanitiseNumber(obj2);
            Integer iParsed = Ints.tryParse((String)strObj);
            if (iParsed == null) {
                Double dParsed = Doubles.tryParse((String)strObj);
                return dParsed == null ? Optional.empty() : Optional.of(dParsed.intValue());
            }
            return Optional.of(iParsed);
        }
    }

    public static double toDouble(@Nullable Object obj2) {
        if (obj2 == null) {
            return 0.0;
        }
        if (obj2 instanceof Number) {
            return ((Number)obj2).doubleValue();
        }
        Double parsed = Doubles.tryParse((String)Coerce.sanitiseNumber(obj2));
        return parsed != null ? parsed : 0.0;
    }

    public static Optional<Double> asDouble(@Nullable Object obj2) {
        if (obj2 == null) {
            return Optional.empty();
        }
        if (obj2 instanceof Number) {
            return Optional.of(((Number)obj2).doubleValue());
        }
        try {
            return Optional.of(Double.valueOf(obj2.toString()));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String strObj = Coerce.sanitiseNumber(obj2);
            Double dParsed = Doubles.tryParse((String)strObj);
            return dParsed == null ? Optional.empty() : Optional.of(dParsed);
        }
    }

    public static float toFloat(@Nullable Object obj2) {
        if (obj2 == null) {
            return 0.0f;
        }
        if (obj2 instanceof Number) {
            return ((Number)obj2).floatValue();
        }
        Float parsed = Floats.tryParse((String)Coerce.sanitiseNumber(obj2));
        return parsed != null ? parsed.floatValue() : 0.0f;
    }

    public static Optional<Float> asFloat(@Nullable Object obj2) {
        if (obj2 == null) {
            return Optional.empty();
        }
        if (obj2 instanceof Number) {
            return Optional.of(Float.valueOf(((Number)obj2).floatValue()));
        }
        try {
            return Optional.of(Float.valueOf(obj2.toString()));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String strObj = Coerce.sanitiseNumber(obj2);
            Double dParsed = Doubles.tryParse((String)strObj);
            return dParsed == null ? Optional.empty() : Optional.of(Float.valueOf(dParsed.floatValue()));
        }
    }

    public static short toShort(@Nullable Object obj2) {
        if (obj2 == null) {
            return 0;
        }
        if (obj2 instanceof Number) {
            return ((Number)obj2).shortValue();
        }
        try {
            return Short.parseShort(Coerce.sanitiseNumber(obj2));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static Optional<Short> asShort(@Nullable Object obj2) {
        if (obj2 == null) {
            return Optional.empty();
        }
        if (obj2 instanceof Number) {
            return Optional.of(((Number)obj2).shortValue());
        }
        try {
            return Optional.of(Short.parseShort(Coerce.sanitiseNumber(obj2)));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return Optional.empty();
        }
    }

    public static byte toByte(@Nullable Object obj2) {
        if (obj2 == null) {
            return 0;
        }
        if (obj2 instanceof Number) {
            return ((Number)obj2).byteValue();
        }
        try {
            return Byte.parseByte(Coerce.sanitiseNumber(obj2));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static Optional<Byte> asByte(@Nullable Object obj2) {
        if (obj2 == null) {
            return Optional.empty();
        }
        if (obj2 instanceof Number) {
            return Optional.of(((Number)obj2).byteValue());
        }
        try {
            return Optional.of(Byte.parseByte(Coerce.sanitiseNumber(obj2)));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return Optional.empty();
        }
    }

    public static long toLong(@Nullable Object obj2) {
        if (obj2 == null) {
            return 0L;
        }
        if (obj2 instanceof Number) {
            return ((Number)obj2).longValue();
        }
        try {
            return Long.parseLong(Coerce.sanitiseNumber(obj2));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static Optional<Long> asLong(@Nullable Object obj2) {
        if (obj2 == null) {
            return Optional.empty();
        }
        if (obj2 instanceof Number) {
            return Optional.of(((Number)obj2).longValue());
        }
        try {
            return Optional.of(Long.parseLong(Coerce.sanitiseNumber(obj2)));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return Optional.empty();
        }
    }

    public static char toChar(@Nullable Object obj2) {
        if (obj2 == null) {
            return '\u0000';
        }
        if (obj2 instanceof Character) {
            return ((Character)obj2).charValue();
        }
        try {
            return obj2.toString().charAt(0);
        }
        catch (Exception exception) {
            return '\u0000';
        }
    }

    public static Optional<Character> asChar(@Nullable Object obj2) {
        if (obj2 == null) {
            return Optional.empty();
        }
        if (obj2 instanceof Character) {
            return Optional.of((Character)obj2);
        }
        try {
            return Optional.of(Character.valueOf(obj2.toString().charAt(0)));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static <E extends Enum<E>> E toEnum(@Nullable Object obj2, Class<E> enumClass) {
        return (E)Coerce.toEnum(obj2, enumClass, ((Enum[])enumClass.getEnumConstants())[0]);
    }

    public static <E extends Enum<E>> E toEnum(@Nullable Object obj2, Class<E> enumClass, E defaultValue) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass");
        Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
        if (obj2 == null) {
            return defaultValue;
        }
        if (enumClass.isAssignableFrom(obj2.getClass())) {
            Enum enumObj = (Enum)obj2;
            return (E)enumObj;
        }
        String strObj = obj2.toString().trim();
        try {
            return Enum.valueOf(enumClass, strObj);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (Enum value : (Enum[])enumClass.getEnumConstants()) {
                if (!value.name().equalsIgnoreCase(strObj)) continue;
                return (E)value;
            }
            return defaultValue;
        }
    }

    public static <T> T toPseudoEnum(@Nullable Object obj2, Class<T> pseudoEnumClass, Class<?> dictionaryClass, T defaultValue) {
        Preconditions.checkNotNull(pseudoEnumClass, (Object)"pseudoEnumClass");
        Preconditions.checkNotNull(dictionaryClass, (Object)"dictionaryClass");
        Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
        if (obj2 == null) {
            return defaultValue;
        }
        if (pseudoEnumClass.isAssignableFrom(obj2.getClass())) {
            Object enumObj = obj2;
            return (T)enumObj;
        }
        String strObj = obj2.toString().trim();
        try {
            for (Field field : dictionaryClass.getFields()) {
                if ((field.getModifiers() & 8) == 0 || !pseudoEnumClass.isAssignableFrom(field.getType())) continue;
                String fieldName = field.getName();
                Object entry = field.get(null);
                if (!strObj.equalsIgnoreCase(fieldName)) continue;
                return (T)entry;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    private static String sanitiseNumber(Object obj2) {
        String string = obj2.toString().trim();
        if (string.length() < 1) {
            return "0";
        }
        Matcher candidate = listPattern.matcher(string);
        if (Coerce.listBracketsMatch(candidate)) {
            string = candidate.group(2).trim();
        }
        int decimal = string.indexOf(46);
        int comma = string.indexOf(44, decimal);
        if (decimal > -1 && comma > -1) {
            return Coerce.sanitiseNumber(string.substring(0, comma));
        }
        if (string.indexOf(45, 1) != -1) {
            return "0";
        }
        return string.replace(",", "").split(" ")[0];
    }

    private static boolean listBracketsMatch(Matcher candidate) {
        return candidate.matches() && listPairings[0].indexOf(candidate.group(1)) == listPairings[1].indexOf(candidate.group(3));
    }

    private static List<?> primitiveArrayToList(Object obj2) {
        if (obj2 instanceof boolean[]) {
            return Booleans.asList((boolean[])((boolean[])obj2));
        }
        if (obj2 instanceof char[]) {
            return Chars.asList((char[])((char[])obj2));
        }
        if (obj2 instanceof byte[]) {
            return Bytes.asList((byte[])((byte[])obj2));
        }
        if (obj2 instanceof short[]) {
            return Shorts.asList((short[])((short[])obj2));
        }
        if (obj2 instanceof int[]) {
            return Ints.asList((int[])((int[])obj2));
        }
        if (obj2 instanceof long[]) {
            return Longs.asList((long[])((long[])obj2));
        }
        if (obj2 instanceof float[]) {
            return Floats.asList((float[])((float[])obj2));
        }
        if (obj2 instanceof double[]) {
            return Doubles.asList((double[])((double[])obj2));
        }
        return Collections.emptyList();
    }

    private static List<?> parseStringToList(String string) {
        Matcher candidate = listPattern.matcher(string);
        if (!Coerce.listBracketsMatch(candidate)) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        for (String part : candidate.group(2).split(",")) {
            if (part == null) continue;
            list.add(part);
        }
        return list;
    }
}

