/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.module.database;

import com.zaxxer.hikari_4_0_3.HikariConfig;
import com.zaxxer.hikari_4_0_3.HikariDataSource;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin1520.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.serverct.ersha.taboolib.common.env.RuntimeDependency;
import org.serverct.ersha.taboolib.module.configuration.Config;
import org.serverct.ersha.taboolib.module.configuration.Configuration;
import org.serverct.ersha.taboolib.module.database.Host;
import org.serverct.ersha.taboolib.module.database.HostSQL;
import org.serverct.ersha.taboolib.module.database.HostSQLite;

@RuntimeDependency(value="!com.zaxxer:HikariCP:4.0.3", test="!com.zaxxer.hikari_4_0_3.HikariDataSource", relocate={"!com.zaxxer.hikari", "!com.zaxxer.hikari_4_0_3"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u000e\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0012\u0010\u000f\u001a\u00020\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/serverct/ersha/taboolib/module/database/Database;", "", "()V", "<set-?>", "Lorg/serverct/ersha/taboolib/module/configuration/Configuration;", "settingsFile", "getSettingsFile", "()Lorg/serverct/ersha/taboolib/module/configuration/Configuration;", "createDataSource", "Ljavax/sql/DataSource;", "host", "Lorg/serverct/ersha/taboolib/module/database/Host;", "hikariConfig", "Lcom/zaxxer/hikari_4_0_3/HikariConfig;", "createDataSourceWithoutConfig", "createHikariConfig", "prepareClose", "", "func", "Ljava/lang/Runnable;", "module-database-core"})
public final class Database {
    @NotNull
    public static final Database INSTANCE = new Database();
    @Config(value="datasource.yml")
    private static Configuration settingsFile;

    private Database() {
    }

    @NotNull
    public final Configuration getSettingsFile() {
        Configuration configuration = settingsFile;
        if (configuration != null) {
            return configuration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsFile");
        throw null;
    }

    public final void prepareClose(@NotNull Runnable func) {
        Intrinsics.checkNotNullParameter((Object)func, (String)"func");
        Host.Companion companion = Host.Companion;
        Collection collection = companion.getCallbackClose$module_database_core();
        boolean bl = false;
        collection.add(func);
    }

    @NotNull
    public final DataSource createDataSource(@NotNull Host<?> host, @Nullable HikariConfig hikariConfig) {
        Intrinsics.checkNotNullParameter(host, (String)"host");
        HikariConfig hikariConfig2 = hikariConfig;
        return (DataSource)new HikariDataSource(hikariConfig2 == null ? this.createHikariConfig(host) : hikariConfig2);
    }

    public static /* synthetic */ DataSource createDataSource$default(Database database, Host host, HikariConfig hikariConfig, int n, Object object) {
        if ((n & 2) != 0) {
            hikariConfig = null;
        }
        return database.createDataSource(host, hikariConfig);
    }

    @NotNull
    public final DataSource createDataSourceWithoutConfig(@NotNull Host<?> host) {
        Intrinsics.checkNotNullParameter(host, (String)"host");
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(host.getConnectionUrl());
        if (!(host instanceof HostSQL)) {
            String string = Intrinsics.stringPlus((String)"Unsupported host: ", host);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        config.setUsername(((HostSQL)host).getUser());
        config.setPassword(((HostSQL)host).getPassword());
        return (DataSource)new HikariDataSource(config);
    }

    @NotNull
    public final HikariConfig createHikariConfig(@NotNull Host<?> host) {
        Set<String> set;
        Intrinsics.checkNotNullParameter(host, (String)"host");
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(host.getConnectionUrl());
        Object object = host;
        if (object instanceof HostSQL) {
            config.setDriverClassName(this.getSettingsFile().getString("DefaultSettings.DriverClassName", "com.mysql.jdbc.Driver"));
            config.setUsername(((HostSQL)host).getUser());
            config.setPassword(((HostSQL)host).getPassword());
        } else if (object instanceof HostSQLite) {
            config.setDriverClassName("org.sqlite.JDBC");
        } else {
            String string = Intrinsics.stringPlus((String)"Unsupported host: ", host);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        config.setAutoCommit(this.getSettingsFile().getBoolean("DefaultSettings.AutoCommit", true));
        config.setMinimumIdle(this.getSettingsFile().getInt("DefaultSettings.MinimumIdle", 1));
        config.setMaximumPoolSize(this.getSettingsFile().getInt("DefaultSettings.MaximumPoolSize", 10));
        config.setValidationTimeout(this.getSettingsFile().getLong("DefaultSettings.ValidationTimeout", 5000L));
        config.setConnectionTimeout(this.getSettingsFile().getLong("DefaultSettings.ConnectionTimeout", 30000L));
        config.setIdleTimeout(this.getSettingsFile().getLong("DefaultSettings.IdleTimeout", 600000L));
        config.setMaxLifetime(this.getSettingsFile().getLong("DefaultSettings.MaxLifetime", 1800000L));
        if (this.getSettingsFile().contains("DefaultSettings.ConnectionTestQuery")) {
            config.setConnectionTestQuery(this.getSettingsFile().getString("DefaultSettings.ConnectionTestQuery"));
        }
        if (this.getSettingsFile().contains("DefaultSettings.DataSourceProperty") && (object = this.getSettingsFile().getConfigurationSection("DefaultSettings.DataSourceProperty")) != null && (set = object.getKeys(false)) != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String key2 = (String)element$iv;
                boolean bl = false;
                config.addDataSourceProperty(key2, (Object)INSTANCE.getSettingsFile().getString(Intrinsics.stringPlus((String)"DefaultSettings.DataSourceProperty.", (Object)key2)));
            }
        }
        return config;
    }
}

