/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.library.xseries;

import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.serverct.ersha.taboolib.library.reflex.Reflex;
import org.serverct.ersha.taboolib.library.xseries.ReflectionUtils;
import org.serverct.ersha.taboolib.library.xseries.XMaterial;
import org.serverct.ersha.taboolib.platform.util.ItemBuilder;

public class XSkull {
    protected static final MethodHandle CRAFT_META_SKULL_PROFILE_GETTER;
    protected static final MethodHandle CRAFT_META_SKULL_PROFILE_SETTER;
    protected static final MethodHandle CRAFT_META_SKULL_BLOCK_SETTER;
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":{\"url\":\"";
    private static final boolean SUPPORTS_UUID;
    private static final String INVALID_BASE64 = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzEwNTkxZTY5MDllNmEyODFiMzcxODM2ZTQ2MmQ2N2EyYzc4ZmEwOTUyZTkxMGYzMmI0MWEyNmM0OGMxNzU3YyJ9fX0=";
    private static final Pattern MOJANG_SHA256_APPROX;
    private static final String TEXTURES = "https://textures.minecraft.net/texture/";

    @NotNull
    public static ItemStack getSkull(@NotNull UUID id2) {
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (SUPPORTS_UUID) {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id2));
        } else {
            meta.setOwner(id2.toString());
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @NotNull
    public static SkullMeta applySkin(@NotNull ItemMeta head, @NotNull OfflinePlayer identifier) {
        SkullMeta meta = (SkullMeta)head;
        if (SUPPORTS_UUID) {
            meta.setOwningPlayer(identifier);
        } else {
            meta.setOwner(identifier.getName());
        }
        return meta;
    }

    @NotNull
    public static SkullMeta applySkin(@NotNull ItemMeta head, @NotNull UUID identifier) {
        return XSkull.applySkin(head, Bukkit.getOfflinePlayer((UUID)identifier));
    }

    @NotNull
    public static SkullMeta applySkin(@NotNull ItemMeta head, @NotNull String identifier) {
        SkullMeta meta = (SkullMeta)head;
        switch (XSkull.detectSkullValueType(identifier)) {
            case UUID: {
                return XSkull.applySkin(head, Bukkit.getOfflinePlayer((UUID)UUID.fromString(identifier)));
            }
            case NAME: {
                return XSkull.applySkin(head, Bukkit.getOfflinePlayer((String)identifier));
            }
            case BASE64: {
                return XSkull.setSkullBase64(meta, identifier);
            }
            case TEXTURE_URL: {
                return XSkull.setSkullBase64(meta, XSkull.encodeTexturesURL(identifier));
            }
            case TEXTURE_HASH: {
                return XSkull.setSkullBase64(meta, XSkull.encodeTexturesURL(TEXTURES + identifier));
            }
            case UNKNOWN: {
                return XSkull.setSkullBase64(meta, INVALID_BASE64);
            }
        }
        throw new AssertionError((Object)"Unknown skull value");
    }

    @NotNull
    protected static SkullMeta setSkullBase64(@NotNull SkullMeta head, @NotNull String value2) {
        if (value2 == null || value2.isEmpty()) {
            throw new IllegalArgumentException("Skull value cannot be null or empty");
        }
        GameProfile profile = XSkull.profileFromBase64(value2);
        try {
            CRAFT_META_SKULL_PROFILE_SETTER.invoke(head, profile);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return head;
    }

    @NotNull
    public static GameProfile profileFromBase64(String value2) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", value2));
        return profile;
    }

    @NotNull
    public static GameProfile profileFromPlayer(OfflinePlayer player) {
        return new GameProfile(player.getUniqueId(), player.getName());
    }

    @NotNull
    public static GameProfile detectProfileFromString(String identifier) {
        switch (XSkull.detectSkullValueType(identifier)) {
            case UUID: {
                return new GameProfile(UUID.fromString(identifier), null);
            }
            case NAME: {
                return new GameProfile(null, identifier);
            }
            case BASE64: {
                return XSkull.profileFromBase64(identifier);
            }
            case TEXTURE_URL: {
                return XSkull.profileFromBase64(XSkull.encodeTexturesURL(identifier));
            }
            case TEXTURE_HASH: {
                return XSkull.profileFromBase64(XSkull.encodeTexturesURL(TEXTURES + identifier));
            }
            case UNKNOWN: {
                return XSkull.profileFromBase64(INVALID_BASE64);
            }
        }
        throw new AssertionError((Object)"Unknown skull value");
    }

    public static ValueType detectSkullValueType(String identifier) {
        try {
            UUID.fromString(identifier);
            return ValueType.UUID;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (XSkull.isUsername(identifier)) {
                return ValueType.NAME;
            }
            if (identifier.contains("textures.minecraft.net")) {
                return ValueType.TEXTURE_URL;
            }
            if (identifier.length() > 100 && XSkull.isBase64(identifier)) {
                return ValueType.BASE64;
            }
            if (MOJANG_SHA256_APPROX.matcher(identifier).matches()) {
                return ValueType.TEXTURE_HASH;
            }
            return ValueType.UNKNOWN;
        }
    }

    public static void setSkin(@NotNull Block block, @NotNull String value2) {
        Objects.requireNonNull(block, "Can't set skin of null block");
        BlockState state = block.getState();
        if (!(state instanceof Skull)) {
            return;
        }
        Skull skull = (Skull)state;
        GameProfile profile = XSkull.detectProfileFromString(value2);
        try {
            CRAFT_META_SKULL_BLOCK_SETTER.invoke(skull, profile);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while setting block skin with value: " + value2, e);
        }
        skull.update(true);
    }

    public static String encodeTexturesURL(String url) {
        return XSkull.encodeBase64(VALUE_PROPERTY + url + "\"}}}");
    }

    @NotNull
    private static String encodeBase64(@NotNull String str) {
        return Base64.getEncoder().encodeToString(str.getBytes());
    }

    private static boolean isBase64(@NotNull String base64) {
        try {
            Base64.getDecoder().decode(base64);
            return true;
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    @Nullable
    public static ItemBuilder.SkullTexture getSkinValue(@NotNull ItemMeta skull) {
        GameProfile profile = null;
        try {
            profile = (GameProfile)Reflex.Companion.getProperty(skull, "profile", false, true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (profile != null && !profile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : profile.getProperties().get((Object)"textures")) {
                if (property.getValue().isEmpty()) continue;
                return new ItemBuilder.SkullTexture(property.getValue(), profile.getId());
            }
        }
        return null;
    }

    private static boolean isUsername(@NotNull String name2) {
        int len = name2.length();
        if (len > 16) {
            return false;
        }
        UnmodifiableIterator unmodifiableIterator = Lists.charactersOf((String)name2).iterator();
        while (unmodifiableIterator.hasNext()) {
            char ch = ((Character)unmodifiableIterator.next()).charValue();
            if (ch == '_' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        SUPPORTS_UUID = ReflectionUtils.supports(12);
        MOJANG_SHA256_APPROX = Pattern.compile("[0-9a-z]{60,70}");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle profileSetter = null;
        MethodHandle profileGetter = null;
        MethodHandle blockSetter = null;
        try {
            Class<?> CraftMetaSkull = ReflectionUtils.getCraftClass("inventory.CraftMetaSkull");
            Field profile = CraftMetaSkull.getDeclaredField("profile");
            profile.setAccessible(true);
            profileGetter = lookup.unreflectGetter(profile);
            try {
                Method setProfile = CraftMetaSkull.getDeclaredMethod("setProfile", GameProfile.class);
                setProfile.setAccessible(true);
                profileSetter = lookup.unreflect(setProfile);
            }
            catch (NoSuchMethodException e) {
                profileSetter = lookup.unreflectSetter(profile);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        try {
            Class<?> CraftSkullBlock = ReflectionUtils.getCraftClass("block.CraftSkull");
            Field field = CraftSkullBlock.getDeclaredField("profile");
            field.setAccessible(true);
            blockSetter = lookup.unreflectSetter(field);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        CRAFT_META_SKULL_PROFILE_SETTER = profileSetter;
        CRAFT_META_SKULL_PROFILE_GETTER = profileGetter;
        CRAFT_META_SKULL_BLOCK_SETTER = blockSetter;
    }

    public static enum ValueType {
        NAME,
        UUID,
        BASE64,
        TEXTURE_URL,
        TEXTURE_HASH,
        UNKNOWN;

    }
}

