/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.module.nms;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.serverct.ersha.taboolib.module.nms.ItemTagData;
import org.serverct.ersha.taboolib.module.nms.ItemTagType;

public class ItemTagList
extends ItemTagData
implements List<ItemTagData> {
    private final List<ItemTagData> value = new CopyOnWriteArrayList<ItemTagData>();

    public ItemTagList() {
        super(0);
        this.type = ItemTagType.LIST;
        this.data = this;
    }

    public static ItemTagList of(ItemTagData ... base) {
        ItemTagList list = new ItemTagList();
        list.addAll((Collection<? extends ItemTagData>)Arrays.asList(base));
        return list;
    }

    public static ItemTagList of(Object ... base) {
        ItemTagList list = new ItemTagList();
        for (Object obj : base) {
            list.add(ItemTagData.toNBT(obj));
        }
        return list;
    }

    @Override
    public String toJsonSimplified() {
        return this.toJsonSimplified(0);
    }

    @Override
    public String toJsonSimplified(int index) {
        StringBuilder builder = new StringBuilder();
        builder.append("[\n");
        this.value.forEach((? super T v) -> builder.append(this.copy("  ", index + 1)).append(v.toJsonSimplified(index + 1)).append("\n"));
        builder.append(this.copy("  ", index)).append("]");
        return builder.toString();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.value.contains(0);
    }

    @Override
    @NotNull
    public Iterator<ItemTagData> iterator() {
        return this.value.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.value.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.value.toArray();
    }

    @Override
    public boolean add(ItemTagData base) {
        return this.value.add(base);
    }

    @Override
    public boolean remove(Object o) {
        return this.value.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return new HashSet<ItemTagData>(this.value).containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends ItemTagData> c) {
        return this.value.addAll(c);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends ItemTagData> c) {
        return this.value.addAll(index, c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.value.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super ItemTagData> filter) {
        return this.value.removeIf(filter);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.value.retainAll(c);
    }

    @Override
    public void replaceAll(UnaryOperator<ItemTagData> operator) {
        this.value.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super ItemTagData> c) {
        this.value.sort(c);
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    @Override
    public ItemTagData get(int index) {
        return this.value.get(index);
    }

    @Override
    public ItemTagData set(int index, ItemTagData element) {
        return this.value.set(index, element);
    }

    @Override
    public void add(int index, ItemTagData element) {
        this.value.add(index, element);
    }

    @Override
    public ItemTagData remove(int index) {
        return this.value.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.value.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.value.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<ItemTagData> listIterator() {
        return this.value.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<ItemTagData> listIterator(int index) {
        return this.value.listIterator(index);
    }

    @Override
    @NotNull
    public List<ItemTagData> subList(int fromIndex, int toIndex) {
        return this.value.subList(fromIndex, toIndex);
    }

    @Override
    public Spliterator<ItemTagData> spliterator() {
        return this.value.spliterator();
    }

    @Override
    public Stream<ItemTagData> stream() {
        return this.value.stream();
    }

    @Override
    public Stream<ItemTagData> parallelStream() {
        return this.value.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super ItemTagData> action) {
        this.value.forEach(action);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemTagList)) {
            return false;
        }
        ItemTagList nbtBases = (ItemTagList)o;
        return Objects.equals(this.value, nbtBases.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String toString() {
        return NMS_UTILS.itemTagToString(this);
    }
}

