/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.tool;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static List<Class<?>> getClasses(Class<?> plugin) {
        ArrayList classes = new ArrayList();
        boolean recursive = true;
        String[] args = plugin.getPackage().getName().split("\\.");
        String packageName = args.length >= 2 ? args[0] + "." + args[1] : plugin.getPackage().getName();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = plugin.getClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name2 = entry.getName();
                        if (name2.charAt(0) == '/') {
                            name2 = name2.substring(1);
                        }
                        if (!name2.startsWith(packageDirName)) continue;
                        int idx = name2.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name2.substring(0, idx).replace('/', '.');
                        }
                        if (packageName.contains("org.serverct.ersha.taboolib") || !name2.endsWith(".class") || entry.isDirectory() || packageName.contains("org.serverct.ersha.taboolib") || packageName.contains("legendinlay.data") || packageName.contains("ink.star")) continue;
                        String className = name2.substring(packageName.length() + 1, name2.length() - 6);
                        try {
                            Class<?> clazz = Class.forName(packageName + '.' + className);
                            classes.add(clazz);
                        }
                        catch (ClassNotFoundException | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | VerifyError throwable) {}
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, boolean recursive, List<Class<?>> classes) {
        File[] dirFiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file2 : dirFiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class"))) {
            if (file2.isDirectory()) {
                ClassUtil.findAndAddClassesInPackageByFile(packageName + "." + file2.getName(), file2.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().length() - 6);
            try {
                classes.add(Class.forName(packageName + '.' + className));
            }
            catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodError throwable) {
                // empty catch block
            }
        }
    }
}

