/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer;

import com.github.rossrao.auctioneer.addons.Citizens;
import com.github.rossrao.auctioneer.addons.HolographicDisplays;
import com.github.rossrao.auctioneer.addons.PlaceholderAPI;
import com.github.rossrao.auctioneer.addons.bStats;
import com.github.rossrao.auctioneer.auction.RewardData;
import com.github.rossrao.auctioneer.auction.TimingData;
import com.github.rossrao.auctioneer.auction.handlers.ReminderHandler;
import com.github.rossrao.auctioneer.auction.handlers.TimeHandler;
import com.github.rossrao.auctioneer.auction.listeners.ArmorStandListener;
import com.github.rossrao.auctioneer.auction.listeners.AsyncChatListener;
import com.github.rossrao.auctioneer.auction.listeners.NPCListener;
import com.github.rossrao.auctioneer.auction.listeners.PlayerQuitListener;
import com.github.rossrao.auctioneer.auction.menus.BidUI;
import com.github.rossrao.auctioneer.auction.menus.DisplayItemUI;
import com.github.rossrao.auctioneer.auction.menus.ItemEditorUI;
import com.github.rossrao.auctioneer.auction.menus.ItemsUI;
import com.github.rossrao.auctioneer.auction.menus.JoinUI;
import com.github.rossrao.auctioneer.auction.menus.RewardCollectorUI;
import com.github.rossrao.auctioneer.commands.AuctioneerCommand;
import com.github.rossrao.auctioneer.data.ConfigValues;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Auctioneer
extends JavaPlugin {
    private static Auctioneer instance;
    private static boolean citizensEnabled;
    private static boolean holographicDisplaysEnabled;
    private static boolean cmiHologramsEnabled;
    private BidUI bidUI;
    private static Economy economy;

    public static Auctioneer getInstance() {
        return instance;
    }

    public static boolean isCitizensEnabled() {
        return citizensEnabled;
    }

    public static boolean isHolographicDisplaysEnabled() {
        return holographicDisplaysEnabled;
    }

    public static Economy getEconomy() {
        return economy;
    }

    public BidUI getBidUI() {
        return this.bidUI;
    }

    public static boolean isCmiHologramsEnabled() {
        return cmiHologramsEnabled;
    }

    public void onEnable() {
        Auctioneer.loadConfig0();
        instance = this;
        this.saveDefaultConfig();
        new RewardData().moveOldData();
        new TimingData().moveOldData();
        this.getLogger().info(ChatColor.GREEN + "-----------------------------------");
        this.getLogger().info(ChatColor.GREEN + "Auctioneer: Enabled");
        this.getLogger().info(ChatColor.GREEN + " - Author: " + this.getAuthors());
        this.getLogger().info(ChatColor.GREEN + " - Version: " + this.getDescription().getVersion());
        this.getLogger().info(ChatColor.GREEN + "-----------------------------------");
        this.loadConfig();
        this.loadAuction();
        this.loadCitizensSupport();
        this.loadHologramSupport();
        this.setupEconomy();
        this.loadMetrics();
        this.loadPlaceholderAPISupport();
    }

    public void onDisable() {
        if (citizensEnabled) {
            new Citizens().despawnNPC();
        }
        this.getLogger().info(ChatColor.RED + "-----------------------------------");
        this.getLogger().info(ChatColor.RED + "Auctioneer: Disabled");
        this.getLogger().info(ChatColor.RED + " - Author: " + this.getAuthors());
        this.getLogger().info(ChatColor.RED + " - Version: " + this.getDescription().getVersion());
        this.getLogger().info(ChatColor.RED + "-----------------------------------");
    }

    private String getAuthors() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.getDescription().getAuthors()) {
            if (this.getDescription().getAuthors().size() > 1) {
                stringBuilder.append(string).append(", ");
                continue;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void loadConfig() {
        new ConfigValues();
    }

    private void loadAuction() {
        FileConfiguration fileConfiguration = new TimingData().getData();
        TimeHandler timeHandler = new TimeHandler();
        if (fileConfiguration.get("last-date") == null) {
            fileConfiguration.set("last-date", (Object)timeHandler.getCurrentDate());
        } else if (!fileConfiguration.getString("last-date").equals(timeHandler.getCurrentDate())) {
            fileConfiguration.set("last-date", (Object)timeHandler.getCurrentDate());
            fileConfiguration.set("passed", null);
        }
        try {
            fileConfiguration.save(new TimingData().getFile());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        timeHandler.startRunnable();
        new AuctioneerCommand(this);
        new ItemsUI(this);
        new ItemEditorUI(this);
        new RewardCollectorUI(this);
        new ArmorStandListener(this);
        new PlayerQuitListener(this);
        new AsyncChatListener(this);
        switch (ConfigValues.bidding_type) {
            case CHAT: {
                new DisplayItemUI(this);
            }
            case MENU: {
                this.bidUI = new BidUI(this);
            }
        }
        switch (ConfigValues.joining_type) {
            case MENU: {
                new JoinUI(this);
            }
        }
        ReminderHandler.startRemindingPlayers();
    }

    private void loadMetrics() {
        int n = 13030;
        new bStats(this, n);
    }

    private void loadCitizensSupport() {
        if (this.getServer().getPluginManager().getPlugin("Citizens") != null) {
            citizensEnabled = true;
            new NPCListener(this);
            return;
        }
        citizensEnabled = false;
    }

    private void loadHologramSupport() {
        if (this.getServer().getPluginManager().getPlugin("HolographicDisplays") != null) {
            holographicDisplaysEnabled = true;
            new HolographicDisplays().registerHologramPlaceholders();
        } else {
            holographicDisplaysEnabled = false;
            this.loadCMIHologramSupport();
        }
    }

    private void loadCMIHologramSupport() {
        if (this.getServer().getPluginManager().getPlugin("CMI") != null) {
            cmiHologramsEnabled = true;
            return;
        }
        cmiHologramsEnabled = false;
    }

    private void loadPlaceholderAPISupport() {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderAPI().register();
            return;
        }
    }

    private void setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (registeredServiceProvider == null) {
                return;
            }
            economy = (Economy)registeredServiceProvider.getProvider();
        }
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=997807&resource_id=96826&nonce=1529223915").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

