/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.listeners;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.handlers.AuctionHandler;
import com.github.rossrao.auctioneer.data.ConfigValues;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerQuitListener
implements Listener {
    private Auctioneer auctioneer;
    private AuctionData data;

    public PlayerQuitListener(Auctioneer auctioneer) {
        this.auctioneer = auctioneer;
        this.data = new AuctionData();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)auctioneer);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (AuctionHandler.isParticipant(player)) {
            AuctionHandler.showParticipants(player);
            List<String> list = this.data.getLoggedOutCache();
            list.add(player.getUniqueId().toString());
            this.data.getData().set("logout-cache", list);
            this.data.save();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        Bukkit.getServer().getScheduler().runTaskLater((Plugin)this.auctioneer, () -> {
            if (this.data.getLoggedOutCache().contains(player.getUniqueId().toString())) {
                AuctionHandler.removeParticipant(player);
                if (Auctioneer.isCitizensEnabled() && ConfigValues.npc_enabled && this.data.getNPCSpawnLocation() != null) {
                    player.teleport(this.data.getNPCSpawnLocation());
                }
                this.data.removeLoggedOutCache(player.getUniqueId());
            }
        }, 20L);
    }
}

