/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.menus;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.items.AuctionItem;
import com.github.rossrao.auctioneer.auction.listeners.AsyncChatListener;
import com.github.rossrao.auctioneer.auction.menus.ItemsUI;
import com.github.rossrao.auctioneer.utils.ItemBuilder;
import com.github.rossrao.auctioneer.utils.Utils;
import com.github.rossrao.auctioneer.utils.xseries.XMaterial;
import com.github.rossrao.auctioneer.utils.xseries.XSound;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemEditorUI
implements Listener {
    private Auctioneer auctioneer;
    private AuctionData auctionData;
    private Inventory inv;
    private Player player;
    public static AuctionItem auctionItem;
    private HashMap<Integer, AuctionItem> items = new HashMap();

    public ItemEditorUI(Auctioneer auctioneer) {
        this.auctioneer = auctioneer;
        this.auctionData = new AuctionData();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)auctioneer);
    }

    public Inventory open(Player player, AuctionItem auctionItem) {
        Inventory inventory;
        this.inv = inventory = Bukkit.createInventory(null, (int)54, (String)"Auction Item Editor");
        this.player = player;
        ItemEditorUI.auctionItem = auctionItem;
        ItemStack itemStack = new ItemBuilder(XMaterial.BLACK_STAINED_GLASS_PANE).setName(Utils.colorize("&7")).toItemStack();
        for (int i = 0; i < 54; ++i) {
            this.inv.setItem(i, itemStack);
        }
        this.inv.setItem(13, auctionItem.getItemStack(true));
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.COMMAND_BLOCK).setName(Utils.colorize("&bEdit Commands")).addLoreLine(Utils.colorize("&7Use %player% in your commands")).addLoreLine(Utils.colorize("&7to get the auction winners name!")).addLoreLine(Utils.colorize(""));
        if (!auctionItem.getCommands().isEmpty()) {
            itemBuilder.addLoreLine(Utils.colorize("&f&lCurrent Commands:"));
            auctionItem.getCommands().forEach(string -> itemBuilder.addLoreLine(Utils.colorize(" &b- " + string)));
            itemBuilder.addLoreLine(Utils.colorize("&8-------------------"));
        }
        itemBuilder.addLoreLine(Utils.colorize("&bLeft-Click to add a command!"));
        if (!auctionItem.getCommands().isEmpty()) {
            itemBuilder.addLoreLine(Utils.colorize("&3Right-Click to remove last command!"));
        }
        this.inv.setItem(28, itemBuilder.toItemStack());
        ItemStack itemStack2 = new ItemBuilder(XMaterial.GOLD_BLOCK).setName(Utils.colorize("&bSet Base Cost")).addLoreLine(Utils.colorize("&f&lCurrent Base Cost: &6" + Utils.formatDouble(auctionItem.getBaseCost()))).addLoreLine(Utils.colorize("&8-------------------")).addLoreLine(Utils.colorize("&bClick to set base cost!")).toItemStack();
        this.inv.setItem(32, itemStack2);
        ItemStack itemStack3 = new ItemBuilder(XMaterial.CHEST).setName(Utils.colorize("&bSet Give Item")).addLoreLine(Utils.colorize("&7Should the item above be given to")).addLoreLine(Utils.colorize("&7the player after they have won a bid?")).addLoreLine(Utils.colorize("")).addLoreLine(Utils.colorize("&f&lCurrently Enabled: &b" + auctionItem.isGiveItem())).addLoreLine(Utils.colorize("&8-------------------")).addLoreLine(Utils.colorize("&bClick to toggle give item!")).toItemStack();
        this.inv.setItem(30, itemStack3);
        ItemStack itemStack4 = new ItemBuilder(XMaterial.NAME_TAG).setName(Utils.colorize("&bSet Display Name")).addLoreLine(Utils.colorize("&7Set this item to have a custom name")).addLoreLine(Utils.colorize("&7when sold at the auction.")).addLoreLine(Utils.colorize("")).addLoreLine(Utils.colorize("&c&lNote: &fThis will not change the item's name")).addLoreLine(Utils.colorize("&fwhen given to the player after winning the bid.")).addLoreLine(Utils.colorize("")).addLoreLine(Utils.colorize("&f&lCurrent Display Name: &b" + auctionItem.getDisplayName())).addLoreLine(Utils.colorize("&8-------------------")).addLoreLine(Utils.colorize("&bLeft-Click to set display name!")).addLoreLine(Utils.colorize("&3Right-Click to remove display name!")).toItemStack();
        this.inv.setItem(34, itemStack4);
        ItemStack itemStack5 = new ItemBuilder(XMaterial.EMERALD).setName(Utils.colorize("&bSave")).toItemStack();
        this.inv.setItem(49, itemStack5);
        inventory.setContents(this.inv.getContents());
        return this.inv;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (!inventoryClickEvent.getInventory().equals(this.inv)) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        int n = inventoryClickEvent.getSlot();
        ClickType clickType = inventoryClickEvent.getClick();
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (inventoryClickEvent.getClickedInventory() == inventoryClickEvent.getView().getBottomInventory()) {
            this.player.getOpenInventory().setItem(13, itemStack);
            auctionItem.setItemStack(itemStack);
            this.player.playSound(this.player.getLocation(), XSound.UI_BUTTON_CLICK.parseSound(), 1.0f, 1.0f);
            return;
        }
        if (n == 49) {
            this.player.openInventory(new ItemsUI(this.auctioneer).open(this.player, 1));
            this.player.playSound(this.player.getLocation(), XSound.UI_BUTTON_CLICK.parseSound(), 1.0f, 1.0f);
            return;
        }
        if (n == 28) {
            if (clickType == ClickType.LEFT) {
                this.player.closeInventory();
                this.player.sendMessage(Utils.colorize("&7Please enter the command you would like to add. (Without the /)"));
                AsyncChatListener.editorUsers.put(this.player.getUniqueId(), "command");
            } else if (clickType == ClickType.RIGHT) {
                List<String> list = auctionItem.getCommands();
                if (!list.isEmpty()) {
                    String string2 = list.get(list.size() - 1);
                    list.remove(string2);
                    auctionItem.setCommands(list);
                    this.player.playSound(this.player.getLocation(), XSound.UI_BUTTON_CLICK.parseSound(), 1.0f, 1.0f);
                    ItemBuilder itemBuilder = new ItemBuilder(XMaterial.COMMAND_BLOCK).setName(Utils.colorize("&bEdit Commands")).addLoreLine(Utils.colorize("&7Use %player% in your commands")).addLoreLine(Utils.colorize("&7to get the auction winners name!")).addLoreLine(Utils.colorize(""));
                    if (!auctionItem.getCommands().isEmpty()) {
                        itemBuilder.addLoreLine(Utils.colorize("&f&lCurrent Commands:"));
                        auctionItem.getCommands().forEach(string -> itemBuilder.addLoreLine(Utils.colorize(" &b- " + string)));
                        itemBuilder.addLoreLine(Utils.colorize("&8-------------------"));
                    }
                    itemBuilder.addLoreLine(Utils.colorize("&bLeft-Click to add a command!"));
                    if (!auctionItem.getCommands().isEmpty()) {
                        itemBuilder.addLoreLine(Utils.colorize("&3Right-Click to remove last command!"));
                    }
                    this.player.getOpenInventory().setItem(28, itemBuilder.toItemStack());
                }
            }
            return;
        }
        if (n == 32) {
            this.player.closeInventory();
            this.player.sendMessage(Utils.colorize("&7Please enter the the base cost of this item."));
            AsyncChatListener.editorUsers.put(this.player.getUniqueId(), "base-cost");
            return;
        }
        if (n == 30) {
            if (auctionItem.isGiveItem()) {
                auctionItem.setGiveItem(false);
            } else {
                auctionItem.setGiveItem(true);
            }
            ItemStack itemStack2 = new ItemBuilder(XMaterial.CHEST).setName(Utils.colorize("&bSet Give Item")).addLoreLine(Utils.colorize("&7Should the item above be given to")).addLoreLine(Utils.colorize("&7the player after they have won the bid?")).addLoreLine(Utils.colorize("")).addLoreLine(Utils.colorize("&f&lCurrently Enabled: &b" + auctionItem.isGiveItem())).toItemStack();
            this.player.getOpenInventory().setItem(30, itemStack2);
            this.player.playSound(this.player.getLocation(), XSound.UI_BUTTON_CLICK.parseSound(), 1.0f, 1.0f);
            return;
        }
        if (n == 34) {
            if (clickType == ClickType.LEFT) {
                this.player.closeInventory();
                this.player.sendMessage(Utils.colorize("&7Please enter the the display name you want for this item."));
                AsyncChatListener.editorUsers.put(this.player.getUniqueId(), "display-name");
            } else if (clickType == ClickType.RIGHT) {
                auctionItem.deleteDisplayName();
                this.player.playSound(this.player.getLocation(), XSound.UI_BUTTON_CLICK.parseSound(), 1.0f, 1.0f);
                ItemStack itemStack3 = new ItemBuilder(XMaterial.NAME_TAG).setName(Utils.colorize("&bSet Display Name")).addLoreLine(Utils.colorize("&7Set this item to have a custom name")).addLoreLine(Utils.colorize("&7when sold at the auction.")).addLoreLine(Utils.colorize("")).addLoreLine(Utils.colorize("&c&lNote: &fThis will not change the item's name")).addLoreLine(Utils.colorize("&fwhen given to the player after winning the bid.")).addLoreLine(Utils.colorize("")).addLoreLine(Utils.colorize("&f&lCurrent Display Name: &b" + auctionItem.getDisplayName())).addLoreLine(Utils.colorize("&8-------------------")).addLoreLine(Utils.colorize("&bLeft-Click to set display name!")).addLoreLine(Utils.colorize("&3Right-Click to remove display name!")).toItemStack();
                this.player.getOpenInventory().setItem(34, itemStack3);
            }
            return;
        }
    }
}

